/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.models;

import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.models.IslandTableModel;
import com.empireclassic.jec.models.SectorChangeEvent;
import com.empireclassic.jec.models.SectorChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectorTableModel
extends AbstractTableModel {
    private RemoteEmpire empire = null;
    private IslandTableModel islandTableModel;
    private boolean filterSelection = false;
    List<SectorTableData> sectors = new ArrayList<SectorTableData>();
    DefaultListModel listModel = new DefaultListModel();
    private ListSelectionModel islandSelectionModel;
    private SectorChangeListener sectorListener = new SectorChangeListener(){

        public void sectorChanged(SectorChangeEvent event) {
            SectorTableModel.this.updateSelection();
        }
    };

    public SectorTableModel(RemoteEmpire empire, IslandTableModel islandTableModel, ListSelectionModel islandSelectionModel) {
        this.empire = empire;
        this.islandTableModel = islandTableModel;
        this.islandSelectionModel = islandSelectionModel;
        islandTableModel.addSectorChangeListener(this.sectorListener);
    }

    public List<Sector> getSectorList(int islandNum) {
        ArrayList<Sector> islandSectors = new ArrayList<Sector>(this.islandTableModel.getModelSectors(islandNum).values());
        Collections.sort(islandSectors);
        for (Sector sector : islandSectors) {
            if (sector.getDes() == Sector.Des.UNKNOWN || sector.getOwner() != Globals.nationNum) continue;
            this.sectors.add(new SectorTableData(islandNum, sector));
        }
        return islandSectors;
    }

    public void setFilterSelectedIslands() {
        this.filterSelection = true;
        this.updateSelection();
    }

    public void clearFilterSelectedIslands() {
        this.filterSelection = false;
        this.sectors.clear();
        for (int i = 0; i < this.islandTableModel.getRowCount(); ++i) {
            this.getSectorList((Integer)this.islandTableModel.getValueAt(i, 0));
        }
        this.fireTableDataChanged();
    }

    public void updateSelection() {
        this.sectors.clear();
        for (int i = 0; i < this.islandTableModel.getRowCount(); ++i) {
            if (this.filterSelection && !this.islandSelectionModel.isSelectedIndex(i)) continue;
            this.getSectorList((Integer)this.islandTableModel.getValueAt(i, 0));
        }
        this.fireTableDataChanged();
    }

    public int getIndex(IslandCoord coord) {
        int index = 0;
        for (SectorTableData sector : this.sectors) {
            if (sector.getLocation().equals((Object)coord)) break;
            ++index;
        }
        return index;
    }

    @Override
    public int getRowCount() {
        return this.sectors.size();
    }

    @Override
    public int getColumnCount() {
        return 14;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Isl";
            }
            case 1: {
                return "Sector";
            }
            case 2: {
                return "Des";
            }
            case 3: {
                return "Civ";
            }
            case 4: {
                return "Mil";
            }
            case 5: {
                return "Art";
            }
            case 6: {
                return "Expl";
            }
            case 7: {
                return "Ore";
            }
            case 8: {
                return "Eff";
            }
            case 9: {
                return "Prod";
            }
            case 10: {
                return "Smpl";
            }
            case 11: {
                return "Auth";
            }
            case 12: {
                return "Ftr";
            }
            case 13: {
                return "Bmr";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SectorTableData sector = this.sectors.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return sector.getIslandNum();
            }
            case 1: {
                return sector.getLocation();
            }
            case 2: {
                return Character.valueOf(sector.getDes().asChar());
            }
            case 3: {
                return sector.getCivilians();
            }
            case 4: {
                return sector.getMilitary();
            }
            case 5: {
                return sector.getGuns();
            }
            case 6: {
                return sector.getShells();
            }
            case 7: {
                return sector.getOre();
            }
            case 8: {
                return sector.getEff();
            }
            case 9: {
                return sector.getProduction();
            }
            case 10: {
                return sector.getOreSample();
            }
            case 11: {
                return sector.getAuthorized();
            }
            case 12: {
                return sector.getFighters();
            }
            case 13: {
                return sector.getBombers();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return IslandCoord.class;
        }
        if (columnIndex == 2) {
            return Character.class;
        }
        return Integer.class;
    }

    private class SectorTableData
    extends Sector {
        private int islandNum;

        public SectorTableData(int islandNum, Sector sector) {
            super(sector);
            this.islandNum = islandNum;
        }

        public int getIslandNum() {
            return this.islandNum;
        }

        public void setIslandNum(int islandNum) {
            this.islandNum = islandNum;
        }
    }
}

