/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.sectormenu;

import com.empireclassic.Remote.EmpireError;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.jec.EmpireLoad;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.sectormenu.SectorAttackDialog;
import com.empireclassic.jec.sectormenu.SectorEnlistDialog;
import com.empireclassic.jec.sectormenu.SectorMoveDialog;
import com.empireclassic.jec.sectormenu.SpreadFinalizeWindow;
import com.empireclassic.jec.sectormenu.SpreadStatusWindow;
import com.empireclassic.jec.utils.UiUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SelectSectorMenu
extends JMenu {
    private PNode islandNode;
    private IslandCoord coord;
    private Paint saveSectorColor = null;
    private PNode saveSector = null;
    private JECFrame frame;
    private JPopupMenu moveInstructions = new JPopupMenu();
    private JPopupMenu attackInstructions = new JPopupMenu();
    private JPopupMenu flyInstructions = new JPopupMenu();
    GetMoveMouseClick getMoveMouseClick = new GetMoveMouseClick();
    GetAttackMouseClick getAttackMouseClick = new GetAttackMouseClick();
    GetFlyMouseClick getFlyMouseClick = new GetFlyMouseClick();
    GetSpreadMouseClick getSpreadMouseClick = new GetSpreadMouseClick();
    SpreadStatusWindow spreadStatusWindow = null;
    private IslandCoord spreadUpperLeft = null;
    private HashMap<IslandCoord, Paint> spreadHiliteList = new HashMap();
    private IslandCoord oldMouseOver = null;

    public SelectSectorMenu(JECFrame parent, String name, PNode islandNode, IslandCoord coord) {
        super(name);
        this.frame = parent;
        this.islandNode = islandNode;
        this.coord = coord;
        IslandInfo island = (IslandInfo)islandNode.getAttribute((Object)"ISLAND");
        Sector sector = (Sector)island.getSectors().get(coord);
        JMenu moveItem = new JMenu("Move");
        JMenuItem moveCivItem = new JMenuItem("Civilians");
        moveCivItem.addActionListener(new AbstractAction("Civilians"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.moveActionPerformed(event, JECFrame.State.LANDMOVECIV);
            }
        });
        if (sector.getCivilians() == 0) {
            moveCivItem.setEnabled(false);
        }
        moveItem.add(moveCivItem);
        JMenuItem moveMilItem = new JMenuItem("Military");
        moveMilItem.addActionListener(new AbstractAction("Military"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.moveActionPerformed(event, JECFrame.State.LANDMOVEMIL);
            }
        });
        if (sector.getMilitary() == 0) {
            moveMilItem.setEnabled(false);
        }
        moveItem.add(moveMilItem);
        JMenuItem moveArtItem = new JMenuItem("Artillery");
        moveArtItem.addActionListener(new AbstractAction("Artillery"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.moveActionPerformed(event, JECFrame.State.LANDMOVEART);
            }
        });
        if (sector.getGuns() == 0) {
            moveArtItem.setEnabled(false);
        }
        moveItem.add(moveArtItem);
        JMenuItem moveExpItem = new JMenuItem("Explosives");
        moveExpItem.addActionListener(new AbstractAction("Shells"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.moveActionPerformed(event, JECFrame.State.LANDMOVEEXP);
            }
        });
        if (sector.getShells() == 0) {
            moveExpItem.setEnabled(false);
        }
        moveItem.add(moveExpItem);
        JMenuItem moveOreItem = new JMenuItem("Ore");
        moveOreItem.addActionListener(new AbstractAction("Ore"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.moveActionPerformed(event, JECFrame.State.LANDMOVEORE);
            }
        });
        if (sector.getOre() == 0) {
            moveOreItem.setEnabled(false);
        }
        moveItem.add(moveOreItem);
        this.add(moveItem);
        JMenu designateItem = new JMenu("Designate");
        designateItem.add(new DesignateAction("Dock"));
        designateItem.add(new DesignateAction("+ Airport"));
        designateItem.add(new DesignateAction("Plane factory"));
        designateItem.add(new DesignateAction("Rural"));
        designateItem.add(new DesignateAction("Artillery plant"));
        designateItem.add(new DesignateAction("Explosives factory"));
        designateItem.add(new DesignateAction("! Radar facility"));
        designateItem.add(new DesignateAction("Fort"));
        designateItem.add(new DesignateAction("Mine"));
        designateItem.add(new DesignateAction("Trade center"));
        designateItem.add(new DesignateAction("Urban area"));
        designateItem.add(new DesignateAction("Waterway"));
        designateItem.addSeparator();
        designateItem.add(new DesignateAction("Capitol"));
        this.add(designateItem);
        JMenu launchItem = new JMenu("Launch");
        launchItem.add(new LaunchAction("Barge"));
        launchItem.add(new LaunchAction("PT boat"));
        launchItem.add(new LaunchAction("Ferry"));
        launchItem.add(new LaunchAction("Mine sweeper"));
        launchItem.add(new LaunchAction("Destroyer"));
        launchItem.add(new LaunchAction("Freighter"));
        launchItem.add(new LaunchAction("Liner"));
        launchItem.add(new LaunchAction("Submarine"));
        launchItem.add(new LaunchAction("Tanker"));
        launchItem.add(new LaunchAction("Transport"));
        launchItem.add(new LaunchAction("Cruiser"));
        launchItem.add(new LaunchAction("Yacht"));
        launchItem.add(new LaunchAction("Battleship"));
        launchItem.add(new LaunchAction("Carrier"));
        this.add(launchItem);
        if (sector.getDes() != Sector.Des.DOCK) {
            launchItem.setEnabled(false);
        }
        this.add(new AbstractAction("Attack"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.attackActionPerformed(event);
            }
        });
        JMenu flyItem = new JMenu("Fly");
        flyItem.setEnabled(false);
        this.add(flyItem);
        JMenuItem flyFightersItem = new JMenuItem("Fighters");
        flyFightersItem.addActionListener(new AbstractAction("Fighters"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.landFlyActionPerformed(event);
            }
        });
        if (sector.getDes() != Sector.Des.AIRPORT || sector.getFighters() == 0) {
            flyFightersItem.setEnabled(false);
        }
        flyItem.add(flyFightersItem);
        JMenuItem flyBombersItem = new JMenuItem("Bombers");
        flyBombersItem.addActionListener(new AbstractAction("Bombers"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.landFlyActionPerformed(event);
            }
        });
        if (sector.getDes() != Sector.Des.AIRPORT || sector.getBombers() == 0) {
            flyBombersItem.setEnabled(false);
        }
        flyItem.add(flyBombersItem);
        this.add(new AbstractAction("Spread"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.spreadActionPerformed(event);
            }
        });
        JMenuItem enlistItem = new JMenuItem("Enlist");
        enlistItem.addActionListener(new AbstractAction("Enlist"){

            public void actionPerformed(ActionEvent event) {
                SelectSectorMenu.this.enlistActionPerformed(event);
            }
        });
        this.add(enlistItem);
    }

    public void designateActionPerformed(ActionEvent event) {
        String des = event.getActionCommand();
        IslandCoord quad = this.coord;
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        System.out.println("setting des");
        EmpireError error = RemoteEmpire.getInstance().setDes(island.getNumber(), quad, Sector.Des.fromChar((char)des.charAt(0)).getValue());
        island = this.frame.getIslandsTableModel().getIsland(island.getNumber());
        this.frame.getMapCanvas().drawIsland(this.islandNode, island);
    }

    public void launchActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        IslandCoord sectorCoord = new IslandCoord(this.coord);
        EmpireError error = RemoteEmpire.getInstance().launch(island.getNumber(), sectorCoord, event.getActionCommand());
        if (error.errorNum != 0) {
            JOptionPane.showMessageDialog(this.frame, error.errorString, "Launch ship", 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, "You have built ship #" + error.errorString, "Launch ship", 1);
            EmpireLoad loader = new EmpireLoad(this.frame);
            loader.start();
        }
    }

    private void hiliteSector(IslandCoord coord) {
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        Sector sector = (Sector)island.getSectors().get(this.coord);
        PNode sectorNode = (PNode)Globals.sectorNodeList.get(this.coord);
        this.saveSectorColor = sectorNode.getPaint();
        this.saveSector = sectorNode;
        sectorNode.setPaint((Paint)Color.WHITE);
    }

    public void moveActionPerformed(ActionEvent event, JECFrame.State state) {
        this.frame.setFrameState(state);
        this.moveInstructions.add(new JMenuItem("Click on the sector to move to"));
        this.moveInstructions.show((Component)((Object)this.frame.getMapCanvas()), 500, 500);
        this.hiliteSector(this.coord);
        this.frame.getMapCanvas().addInputEventListener((PInputEventListener)this.getMoveMouseClick);
    }

    public void attackActionPerformed(ActionEvent event) {
        this.attackInstructions.add(new JMenuItem("Click on the sector to attack"));
        this.attackInstructions.show((Component)((Object)this.frame.getMapCanvas()), 500, 500);
        this.hiliteSector(this.coord);
        this.frame.setFrameState(JECFrame.State.ATTACK);
        this.frame.getMapCanvas().addInputEventListener((PInputEventListener)this.getAttackMouseClick);
    }

    public void landFlyActionPerformed(ActionEvent event) {
        this.flyInstructions.add(new JMenuItem("Click on the destination airport"));
        this.flyInstructions.show((Component)((Object)this.frame.getMapCanvas()), 500, 500);
        this.hiliteSector(this.coord);
        this.frame.setFrameState(JECFrame.State.FLY);
        this.frame.getMapCanvas().addInputEventListener((PInputEventListener)this.getFlyMouseClick);
    }

    public void spreadActionPerformed(ActionEvent event) {
        this.frame.setFrameState(JECFrame.State.SPREAD);
        if (this.islandNode != null && this.islandNode.getAttribute((Object)"ISLAND") != null) {
            IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
            this.frame.getMapCanvas().addInputEventListener((PInputEventListener)this.getSpreadMouseClick);
            this.spreadStatusWindow = new SpreadStatusWindow((Frame)this.frame, island);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.spreadStatusWindow.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.spreadStatusWindow.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.spreadStatusWindow.setVisible(true);
            this.spreadHiliteList = new HashMap();
            this.hiliteSector(this.coord);
        }
    }

    public void enlistActionPerformed(ActionEvent event) {
        this.hiliteSector(this.coord);
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        Map sectors = island.getSectors();
        Sector sector = (Sector)sectors.get(this.coord);
        SectorEnlistDialog enlistDialog = new SectorEnlistDialog(this.frame, "Enlist in " + sector.getLocation(), sector.getCivilians());
        enlistDialog.setModal(true);
        UiUtil.centerAndShow(enlistDialog);
        if (!enlistDialog.cancelledd()) {
            EmpireError error = RemoteEmpire.getInstance().enlist(island.getNumber(), this.coord, enlistDialog.getNumEnlist());
        }
    }

    public void spreadMouseClicked(PInputEvent event) {
        if (event.getButton() != 1) {
            this.spreadUpperLeft = null;
            this.spreadUnhilite();
            return;
        }
        Point2D canvasPoint = (Point2D)event.getPosition().clone();
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        IslandCoord thisPoint = new IslandCoord((int)canvasPoint.getX(), (int)canvasPoint.getY());
        thisPoint.translate(-island.getLocation().x + 1, -island.getLocation().y + 1);
        if (this.spreadUpperLeft == null) {
            this.spreadUpperLeft = thisPoint;
            SpreadUpdateInfo updateInfo = this.spreadHilite(event);
            this.spreadStatusWindow.updateSectors(updateInfo.timeNeeded, updateInfo.sectors, updateInfo.civilians + ((Sector)island.getSectors().get(this.coord)).getCivilians(), updateInfo.mountains);
        } else {
            this.spreadStatusWindow.dispose();
            this.frame.setFrameState(JECFrame.State.PANANDZOOM);
            this.frame.getMapCanvas().removeInputEventListener((PInputEventListener)this.getSpreadMouseClick);
            SpreadUpdateInfo updateInfo = this.spreadHilite(event);
            int maxCivPerSec = updateInfo.civilians + ((Sector)island.getSectors().get(this.coord)).getCivilians() / updateInfo.sectors;
            SpreadFinalizeWindow spreadWindow = new SpreadFinalizeWindow((Frame)this.frame, maxCivPerSec);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = spreadWindow.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            spreadWindow.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            spreadWindow.setVisible(true);
            if (!spreadWindow.cancelled()) {
                System.out.println("spread");
                System.out.println((int)this.spreadUpperLeft.getX() + "," + (int)this.spreadUpperLeft.getY() + "," + (int)thisPoint.getX() + "," + (int)thisPoint.getY());
                System.out.println(this.coord.x + "," + this.coord.y);
                System.out.println(this.spreadStatusWindow.getMountains() ? "Y" : "N");
                System.out.println(this.spreadStatusWindow.getOwn() ? "Y" : "N");
                IslandCoord corner = this.spreadUpperLeft;
                if (spreadWindow.getCorner() == 1) {
                    corner = new IslandCoord(thisPoint.x, this.spreadUpperLeft.y);
                } else if (spreadWindow.getCorner() == 2) {
                    corner = new IslandCoord((thisPoint.x - this.spreadUpperLeft.x) / 2, (thisPoint.y - this.spreadUpperLeft.y) / 2);
                } else if (spreadWindow.getCorner() == 3) {
                    corner = new IslandCoord(this.spreadUpperLeft.x, thisPoint.y);
                } else if (spreadWindow.getCorner() == 4) {
                    corner = thisPoint;
                }
                Rectangle area = new Rectangle(this.spreadUpperLeft.x, this.spreadUpperLeft.y, thisPoint.x - this.spreadUpperLeft.x + 1, thisPoint.y - this.spreadUpperLeft.y + 1);
                EmpireError error = RemoteEmpire.getInstance().spread(island.getNumber(), area, this.coord, this.spreadStatusWindow.getMountains(), this.spreadStatusWindow.getOwn(), spreadWindow.getCivilians(), corner);
                if (error.errorNum != 0) {
                    JOptionPane.showMessageDialog(this.frame, error.errorString, "Spread Error", 0);
                }
                event.setHandled(true);
                this.frame.getMapCanvas().drawIsland(this.islandNode, island);
            } else {
                this.saveSector.setPaint(this.saveSectorColor);
                this.spreadUnhilite();
            }
        }
    }

    public void spreadMouseMoved(PInputEvent event) {
        Point2D newMouseOverTemp = (Point2D)event.getPosition().clone();
        IslandCoord newMouseOver = new IslandCoord((int)newMouseOverTemp.getX(), (int)newMouseOverTemp.getY());
        newMouseOver.translate(1, 1);
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        Sector sector = (Sector)island.getSectors().get(this.coord);
        System.out.println("over sector " + sector.getLocation());
        if (this.spreadUpperLeft != null && !newMouseOver.equals((Object)this.oldMouseOver)) {
            this.oldMouseOver = newMouseOver;
            SpreadUpdateInfo updateInfo = this.spreadHilite(event);
            this.spreadStatusWindow.updateSectors(updateInfo.timeNeeded, updateInfo.sectors, (updateInfo.civilians + sector.getCivilians()) / updateInfo.sectors, updateInfo.mountains);
        }
    }

    private SpreadUpdateInfo spreadHilite(PInputEvent event) {
        boolean foundAtLeastOne;
        SpreadUpdateInfo updateInfo = new SpreadUpdateInfo();
        Point2D canvasPoint = (Point2D)event.getPosition().clone();
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        IslandCoord coordTo = new IslandCoord((int)canvasPoint.getX(), (int)canvasPoint.getY());
        coordTo.translate(-island.getLocation().x + 1, -island.getLocation().y + 1);
        this.spreadUnhilite();
        this.spreadHiliteList = new HashMap();
        Sector sector = (Sector)island.getSectors().get(this.spreadUpperLeft);
        this.spreadHiliteList.put(this.spreadUpperLeft, Globals.sectorNodeList.get(this.spreadUpperLeft).getPaint());
        do {
            foundAtLeastOne = false;
            for (int x = (int)this.spreadUpperLeft.getX(); x <= (int)coordTo.getX(); ++x) {
                for (int y = (int)this.spreadUpperLeft.getY(); y <= (int)coordTo.getY(); ++y) {
                    IslandCoord thisCoord = new IslandCoord(x, y);
                    sector = (Sector)island.getSectors().get(thisCoord);
                    if (sector == null || sector.getOwner() != 0 && (!this.spreadStatusWindow.getOwn() || sector.getOwner() != Globals.nationNum) || this.spreadHiliteList.containsKey(thisCoord) || sector.getTerrain() == Sector.Des.WATER || sector.getTerrain() == Sector.Des.MOUNTAIN && !this.spreadStatusWindow.getMountains() || !(y > 1 && this.spreadHiliteList.containsKey(new IslandCoord(x, y - 1)) || y < island.getSize().height && this.spreadHiliteList.containsKey(new IslandCoord(x, y + 1)) || x > 1 && this.spreadHiliteList.containsKey(new IslandCoord(x - 1, y))) && (x >= island.getSize().width || !this.spreadHiliteList.containsKey(new IslandCoord(x + 1, y)))) continue;
                    foundAtLeastOne = true;
                    ++updateInfo.timeNeeded;
                    if (sector.getTerrain() == Sector.Des.MOUNTAIN) {
                        updateInfo.timeNeeded += 4;
                        ++updateInfo.mountains;
                    }
                    updateInfo.civilians += sector.getCivilians();
                    this.spreadHiliteList.put(thisCoord, Globals.sectorNodeList.get(thisCoord).getPaint());
                    PNode sectorNode = (PNode)Globals.sectorNodeList.get(sector.getLocation());
                    sectorNode.setPaint((Paint)Color.WHITE);
                }
            }
        } while (foundAtLeastOne);
        updateInfo.sectors = this.spreadHiliteList.size();
        updateInfo.sectorList = this.spreadHiliteList;
        return updateInfo;
    }

    private void spreadUnhilite() {
        IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
        for (IslandCoord coord : this.spreadHiliteList.keySet()) {
            Paint paint = this.spreadHiliteList.get(coord);
            Globals.sectorNodeList.get(coord).setPaint(paint);
        }
    }

    public void flyMouseClicked(PInputEvent event) {
    }

    public void attackMouseClicked(PInputEvent event) {
        this.frame.setFrameState(JECFrame.State.PANANDZOOM);
        if (this.islandNode != null && this.islandNode.getAttribute((Object)"ISLAND") != null) {
            Point2D canvasPoint = (Point2D)event.getPosition().clone();
            IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
            RemoteEmpire empire = RemoteEmpire.getInstance();
            WorldCoord coordToW = new WorldCoord((int)canvasPoint.getX(), (int)canvasPoint.getY());
            IslandCoord coordTo = coordToW.asIslandCoord(island);
            IslandCoord coordFrom = this.coord;
            System.out.println("attack from " + coordFrom.toString() + " to " + coordTo.toString());
            RemoteEmpire.AttackReply reply = empire.attackTest(island.getNumber(), coordFrom, coordTo);
            if (reply.getError().errorNum != 0) {
                JOptionPane.showMessageDialog(this, reply.getError().errorString, "Error during attack", 0);
            } else {
                SectorAttackDialog attackWindow = new SectorAttackDialog(island, coordFrom, coordTo, ((Sector)island.getSectors().get(coordTo)).getMilitary(), ((Sector)island.getSectors().get(coordFrom)).getMilitary(), reply.getCasualties());
                UiUtil.centerAndShow(attackWindow);
                if (!attackWindow.cancelled()) {
                    reply = empire.attack(island.getNumber(), coordFrom, coordTo, attackWindow.getNumMilitary());
                    JOptionPane.showMessageDialog(this, "You " + (reply.isWon() ? "won" : "lost") + "!  Casualties " + reply.getCasualties() + ", enemy casualties " + reply.getEnemyCasualties(), "Attack results", 1);
                }
            }
            this.frame.getMapCanvas().removeInputEventListener((PInputEventListener)this.getAttackMouseClick);
            this.saveSector.setPaint(this.saveSectorColor);
            this.frame.getMapCanvas().drawIsland(this.islandNode, island);
        }
    }

    public void moveMouseClicked(PInputEvent event) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        JECFrame.State inState = this.frame.getFrameState();
        this.frame.setFrameState(JECFrame.State.PANANDZOOM);
        if (this.islandNode != null && this.islandNode.getAttribute((Object)"ISLAND") != null && event.getButton() == 1) {
            Point2D canvasPoint = (Point2D)event.getPosition().clone();
            IslandInfo island = (IslandInfo)this.islandNode.getAttribute((Object)"ISLAND");
            WorldCoord coordToW = new WorldCoord((int)canvasPoint.getX(), (int)canvasPoint.getY());
            IslandCoord coordTo = coordToW.asIslandCoord(island);
            IslandCoord coordFrom = this.coord;
            System.out.println("move from " + coordFrom.toString() + " to " + coordTo.toString());
            String thing = new String();
            switch (inState) {
                case LANDMOVECIV: {
                    thing = "civilians";
                    break;
                }
                case LANDMOVEMIL: {
                    thing = "military";
                    break;
                }
                case LANDMOVEART: {
                    thing = "artillery";
                    break;
                }
                case LANDMOVEEXP: {
                    thing = "explosives";
                    break;
                }
                case LANDMOVEORE: {
                    thing = "ore";
                }
            }
            Object moveCommand = null;
            EmpireError error = empire.move(island.getNumber(), thing.charAt(0), coordFrom.toString(), coordTo.toString(), 1, true);
            if (error.errorNum != 0) {
                JOptionPane.showMessageDialog(this.frame, error.errorString, "Sector move", 0);
            } else {
                String[] errorStrings = error.errorString.split(":");
                int timeUnits = Integer.parseInt(errorStrings[1]);
                if (timeUnits == 0) {
                    // empty if block
                }
                SectorMoveDialog moveWindow = new SectorMoveDialog(null, island, coordFrom, coordTo, inState, timeUnits);
                UiUtil.centerAndShow(moveWindow);
                if (!moveWindow.cancelled()) {
                    error = empire.move(island.getNumber(), thing.charAt(0), coordFrom.toString(), coordTo.toString(), moveWindow.getNumMoved(), false);
                }
                this.frame.getMapCanvas().drawIsland(this.islandNode, island);
            }
        }
        this.saveSector.setPaint(this.saveSectorColor);
        this.frame.getMapCanvas().removeInputEventListener((PInputEventListener)this.getMoveMouseClick);
    }

    public class LaunchAction
    extends AbstractAction {
        public LaunchAction(String shipType) {
            super(shipType);
        }

        public void actionPerformed(ActionEvent event) {
            SelectSectorMenu.this.launchActionPerformed(event);
        }
    }

    public class DesignateAction
    extends AbstractAction {
        public DesignateAction(String des) {
            super(des);
        }

        public void actionPerformed(ActionEvent event) {
            SelectSectorMenu.this.designateActionPerformed(event);
        }
    }

    public class GetAttackMouseClick
    extends PBasicInputEventHandler {
        public void mousePressed(PInputEvent event) {
            SelectSectorMenu.this.attackMouseClicked(event);
        }

        public void keyTyped(PInputEvent event) {
            SelectSectorMenu.this.frame.setFrameState(JECFrame.State.PANANDZOOM);
        }
    }

    public class GetFlyMouseClick
    extends PBasicInputEventHandler {
        public void mousePressed(PInputEvent event) {
            SelectSectorMenu.this.flyMouseClicked(event);
        }
    }

    public class GetSpreadMouseClick
    extends PBasicInputEventHandler {
        public void mousePressed(PInputEvent event) {
            SelectSectorMenu.this.spreadStatusWindow.toFront();
            SelectSectorMenu.this.spreadMouseClicked(event);
        }

        public void mouseMoved(PInputEvent event) {
            SelectSectorMenu.this.spreadStatusWindow.toFront();
            SelectSectorMenu.this.spreadMouseMoved(event);
        }
    }

    public class GetMoveMouseClick
    extends PBasicInputEventHandler {
        public void mousePressed(PInputEvent event) {
            SelectSectorMenu.this.moveMouseClicked(event);
        }

        public void keyTyped(PInputEvent event) {
            SelectSectorMenu.this.frame.setFrameState(JECFrame.State.PANANDZOOM);
        }
    }

    public class SpreadUpdateInfo {
        public int civilians = 0;
        public int sectors = 0;
        public int mountains = 0;
        public int timeNeeded = 0;
        public HashMap sectorList = new HashMap();
    }

    public class SpreadSaveInfo {
        public IslandCoord saveCoord;
        public Paint saveColor;

        public SpreadSaveInfo(IslandCoord coord, Paint color) {
            this.saveCoord = coord;
            this.saveColor = color;
        }
    }
}

