/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.TargetableSupport;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.Targetable;

public class JXEditorPane
extends JEditorPane
implements Targetable {
    private static final Logger LOG = Logger.getLogger(JXEditorPane.class.getName());
    private UndoableEditListener undoHandler;
    private UndoManager undoManager;
    private CaretListener caretHandler;
    private JComboBox selector;
    private static final String ACTION_FIND = "find";
    private static final String ACTION_UNDO = "undo";
    private static final String ACTION_REDO = "redo";
    private static final String ACTION_CUT = "cut";
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_PASTE = "paste";
    private TargetableSupport targetSupport = new TargetableSupport(this);
    private Searchable searchable;

    public JXEditorPane() {
        this.init();
    }

    public JXEditorPane(String url) throws IOException {
        super(url);
        this.init();
    }

    public JXEditorPane(String type, String text) {
        super(type, text);
        this.init();
    }

    public JXEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.init();
    }

    private void init() {
        this.setEditorKitForContentType("text/html", new SloppyHTMLEditorKit());
        this.addPropertyChangeListener(new PropertyHandler());
        this.getDocument().addUndoableEditListener(this.getUndoableEditListener());
        this.initActions();
    }

    CaretListener getCaretListener() {
        return this.caretHandler;
    }

    UndoableEditListener getUndoableEditListener() {
        if (this.undoHandler == null) {
            this.undoHandler = new UndoHandler();
            this.undoManager = new UndoManager();
        }
        return this.undoHandler;
    }

    public void setEditorKit(EditorKit kit) {
        super.setEditorKit(kit);
        if (kit instanceof StyledEditorKit) {
            if (this.caretHandler == null) {
                this.caretHandler = new CaretHandler();
            }
            this.addCaretListener(this.caretHandler);
        }
    }

    protected void initActions() {
        ActionMap map = this.getActionMap();
        map.put(ACTION_FIND, new Actions(ACTION_FIND));
        map.put(ACTION_UNDO, new Actions(ACTION_UNDO));
        map.put(ACTION_REDO, new Actions(ACTION_REDO));
        map.put(ACTION_CUT, new Actions(ACTION_CUT));
        map.put(ACTION_COPY, new Actions(ACTION_COPY));
        map.put(ACTION_PASTE, new Actions(ACTION_PASTE));
        KeyStroke findStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(findStroke, ACTION_FIND);
    }

    private void updateActionState() {
        Runnable doEnabled = new Runnable(){

            public void run() {
                ActionManager manager = ActionManager.getInstance();
                manager.setEnabled(JXEditorPane.ACTION_UNDO, JXEditorPane.this.undoManager.canUndo());
                manager.setEnabled(JXEditorPane.ACTION_REDO, JXEditorPane.this.undoManager.canRedo());
            }
        };
        SwingUtilities.invokeLater(doEnabled);
    }

    public JComboBox getParagraphSelector() {
        if (this.selector == null) {
            this.selector = new ParagraphSelector();
        }
        return this.selector;
    }

    protected void applyTag(HTML.Tag tag) {
        Document doc = this.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        HTMLDocument hdoc = (HTMLDocument)doc;
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        Element element = hdoc.getParagraphElement(start);
        SimpleAttributeSet newAttrs = new SimpleAttributeSet(element.getAttributes());
        newAttrs.addAttribute(StyleConstants.NameAttribute, tag);
        hdoc.setParagraphAttributes(start, end - start, newAttrs, true);
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null) {
            DataFlavor[] flavors = content.getTransferDataFlavors();
            try {
                for (int i = 0; i < flavors.length; ++i) {
                    if (!String.class.equals(flavors[i].getRepresentationClass())) continue;
                    Object data = content.getTransferData(flavors[i]);
                    if (!flavors[i].isMimeTypeEqual("text/plain")) continue;
                    this.replaceSelection(data.toString());
                    break;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "What can produce a problem with data flavor?", ex);
            }
        }
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new DocumentSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public boolean hasCommand(Object command) {
        return this.targetSupport.hasCommand(command);
    }

    public Object[] getCommands() {
        return this.targetSupport.getCommands();
    }

    public boolean doCommand(Object command, Object value) {
        return this.targetSupport.doCommand(command, value);
    }

    private static final class SloppyHTMLEditorKit
    extends HTMLEditorKit {
        private SloppyHTMLEditorKit() {
        }

        public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
            StringBuffer buffer = new StringBuffer();
            int length = -1;
            char[] data = new char[1024];
            while ((length = in.read(data)) != -1) {
                buffer.append(data, 0, length);
            }
            StringReader reader = new StringReader(buffer.toString().replaceAll("/>", ">"));
            super.read(reader, doc, pos);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            StyledDocument document = (StyledDocument)JXEditorPane.this.getDocument();
            int dot = evt.getDot();
            Element elem = document.getCharacterElement(dot);
            AttributeSet set = elem.getAttributes();
            ActionManager manager = ActionManager.getInstance();
            manager.setSelected("font-bold", StyleConstants.isBold(set));
            manager.setSelected("font-italic", StyleConstants.isItalic(set));
            manager.setSelected("font-underline", StyleConstants.isUnderline(set));
            elem = document.getParagraphElement(dot);
            set = elem.getAttributes();
            if (JXEditorPane.this.selector != null) {
                JXEditorPane.this.selector.setSelectedItem(set.getAttribute(StyleConstants.NameAttribute));
            }
            switch (StyleConstants.getAlignment(set)) {
                case 0: {
                    manager.setSelected("left-justify", true);
                    break;
                }
                case 1: {
                    manager.setSelected("center-justify", true);
                    break;
                }
                case 2: {
                    manager.setSelected("right-justify", true);
                }
            }
        }
    }

    public class DocumentSearchable
    implements Searchable {
        int lastFoundIndex = -1;
        MatchResult lastMatchResult;
        String lastRegEx;

        public int search(String searchString) {
            return this.search(searchString, -1);
        }

        public int search(String searchString, int columnIndex) {
            return this.search(searchString, columnIndex, false);
        }

        public int search(String searchString, int columnIndex, boolean backward) {
            Pattern pattern = null;
            if (!this.isEmpty(searchString)) {
                pattern = Pattern.compile(searchString, 0);
            }
            return this.search(pattern, columnIndex, backward);
        }

        protected boolean isEmpty(String searchString) {
            return searchString == null || searchString.length() == 0;
        }

        public int search(Pattern pattern) {
            return this.search(pattern, -1);
        }

        public int search(Pattern pattern, int startIndex) {
            return this.search(pattern, startIndex, false);
        }

        public int search(Pattern pattern, int startIndex, boolean backwards) {
            int length;
            if (pattern == null || JXEditorPane.this.getDocument().getLength() == 0 || startIndex > -1 && JXEditorPane.this.getDocument().getLength() < startIndex) {
                this.updateStateAfterNotFound();
                return -1;
            }
            int start = startIndex;
            if (this.maybeExtendedMatch(startIndex)) {
                if (this.foundExtendedMatch(pattern, start)) {
                    return this.lastFoundIndex;
                }
                ++start;
            }
            if (backwards) {
                start = 0;
                length = startIndex < 0 ? JXEditorPane.this.getDocument().getLength() - 1 : -1 + startIndex;
            } else {
                if (start < 0) {
                    start = 0;
                }
                length = JXEditorPane.this.getDocument().getLength() - start;
            }
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(start, length, segment);
            }
            catch (BadLocationException ex) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", ex);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult currentResult = this.getMatchResult(matcher, !backwards);
            if (currentResult != null) {
                this.updateStateAfterFound(currentResult, start);
            } else {
                this.updateStateAfterNotFound();
            }
            return this.lastFoundIndex;
        }

        private boolean foundExtendedMatch(Pattern pattern, int start) {
            if (pattern.pattern().equals(this.lastRegEx)) {
                return false;
            }
            int length = JXEditorPane.this.getDocument().getLength() - start;
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(start, length, segment);
            }
            catch (BadLocationException ex) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", ex);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult currentResult = this.getMatchResult(matcher, true);
            if (currentResult != null && currentResult.start() == 0 && !this.lastMatchResult.group().equals(currentResult.group())) {
                this.updateStateAfterFound(currentResult, start);
                return true;
            }
            return false;
        }

        private boolean maybeExtendedMatch(int startIndex) {
            return startIndex >= 0 && startIndex == this.lastFoundIndex;
        }

        private int updateStateAfterFound(MatchResult currentResult, int offset) {
            int end = currentResult.end() + offset;
            int found = currentResult.start() + offset;
            JXEditorPane.this.select(found, end);
            JXEditorPane.this.getCaret().setSelectionVisible(true);
            this.lastFoundIndex = found;
            this.lastMatchResult = currentResult;
            this.lastRegEx = ((Matcher)this.lastMatchResult).pattern().pattern();
            return found;
        }

        private MatchResult getMatchResult(Matcher matcher, boolean useFirst) {
            MatchResult currentResult = null;
            while (matcher.find()) {
                currentResult = matcher.toMatchResult();
                if (!useFirst) continue;
                break;
            }
            return currentResult;
        }

        private void updateStateAfterNotFound() {
            this.lastFoundIndex = -1;
            this.lastMatchResult = null;
            this.lastRegEx = null;
            JXEditorPane.this.setCaretPosition(JXEditorPane.this.getSelectionEnd());
        }
    }

    private class ParagraphSelector
    extends JComboBox
    implements ItemListener {
        private Map itemMap = new HashMap();

        public ParagraphSelector() {
            this.itemMap.put(HTML.Tag.P, "Paragraph");
            this.itemMap.put(HTML.Tag.H1, "Heading 1");
            this.itemMap.put(HTML.Tag.H2, "Heading 2");
            this.itemMap.put(HTML.Tag.H3, "Heading 3");
            this.itemMap.put(HTML.Tag.H4, "Heading 4");
            this.itemMap.put(HTML.Tag.H5, "Heading 5");
            this.itemMap.put(HTML.Tag.H6, "Heading 6");
            this.itemMap.put(HTML.Tag.PRE, "Preformatted");
            Vector<HTML.Tag> items = new Vector<HTML.Tag>();
            items.addElement(HTML.Tag.P);
            items.addElement(HTML.Tag.H1);
            items.addElement(HTML.Tag.H2);
            items.addElement(HTML.Tag.H3);
            items.addElement(HTML.Tag.H4);
            items.addElement(HTML.Tag.H5);
            items.addElement(HTML.Tag.H6);
            items.addElement(HTML.Tag.PRE);
            this.setModel(new DefaultComboBoxModel(items));
            this.setRenderer(new ParagraphRenderer());
            this.addItemListener(this);
            this.setFocusable(false);
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                JXEditorPane.this.applyTag((HTML.Tag)evt.getItem());
            }
        }

        private class ParagraphRenderer
        extends DefaultListCellRenderer {
            public ParagraphRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText((String)ParagraphSelector.this.itemMap.get(value));
                return this;
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            String name = this.getName();
            if (JXEditorPane.ACTION_FIND.equals(name)) {
                JXEditorPane.this.find();
            } else if (JXEditorPane.ACTION_UNDO.equals(name)) {
                try {
                    JXEditorPane.this.undoManager.undo();
                }
                catch (CannotUndoException ex) {
                    LOG.info("Could not undo");
                }
                JXEditorPane.this.updateActionState();
            } else if (JXEditorPane.ACTION_REDO.equals(name)) {
                try {
                    JXEditorPane.this.undoManager.redo();
                }
                catch (CannotRedoException ex) {
                    LOG.info("Could not redo");
                }
                JXEditorPane.this.updateActionState();
            } else if (JXEditorPane.ACTION_CUT.equals(name)) {
                ActionMap map = JXEditorPane.this.getActionMap();
                map.remove(JXEditorPane.ACTION_CUT);
                JXEditorPane.this.cut();
                map.put(JXEditorPane.ACTION_CUT, this);
            } else if (JXEditorPane.ACTION_COPY.equals(name)) {
                ActionMap map = JXEditorPane.this.getActionMap();
                map.remove(JXEditorPane.ACTION_COPY);
                JXEditorPane.this.copy();
                map.put(JXEditorPane.ACTION_COPY, this);
            } else if (JXEditorPane.ACTION_PASTE.equals(name)) {
                ActionMap map = JXEditorPane.this.getActionMap();
                map.remove(JXEditorPane.ACTION_PASTE);
                JXEditorPane.this.paste();
                map.put(JXEditorPane.ACTION_PASTE, this);
            } else {
                LOG.fine("ActionHandled: " + name);
            }
        }
    }

    private class UndoHandler
    implements UndoableEditListener {
        private UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent evt) {
            JXEditorPane.this.undoManager.addEdit(evt.getEdit());
            JXEditorPane.this.updateActionState();
        }
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("document")) {
                Document doc = (Document)evt.getOldValue();
                if (doc != null) {
                    doc.removeUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
                if ((doc = (Document)evt.getNewValue()) != null) {
                    doc.addUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
            }
        }
    }
}

