/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginAdapter;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.PasswordStore;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdesktop.swingx.plaf.JXLoginPanelAddon;
import org.jdesktop.swingx.plaf.LoginPanelUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.util.WindowUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLoginPanel
extends JXImagePanel {
    private static final Logger LOG = Logger.getLogger(JXLoginPanel.class.getName());
    private static final long serialVersionUID = 3544949969896288564L;
    public static final String uiClassID = "LoginPanelUI";
    public static final String LOGIN_ACTION_COMMAND = "login";
    public static final String CANCEL_LOGIN_ACTION_COMMAND = "cancel-login";
    private static String CLASS_NAME;
    private Status status = Status.NOT_STARTED;
    private JXImagePanel banner;
    private String bannerText = "Login";
    private JLabel messageLabel;
    private JLabel errorMessageLabel;
    private JXPanel loginPanel;
    private JXPanel contentPanel;
    private NameComponent namePanel;
    private JPasswordField passwordField;
    private JComboBox serverCombo;
    private JCheckBox saveCB;
    private JXPanel progressPanel;
    private JLabel progressMessageLabel;
    private LoginService loginService;
    private PasswordStore passwordStore;
    private UserNameStore userNameStore;
    private List<String> servers;
    private SaveMode saveMode;
    private LoginListenerImpl loginListener;
    private Cursor oldCursor;

    public JXLoginPanel() {
        this((LoginService)null);
    }

    public JXLoginPanel(LoginService service) {
        this(service, null, null);
    }

    public JXLoginPanel(LoginService service, PasswordStore passwordStore, UserNameStore userStore) {
        this(service, passwordStore, userStore, null);
    }

    public JXLoginPanel(LoginService service, PasswordStore passwordStore, UserNameStore userStore, List<String> servers) {
        this.loginService = service == null ? new NullLoginService() : service;
        this.passwordStore = passwordStore == null ? new NullPasswordStore() : passwordStore;
        this.userNameStore = userStore == null ? new DefaultUserNameStore() : userStore;
        this.servers = servers == null ? new ArrayList() : servers;
        this.getActionMap().put(LOGIN_ACTION_COMMAND, this.createLoginAction());
        this.getActionMap().put(CANCEL_LOGIN_ACTION_COMMAND, this.createCancelAction());
        this.saveMode = passwordStore != null && userStore != null ? SaveMode.BOTH : (passwordStore != null ? SaveMode.PASSWORD : (userStore != null ? SaveMode.USER_NAME : SaveMode.NONE));
        this.loginListener = new LoginListenerImpl();
        this.loginService.addLoginListener(this.loginListener);
        this.bannerText = UIManager.getString(CLASS_NAME + ".bannerString");
        this.updateUI();
        this.initComponents();
    }

    @Override
    public LoginPanelUI getUI() {
        return (LoginPanelUI)super.getUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void recreateLoginPanel() {
        this.contentPanel.remove(this.loginPanel);
        this.loginPanel = this.createLoginPanel();
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add((Component)this.loginPanel, 1);
    }

    private JXPanel createLoginPanel() {
        JXPanel loginPanel = new JXPanel();
        this.namePanel = this.saveMode == SaveMode.NONE ? new SimpleNamePanel() : new ComboNamePanel(this.userNameStore);
        JLabel nameLabel = new JLabel(UIManager.getString(CLASS_NAME + ".nameString"));
        nameLabel.setLabelFor(this.namePanel.getComponent());
        this.passwordField = new JPasswordField("", 15);
        JLabel passwordLabel = new JLabel(UIManager.getString(CLASS_NAME + ".passwordString"));
        passwordLabel.setLabelFor(this.passwordField);
        JLabel serverLabel = new JLabel("Server");
        if (this.servers.size() > 1) {
            this.serverCombo = new JComboBox<Object>(this.servers.toArray());
            serverLabel.setLabelFor(this.serverCombo);
        } else {
            this.serverCombo = null;
        }
        this.saveCB = new JCheckBox(UIManager.getString(CLASS_NAME + ".rememberPasswordString"));
        this.saveCB.setSelected(false);
        this.saveCB.setVisible(this.saveMode == SaveMode.PASSWORD || this.saveMode == SaveMode.BOTH);
        loginPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        loginPanel.add((Component)nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        loginPanel.add((Component)this.namePanel.getComponent(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        loginPanel.add((Component)passwordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        loginPanel.add((Component)this.passwordField, gridBagConstraints);
        if (this.serverCombo != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 5, 11);
            loginPanel.add((Component)serverLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            loginPanel.add((Component)this.serverCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            loginPanel.add((Component)this.saveCB, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            loginPanel.add((Component)this.saveCB, gridBagConstraints);
        }
        return loginPanel;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orient) {
        if (orient != super.getComponentOrientation()) {
            super.setComponentOrientation(orient);
            this.banner.setImage(this.createLoginBanner());
            this.progressPanel.applyComponentOrientation(orient);
        }
    }

    private void initComponents() {
        this.banner = new JXImagePanel();
        this.banner.setImage(this.createLoginBanner());
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setOpaque(true);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.loginPanel = this.createLoginPanel();
        this.errorMessageLabel = new JLabel(UIManager.getString(CLASS_NAME + ".errorMessage"));
        this.errorMessageLabel.setIcon(UIManager.getIcon("JXLoginDialog.error.icon"));
        this.errorMessageLabel.setVerticalTextPosition(1);
        this.errorMessageLabel.setOpaque(true);
        this.errorMessageLabel.setBackground(new Color(255, 215, 215));
        this.errorMessageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.errorMessageLabel.getBackground().darker()), BorderFactory.createEmptyBorder(5, 7, 5, 5)));
        this.errorMessageLabel.setVisible(false);
        this.contentPanel = new JXPanel(new VerticalLayout());
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 7, 11));
        this.contentPanel.add(this.messageLabel);
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add(this.loginPanel);
        this.errorMessageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 36, 0, 11, this.contentPanel.getBackground()), this.errorMessageLabel.getBorder()));
        this.contentPanel.add(this.errorMessageLabel);
        this.progressPanel = new JXPanel(new GridBagLayout());
        this.progressMessageLabel = new JLabel(UIManager.getString(CLASS_NAME + ".pleaseWait"));
        this.progressMessageLabel.setFont(this.progressMessageLabel.getFont().deriveFont(1));
        JProgressBar pb = new JProgressBar();
        pb.setIndeterminate(true);
        JButton cancelButton = new JButton(this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND));
        this.progressPanel.add((Component)this.progressMessageLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.progressPanel.add((Component)pb, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 11, 7), 0, 0));
        this.progressPanel.add((Component)cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.banner, "North");
        this.add((Component)this.contentPanel, "Center");
    }

    protected Image createLoginBanner() {
        return this.getUI() == null ? null : this.getUI().getBanner();
    }

    protected Action createLoginAction() {
        return new LoginAction(this);
    }

    protected Action createCancelAction() {
        return new CancelAction(this);
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
        this.recreateLoginPanel();
    }

    public List<String> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public void setServers(List<String> servers) {
        if (this.servers != servers) {
            List<String> old = this.servers;
            this.servers = servers == null ? new ArrayList() : servers;
            this.recreateLoginPanel();
            this.firePropertyChange("servers", old, servers);
        }
    }

    public void setLoginService(LoginService service) {
        this.loginService = service;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setPasswordStore(PasswordStore store) {
        this.passwordStore = store;
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setUserName(String username) {
        if (this.namePanel != null) {
            this.namePanel.setUserName(username);
        }
    }

    public String getUserName() {
        return this.namePanel == null ? null : this.namePanel.getUserName();
    }

    public void setPassword(char[] password) {
        this.passwordField.setText(new String(password));
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public Image getBanner() {
        return this.banner.getImage();
    }

    public void setBanner(Image img) {
        this.banner.setImage(img);
    }

    public void setBannerText(String text) {
        if (text == null) {
            text = "";
        }
        if (!this.bannerText.equals(text)) {
            String oldText = this.bannerText;
            this.bannerText = text;
            this.banner.setImage(this.createLoginBanner());
            this.firePropertyChange("bannerText", oldText, text);
        }
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public String getErrorMessage() {
        return this.errorMessageLabel.getText();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageLabel.setText(errorMessage);
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status newStatus) {
        if (this.status != newStatus) {
            Status oldStatus = this.status;
            this.status = newStatus;
            this.firePropertyChange("status", (Object)oldStatus, (Object)newStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLogin() {
        this.oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressMessageLabel.setText(UIManager.getString(CLASS_NAME + ".pleaseWait"));
            String name = this.getUserName();
            char[] password = this.getPassword();
            String server = this.servers.size() == 1 ? this.servers.get(0) : (this.serverCombo == null ? null : (String)this.serverCombo.getSelectedItem());
            this.loginService.startAuthentication(name, password, server);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Authentication exception while logging in", ex);
        }
        finally {
            this.setCursor(this.oldCursor);
        }
    }

    protected void cancelLogin() {
        this.progressMessageLabel.setText(UIManager.getString(CLASS_NAME + ".cancelWait"));
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).setEnabled(false);
        this.loginService.cancelAuthentication();
        this.setCursor(this.oldCursor);
    }

    protected void savePassword() {
        if (this.saveCB.isSelected() && (this.saveMode == SaveMode.BOTH || this.saveMode == SaveMode.PASSWORD) && this.passwordStore != null) {
            this.passwordStore.set(this.getUserName(), this.getLoginService().getServer(), this.getPassword());
        }
    }

    public static Status showLoginDialog(Component parent, LoginService svc) {
        return JXLoginPanel.showLoginDialog(parent, svc, null, null);
    }

    public static Status showLoginDialog(Component parent, LoginService svc, PasswordStore ps, UserNameStore us) {
        return JXLoginPanel.showLoginDialog(parent, svc, ps, us, null);
    }

    public static Status showLoginDialog(Component parent, LoginService svc, PasswordStore ps, UserNameStore us, List<String> servers) {
        JXLoginPanel panel = new JXLoginPanel(svc, ps, us, servers);
        return JXLoginPanel.showLoginDialog(parent, panel);
    }

    public static Status showLoginDialog(Component parent, JXLoginPanel panel) {
        Window w = WindowUtils.findWindow(parent);
        JXLoginDialog dlg = null;
        if (w == null) {
            dlg = new JXLoginDialog((Frame)null, panel);
        } else if (w instanceof Dialog) {
            dlg = new JXLoginDialog((Dialog)w, panel);
        } else if (w instanceof Frame) {
            dlg = new JXLoginDialog((Frame)w, panel);
        }
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public static JXLoginFrame showLoginFrame(LoginService svc) {
        return JXLoginPanel.showLoginFrame(svc, null, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService svc, PasswordStore ps, UserNameStore us) {
        return JXLoginPanel.showLoginFrame(svc, ps, us, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService svc, PasswordStore ps, UserNameStore us, List<String> servers) {
        JXLoginPanel panel = new JXLoginPanel(svc, ps, us, servers);
        return JXLoginPanel.showLoginFrame(panel);
    }

    public static JXLoginFrame showLoginFrame(JXLoginPanel panel) {
        return new JXLoginFrame(panel);
    }

    static void initWindow(final Window w, final JXLoginPanel panel) {
        w.setLayout(new BorderLayout());
        w.add((Component)panel, "Center");
        JButton okButton = new JButton(panel.getActionMap().get(LOGIN_ACTION_COMMAND));
        final JButton cancelButton = new JButton(UIManager.getString(CLASS_NAME + ".cancelString"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.status = Status.CANCELLED;
                w.setVisible(false);
                w.dispose();
            }
        });
        panel.addPropertyChangeListener("status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Status status = (Status)((Object)evt.getNewValue());
                switch (status) {
                    case NOT_STARTED: {
                        break;
                    }
                    case IN_PROGRESS: {
                        cancelButton.setEnabled(false);
                        break;
                    }
                    case CANCELLED: {
                        cancelButton.setEnabled(true);
                        w.pack();
                        break;
                    }
                    case FAILED: {
                        cancelButton.setEnabled(true);
                        w.pack();
                        break;
                    }
                    case SUCCEEDED: {
                        w.setVisible(false);
                        w.dispose();
                    }
                }
            }
        });
        cancelButton.setText(UIManager.getString(CLASS_NAME + ".cancelString"));
        int prefWidth = Math.max(cancelButton.getPreferredSize().width, okButton.getPreferredSize().width);
        cancelButton.setPreferredSize(new Dimension(prefWidth, okButton.getPreferredSize().height));
        okButton.setPreferredSize(new Dimension(prefWidth, okButton.getPreferredSize().height));
        JXPanel buttonPanel = new JXPanel(new GridBagLayout());
        buttonPanel.add((Component)okButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(17, 12, 11, 5), 0, 0));
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(17, 0, 11, 11), 0, 0));
        w.add((Component)buttonPanel, "South");
        w.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                panel.cancelLogin();
            }
        });
        if (w instanceof JFrame) {
            final JFrame f = (JFrame)w;
            f.getRootPane().setDefaultButton(okButton);
            f.setResizable(false);
            f.setDefaultCloseOperation(2);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            ActionListener closeAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    f.setVisible(false);
                    f.dispose();
                }
            };
            f.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        } else if (w instanceof JDialog) {
            final JDialog d = (JDialog)w;
            d.getRootPane().setDefaultButton(okButton);
            d.setResizable(false);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            ActionListener closeAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    d.setVisible(false);
                }
            };
            d.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        }
        w.pack();
        w.setLocation(WindowUtils.getPointForCentering(w));
    }

    static {
        LookAndFeelAddons.contribute(new JXLoginPanelAddon());
        CLASS_NAME = JXLoginPanel.class.getCanonicalName();
        ResourceBundle res = ResourceBundle.getBundle("org.jdesktop.swingx.auth.resources.resources");
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String lookup = CLASS_NAME + "." + key;
            if (UIManager.getString(lookup) != null) continue;
            UIManager.put(lookup, res.getString(key));
        }
    }

    public static final class JXLoginFrame
    extends JFrame {
        private JXLoginPanel panel;

        public JXLoginFrame(JXLoginPanel p) {
            super(UIManager.getString(CLASS_NAME + ".titleString"));
            this.panel = p;
            JXLoginPanel.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }

        public JXLoginPanel getPanel() {
            return this.panel;
        }
    }

    public static final class JXLoginDialog
    extends JDialog {
        private JXLoginPanel panel;

        public JXLoginDialog(Frame parent, JXLoginPanel p) {
            super(parent, true);
            this.init(p);
        }

        public JXLoginDialog(Dialog parent, JXLoginPanel p) {
            super(parent, true);
            this.init(p);
        }

        protected void init(JXLoginPanel p) {
            this.setTitle(UIManager.getString(CLASS_NAME + ".titleString"));
            this.panel = p;
            JXLoginPanel.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }
    }

    public static final class ComboNamePanel
    extends JComboBox
    implements NameComponent {
        private UserNameStore userNameStore;

        public ComboNamePanel(UserNameStore userNameStore) {
            this.userNameStore = userNameStore;
            this.setModel(new NameComboBoxModel());
            this.setEditable(true);
        }

        public String getUserName() {
            Object item = this.getModel().getSelectedItem();
            return item == null ? null : item.toString();
        }

        public void setUserName(String userName) {
            this.getModel().setSelectedItem(userName);
        }

        public void setUserNames(String[] names) {
            this.setModel(new DefaultComboBoxModel<String>(names));
        }

        public JComponent getComponent() {
            return this;
        }

        private final class NameComboBoxModel
        extends AbstractListModel
        implements ComboBoxModel {
            private Object selectedItem;

            private NameComboBoxModel() {
            }

            public void setSelectedItem(Object anItem) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }

            public Object getSelectedItem() {
                return this.selectedItem;
            }

            public Object getElementAt(int index) {
                return ComboNamePanel.this.userNameStore.getUserNames()[index];
            }

            public int getSize() {
                return ComboNamePanel.this.userNameStore.getUserNames().length;
            }
        }
    }

    public static final class SimpleNamePanel
    extends JTextField
    implements NameComponent {
        public SimpleNamePanel() {
            super("", 15);
        }

        public String getUserName() {
            return this.getText();
        }

        public void setUserName(String userName) {
            this.setText(userName);
        }

        public JComponent getComponent() {
            return this;
        }
    }

    public static interface NameComponent {
        public String getUserName();

        public void setUserName(String var1);

        public JComponent getComponent();
    }

    private static final class NullPasswordStore
    extends PasswordStore {
        private static final char[] EMPTY = new char[0];

        private NullPasswordStore() {
        }

        public boolean set(String username, String server, char[] password) {
            return false;
        }

        public char[] get(String username, String server) {
            return EMPTY;
        }
    }

    private static final class NullLoginService
    extends LoginService {
        private NullLoginService() {
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            return true;
        }
    }

    private static final class CancelAction
    extends AbstractActionExt {
        private JXLoginPanel panel;

        public CancelAction(JXLoginPanel p) {
            super(UIManager.getString(CLASS_NAME + ".cancelLogin"), JXLoginPanel.CANCEL_LOGIN_ACTION_COMMAND);
            this.panel = p;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.panel.cancelLogin();
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    private static final class LoginAction
    extends AbstractActionExt {
        private JXLoginPanel panel;

        public LoginAction(JXLoginPanel p) {
            super(UIManager.getString(CLASS_NAME + ".loginString"), JXLoginPanel.LOGIN_ACTION_COMMAND);
            this.panel = p;
        }

        public void actionPerformed(ActionEvent e) {
            this.panel.startLogin();
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    protected class LoginListenerImpl
    extends LoginAdapter {
        protected LoginListenerImpl() {
        }

        public void loginSucceeded(LoginEvent source) {
            String userName = JXLoginPanel.this.namePanel.getUserName();
            JXLoginPanel.this.savePassword();
            if (JXLoginPanel.this.getSaveMode() == SaveMode.USER_NAME && userName != null && !userName.trim().equals("")) {
                JXLoginPanel.this.userNameStore.addUserName(userName);
                JXLoginPanel.this.userNameStore.saveUserNames();
            }
            JXLoginPanel.this.setStatus(Status.SUCCEEDED);
        }

        public void loginStarted(LoginEvent source) {
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(false);
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.CANCEL_LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.remove(JXLoginPanel.this.contentPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.progressPanel, "Center");
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.IN_PROGRESS);
        }

        public void loginFailed(LoginEvent source) {
            JXLoginPanel.this.remove(JXLoginPanel.this.progressPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.contentPanel, "Center");
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.errorMessageLabel.setVisible(true);
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.FAILED);
        }

        public void loginCanceled(LoginEvent source) {
            JXLoginPanel.this.remove(JXLoginPanel.this.progressPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.contentPanel, "Center");
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.errorMessageLabel.setVisible(false);
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.CANCELLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        FAILED,
        CANCELLED,
        SUCCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveMode {
        NONE,
        USER_NAME,
        PASSWORD,
        BOTH;

    }
}

