/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.RolloverController;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.RolloverRenderer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.ResetDTCRColorHighlighter;
import org.jdesktop.swingx.decorator.SearchHighlighter;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SizeSequenceMapper;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.icon.ColumnControlIcon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTable
extends JTable {
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    public static final String HORIZONTALSCROLL_ACTION_COMMAND = "column.horizontalScroll";
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    public static final String UIPREFIX = "JXTable.";
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    protected Highlighter resetDefaultTableCellRendererHighlighter;
    protected ComponentAdapter dataAdapter;
    private SelectionMapper selectionMapper;
    private boolean sortable;
    private PipelineListener pipelineListener;
    private ChangeListener highlighterChangeListener;
    private ColumnFactory columnFactory;
    private int visibleRowCount = 18;
    private SizeSequenceMapper rowModelMapper;
    private Field rowModelField;
    private boolean rowHeightEnabled;
    private boolean columnControlVisible;
    private int verticalScrollPolicy;
    private JComponent columnControlButton;
    private RolloverProducer rolloverProducer;
    private TableRolloverController linkController;
    private int oldAutoResizeMode;
    protected boolean isXTableRowHeightSet;
    protected Searchable searchable;
    private boolean fillsViewportHeight;
    private boolean ensureFillsViewportWidth;
    private boolean editable;
    private boolean expandsToViewportWidthEnabled;
    private boolean dockedOnExpand;

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public JXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public JXTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    protected void init() {
        this.setEditable(true);
        this.setSortable(true);
        this.setRolloverEnabled(true);
        this.setTerminateEditOnFocusLost(true);
        this.setFilters(null);
        this.initActionsAndBindings();
        this.updateRowHeightUI(false);
        this.setFillsViewportHeight(true);
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected TableRolloverController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TableRolloverController createLinkController() {
        return new TableRolloverController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer r = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                JTable table = (JTable)component;
                int col = table.columnAtPoint(mousePoint);
                int row = table.rowAtPoint(mousePoint);
                if (col < 0 || row < 0) {
                    row = -1;
                    col = -1;
                }
                this.rollover.x = col;
                this.rollover.y = row;
            }
        };
        return r;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureColumnControl();
    }

    protected void configureViewportBackground() {
        Container p = this.getParent();
        if (p instanceof JViewport) {
            p.setBackground(this.getBackground());
        }
    }

    private void configureColumnControl() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (this.isColumnControlVisible()) {
                this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
                scrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
                scrollPane.setVerticalScrollBarPolicy(22);
            } else {
                if (this.verticalScrollPolicy != 0) {
                    scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                }
                try {
                    scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this.configureColumnControl();
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = new ColumnControlButton(this, (Icon)new ColumnControlIcon());
        }
        return this.columnControlButton;
    }

    public void setColumnControlVisible(boolean showColumnControl) {
        boolean old = this.columnControlVisible;
        this.columnControlVisible = showColumnControl;
        this.configureColumnControl();
        this.firePropertyChange("columnControlVisible", old, this.columnControlVisible);
    }

    private void initActionsAndBindings() {
        ActionMap map = this.getActionMap();
        map.put("print", new Actions("print"));
        map.put("find", new Actions("find"));
        map.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        map.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
        map.put(HORIZONTALSCROLL_ACTION_COMMAND, this.createHorizontalScrollAction());
        KeyStroke findStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createHorizontalScrollAction() {
        String actionName = this.getUIString(HORIZONTALSCROLL_ACTION_COMMAND);
        BoundAction action = new BoundAction(actionName, HORIZONTALSCROLL_ACTION_COMMAND);
        action.setStateAction();
        action.registerCallback(this, "setHorizontalScrollEnabled");
        action.setSelected(this.isHorizontalScrollEnabled());
        return action;
    }

    private String getUIString(String key) {
        String text = UIManager.getString(UIPREFIX + key);
        return text != null ? text : key;
    }

    private Action createPackSelectedAction() {
        String text = this.getUIString(PACKSELECTED_ACTION_COMMAND);
        BoundAction action = new BoundAction(text, PACKSELECTED_ACTION_COMMAND);
        action.registerCallback(this, "packSelected");
        action.setEnabled(this.getSelectedColumnCount() > 0);
        return action;
    }

    private Action createPackAllAction() {
        String text = this.getUIString(PACKALL_ACTION_COMMAND);
        BoundAction action = new BoundAction(text, PACKALL_ACTION_COMMAND);
        action.registerCallback(this, "packAll");
        return action;
    }

    public void packAll() {
        this.packTable(-1);
        this.expandToViewportWidth();
    }

    public void packSelected() {
        int selected = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (selected >= 0) {
            this.packColumn(selected, -1);
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        Action packSelected = this.getActionMap().get(PACKSELECTED_ACTION_COMMAND);
        if (packSelected != null) {
            packSelected.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
        }
    }

    public void setHorizontalScrollEnabled(boolean enabled) {
        if (enabled == this.isHorizontalScrollEnabled()) {
            return;
        }
        if (enabled) {
            this.oldAutoResizeMode = this.getAutoResizeMode();
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
    }

    protected boolean isHorizontalScrollEnabled() {
        return this.getAutoResizeMode() == 0;
    }

    @Override
    public void setAutoResizeMode(int mode) {
        if (mode == 0 && this.getAutoResizeMode() != mode) {
            this.ensureFillsViewportWidth = true;
        }
        if (mode != 0) {
            this.oldAutoResizeMode = mode;
        }
        super.setAutoResizeMode(mode);
        Action showHorizontal = this.getActionMap().get(HORIZONTALSCROLL_ACTION_COMMAND);
        if (showHorizontal instanceof BoundAction) {
            ((BoundAction)showHorizontal).setSelected(this.isHorizontalScrollEnabled());
        }
    }

    public void expandToViewportWidth() {
        if (!this.isExpandsToViewportWidthEnabled()) {
            return;
        }
        this.ensureFillsViewportWidth = true;
        this.revalidate();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        boolean shouldTrack = super.getScrollableTracksViewportWidth();
        if (this.isExpandsToViewportWidthEnabled() && this.ensureFillsViewportWidth && this.isHorizontalScrollEnabled()) {
            shouldTrack = this.getPreferredSize().width <= this.getParent().getWidth();
        }
        return shouldTrack;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.isExpandsToViewportWidthEnabled()) {
            return;
        }
        if (this.ensureFillsViewportWidth && this.getWidth() > 0 && this.getParent() != null && this.getParent().getWidth() > 0) {
            if (!this.isDockedOnExpandWidth()) {
                this.ensureFillsViewportWidth = false;
            }
            Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn c = enumeration.nextElement();
                c.setPreferredWidth(c.getWidth());
            }
            this.revalidate();
        }
    }

    public void setExpandsToViewportWidthEnabled(boolean enabled) {
        boolean old = this.isExpandsToViewportWidthEnabled();
        if (old == enabled) {
            return;
        }
        this.expandsToViewportWidthEnabled = enabled;
        this.firePropertyChange("expandsToViewportWidthEnabled", old, this.isExpandsToViewportWidthEnabled());
        this.expandToViewportWidth();
    }

    protected boolean isExpandsToViewportWidthEnabled() {
        return this.expandsToViewportWidthEnabled;
    }

    public void setDockedOnExpandWidth(boolean docked) {
        boolean old = this.isDockedOnExpandWidth();
        if (old == docked) {
            return;
        }
        this.dockedOnExpand = docked;
        this.expandToViewportWidth();
        this.firePropertyChange("dockeOnExpandWidth", old, this.isDockedOnExpandWidth());
    }

    protected boolean isDockedOnExpandWidth() {
        return this.dockedOnExpand;
    }

    @Override
    public void setFillsViewportHeight(boolean fillsViewportHeight) {
        if (fillsViewportHeight == this.getFillsViewportHeight()) {
            return;
        }
        boolean old = this.getFillsViewportHeight();
        this.fillsViewportHeight = fillsViewportHeight;
        this.firePropertyChange("fillsViewportHeight", old, this.getFillsViewportHeight());
        this.revalidate();
    }

    @Override
    public boolean getFillsViewportHeight() {
        return this.fillsViewportHeight;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getFillsViewportHeight() && this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
    }

    @Override
    public int getRowCount() {
        return this.filters == null ? super.getRowCount() : this.filters.getOutputSize();
    }

    public boolean isHierarchical(int column) {
        return false;
    }

    @Override
    public int convertRowIndexToModel(int row) {
        return this.getFilters().convertRowIndexToModel(row);
    }

    @Override
    public int convertRowIndexToView(int row) {
        return this.getFilters().convertRowIndexToView(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getModel().getValueAt(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        this.getModel().setValueAt(aValue, this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        TableColumnExt tableColumn;
        if (!this.isEditable()) {
            return false;
        }
        boolean editable = this.getModel().isCellEditable(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
        if (editable && (tableColumn = this.getColumnExt(column)) != null) {
            editable = editable && tableColumn.isEditable();
        }
        return editable;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        super.setSelectionModel(newModel);
        this.getSelectionMapper().setViewSelectionModel(this.getSelectionModel());
    }

    @Override
    public void setModel(TableModel newModel) {
        this.getSelectionMapper().lock();
        super.setModel(newModel);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.getSelectionModel().getValueIsAdjusting()) {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
        this.getSelectionMapper().lock();
        super.tableChanged(e);
        this.updateSelectionAndRowModel(e);
        this.use(this.filters);
    }

    private void updateSelectionAndRowModel(TableModelEvent e) {
        if (e.getType() == 1) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            if (end < 0) {
                end = this.getModel().getRowCount() - 1;
            }
            int length = end - start + 1;
            this.getSelectionMapper().insertIndexInterval(start, length, true);
            this.getRowModelMapper().insertIndexInterval(start, length, this.getRowHeight());
        } else if (e.getType() == -1) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            if (end < 0) {
                end = this.getModel().getRowCount() - 1;
            }
            int deletedCount = end - start + 1;
            this.getSelectionMapper().removeIndexInterval(start, end);
            this.getRowModelMapper().removeIndexInterval(start, deletedCount);
        } else if (this.isDataChanged(e) || this.isStructureChanged(e)) {
            this.hackLeadAnchor(e);
            this.getSelectionMapper().clearModelSelection();
            this.getRowModelMapper().clearModelSizes();
            this.updateViewSizeSequence();
        }
    }

    private boolean isDataChanged(TableModelEvent e) {
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    private boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    private void hackLeadAnchor(TableModelEvent e) {
        int lead = this.getSelectionModel().getLeadSelectionIndex();
        int anchor = this.getSelectionModel().getAnchorSelectionIndex();
        int lastRow = this.getModel().getRowCount() - 1;
        if (lead > lastRow || anchor > lastRow) {
            lead = anchor = lastRow;
            this.getSelectionModel().setAnchorSelectionIndex(lead);
            this.getSelectionModel().setLeadSelectionIndex(lead);
        }
    }

    protected void updateViewSizeSequence() {
        SizeSequence sizeSequence = null;
        if (this.isRowHeightEnabled()) {
            sizeSequence = this.getSuperRowModel();
        }
        this.getRowModelMapper().setViewSizeSequence(sizeSequence, this.getRowHeight());
    }

    protected SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new SelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            if (this.initialUse(pipeline)) {
                pipeline.addPipelineListener(this.getFilterPipelineListener());
                pipeline.assign(this.getComponentAdapter());
            } else {
                pipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline pipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] l = pipeline.getPipelineListeners();
        for (int i = 0; i < l.length; ++i) {
            if (!this.pipelineListener.equals(l[i])) continue;
            return false;
        }
        return true;
    }

    public void setFilters(FilterPipeline pipeline) {
        FilterPipeline old = this.getFilters();
        List<? extends SortKey> sortKeys = null;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
            sortKeys = old.getSortController().getSortKeys();
        }
        if (pipeline == null) {
            pipeline = new FilterPipeline();
        }
        this.filters = pipeline;
        this.filters.getSortController().setSortKeys(sortKeys);
        this.use(this.filters);
        this.getRowModelMapper().setFilters(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        PipelineListener l = new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                JXTable.this.updateOnFilterContentChanged();
            }
        };
        return l;
    }

    protected void updateOnFilterContentChanged() {
        this.revalidate();
        this.repaint();
    }

    public void setSortable(boolean sortable) {
        if (sortable == this.isSortable()) {
            return;
        }
        this.sortable = sortable;
        if (!this.isSortable()) {
            this.resetSortOrder();
        }
        this.firePropertyChange("sortable", !sortable, sortable);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void resetSortOrder() {
        SortController controller = this.getSortController();
        if (controller != null) {
            controller.setSortKeys(null);
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public void toggleSortOrder(int columnIndex) {
        if (!this.isSortable(columnIndex)) {
            return;
        }
        SortController controller = this.getSortController();
        if (controller != null) {
            TableColumnExt columnExt = this.getColumnExt(columnIndex);
            controller.toggleSortOrder(this.convertColumnIndexToModel(columnIndex), columnExt != null ? columnExt.getComparator() : null);
        }
    }

    protected boolean isSortable(int columnIndex) {
        boolean sortable = this.isSortable();
        TableColumnExt tableColumnExt = this.getColumnExt(columnIndex);
        if (tableColumnExt != null) {
            sortable = sortable && tableColumnExt.isSortable();
        }
        return sortable;
    }

    public void setSortOrder(int columnIndex, SortOrder sortOrder) {
        if (sortOrder == null || !sortOrder.isSorted()) {
            this.resetSortOrder();
            return;
        }
        if (!this.isSortable(columnIndex)) {
            return;
        }
        SortController sortController = this.getSortController();
        if (sortController != null) {
            TableColumnExt columnExt = this.getColumnExt(columnIndex);
            SortKey sortKey = new SortKey(sortOrder, this.convertColumnIndexToModel(columnIndex), columnExt != null ? columnExt.getComparator() : null);
            sortController.setSortKeys(Collections.singletonList(sortKey));
        }
    }

    public SortOrder getSortOrder(int columnIndex) {
        SortController sortController = this.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        SortKey sortKey = SortKey.getFirstSortKeyForColumn(sortController.getSortKeys(), this.convertColumnIndexToModel(columnIndex));
        return sortKey != null ? sortKey.getSortOrder() : SortOrder.UNSORTED;
    }

    public void toggleSortOrder(Object identifier) {
        if (!this.isSortable(identifier)) {
            return;
        }
        SortController controller = this.getSortController();
        if (controller != null) {
            TableColumnExt columnExt = this.getColumnExt(identifier);
            if (columnExt == null) {
                return;
            }
            controller.toggleSortOrder(columnExt.getModelIndex(), columnExt.getComparator());
        }
    }

    public void setSortOrder(Object identifier, SortOrder sortOrder) {
        if (sortOrder == null || !sortOrder.isSorted()) {
            this.resetSortOrder();
            return;
        }
        if (!this.isSortable(identifier)) {
            return;
        }
        SortController sortController = this.getSortController();
        if (sortController != null) {
            TableColumnExt columnExt = this.getColumnExt(identifier);
            if (columnExt == null) {
                return;
            }
            SortKey sortKey = new SortKey(sortOrder, columnExt.getModelIndex(), columnExt.getComparator());
            sortController.setSortKeys(Collections.singletonList(sortKey));
        }
    }

    public SortOrder getSortOrder(Object identifier) {
        SortController sortController = this.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        TableColumnExt columnExt = this.getColumnExt(identifier);
        if (columnExt == null) {
            return SortOrder.UNSORTED;
        }
        int modelIndex = columnExt.getModelIndex();
        SortKey sortKey = SortKey.getFirstSortKeyForColumn(sortController.getSortKeys(), modelIndex);
        return sortKey != null ? sortKey.getSortOrder() : SortOrder.UNSORTED;
    }

    protected boolean isSortable(Object identifier) {
        boolean sortable = this.isSortable();
        TableColumnExt tableColumnExt = this.getColumnExt(identifier);
        if (tableColumnExt != null) {
            sortable = sortable && tableColumnExt.isSortable();
        }
        return sortable;
    }

    protected SortController getSortController() {
        if (this.filters == null) {
            return null;
        }
        return this.getFilters().getSortController();
    }

    public TableColumn getSortedColumn() {
        SortKey sortKey;
        SortController controller = this.getSortController();
        if (controller != null && (sortKey = SortKey.getFirstSortingKey(controller.getSortKeys())) != null) {
            int sorterColumn = sortKey.getColumn();
            List<TableColumn> columns = this.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != sorterColumn) continue;
                return column;
            }
        }
        return null;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.updateSorterAfterColumnRemoved();
        super.columnRemoved(e);
    }

    private void updateSorterAfterColumnRemoved() {
        TableColumn sortedColumn = this.getSortedColumn();
        if (sortedColumn == null) {
            this.resetSortOrder();
        }
    }

    protected void removeColumns() {
        List<TableColumn> columns = this.getColumns(true);
        Iterator<TableColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            this.getColumnModel().removeColumn(iter.next());
        }
    }

    public List<TableColumn> getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public List<TableColumn> getColumns(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(includeHidden);
        }
        return this.getColumns();
    }

    public int getColumnCount(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnCount(includeHidden);
        }
        return this.getColumnCount();
    }

    public void setColumnSequence(Object[] identifiers) {
        List<TableColumn> columns = this.getColumns(true);
        HashMap<Object, TableColumn> map = new HashMap<Object, TableColumn>();
        for (TableColumn column : columns) {
            map.put(column.getIdentifier(), column);
            this.getColumnModel().removeColumn(column);
        }
        for (int i = 0; i < identifiers.length; ++i) {
            TableColumn column;
            column = (TableColumn)map.get(identifiers[i]);
            if (column == null) continue;
            this.getColumnModel().addColumn(column);
            columns.remove(column);
        }
        for (TableColumn column : columns) {
            this.getColumnModel().addColumn(column);
        }
    }

    public TableColumnExt getColumnExt(Object identifier) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnExt(identifier);
        }
        try {
            TableColumn column = this.getColumn(identifier);
            if (column instanceof TableColumnExt) {
                return (TableColumnExt)column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public TableColumnExt getColumnExt(int viewColumnIndex) {
        TableColumn column = this.getColumn(viewColumnIndex);
        if (column instanceof TableColumnExt) {
            return (TableColumnExt)column;
        }
        return null;
    }

    public TableColumn getColumn(int viewColumnIndex) {
        return this.getColumnModel().getColumn(viewColumnIndex);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel model = this.getModel();
        if (model != null) {
            int i;
            int modelColumnCount = model.getColumnCount();
            TableColumn[] newColumns = new TableColumn[modelColumnCount];
            for (i = 0; i < newColumns.length; ++i) {
                newColumns[i] = this.createAndConfigureColumn(model, i);
            }
            this.removeColumns();
            for (i = 0; i < newColumns.length; ++i) {
                this.addColumn(newColumns[i]);
            }
        }
        this.expandToViewportWidth();
    }

    protected TableColumn createAndConfigureColumn(TableModel model, int modelColumn) {
        return this.getColumnFactory().createAndConfigureTableColumn(model, modelColumn);
    }

    protected ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            return ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        ColumnFactory old = this.getColumnFactory();
        this.columnFactory = columnFactory;
        this.firePropertyChange("columnFactory", old, this.getColumnFactory());
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.getColumnModel().setColumnMargin(value);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TableSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void scrollRowToVisible(int row) {
        Rectangle cellRect = this.getCellRect(row, 0, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollColumnToVisible(int column) {
        Rectangle cellRect = this.getCellRect(0, column, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.y = visibleRect.y;
        cellRect.height = visibleRect.height;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollCellToVisible(int row, int column) {
        Rectangle cellRect = this.getCellRect(row, column, false);
        this.scrollRectToVisible(cellRect);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = super.getPreferredScrollableViewportSize();
        if (prefSize.getWidth() == 450.0 && prefSize.getHeight() == 400.0) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            int w = 0;
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = columnModel.getColumn(i);
                this.initializeColumnPreferredWidth(column);
                w += column.getPreferredWidth();
            }
            prefSize.width = w;
            JTableHeader header = this.getTableHeader();
            int rowCount = this.getVisibleRowCount();
            prefSize.height = rowCount * this.getRowHeight() + (header != null ? header.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(prefSize);
        }
        return prefSize;
    }

    public void packTable(int margin) {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            this.packColumn(c, margin, -1);
        }
    }

    public void packColumn(int column, int margin) {
        this.packColumn(column, margin, -1);
    }

    public void packColumn(int column, int margin, int max) {
        this.getColumnFactory().packColumn(this, this.getColumnExt(column), margin, max);
    }

    protected void initializeColumnPreferredWidth(TableColumn column) {
        if (column instanceof TableColumnExt) {
            this.getColumnFactory().configureColumnWidths(this, (TableColumnExt)column);
        }
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TableAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int row, int column) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return adapter;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        HighlighterPipeline old = this.getHighlighters();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = pipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getHighlighters());
        this.repaint();
    }

    public void addHighlighter(Highlighter highlighter) {
        HighlighterPipeline pipeline = this.getHighlighters();
        if (pipeline == null) {
            this.setHighlighters(new HighlighterPipeline(new Highlighter[]{highlighter}));
        } else {
            pipeline.addHighlighter(highlighter);
        }
    }

    public void removeHighlighter(Highlighter highlighter) {
        if (this.getHighlighters() == null) {
            return;
        }
        this.getHighlighters().removeHighlighter(highlighter);
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXTable.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component stamp = super.prepareRenderer(renderer, row, column);
        this.adjustComponentOrientation(stamp);
        this.resetDefaultTableCellRendererColors(stamp, row, column);
        if (this.highlighters == null) {
            return stamp;
        }
        return this.highlighters.apply(stamp, this.getComponentAdapter(row, column));
    }

    protected void resetDefaultTableCellRendererColors(Component renderer, int row, int column) {
        ComponentAdapter adapter = this.getComponentAdapter(row, column);
        if (this.resetDefaultTableCellRendererHighlighter == null) {
            this.resetDefaultTableCellRendererHighlighter = new ResetDTCRColorHighlighter();
        }
        this.resetDefaultTableCellRendererHighlighter.highlight(renderer, adapter);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        this.adjustComponentOrientation(comp);
        return comp;
    }

    protected void adjustComponentOrientation(Component stamp) {
        if (stamp.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        stamp.applyComponentOrientation(this.getComponentOrientation());
    }

    public TableCellRenderer getNewDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = this.getDefaultRenderer(columnClass);
        if (renderer != null) {
            try {
                return (TableCellRenderer)renderer.getClass().newInstance();
            }
            catch (Exception e) {
                LOG.fine("could not create renderer for " + columnClass);
            }
        }
        return null;
    }

    @Override
    protected void createDefaultRenderers() {
        Object[] dummies = new Object[]{1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0};
        this.defaultRenderersByColumnClass = new UIDefaults(dummies);
        this.defaultRenderersByColumnClass.clear();
        this.setLazyRenderer(Object.class, "javax.swing.table.DefaultTableCellRenderer");
        this.setLazyRenderer(Number.class, "org.jdesktop.swingx.JXTable$NumberRenderer");
        this.setLazyRenderer(Float.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Double.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Date.class, "org.jdesktop.swingx.JXTable$DateRenderer");
        this.setLazyRenderer(Icon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(ImageIcon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanRenderer");
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    private void setLazyEditor(Class c, String s) {
        this.setLazyValue(this.defaultEditorsByColumnClass, c, s);
    }

    @Override
    protected void createDefaultEditors() {
        Object[] dummies = new Object[]{1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0};
        this.defaultEditorsByColumnClass = new UIDefaults(dummies);
        this.defaultEditorsByColumnClass.clear();
        this.setLazyEditor(Object.class, "org.jdesktop.swingx.JXTable$GenericEditor");
        this.setLazyEditor(Number.class, "org.jdesktop.swingx.JXTable$NumberEditor");
        this.setLazyEditor(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanEditor");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean old = this.isEditable();
        this.editable = editable;
        this.firePropertyChange("editable", old, this.isEditable());
    }

    public boolean isTerminateEditOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("terminateEditOnFocusLost"));
    }

    public void setTerminateEditOnFocusLost(boolean terminate) {
        this.putClientProperty("terminateEditOnFocusLost", terminate);
    }

    public boolean isAutoStartEditOnKeyStroke() {
        return !Boolean.FALSE.equals(this.getClientProperty("JTable.autoStartsEdit"));
    }

    public void setAutoStartEditOnKeyStroke(boolean autoStart) {
        boolean old = this.isAutoStartEditOnKeyStroke();
        this.putClientProperty("JTable.autoStartsEdit", autoStart);
        this.firePropertyChange("autoStartEditOnKeyStroke", old, this.isAutoStartEditOnKeyStroke());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.columnControlButton != null) {
            this.columnControlButton.updateUI();
        }
        Enumeration defaultEditors = this.defaultEditorsByColumnClass.elements();
        while (defaultEditors.hasMoreElements()) {
            this.updateEditorUI(defaultEditors.nextElement());
        }
        Enumeration defaultRenderers = this.defaultRenderersByColumnClass.elements();
        while (defaultRenderers.hasMoreElements()) {
            this.updateRendererUI(defaultRenderers.nextElement());
        }
        List<TableColumn> columns = this.getColumns(true);
        for (TableColumn column : columns) {
            this.updateEditorUI(column.getCellEditor());
            this.updateRendererUI(column.getCellRenderer());
            this.updateRendererUI(column.getHeaderRenderer());
        }
        this.updateRowHeightUI(true);
        this.updateHighlighters();
        this.configureViewportBackground();
    }

    protected void updateHighlighters() {
        if (this.getHighlighters() == null) {
            return;
        }
        this.getHighlighters().updateUI();
    }

    private void updateRowHeightUI(boolean respectRowSetFlag) {
        if (respectRowSetFlag && this.isXTableRowHeightSet) {
            return;
        }
        int minimumSize = this.getFont().getSize() + 6;
        int uiSize = UIManager.getInt("JXTable.rowHeight");
        this.setRowHeight(Math.max(minimumSize, uiSize != 0 ? uiSize : 18));
        this.isXTableRowHeightSet = false;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (rowHeight > 0) {
            this.isXTableRowHeightSet = true;
        }
        this.updateViewSizeSequence();
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        if (!this.isRowHeightEnabled()) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        this.updateViewSizeSequence();
        this.resizeAndRepaint();
    }

    public void setRowHeightEnabled(boolean enabled) {
        boolean old = this.isRowHeightEnabled();
        if (old == enabled) {
            return;
        }
        if (enabled && !this.canEnableRowHeight()) {
            return;
        }
        this.rowHeightEnabled = enabled;
        if (!enabled) {
            this.adminSetRowHeight(this.getRowHeight());
        }
        this.firePropertyChange("rowHeightEnabled", old, this.rowHeightEnabled);
    }

    private boolean canEnableRowHeight() {
        return this.getRowModelField() != null;
    }

    public boolean isRowHeightEnabled() {
        return this.rowHeightEnabled;
    }

    private SizeSequence getSuperRowModel() {
        try {
            Field field = this.getRowModelField();
            if (field != null) {
                return (SizeSequence)field.get(this);
            }
        }
        catch (SecurityException e) {
            LOG.fine("cannot use reflection  - expected behaviour in sandbox");
        }
        catch (IllegalArgumentException e) {
            LOG.fine("problem while accessing super's private field - private api changed?");
        }
        catch (IllegalAccessException e) {
            LOG.fine("cannot access private field  - expected behaviour in sandbox. Could be program logic running wild in unrestricted contexts");
        }
        return null;
    }

    private Field getRowModelField() {
        if (this.rowModelField == null) {
            try {
                this.rowModelField = JTable.class.getDeclaredField("rowModel");
                this.rowModelField.setAccessible(true);
            }
            catch (SecurityException e) {
                this.rowModelField = null;
                LOG.fine("cannot access JTable private field rowModel - expected behaviour in sandbox");
            }
            catch (NoSuchFieldException e) {
                LOG.fine("problem while accessing super's private field - private api changed?");
            }
        }
        return this.rowModelField;
    }

    protected SizeSequenceMapper getRowModelMapper() {
        if (this.rowModelMapper == null) {
            this.rowModelMapper = new SizeSequenceMapper(this.filters);
        }
        return this.rowModelMapper;
    }

    protected void adminSetRowHeight(int rowHeight) {
        boolean heightSet = this.isXTableRowHeightSet;
        this.setRowHeight(rowHeight);
        this.isXTableRowHeightSet = heightSet;
    }

    private void updateEditorUI(Object value) {
        if (!(value instanceof TableCellEditor)) {
            return;
        }
        if (value instanceof JComponent || value instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component comp = ((TableCellEditor)value).getTableCellEditorComponent(this, null, false, -1, -1);
            if (comp instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(Object value) {
        if (!(value instanceof TableCellRenderer)) {
            return;
        }
        if (value instanceof JComponent) {
            return;
        }
        try {
            Component comp = ((TableCellRenderer)value).getTableCellRendererComponent(this, null, false, false, -1, -1);
            if (comp instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int rowAtPoint(Point point) {
        if (point.y < 0) {
            return -1;
        }
        return super.rowAtPoint(point);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel);
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    public static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }
    }

    public static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    public static class GenericEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;

        public GenericEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if ("".equals(s)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = s;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(s);
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (Exception e) {
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return this.value;
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        private final DateFormat formatter;

        public DateRenderer() {
            this((DateFormat)null);
        }

        public DateRenderer(DateFormat formatter) {
            if (formatter == null) {
                formatter = DateFormat.getDateInstance();
            }
            this.formatter = formatter;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        private final NumberFormat formatter;

        public DoubleRenderer() {
            this((NumberFormat)null);
        }

        public DoubleRenderer(NumberFormat formatter) {
            if (formatter == null) {
                formatter = NumberFormat.getInstance();
            }
            this.formatter = formatter;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(11);
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        public TableAdapter(JXTable component) {
            super(component);
            this.table = component;
        }

        public JXTable getTable() {
            return this.table;
        }

        public String getColumnName(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            return column == null ? "" : column.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int modelColumn) {
            List<TableColumn> columns = this.table.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != modelColumn) continue;
                return column;
            }
            return null;
        }

        public String getColumnIdentifier(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            Object identifier = column != null ? column.getIdentifier() : null;
            return identifier != null ? identifier.toString() : null;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.table.getModel().getValueAt(row, column);
        }

        public void setValueAt(Object aValue, int row, int column) {
            this.table.getModel().setValueAt(aValue, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.table.getModel().isCellEditable(row, column);
        }

        public boolean isTestable(int column) {
            return this.getColumnByModelIndex(column) != null;
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(this.table.convertRowIndexToModel(row), column);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean rowIsLead = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean colIsLead = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && rowIsLead && colIsLead;
        }

        public int modelToView(int columnIndex) {
            return this.table.convertColumnIndexToView(columnIndex);
        }

        public int viewToModel(int columnIndex) {
            return this.table.convertColumnIndexToModel(columnIndex);
        }
    }

    public class TableSearchable
    extends AbstractSearchable {
        private SearchHighlighter searchHighlighter;

        protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
            AbstractSearchable.SearchResult matchRow = null;
            if (backwards) {
                for (int r = startRow; r >= -1 && matchRow == null; --r) {
                    matchRow = this.findMatchBackwardsInRow(pattern, r);
                    this.updateState(matchRow);
                }
            } else {
                for (int r = startRow; r <= this.getSize() && matchRow == null; ++r) {
                    matchRow = this.findMatchForwardInRow(pattern, r);
                    this.updateState(matchRow);
                }
            }
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
            return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
        }

        private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
            int startColumn;
            int n = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(row)) {
                for (int column = startColumn; column < JXTable.this.getColumnCount(); ++column) {
                    AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
            int startColumn;
            int n = startColumn = this.lastSearchResult.foundColumn < 0 ? JXTable.this.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(row)) {
                for (int column = startColumn; column >= 0; --column) {
                    AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column) {
            Matcher matcher;
            Object value = JXTable.this.getValueAt(row, column);
            if (value != null && (matcher = pattern.matcher(value.toString())).find()) {
                return this.createSearchResult(matcher, row, column);
            }
            return null;
        }

        protected int adjustStartPosition(int startIndex, boolean backwards) {
            this.lastSearchResult.foundColumn = -1;
            return super.adjustStartPosition(startIndex, backwards);
        }

        protected int moveStartPosition(int startRow, boolean backwards) {
            if (backwards) {
                --this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn < 0) {
                    --startRow;
                }
            } else {
                ++this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn >= JXTable.this.getColumnCount()) {
                    this.lastSearchResult.foundColumn = -1;
                    ++startRow;
                }
            }
            return startRow;
        }

        protected boolean isEqualStartIndex(int startIndex) {
            return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
        }

        private boolean isValidColumn(int column) {
            return column >= 0 && column < JXTable.this.getColumnCount();
        }

        protected int getSize() {
            return JXTable.this.getRowCount();
        }

        protected void moveMatchMarker() {
            int row = this.lastSearchResult.foundRow;
            int column = this.lastSearchResult.foundColumn;
            Pattern pattern = this.lastSearchResult.pattern;
            if (row < 0 || column < 0) {
                if (this.markByHighlighter()) {
                    this.getSearchHighlighter().setPattern(null);
                }
                return;
            }
            if (this.markByHighlighter()) {
                Rectangle cellRect = JXTable.this.getCellRect(row, column, true);
                if (cellRect != null) {
                    JXTable.this.scrollRectToVisible(cellRect);
                }
                this.ensureInsertedSearchHighlighters();
                this.getSearchHighlighter().setPattern(pattern);
                int modelColumn = JXTable.this.convertColumnIndexToModel(column);
                this.getSearchHighlighter().setHighlightCell(row, modelColumn);
            } else {
                Rectangle cellRect;
                JXTable.this.changeSelection(row, column, false, false);
                if (!JXTable.this.getAutoscrolls() && (cellRect = JXTable.this.getCellRect(row, column, true)) != null) {
                    JXTable.this.scrollRectToVisible(cellRect);
                }
            }
        }

        private boolean markByHighlighter() {
            return Boolean.TRUE.equals(JXTable.this.getClientProperty(JXTable.MATCH_HIGHLIGHTER));
        }

        private SearchHighlighter getSearchHighlighter() {
            if (this.searchHighlighter == null) {
                this.searchHighlighter = this.createSearchHighlighter();
            }
            return this.searchHighlighter;
        }

        private void ensureInsertedSearchHighlighters() {
            if (JXTable.this.getHighlighters() == null) {
                JXTable.this.setHighlighters(new HighlighterPipeline(new Highlighter[]{this.getSearchHighlighter()}));
            } else if (!this.isInPipeline(this.getSearchHighlighter())) {
                JXTable.this.getHighlighters().addHighlighter(this.getSearchHighlighter());
            }
        }

        private boolean isInPipeline(PatternHighlighter searchHighlighter) {
            Highlighter[] inPipeline = JXTable.this.getHighlighters().getHighlighters();
            if (inPipeline.length > 0 && searchHighlighter.equals(inPipeline[inPipeline.length - 1])) {
                return true;
            }
            JXTable.this.getHighlighters().removeHighlighter(searchHighlighter);
            return false;
        }

        protected SearchHighlighter createSearchHighlighter() {
            return new SearchHighlighter();
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException ex) {
                    LOG.log(Level.WARNING, "", ex);
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.find();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableRolloverController<T extends JTable>
    extends RolloverController<T> {
        private Cursor oldCursor;

        @Override
        protected void rollover(Point oldLocation, Point newLocation) {
            Rectangle r;
            if (oldLocation != null) {
                r = ((JTable)this.component).getCellRect(oldLocation.y, oldLocation.x, false);
                r.x = 0;
                r.width = ((JTable)this.component).getWidth();
                ((JTable)this.component).repaint(r);
            }
            if (newLocation != null) {
                r = ((JTable)this.component).getCellRect(newLocation.y, newLocation.x, false);
                r.x = 0;
                r.width = ((JTable)this.component).getWidth();
                ((JTable)this.component).repaint(r);
            }
            this.setRolloverCursor(newLocation);
        }

        @Override
        protected boolean isClickable(Point location) {
            return super.isClickable(location) && !((JTable)this.component).isCellEditable(location.y, location.x);
        }

        @Override
        protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
            RolloverRenderer rollover;
            TableCellRenderer renderer = ((JTable)this.component).getCellRenderer(location.y, location.x);
            RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
            if (rollover != null && !rollover.isEnabled()) {
                rollover = null;
            }
            if (rollover != null && prepare) {
                ((JTable)this.component).prepareRenderer(renderer, location.y, location.x);
            }
            return rollover;
        }

        private void setRolloverCursor(Point location) {
            if (this.hasRollover(location)) {
                if (this.oldCursor == null) {
                    this.oldCursor = ((JTable)this.component).getCursor();
                    ((JTable)this.component).setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.oldCursor != null) {
                ((JTable)this.component).setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        @Override
        protected Point getFocusedCell() {
            int leadRow = ((JTable)this.component).getSelectionModel().getLeadSelectionIndex();
            int leadColumn = ((JTable)this.component).getColumnModel().getSelectionModel().getLeadSelectionIndex();
            return new Point(leadColumn, leadRow);
        }
    }
}

