/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.event.MouseInputAdapter;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.jdesktop.swingx.JXGradientChooser;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.multislider.Thumb;

public class GradientPreviewPanel
extends JXPanel {
    private Paint checker_texture = null;
    private Point2D start = new Point2D.Float(10.0f, 10.0f);
    private Point2D end = new Point2D.Float(80.0f, 10.0f);
    public JXGradientChooser picker;
    boolean moving_start = false;
    boolean moving_end = false;

    public GradientPreviewPanel() {
        this.checker_texture = ColorUtil.getCheckerPaint();
        GradientMouseHandler ma = new GradientMouseHandler();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    public void setGradient() {
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.checker_texture);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            List<Thumb<Color>> stops = this.picker.getSlider().getModel().getSortedThumbs();
            int len = stops.size();
            float[] fractions = new float[len];
            Color[] colors = new Color[len];
            int i = 0;
            for (Thumb<Color> thumb : stops) {
                colors[i] = thumb.getObject();
                fractions[i] = thumb.getPosition();
                ++i;
            }
            MultipleGradientPaint paint = this.calculateGradient(fractions, colors);
            if (paint != null) {
                g2.setPaint((Paint)paint);
            } else {
                g2.setPaint(Color.black);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawHandles(g2);
        }
        catch (Exception ex) {
            System.out.println("ex: " + ex);
        }
    }

    private MultipleGradientPaint calculateGradient(float[] fractions, Color[] colors) {
        Point2D start = this.start;
        Point2D end = this.end;
        if (this.picker.reversedCheck.isSelected()) {
            start = this.end;
            end = this.start;
        }
        MultipleGradientPaint.CycleMethodEnum cycle = MultipleGradientPaint.NO_CYCLE;
        if (this.picker.repeatedRadio.isSelected()) {
            cycle = MultipleGradientPaint.REPEAT;
        }
        if (this.picker.reflectedRadio.isSelected()) {
            cycle = MultipleGradientPaint.REFLECT;
        }
        LinearGradientPaint paint = null;
        if (this.picker.styleCombo.getSelectedItem().toString().equals("Linear")) {
            paint = new LinearGradientPaint((float)start.getX(), (float)start.getY(), (float)end.getX(), (float)end.getY(), fractions, colors, cycle);
        }
        if (this.picker.styleCombo.getSelectedItem().toString().equals("Radial")) {
            paint = new RadialGradientPaint(start, (float)start.distance(end), start, fractions, colors, cycle, MultipleGradientPaint.SRGB);
        }
        return paint;
    }

    private void drawHandles(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.drawOval((int)this.start.getX() - 5, (int)this.start.getY() - 5, 10, 10);
        g2.setColor(Color.white);
        g2.drawOval((int)this.start.getX() - 4, (int)this.start.getY() - 4, 8, 8);
        g2.setColor(Color.black);
        g2.drawOval((int)this.end.getX() - 5, (int)this.end.getY() - 5, 10, 10);
        g2.setColor(Color.white);
        g2.drawOval((int)this.end.getX() - 4, (int)this.end.getY() - 4, 8, 8);
        g2.setColor(Color.darkGray);
        g2.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.end.getX(), (int)this.end.getY());
        g2.setColor(Color.gray);
        g2.drawLine((int)this.start.getX() - 1, (int)this.start.getY() - 1, (int)this.end.getX() - 1, (int)this.end.getY() - 1);
    }

    private class GradientMouseHandler
    extends MouseInputAdapter {
        private GradientMouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            GradientPreviewPanel.this.moving_start = false;
            GradientPreviewPanel.this.moving_end = false;
            if (evt.getPoint().distance(GradientPreviewPanel.this.start) < 5.0) {
                GradientPreviewPanel.this.moving_start = true;
                GradientPreviewPanel.this.start = evt.getPoint();
                return;
            }
            if (evt.getPoint().distance(GradientPreviewPanel.this.end) < 5.0) {
                GradientPreviewPanel.this.moving_end = true;
                GradientPreviewPanel.this.end = evt.getPoint();
                return;
            }
            GradientPreviewPanel.this.start = evt.getPoint();
        }

        public void mouseDragged(MouseEvent evt) {
            if (GradientPreviewPanel.this.moving_start) {
                GradientPreviewPanel.this.start = evt.getPoint();
            } else {
                GradientPreviewPanel.this.end = evt.getPoint();
            }
            GradientPreviewPanel.this.repaint();
        }
    }
}

