/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.Resize;

public class TextPainter
extends AbstractPainter {
    private Resize resize;
    private String text = "";
    private Font font;
    private Paint paint;
    private Point2D location = new Point2D.Double(0.0, 0.0);

    public TextPainter() {
    }

    public TextPainter(String text) {
        this(text, new Font("Dialog", 0, 12));
    }

    public TextPainter(String text, Font font) {
        this(text, font, Color.BLACK);
    }

    public TextPainter(String text, Font font, Paint paint) {
        this.text = text;
        this.font = font;
        this.paint = paint;
    }

    public void setFont(Font f) {
        Font old = this.getFont();
        this.font = f;
        this.firePropertyChange("font", old, this.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String text) {
        String old = this.getText();
        this.text = text == null ? "" : text;
        this.firePropertyChange("text", old, this.getText());
    }

    public String getText() {
        return this.text;
    }

    public void setPaint(Paint paint) {
        Paint old = this.getPaint();
        this.paint = paint;
        this.firePropertyChange("paint", old, this.getPaint());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setLocation(Point2D location) {
        Point2D old = this.getLocation();
        this.location = location == null ? new Point2D.Double(0.0, 0.0) : location;
        this.firePropertyChange("location", old, this.getLocation());
    }

    public Point2D getLocation() {
        return this.location;
    }

    protected void paintBackground(Graphics2D g, JComponent component) {
        Paint paint;
        Font font = this.getFont();
        if (font != null) {
            g.setFont(font);
        }
        if ((paint = this.getPaint()) != null) {
            g.setPaint(paint);
        }
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        String text = this.getText();
        Point2D location = this.getLocation();
        int tw = metrics.stringWidth(text);
        int th = metrics.getHeight();
        double x = location.getX() * (double)(component.getWidth() - tw);
        double y = location.getY() * (double)(component.getHeight() - th);
        g.drawString(text, (float)x, (float)(y += (double)metrics.getAscent()));
    }
}

