/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Date;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXDatePickerFormatter;
import org.jdesktop.swingx.calendar.JXMonthView;
import org.jdesktop.swingx.plaf.DatePickerUI;

public class BasicDatePickerUI
extends DatePickerUI {
    protected JXDatePicker datePicker;
    private JButton popupButton;
    private BasicDatePickerPopup popup;
    private Handler handler;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDatePickerUI();
    }

    public void installUI(JComponent c) {
        this.datePicker = (JXDatePicker)c;
        this.datePicker.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.datePicker.setLayout(null);
        this.datePicker = null;
    }

    protected void installComponents() {
        JFormattedTextField editor = this.datePicker.getEditor();
        if (editor == null || editor instanceof UIResource) {
            this.datePicker.setEditor(this.createEditor());
        }
        editor = this.datePicker.getEditor();
        this.datePicker.add(editor);
        editor.addPropertyChangeListener(this.getHandler());
        this.popupButton = this.createPopupButton();
        if (this.popupButton != null) {
            JComboBox box = new JComboBox();
            Object preventHide = box.getClientProperty("doNotCancelPopup");
            this.popupButton.putClientProperty("doNotCancelPopup", preventHide);
            this.datePicker.add(this.popupButton);
        }
    }

    protected void uninstallComponents() {
        JFormattedTextField editor = this.datePicker.getEditor();
        if (editor != null) {
            editor.removePropertyChangeListener(this.getHandler());
            this.datePicker.remove(editor);
        }
        if (this.popupButton != null) {
            this.datePicker.remove(this.popupButton);
            this.popupButton = null;
        }
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        KeyStroke spaceKey = KeyStroke.getKeyStroke(32, 0, false);
        InputMap inputMap = this.popupButton.getInputMap(0);
        inputMap.put(spaceKey, "TOGGLE_POPUP");
        ActionMap actionMap = this.popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.datePicker.addPropertyChangeListener(this.propertyChangeListener);
        if (this.popupButton != null) {
            this.popupButton.addPropertyChangeListener(this.propertyChangeListener);
            this.popupButton.addMouseListener(this.mouseListener);
            this.popupButton.addMouseMotionListener(this.mouseMotionListener);
        }
    }

    protected void uninstallListeners() {
        this.datePicker.removePropertyChangeListener(this.propertyChangeListener);
        if (this.popupButton != null) {
            this.popupButton.removePropertyChangeListener(this.propertyChangeListener);
            this.popupButton.removeMouseListener(this.mouseListener);
            this.popupButton.removeMouseMotionListener(this.mouseMotionListener);
        }
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.handler = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected JFormattedTextField createEditor() {
        DefaultEditor f = new DefaultEditor(new JXDatePickerFormatter());
        f.setName("dateField");
        f.setColumns(UIManager.getInt("JXDatePicker.numColumns"));
        f.setBorder(UIManager.getBorder("JXDatePicker.border"));
        return f;
    }

    protected JButton createPopupButton() {
        JButton b = new JButton();
        b.setName("popupButton");
        b.setRolloverEnabled(false);
        b.setMargin(new Insets(0, 3, 0, 3));
        Icon icon = UIManager.getIcon("JXDatePicker.arrowDown.image");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        b.setIcon(icon);
        return b;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = this.datePicker.getEditor().getPreferredSize();
        if (this.popupButton != null) {
            dim.width += this.popupButton.getPreferredSize().width;
        }
        Insets insets = this.datePicker.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return (Dimension)dim.clone();
    }

    public int getBaseline(int width, int height) {
        JFormattedTextField editor = this.datePicker.getEditor();
        View rootView = editor.getUI().getRootView(editor);
        if (rootView.getViewCount() > 0) {
            Insets insets = editor.getInsets();
            Insets insetsOut = this.datePicker.getInsets();
            int nh = height - insets.top - insets.bottom - insetsOut.top - insetsOut.bottom;
            int y = insets.top + insetsOut.top;
            View fieldView = rootView.getView(0);
            int vspan = (int)fieldView.getPreferredSpan(1);
            if (nh != vspan) {
                int slop = nh - vspan;
                y += slop / 2;
            }
            FontMetrics fm = editor.getFontMetrics(editor.getFont());
            return y += fm.getAscent();
        }
        return -1;
    }

    private class Handler
    implements LayoutManager,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mousePressed(MouseEvent ev) {
            JFormattedTextField editor;
            if (!BasicDatePickerUI.this.datePicker.isEnabled()) {
                return;
            }
            if (!BasicDatePickerUI.this.datePicker.isEditable() && (editor = BasicDatePickerUI.this.datePicker.getEditor()).isEditValid()) {
                try {
                    editor.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent ev) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            if (this._forwardReleaseEvent) {
                JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
                ev = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, ev, monthView);
                monthView.dispatchEvent(ev);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseDragged(MouseEvent ev) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            this._forwardReleaseEvent = true;
            if (!BasicDatePickerUI.this.popup.isShowing()) {
                return;
            }
            JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
            ev = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, ev, monthView);
            monthView.dispatchEvent(ev);
        }

        public void mouseMoved(MouseEvent ev) {
        }

        public void toggleShowPopup() {
            if (BasicDatePickerUI.this.popup == null) {
                BasicDatePickerUI.this.popup = new BasicDatePickerPopup();
            }
            if (!BasicDatePickerUI.this.popup.isVisible()) {
                JFormattedTextField editor = BasicDatePickerUI.this.datePicker.getEditor();
                JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
                SortedSet<Date> selection = monthView.getSelection();
                if (!selection.isEmpty()) {
                    Date date = selection.first();
                    monthView.setSelectionInterval(date, date);
                    monthView.ensureDateVisible(date.getTime());
                } else {
                    monthView.ensureDateVisible(System.currentTimeMillis());
                }
                BasicDatePickerUI.this.popup.show(BasicDatePickerUI.this.datePicker, 0, BasicDatePickerUI.this.datePicker.getHeight());
            } else {
                BasicDatePickerUI.this.popup.setVisible(false);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("enabled".equals(property)) {
                boolean isEnabled = BasicDatePickerUI.this.datePicker.isEnabled();
                BasicDatePickerUI.this.popupButton.setEnabled(isEnabled);
                BasicDatePickerUI.this.datePicker.getEditor().setEnabled(isEnabled);
            } else if ("editable".equals(property)) {
                boolean isEditable = BasicDatePickerUI.this.datePicker.isEditable();
                BasicDatePickerUI.this.datePicker.getMonthView().setEnabled(isEditable);
                BasicDatePickerUI.this.datePicker.getEditor().setEditable(isEditable);
            } else if ("ToolTipText".equals(property)) {
                String tip = BasicDatePickerUI.this.datePicker.getToolTipText();
                BasicDatePickerUI.this.datePicker.getEditor().setToolTipText(tip);
                BasicDatePickerUI.this.popupButton.setToolTipText(tip);
            } else if ("monthView".equals(property)) {
                BasicDatePickerUI.this.popup = null;
            } else if ("linkPanel".equals(property)) {
                JPanel linkPanel = BasicDatePickerUI.this.datePicker.getLinkPanel();
                if (BasicDatePickerUI.this.popup != null) {
                    BasicDatePickerUI.this.popup.remove(linkPanel);
                    BasicDatePickerUI.this.popup.add((Component)linkPanel, "South");
                }
            } else if ("editor".equals(property)) {
                JFormattedTextField oldEditor = (JFormattedTextField)e.getOldValue();
                if (oldEditor != null) {
                    oldEditor.removePropertyChangeListener(this);
                    BasicDatePickerUI.this.datePicker.remove(oldEditor);
                }
                JFormattedTextField editor = (JFormattedTextField)e.getNewValue();
                BasicDatePickerUI.this.datePicker.add(editor);
                editor.addPropertyChangeListener(this);
                BasicDatePickerUI.this.datePicker.revalidate();
            } else if ("componentOrientation".equals(property)) {
                BasicDatePickerUI.this.datePicker.revalidate();
            } else if ("value".equals(property)) {
                Date date = (Date)BasicDatePickerUI.this.datePicker.getEditor().getValue();
                BasicDatePickerUI.this.datePicker.setDate(date);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            Insets insets = BasicDatePickerUI.this.datePicker.getInsets();
            int width = BasicDatePickerUI.this.datePicker.getWidth() - insets.left - insets.right;
            int height = BasicDatePickerUI.this.datePicker.getHeight() - insets.top - insets.bottom;
            int popupButtonWidth = BasicDatePickerUI.this.popupButton != null ? ((BasicDatePickerUI)BasicDatePickerUI.this).popupButton.getPreferredSize().width : 0;
            boolean ltr = BasicDatePickerUI.this.datePicker.getComponentOrientation().isLeftToRight();
            BasicDatePickerUI.this.datePicker.getEditor().setBounds(ltr ? insets.left : insets.left + popupButtonWidth, insets.top, width - popupButtonWidth, height);
            if (BasicDatePickerUI.this.popupButton != null) {
                BasicDatePickerUI.this.popupButton.setBounds(ltr ? width - popupButtonWidth + insets.left : insets.left, insets.top, popupButtonWidth, height);
            }
        }
    }

    protected class BasicDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        public BasicDatePickerPopup() {
            JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
            monthView.setActionCommand("MONTH_VIEW");
            monthView.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)monthView, "Center");
            JPanel linkPanel = BasicDatePickerUI.this.datePicker.getLinkPanel();
            if (linkPanel != null) {
                this.add((Component)linkPanel, "South");
            }
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("MONTH_VIEW".equals(command)) {
                SortedSet<Date> selection = BasicDatePickerUI.this.datePicker.getMonthView().getSelectionModel().getSelection();
                if (!selection.isEmpty()) {
                    BasicDatePickerUI.this.datePicker.getEditor().setValue(selection.first());
                } else {
                    BasicDatePickerUI.this.datePicker.getEditor().setValue(null);
                }
                this.setVisible(false);
                BasicDatePickerUI.this.datePicker.postActionEvent();
            }
        }
    }

    private class DefaultEditor
    extends JFormattedTextField
    implements UIResource {
        public DefaultEditor(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent ev) {
            BasicDatePickerUI.this.handler.toggleShowPopup();
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                BasicDatePickerUI.this.datePicker.commitEdit();
                BasicDatePickerUI.this.datePicker.postActionEvent();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

