/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.IslandCoord;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sector
implements Serializable,
Comparable<Sector> {
    protected IslandCoord coord;
    protected int owner;
    protected Des terrain;
    protected Des des;
    protected int civilians;
    protected int military;
    protected int guns;
    protected int shells;
    protected int fighters;
    protected int bombers;
    protected int ore;
    protected int oreSample;
    protected int eff;
    protected int production;
    protected int authorized;
    protected int timeLeft;
    protected int timeRight;

    public Sector(Sector sector) {
        this.coord = sector.getLocation();
        this.terrain = sector.getTerrain();
        this.des = sector.getDes();
        this.civilians = sector.getCivilians();
        this.military = sector.getMilitary();
        this.guns = sector.getGuns();
        this.shells = sector.getShells();
        this.fighters = sector.getFighters();
        this.bombers = sector.getBombers();
        this.ore = sector.getOre();
        this.oreSample = sector.getOreSample();
        this.eff = sector.getEff();
        this.production = sector.getProduction();
        this.authorized = sector.getAuthorized();
        this.timeLeft = sector.getTimeLeft();
        this.timeRight = sector.getTimeRight();
    }

    public Sector(String serverString) {
        try {
            String[] params = serverString.split(":");
            String[] locString = params[0].split(",");
            int x = Integer.parseInt(locString[0]);
            int y = Integer.parseInt(locString[1]);
            this.coord = new IslandCoord(x, y);
            this.owner = Integer.parseInt(params[1]);
            this.terrain = Des.fromInt(Integer.parseInt(params[2]));
            this.des = Des.UNKNOWN;
            if (params.length > 3) {
                this.des = Des.fromInt(Integer.parseInt(params[3]));
                this.civilians = Integer.parseInt(params[4]);
                this.military = Integer.parseInt(params[5]);
                this.guns = Integer.parseInt(params[6]);
                this.shells = Integer.parseInt(params[7]);
                this.fighters = Integer.parseInt(params[8]);
                this.bombers = Integer.parseInt(params[9]);
                this.ore = Integer.parseInt(params[10]);
                this.eff = Integer.parseInt(params[11]);
                this.production = Integer.parseInt(params[12]);
                if (params.length > 13) {
                    this.oreSample = Integer.parseInt(params[13]);
                    this.authorized = Integer.parseInt(params[14]);
                    if (params.length > 15) {
                        this.timeLeft = Integer.parseInt(params[15]);
                        this.timeRight = Integer.parseInt(params[16]);
                    }
                }
            }
        }
        catch (NumberFormatException except) {
            System.out.println("Unable to parse sector: <" + serverString + ">");
            except.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException except) {
            System.out.println("Unable to parse sector: <" + serverString + ">");
            except.printStackTrace();
        }
    }

    @Override
    public int compareTo(Sector o) {
        return this.getLocation().compareTo(o.getLocation());
    }

    public List<IslandCoord> getAdjacencies() {
        ArrayList<IslandCoord> list = new ArrayList<IslandCoord>();
        list.add(new IslandCoord(this.getLocation().x - 1, this.getLocation().y));
        list.add(new IslandCoord(this.getLocation().x + 1, this.getLocation().y));
        list.add(new IslandCoord(this.getLocation().x, this.getLocation().y - 1));
        list.add(new IslandCoord(this.getLocation().x, this.getLocation().y + 1));
        return list;
    }

    public Des getTerrain() {
        return this.terrain;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public Des getDes() {
        return this.des;
    }

    public void setDes(Des des) {
        this.des = des;
    }

    public int getBombers() {
        return this.bombers;
    }

    public void setBombers(int bombers) {
        this.bombers = bombers;
    }

    public int getCivilians() {
        return this.civilians;
    }

    public void setCivilians(int civilians) {
        this.civilians = civilians;
    }

    public IslandCoord getLocation() {
        return this.coord;
    }

    public void setLocation(IslandCoord coord) {
        this.coord = coord;
    }

    public int getFighters() {
        return this.fighters;
    }

    public void setFighters(int fighters) {
        this.fighters = fighters;
    }

    public int getGuns() {
        return this.guns;
    }

    public void setGuns(int guns) {
        this.guns = guns;
    }

    public int getMilitary() {
        return this.military;
    }

    public void setMilitary(int military) {
        this.military = military;
    }

    public int getOre() {
        return this.ore;
    }

    public void setOre(int ore) {
        this.ore = ore;
    }

    public int getShells() {
        return this.shells;
    }

    public void setShells(int shells) {
        this.shells = shells;
    }

    public int getOreSample() {
        return this.oreSample;
    }

    public void setOreSample(int oreSample) {
        this.oreSample = oreSample;
    }

    public int getAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(int authorized) {
        this.authorized = authorized;
    }

    public int getEff() {
        return this.eff;
    }

    public void setEff(int eff) {
        this.eff = eff;
    }

    public int getProduction() {
        return this.production;
    }

    public void setProduction(int production) {
        this.production = production;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public int getTimeRight() {
        return this.timeRight;
    }

    public void setTimeRight(int timeRight) {
        this.timeRight = timeRight;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Des implements Serializable
    {
        WATER(0, "Water"),
        MOUNTAIN(1, "Mountain"),
        RURAL(2, "Rural"),
        SANCTUARY(3, "Sanctuary"),
        CAPITOL(4, "Capitol"),
        URBAN(5, "Urban"),
        FORT(6, "Fort"),
        MINE(7, "Mine"),
        EXPLOSIVE(8, "Explosives factory"),
        ARTILLERY(9, "Artillery plant"),
        DOCK(10, "Dock"),
        PLANE(11, "Plane factory"),
        AIRPORT(12, "Airport"),
        RADAR(13, "Radar installation"),
        WATERWAY(14, "Waterway"),
        TRADE(15, "Trade center"),
        UNKNOWN(16, " ");

        public static final String designations = " ^RSCUFMEADP+!WT ";
        public static final String designationsMatcher = "[ \\^RrSsCcUuFfMmEeAaDdPp\\+!WwTt]";
        private static Map<Integer, Des> typeMap;
        private String description;
        private int i;

        private Des(int i, String description) {
            if (typeMap == null) {
                typeMap = new HashMap<Integer, Des>();
            }
            typeMap.put(i, this);
            this.i = i;
            this.description = description;
        }

        public int getValue() {
            return this.i;
        }

        public static Des fromInt(int i) {
            return typeMap.get(i);
        }

        public static Des fromChar(char c) {
            return typeMap.get(designations.toLowerCase().indexOf(Character.toLowerCase(c)));
        }

        public char asChar() {
            return designations.charAt(this.i);
        }

        public String getDescription() {
            return this.description;
        }

        public static int count() {
            return typeMap.size();
        }

        public void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.getValue());
        }

        public void readObject(ObjectInputStream in) throws IOException {
            this.i = in.readInt();
            this.description = Des.typeMap.get((Object)Integer.valueOf((int)this.i)).description;
        }
    }
}

