/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.ParamInfo;
import com.empireclassic.Remote.RemoteEmpire;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AboutBox
extends JDialog {
    ParamInfo params = RemoteEmpire.getInstance().getParams();
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JLabel iconLabel = null;
    private JButton okButton = null;
    private JPanel labelPanel = null;
    private JLabel about1Label = null;
    private JLabel about2Label = null;
    private JLabel about3Label = null;
    private JPanel leftInsetsPanel = null;
    private JPanel topInsetsPanel = null;
    private JPanel rightInsetsPanel = null;
    private JScrollPane serverInfoScrollPane = null;
    private JList serverInfoList = null;
    private JLabel iconLabel1 = null;

    public AboutBox(JFrame parent) {
        super(parent);
        this.initialize();
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Server Information:");
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Server version: " + this.params.getServerVersion());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Schema: " + this.params.getSchema());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("DB version: " + this.params.getDbVersion());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Game end date: " + this.params.getGameEndDate());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("World size: " + this.params.getWorldSize());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Number of islands: " + this.params.getNumIslands());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Date increment: " + this.params.getDateIncrement());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Ship day length: " + this.params.getShipDayLength());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("News increment: " + this.params.getNewsmanIncrement());
        ((DefaultListModel)this.serverInfoList.getModel()).addElement("Date of last power report: " + String.format("%6.2f", this.params.getLastPowerDate()));
    }

    private void initialize() {
        this.setSize(300, 377);
        this.setTitle("Java Empire Client");
        this.setContentPane(this.getJContentPane());
        String version = "unknown";
        Properties versionProperties = new Properties();
        try {
            versionProperties.load(this.getClass().getResourceAsStream("/version.properties"));
            version = versionProperties.getProperty("version.version", version);
        }
        catch (FileNotFoundException except1) {
            except1.printStackTrace();
        }
        catch (IOException except1) {
            except1.printStackTrace();
        }
        this.about3Label = new JLabel();
        this.about3Label.setText("Version " + version);
        this.about2Label = new JLabel();
        this.about2Label.setText("Empire Development Team");
        this.about1Label = new JLabel();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getLabelPanel(), "Center");
            this.mainPanel.add((Component)this.getLeftInsetsPanel(), "West");
            this.mainPanel.add((Component)this.getTopInsetsPanel(), "North");
            this.mainPanel.add((Component)this.getRightInsetsPanel(), "East");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutBox.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JPanel getLabelPanel() {
        if (this.labelPanel == null) {
            this.about3Label = new JLabel();
            this.about3Label.setText("Version 2.0");
            this.about2Label = new JLabel();
            this.about2Label.setText("Empire Development Team");
            this.about1Label = new JLabel();
            this.about1Label.setText("Copyright (C) 2006");
            this.labelPanel = new JPanel();
            this.labelPanel.setLayout(new BoxLayout(this.getLabelPanel(), 1));
            this.labelPanel.add((Component)this.about1Label, null);
            this.labelPanel.add((Component)this.about2Label, null);
            this.labelPanel.add((Component)this.about3Label, null);
            this.labelPanel.add((Component)this.getServerInfoScrollPane(), null);
        }
        return this.labelPanel;
    }

    private JPanel getLeftInsetsPanel() {
        if (this.leftInsetsPanel == null) {
            this.iconLabel1 = new JLabel();
            this.iconLabel1.setText("");
            this.iconLabel1.setIcon(new ImageIcon(this.getClass().getResource("/image/empire.png")));
            this.leftInsetsPanel = new JPanel();
            this.leftInsetsPanel.setPreferredSize(new Dimension(30, 10));
            this.leftInsetsPanel.add((Component)this.iconLabel1, null);
        }
        return this.leftInsetsPanel;
    }

    private JPanel getTopInsetsPanel() {
        if (this.topInsetsPanel == null) {
            this.topInsetsPanel = new JPanel();
            this.topInsetsPanel.setPreferredSize(new Dimension(10, 20));
        }
        return this.topInsetsPanel;
    }

    private JPanel getRightInsetsPanel() {
        if (this.rightInsetsPanel == null) {
            this.rightInsetsPanel = new JPanel();
        }
        return this.rightInsetsPanel;
    }

    private JScrollPane getServerInfoScrollPane() {
        if (this.serverInfoScrollPane == null) {
            this.serverInfoScrollPane = new JScrollPane();
            this.serverInfoScrollPane.setViewportView(this.getServerInfoList());
        }
        return this.serverInfoScrollPane;
    }

    private JList getServerInfoList() {
        if (this.serverInfoList == null) {
            this.serverInfoList = new JList();
            this.serverInfoList.setModel(new DefaultListModel());
        }
        return this.serverInfoList;
    }
}

