/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.models;

import com.empireclassic.Remote.RemoteEmpire;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailTableModel
extends AbstractTableModel {
    List<RemoteEmpire.Mail> mailList;

    public MailTableModel() {
        this.mailList = new ArrayList<RemoteEmpire.Mail>();
    }

    public MailTableModel(List<RemoteEmpire.Mail> list) {
        this.mailList = list;
    }

    public void update(List<RemoteEmpire.Mail> list) {
        this.mailList = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.mailList.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public String getMessageFromRow(int row) {
        RemoteEmpire.Mail mail = this.mailList.get(row);
        return RemoteEmpire.getInstance().getMail((int)mail.getId()).errorString;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RemoteEmpire.Mail mail = this.mailList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mail.getStatus();
            }
            case 1: {
                return mail.getFrom();
            }
            case 2: {
                return mail.getDate();
            }
            case 3: {
                return mail.getSubject();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Status";
            }
            case 1: {
                return "From";
            }
            case 2: {
                return "Sent";
            }
            case 3: {
                return "Subject";
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 2) {
            return Double.class;
        }
        if (column == 0) {
            return RemoteEmpire.MailStatus.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

