/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.EmpireDimension;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.SelectionMap;
import com.empireclassic.Remote.WorldCoord;
import java.awt.Rectangle;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IslandInfo
implements Comparable {
    private int number;
    private String name;
    private WorldCoord location;
    private EmpireDimension size;
    private float dateDiscovered;
    private int namingNationNum;
    private boolean knows;
    private boolean visited;
    private boolean occuppied;
    private boolean released;
    private int version;

    public IslandInfo(String initString) {
        try {
            if (initString.charAt(initString.length() - 1) != ':') {
                initString = initString + ":";
            }
            String[] fields = initString.split(":");
            this.number = Integer.parseInt(fields[0]);
            this.name = fields[1].replace("\"", "");
            String[] locString = fields[2].split(",");
            int locX = Integer.parseInt(locString[0]);
            int locY = Integer.parseInt(locString[1]);
            this.location = new WorldCoord(locX, locY);
            String[] sizeString = fields[3].split(",");
            int width = Integer.parseInt(sizeString[0]);
            int height = Integer.parseInt(sizeString[1]);
            this.size = new EmpireDimension(width, height);
            this.dateDiscovered = Float.parseFloat(fields[4]);
            this.namingNationNum = Integer.parseInt(fields[5]);
            String flags = fields[6];
            this.knows = flags.contains("K");
            this.visited = flags.contains("V");
            this.occuppied = flags.contains("O");
            this.released = flags.contains("R");
            this.version = Integer.parseInt(fields[7]);
        }
        catch (NumberFormatException except) {
            System.out.println("Unable to parse island <" + initString + ">");
            except.printStackTrace();
        }
        catch (StringIndexOutOfBoundsException except) {
            System.out.println("Unable to parse island <" + initString + ">");
            except.printStackTrace();
        }
    }

    public String formatIslandName() {
        return new String(this.getName() + "[#" + this.getNumber() + "]");
    }

    public IslandCoord parseCoord(String arg) {
        String[] coordArgs = arg.split(",");
        if (coordArgs.length != 2) {
            // empty if block
        }
        int x = Integer.parseInt(coordArgs[0]);
        int y = Integer.parseInt(coordArgs[1]);
        if (x > this.getSize().width || x < 0 || y > this.getSize().height || y < 0) {
            return new IslandCoord(0, 0);
        }
        return new IslandCoord(x, y);
    }

    public Rectangle getRect() {
        return new Rectangle(this.location, this.size);
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public WorldCoord getLocation() {
        return this.location;
    }

    public void setLocation(WorldCoord coord) {
        this.location = coord;
    }

    public float getDateDiscovered() {
        return this.dateDiscovered;
    }

    public void setDateDiscovered(float dateDiscovered) {
        this.dateDiscovered = dateDiscovered;
    }

    public EmpireDimension getSize() {
        return this.size;
    }

    public void setSize(EmpireDimension size) {
        this.size = size;
    }

    public boolean isKnows() {
        return this.knows;
    }

    public boolean isOccuppied() {
        return this.occuppied;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public Sector getCapitol(int nationNum) {
        Map<IslandCoord, Sector> sectors = RemoteEmpire.getInstance().getSectors(this.number);
        if (sectors == null) {
            boolean xx = true;
        }
        for (int x = 1; x <= this.size.width; ++x) {
            for (int y = 1; y <= this.size.height; ++y) {
                Sector sector = sectors.get(new IslandCoord(x, y));
                if (sector == null) {
                    boolean f = true;
                }
                if (sector == null || sector.getOwner() != nationNum || sector.getDes() != Sector.Des.SANCTUARY && sector.getDes() != Sector.Des.CAPITOL) continue;
                return sector;
            }
        }
        return null;
    }

    public Map<IslandCoord, Sector> getSectors() {
        return RemoteEmpire.getInstance().getSectors(this.number);
    }

    public int compareTo(Object o) {
        return this.number - ((IslandInfo)o).getNumber();
    }

    public SelectionMap getSelectionMap() {
        return new SelectionMap(this);
    }

    public int getNamingNationNum() {
        return this.namingNationNum;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

