/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.maputils;

import com.empireclassic.jec.maputils.EPHandle;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CourseSetNode
extends PNode {
    protected Point2D.Double pointOne;
    protected Point2D.Double pointTwo;
    protected Stroke stroke;

    public CourseSetNode(Point start, Point handle) {
        this.pointOne = new Point2D.Double(start.getX() + 0.5, start.getY() + 0.5);
        this.pointTwo = new Point2D.Double(handle.getX() + 0.5, handle.getY() + 0.5);
        this.stroke = new BasicStroke(0.0f, 0, 2);
        this.setPaint(Color.BLACK);
        this.updateBounds();
        this.addHandles();
    }

    public void addHandles() {
        PLocator l = new PLocator(){

            public double locateX() {
                return CourseSetNode.this.pointTwo.getX();
            }

            public double locateY() {
                return CourseSetNode.this.pointTwo.getY();
            }
        };
        EPHandle h = new EPHandle(l){

            public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
                this.localToParent((Dimension2D)aLocalDimension);
                CourseSetNode.this.pointTwo.setLocation(CourseSetNode.this.pointTwo.getX() + aLocalDimension.getWidth(), CourseSetNode.this.pointTwo.getY() + aLocalDimension.getHeight());
                CourseSetNode.this.updateBounds();
                this.relocateHandle();
            }

            public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
                CourseSetNode.this.pointTwo.setLocation((float)((int)((double)((int)aLocalPoint.getX()) + 0.5)) + 0.5f, (float)((int)((double)((int)aLocalPoint.getY()) + 0.5)) + 0.5f);
                CourseSetNode.this.updateBounds();
                this.relocateHandle();
            }
        };
        this.addChild((PNode)h);
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        g2.setStroke(this.stroke);
        g2.setPaint(this.getPaint());
        g2.draw(this.getAnglePath());
    }

    protected void updateBounds() {
        GeneralPath p = this.getAnglePath();
        Rectangle2D b = this.stroke.createStrokedShape(p).getBounds2D();
        super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    public GeneralPath getAnglePath() {
        GeneralPath p = new GeneralPath();
        p.moveTo((float)this.pointOne.getX(), (float)this.pointOne.getY());
        p.lineTo((float)this.pointTwo.getX(), (float)this.pointTwo.getY());
        return p;
    }

    public boolean setBounds(double x, double y, double width, double height) {
        return false;
    }
}

