/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.sectormenu;

import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SectorAttackDialog
extends JDialog {
    private boolean cancelled = true;
    IslandInfo island;
    IslandCoord from;
    IslandCoord to;
    int numMilitary;
    int numCasualtiesExpected;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel infoLabel = null;
    private JLabel infoCasualtiesLabel = null;
    private JLabel numLabel = null;
    private JTextField numAttackingTextField = null;
    private JSlider numSlider = null;
    private JLabel minNumLabel = null;
    private JLabel maxNumLabel = null;

    public SectorAttackDialog(IslandInfo island, IslandCoord from, IslandCoord to, int numDefenders, int maxAttackers, int numCasualtiesExpected) {
        this.island = island;
        this.from = from;
        this.to = to;
        this.numCasualtiesExpected = numCasualtiesExpected;
        this.initialize();
        this.infoLabel.setText(island.formatIslandName() + " island, attacking " + to + " from " + from + ".  " + numDefenders + " defenders.");
        this.infoCasualtiesLabel.setText("Expected casualties: " + numCasualtiesExpected);
        this.numSlider.setMaximum(maxAttackers);
        this.numSlider.setValue(numCasualtiesExpected);
        this.numAttackingTextField.setText("" + numCasualtiesExpected);
        this.maxNumLabel.setText("" + maxAttackers);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public int getNumMilitary() {
        return Integer.parseInt(this.numAttackingTextField.getText());
    }

    private void initialize() {
        this.setSize(423, 200);
        this.setModal(true);
        this.setTitle("Attack");
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.maxNumLabel = new JLabel();
            this.maxNumLabel.setBounds(new Rectangle(284, 99, 45, 16));
            this.maxNumLabel.setHorizontalTextPosition(0);
            this.maxNumLabel.setText("9999");
            this.minNumLabel = new JLabel();
            this.minNumLabel.setBounds(new Rectangle(55, 99, 19, 16));
            this.minNumLabel.setText("1");
            this.numLabel = new JLabel();
            this.numLabel.setBounds(new Rectangle(66, 72, 169, 16));
            this.numLabel.setText("Number of men in the attack:");
            this.infoCasualtiesLabel = new JLabel();
            this.infoCasualtiesLabel.setBounds(new Rectangle(105, 44, 195, 16));
            this.infoCasualtiesLabel.setText("Expected casualties 9999 men.");
            this.infoLabel = new JLabel();
            this.infoLabel.setBounds(new Rectangle(32, 16, 354, 16));
            this.infoLabel.setText("DuMorte Island, attacking 12,12 from 12,13.  9999 defenders.");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.add((Component)this.infoLabel, null);
            this.mainPanel.add((Component)this.infoCasualtiesLabel, null);
            this.mainPanel.add((Component)this.numLabel, null);
            this.mainPanel.add((Component)this.getNumAttackingTextField(), null);
            this.mainPanel.add((Component)this.getNumSlider(), null);
            this.mainPanel.add((Component)this.minNumLabel, null);
            this.mainPanel.add((Component)this.maxNumLabel, null);
        }
        return this.mainPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SectorAttackDialog.this.cancelled = false;
                    SectorAttackDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SectorAttackDialog.this.cancelled = true;
                    SectorAttackDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JTextField getNumAttackingTextField() {
        if (this.numAttackingTextField == null) {
            this.numAttackingTextField = new JTextField();
            this.numAttackingTextField.setBounds(new Rectangle(246, 70, 50, 20));
        }
        return this.numAttackingTextField;
    }

    private JSlider getNumSlider() {
        if (this.numSlider == null) {
            this.numSlider = new JSlider();
            this.numSlider.setBounds(new Rectangle(79, 100, 200, 16));
            this.numSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    JSlider slider = (JSlider)event.getSource();
                    SectorAttackDialog.this.numAttackingTextField.setText("" + slider.getValue());
                }
            });
        }
        return this.numSlider;
    }
}

