/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.fleetmenu;

import com.empireclassic.Remote.EmpireError;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.utils.EmpireUtilities;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;

public class SelectFleetMenu
extends JMenu {
    private int fleetNum;
    private Vector<PPath> movePathList = new Vector();
    private JECFrame parent;
    GetFleetCourseMouseClick getFleetCourseMouseClick = new GetFleetCourseMouseClick();

    public SelectFleetMenu(JECFrame parent, String name, int fleetNum) {
        super(name);
        this.parent = parent;
        this.fleetNum = fleetNum;
        SetCourseAction setCourseAction = new SetCourseAction("Set course");
        this.add(setCourseAction);
    }

    public void fleetCourseActionPerformed(ActionEvent event) {
        this.parent.getMapCanvas().addInputEventListener(this.getFleetCourseMouseClick);
    }

    public class SetCourseAction
    extends AbstractAction {
        public SetCourseAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectFleetMenu.this.parent.setFrameState(JECFrame.State.FLEETCOURSE);
            SelectFleetMenu.this.fleetCourseActionPerformed(event);
        }
    }

    public class GetFleetCourseMouseClick
    extends PBasicInputEventHandler {
        public void mouseClicked(PInputEvent event) {
            Iterator pathIt = SelectFleetMenu.this.movePathList.iterator();
            while (pathIt.hasNext()) {
                SelectFleetMenu.this.parent.getMapCanvas().getWorldRect().removeChild((PNode)pathIt.next());
            }
            SelectFleetMenu.this.movePathList.clear();
            JECFrame.State oldState = SelectFleetMenu.this.parent.getFrameState();
            SelectFleetMenu.this.parent.setFrameState(JECFrame.State.PANANDZOOM);
            SelectFleetMenu.this.parent.getMapCanvas().removeInputEventListener(SelectFleetMenu.this.getFleetCourseMouseClick);
            System.out.println("Course");
            EmpireError error = RemoteEmpire.getInstance().setFleetCourse(Globals.nationNum, SelectFleetMenu.this.fleetNum, new WorldCoord(event.getPosition().getX(), event.getPosition().getY()));
            SelectFleetMenu.this.parent.getMapCanvas().updateAllShips();
        }

        public void mouseMoved(PInputEvent event) {
            String status = new String();
            Iterator<MyShip> shipIt = SelectFleetMenu.this.parent.getShipList().values().iterator();
            Iterator pathIt = SelectFleetMenu.this.movePathList.iterator();
            while (pathIt.hasNext()) {
                SelectFleetMenu.this.parent.getMapCanvas().getWorldRect().removeChild((PNode)pathIt.next());
            }
            SelectFleetMenu.this.movePathList.clear();
            while (shipIt.hasNext()) {
                MyShip ship = shipIt.next();
                if (ship.getFleet() != SelectFleetMenu.this.fleetNum) continue;
                float distance = EmpireUtilities.distance(ship.getLoc(), event.getPosition());
                float direction = EmpireUtilities.direction(ship.getLoc(), event.getPosition());
                float destX = (float)((int)(event.getPosition().getX() + 0.5)) + 0.5f;
                float destY = (float)((int)(event.getPosition().getY() + 0.5)) + 0.5f;
                if ((double)distance > ship.getTime() && SelectFleetMenu.this.parent.getFrameState() == JECFrame.State.SHIPMOVE) {
                    int xOff = (int)(Math.sin((double)direction / 57.2958) * (double)((int)ship.getTime()));
                    destX = (float)ship.getLoc().getX() + (float)xOff;
                    int yOff = (int)(Math.cos((double)direction / 57.2958) * (double)((int)ship.getTime()));
                    destY = (float)ship.getLoc().getY() - (float)yOff;
                }
                PPath movePath = new PPath();
                movePath.moveTo((float)(ship.getLoc().getX() + 0.5), (float)(ship.getLoc().getY() + 0.5));
                movePath.lineTo(destX, destY);
                movePath.setStroke(new PFixedWidthStroke());
                SelectFleetMenu.this.movePathList.add(movePath);
                SelectFleetMenu.this.parent.getMapCanvas().getWorldRect().addChild(movePath);
            }
            status = new String("setting " + SelectFleetMenu.this.movePathList.size() + " ships");
            SelectFleetMenu.this.parent.setStatusDisplay(status);
            event.setHandled(true);
        }

        public void keyTyped(PInputEvent event) {
        }
    }
}

