/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.shipmenu;

import com.empireclassic.Remote.EmpireError;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.Ship;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.fleetmenu.FleetAssignDialog;
import com.empireclassic.jec.shipmenu.AssaultResultsDialog;
import com.empireclassic.jec.shipmenu.SeaAssaultDialog;
import com.empireclassic.jec.shipmenu.SeaLoadUnloadDialog;
import com.empireclassic.jec.shipmenu.SeaMineDialog;
import com.empireclassic.jec.utils.EmpireUtilities;
import com.empireclassic.jec.utils.UiUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SelectShipMenu
extends JMenu {
    private JECFrame frame;
    private PNode shipNode;
    private PPath movePath;
    GetSeaMoveMouseClick getSeaMoveMouseClick = new GetSeaMoveMouseClick();

    public SelectShipMenu(JECFrame parent, String name, PNode shipNode) {
        super(name);
        this.frame = parent;
        this.shipNode = shipNode;
        MyShip ship = (MyShip)shipNode.getClientProperty("SHIP");
        MoveAction moveAction = new MoveAction("Move");
        this.add(moveAction);
        if (ship.isDocked() && !ship.isNew()) {
            moveAction.setEnabled(false);
        }
        SetCourseAction setCourseAction = new SetCourseAction("Set course");
        this.add(setCourseAction);
        if (ship.isDocked() || ship.isNew()) {
            setCourseAction.setEnabled(false);
        }
        UndockAction undockAction = new UndockAction("Undock");
        this.add(undockAction);
        if (!ship.isDocked() || ship.isNew()) {
            undockAction.setEnabled(false);
        }
        LoadAction loadAction = new LoadAction("Load/Unload");
        this.add(loadAction);
        if (!ship.isDocked() && !ship.isNew()) {
            loadAction.setEnabled(false);
        }
        AssaultAction assaultAction = new AssaultAction("Assault");
        this.add(assaultAction);
        if (!ship.isDocked()) {
            assaultAction.setEnabled(false);
        }
        EmergeSubmergeAction emergeSubmergeAction = ship.isSubmerged() ? new EmergeSubmergeAction("Emerge") : new EmergeSubmergeAction("Submerge");
        this.add(emergeSubmergeAction);
        if (!ship.getType().equals("Submarine")) {
            emergeSubmergeAction.setEnabled(false);
        }
        JMenuItem fireItem = new JMenuItem("Fire");
        this.add(fireItem);
        fireItem.setEnabled(false);
        MineAction mineItem = new MineAction("Mine");
        this.add(mineItem);
        if (ship.getShells() == 0) {
            mineItem.setEnabled(false);
        }
        this.add(new AbstractAction("Assign to fleet"){

            public void actionPerformed(ActionEvent event) {
                SelectShipMenu.this.assignActionPerformed(event);
            }
        });
    }

    public void assignActionPerformed(ActionEvent event) {
        MyShip ship = (MyShip)this.shipNode.getClientProperty("SHIP");
        System.out.println("Assigning ship to fleet");
        FleetAssignDialog assignWindow = new FleetAssignDialog(null, "Assign", true, ship.getFleet());
        UiUtil.centerAndShow(assignWindow);
        if (!assignWindow.cancelled()) {
            RemoteEmpire.getInstance().assignShipToFleet(ship.getShipNum(), assignWindow.getFleet());
            this.frame.getMapCanvas().updateShip(ship);
        }
    }

    public void seaMoveActionPerformed(ActionEvent event) {
        this.frame.getMapCanvas().addInputEventListener(this.getSeaMoveMouseClick);
        boolean x = false;
    }

    public void seaUndockActionPerformed(ActionEvent event) {
        Ship ship = (Ship)this.shipNode.getClientProperty("SHIP");
        try {
            EmpireError error = RemoteEmpire.getInstance().shipUndock(ship.getShipNum());
            if (error.errorNum != 0) {
                JOptionPane.showMessageDialog(this.frame, error.errorString, "Undock Error", 0);
            }
        }
        catch (Exception except) {
            except.printStackTrace();
        }
        this.frame.getMapCanvas().updateShip(ship);
    }

    public void seaLoadActionPerformed(ActionEvent event) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        MyShip ship = (MyShip)this.shipNode.getClientProperty("SHIP");
        WorldCoord coord = (WorldCoord)ship.getLoc().clone();
        System.out.println("Load/unload");
        PNode islandNode = this.frame.getMapCanvas().findIslandNodeUnder(ship.getLoc());
        IslandInfo island = (IslandInfo)islandNode.getClientProperty("ISLAND");
        Sector sector = island.getSectors().get(coord.asIslandCoord(island));
        SeaLoadUnloadDialog loadUnloadWindow = new SeaLoadUnloadDialog(null, ship, island, coord.asIslandCoord(island));
        UiUtil.centerAndShow(loadUnloadWindow);
        if (!loadUnloadWindow.cancelled()) {
            EmpireError error;
            if (loadUnloadWindow.civilians() != 0) {
                System.out.println("load civ " + loadUnloadWindow.civilians());
                error = empire.shipLoadUnload(ship.getShipNum(), "c", -loadUnloadWindow.civilians());
                this.seaCheckError(error);
            }
            if (loadUnloadWindow.military() != 0) {
                System.out.println("load mil " + loadUnloadWindow.military());
                error = empire.shipLoadUnload(ship.getShipNum(), "m", -loadUnloadWindow.military());
                this.seaCheckError(error);
            }
            if (loadUnloadWindow.artillery() != 0) {
                System.out.println("load guns " + loadUnloadWindow.artillery());
                error = empire.shipLoadUnload(ship.getShipNum(), "a", -loadUnloadWindow.artillery());
                this.seaCheckError(error);
            }
            if (loadUnloadWindow.explosives() != 0) {
                System.out.println("load shells " + loadUnloadWindow.explosives());
                error = empire.shipLoadUnload(ship.getShipNum(), "e", -loadUnloadWindow.explosives());
                this.seaCheckError(error);
            }
            if (loadUnloadWindow.ore() != 0) {
                System.out.println("load ore " + loadUnloadWindow.ore());
                error = empire.shipLoadUnload(ship.getShipNum(), "o", -loadUnloadWindow.ore());
                this.seaCheckError(error);
            }
            this.frame.getMapCanvas().updateShip(ship);
            this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
        }
    }

    private void seaCheckError(EmpireError error) {
        if (error.errorNum != 0) {
            JOptionPane.showMessageDialog(this.frame, error.errorString, "Error during load", 0);
        }
    }

    public void seaAssaultActionPerformed(ActionEvent event) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        MyShip ship = (MyShip)this.shipNode.getClientProperty("SHIP");
        WorldCoord wCoord = (WorldCoord)ship.getLoc().clone();
        System.out.println("Assault");
        PNode islandNode = this.frame.getMapCanvas().findIslandNodeUnder(ship.getLoc());
        IslandInfo island = (IslandInfo)islandNode.getClientProperty("ISLAND");
        IslandCoord coord = wCoord.asIslandCoord(island);
        Sector sector = island.getSectors().get(coord);
        RemoteEmpire.AssaultTestReply reply = empire.shipAssaultTest(ship.getShipNum());
        if (reply.getError().errorNum != 0) {
            JOptionPane.showMessageDialog(this.frame, reply.getError().errorString, "Assault Error", 0);
            return;
        }
        SeaAssaultDialog assaultWindow = new SeaAssaultDialog(null, ship, island, coord, reply.getExpectedCasualties());
        assaultWindow.setModal(true);
        UiUtil.centerAndShow(assaultWindow);
        if (!assaultWindow.cancelled()) {
            RemoteEmpire.AssaultReply assaultReply = empire.shipAssault(ship.getShipNum(), assaultWindow.getNumAttacking());
            AssaultResultsDialog resultsDialog = new AssaultResultsDialog(assaultReply.isWon(), assaultReply.getCasualties(), assaultReply.getEnemyLosses());
            resultsDialog.setModal(true);
            UiUtil.centerAndShow(resultsDialog);
            this.frame.getMapCanvas().updateAllShips();
            this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
            System.out.println("New owner = " + island.getSectors().get(coord).getOwner());
        }
    }

    public void emergeSubmergeActionPerformed(ActionEvent event) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        Ship ship = (Ship)this.shipNode.getClientProperty("SHIP");
        if (event.getActionCommand().equals("Submerge")) {
            EmpireError error = empire.shipSubmerge(ship.getShipNum());
            if (error.errorNum != 0) {
                JOptionPane.showInternalMessageDialog(this.frame, error.errorString, "Submerge error", 0);
            }
        } else {
            EmpireError error = empire.shipEmerge(ship.getShipNum());
        }
        this.frame.getMapCanvas().updateShip(ship);
    }

    public void seaMineActionPerformed(ActionEvent event) {
        MyShip ship = (MyShip)this.shipNode.getClientProperty("SHIP");
        WorldCoord coord = (WorldCoord)ship.getLoc().clone();
        System.out.println("mine");
        PNode islandNode = this.frame.getMapCanvas().findIslandNodeUnder(ship.getLoc());
        IslandInfo island = (IslandInfo)islandNode.getClientProperty("ISLAND");
        coord.translate(-island.getLocation().x + 1, -island.getLocation().y + 1);
        Sector sector = island.getSectors().get(coord);
        SeaMineDialog mineWindow = new SeaMineDialog(null, ship.getShells());
        UiUtil.centerAndShow(mineWindow);
        if (!mineWindow.cancelled()) {
            EmpireError error = RemoteEmpire.getInstance().shipMine(ship.getShipNum(), mineWindow.getMines());
            this.frame.getMapCanvas().updateShip(ship);
            this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
        }
    }

    private Point2D calculateLimitedMove(MyShip ship, float direction, Point2D destination) {
        Point2D.Float limited = new Point2D.Float();
        int xOff = (int)(Math.sin((double)direction / 57.2958) * (double)((int)ship.getTime()));
        int yOff = (int)(Math.cos((double)direction / 57.2958) * (double)((int)ship.getTime()));
        ((Point2D)limited).setLocation(ship.getLoc().getX() + (double)xOff, ship.getLoc().getY() - (double)yOff);
        return limited;
    }

    private class MineAction
    extends AbstractAction {
        public MineAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.seaMineActionPerformed(event);
        }
    }

    private class AssaultAction
    extends AbstractAction {
        public AssaultAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.seaAssaultActionPerformed(event);
        }
    }

    private class EmergeSubmergeAction
    extends AbstractAction {
        public EmergeSubmergeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.emergeSubmergeActionPerformed(event);
        }
    }

    private class LoadAction
    extends AbstractAction {
        public LoadAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.seaLoadActionPerformed(event);
        }
    }

    private class UndockAction
    extends AbstractAction {
        public UndockAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.seaUndockActionPerformed(event);
        }
    }

    private class MoveAction
    extends AbstractAction {
        public MoveAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.frame.setFrameState(JECFrame.State.SHIPMOVE);
            SelectShipMenu.this.seaMoveActionPerformed(event);
        }
    }

    private class SetCourseAction
    extends AbstractAction {
        public SetCourseAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            SelectShipMenu.this.frame.setFrameState(JECFrame.State.SHIPCOURSE);
            SelectShipMenu.this.seaMoveActionPerformed(event);
        }
    }

    public class GetSeaMoveMouseClick
    extends PBasicInputEventHandler {
        public void mousePressed(PInputEvent event) {
            SelectShipMenu.this.frame.getMapCanvas().getWorldRect().removeChild(SelectShipMenu.this.movePath);
            SelectShipMenu.this.movePath = null;
            JECFrame.State oldState = SelectShipMenu.this.frame.getFrameState();
            if (event.getButton() == 1) {
                MyShip ship = (MyShip)SelectShipMenu.this.shipNode.getClientProperty("SHIP");
                System.out.println("Sailing ship #" + ship.getShipNum() + " dir " + EmpireUtilities.direction(ship.getLoc(), event.getPosition()) + " distance " + EmpireUtilities.distance(ship.getLoc(), event.getPosition()));
                if (oldState == JECFrame.State.SHIPMOVE) {
                    Point2D limitedDestination = event.getPosition();
                    if ((double)EmpireUtilities.distance(ship.getLoc(), event.getPosition()) > ship.getTime()) {
                        limitedDestination = SelectShipMenu.this.calculateLimitedMove(ship, EmpireUtilities.direction(ship.getLoc(), event.getPosition()), event.getPosition());
                    }
                    EmpireError error = RemoteEmpire.getInstance().shipMove(ship.getShipNum(), EmpireUtilities.direction(ship.getLoc(), limitedDestination), EmpireUtilities.distance(ship.getLoc(), limitedDestination));
                    if (error.errorNum != 0) {
                        JOptionPane.showMessageDialog(SelectShipMenu.this.frame, error.errorString, "Move Ship Error", 0);
                    }
                    event.setHandled(true);
                } else if (oldState == JECFrame.State.SHIPCOURSE) {
                    WorldCoord destination = new WorldCoord(event.getPosition().getX(), event.getPosition().getY());
                    EmpireError error = RemoteEmpire.getInstance().shipSetCourse(ship.getShipNum(), destination, ship.getType().getSpeed());
                    System.out.println(error.errorNum + ":" + error.errorString);
                    if (error.errorNum != 0) {
                        JOptionPane.showMessageDialog(SelectShipMenu.this.frame, error.errorString, "Course Set Error", 0);
                    }
                    event.setHandled(true);
                }
                SelectShipMenu.this.frame.getMapCanvas().updateShip(ship);
            }
            SelectShipMenu.this.frame.setFrameState(JECFrame.State.PANANDZOOM);
            SelectShipMenu.this.frame.getMapCanvas().removeInputEventListener(SelectShipMenu.this.getSeaMoveMouseClick);
        }

        public void mouseMoved(PInputEvent event) {
            MyShip ship = (MyShip)SelectShipMenu.this.shipNode.getClientProperty("SHIP");
            if (SelectShipMenu.this.movePath != null) {
                SelectShipMenu.this.frame.getMapCanvas().getWorldRect().removeChild(SelectShipMenu.this.movePath);
            }
            float distance = EmpireUtilities.distance(ship.getLoc(), event.getPosition());
            float direction = EmpireUtilities.direction(ship.getLoc(), event.getPosition());
            float destX = (int)event.getPosition().getX();
            float destY = (int)event.getPosition().getY();
            if ((double)distance > ship.getTime() && SelectShipMenu.this.frame.getFrameState() == JECFrame.State.SHIPMOVE) {
                Point2D limited = SelectShipMenu.this.calculateLimitedMove(ship, direction, event.getPosition());
                destX = (float)limited.getX();
                destY = (float)limited.getY();
            }
            SelectShipMenu.this.movePath = new PPath();
            SelectShipMenu.this.movePath.moveTo((float)(ship.getLoc().getX() + 0.5), (float)(ship.getLoc().getY() + 0.5));
            SelectShipMenu.this.movePath.lineTo(destX + 0.5f, destY + 0.5f);
            SelectShipMenu.this.movePath.setStroke(new PFixedWidthStroke());
            SelectShipMenu.this.frame.getMapCanvas().getWorldRect().addChild(SelectShipMenu.this.movePath);
            DecimalFormat format = new DecimalFormat("0.00");
            String status = new String((int)ship.getLoc().getX() + "," + (int)ship.getLoc().getY() + " direction = " + (int)EmpireUtilities.direction(ship.getLoc(), event.getPosition()) + " distance = " + format.format(EmpireUtilities.distance(ship.getLoc(), event.getPosition())));
            SelectShipMenu.this.frame.setStatusDisplay(status);
            event.setHandled(true);
        }

        public void keyTyped(PInputEvent event) {
            SelectShipMenu.this.frame.getMapCanvas().getWorldRect().removeChild(SelectShipMenu.this.movePath);
            SelectShipMenu.this.movePath = null;
            SelectShipMenu.this.frame.setFrameState(JECFrame.State.PANANDZOOM);
            SelectShipMenu.this.frame.getMapCanvas().removeInputEventListener(SelectShipMenu.this.getSeaMoveMouseClick);
        }
    }
}

