/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class GTableModel
extends DefaultTableModel
implements Comparator {
    protected int currCol;
    protected Vector<Integer> ascendCol;
    protected Integer one = new Integer(1);
    protected Integer minusOne = new Integer(-1);

    public GTableModel() {
        this.ascendCol = new Vector();
    }

    public Class getColumnClass(int col) {
        Vector v = (Vector)this.dataVector.elementAt(0);
        return v.elementAt(col).getClass();
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addColumn(Object columnName) {
        super.addColumn(columnName);
        this.ascendCol.add(this.one);
    }

    public void addColumn(Object columnName, Object[] columnData) {
        super.addColumn(columnName, columnData);
        this.ascendCol.add(this.one);
    }

    public void addColumn(Object columnName, Vector columnData) {
        super.addColumn(columnName, columnData);
        this.ascendCol.add(this.one);
    }

    public int compare(Object v1, Object v2) {
        int ascending = this.ascendCol.get(this.currCol);
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v2 == null) {
            return 1 * ascending;
        }
        if (v1 == null) {
            return -1 * ascending;
        }
        Object o1 = ((Vector)v1).get(this.currCol);
        Object o2 = ((Vector)v2).get(this.currCol);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return 1 * ascending;
        }
        if (o1 == null) {
            return -1 * ascending;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n2;
            double d2;
            Number n1 = (Number)o1;
            double d1 = n1.doubleValue();
            if (d1 == (d2 = (n2 = (Number)o2).doubleValue())) {
                return 0;
            }
            if (d1 > d2) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)o1;
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1 * ascending;
            }
            return -1 * ascending;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            try {
                return c1.compareTo(c2) * ascending;
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2) * ascending;
    }

    public void sort() {
        Collections.sort(this.dataVector, this);
        Integer val = this.ascendCol.get(this.currCol);
        this.ascendCol.remove(this.currCol);
        if (val.equals(this.one)) {
            this.ascendCol.add(this.currCol, this.minusOne);
        } else {
            this.ascendCol.add(this.currCol, this.one);
        }
    }

    public void sortByColumn(int column) {
        this.currCol = column;
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final GTableModel sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    sorter.sortByColumn(column);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

