/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PSelectionEventHandler
extends PDragSequenceEventHandler {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION";
    static final int DASH_WIDTH = 5;
    static final int NUM_STROKES = 10;
    private HashMap selection = null;
    private List selectableParents = null;
    private PPath marquee = null;
    private PNode marqueeParent = null;
    private Point2D presspt = null;
    private Point2D canvasPressPt = null;
    private float strokeNum = 0.0f;
    private Stroke[] strokes = null;
    private HashMap allItems = null;
    private ArrayList unselectList = null;
    private HashMap marqueeMap = null;
    private PNode pressNode = null;
    private boolean deleteKeyActive = true;
    private Paint marqueePaint;
    private float marqueePaintTransparency = 1.0f;

    public PSelectionEventHandler(PNode pNode, PNode pNode2) {
        this.marqueeParent = pNode;
        this.selectableParents = new ArrayList();
        this.selectableParents.add(pNode2);
        this.init();
    }

    public PSelectionEventHandler(PNode pNode, List list) {
        this.marqueeParent = pNode;
        this.selectableParents = list;
        this.init();
    }

    protected void init() {
        float[] fArray = new float[]{5.0f, 5.0f};
        this.strokes = new Stroke[10];
        for (int i = 0; i < 10; ++i) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, fArray, i);
        }
        this.selection = new HashMap();
        this.allItems = new HashMap();
        this.unselectList = new ArrayList();
        this.marqueeMap = new HashMap();
    }

    public void select(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            bl |= this.internalSelect(pNode);
        }
        if (bl) {
            this.postSelectionChanged();
        }
    }

    public void select(Map map) {
        this.select(map.keySet());
    }

    private boolean internalSelect(PNode pNode) {
        if (this.isSelected(pNode)) {
            return false;
        }
        this.selection.put(pNode, Boolean.TRUE);
        this.decorateSelectedNode(pNode);
        return true;
    }

    private void postSelectionChanged() {
        PNotificationCenter.defaultCenter().postNotification(SELECTION_CHANGED_NOTIFICATION, (Object)this);
    }

    public void select(PNode pNode) {
        if (this.internalSelect(pNode)) {
            this.postSelectionChanged();
        }
    }

    public void decorateSelectedNode(PNode pNode) {
        PBoundsHandle.addBoundsHandlesTo(pNode);
    }

    public void unselect(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            bl |= this.internalUnselect(pNode);
        }
        if (bl) {
            this.postSelectionChanged();
        }
    }

    private boolean internalUnselect(PNode pNode) {
        if (!this.isSelected(pNode)) {
            return false;
        }
        this.undecorateSelectedNode(pNode);
        this.selection.remove(pNode);
        return true;
    }

    public void unselect(PNode pNode) {
        if (this.internalUnselect(pNode)) {
            this.postSelectionChanged();
        }
    }

    public void undecorateSelectedNode(PNode pNode) {
        PBoundsHandle.removeBoundsHandlesFrom(pNode);
    }

    public void unselectAll() {
        ArrayList arrayList = new ArrayList(this.selection.keySet());
        this.unselect(arrayList);
    }

    public boolean isSelected(PNode pNode) {
        return pNode != null && this.selection.containsKey(pNode);
    }

    public Collection getSelection() {
        ArrayList arrayList = new ArrayList(this.selection.keySet());
        return arrayList;
    }

    public Collection getSelectionReference() {
        return Collections.unmodifiableCollection(this.selection.keySet());
    }

    protected boolean isSelectable(PNode pNode) {
        boolean bl = false;
        Iterator iterator = this.selectableParents.iterator();
        block0: while (iterator.hasNext()) {
            PNode pNode2 = (PNode)iterator.next();
            if (pNode2.getChildrenReference().contains(pNode)) {
                bl = true;
                break;
            }
            if (!(pNode2 instanceof PCamera)) continue;
            for (int i = 0; i < ((PCamera)pNode2).getLayerCount(); ++i) {
                PLayer pLayer = ((PCamera)pNode2).getLayer(i);
                if (!pLayer.getChildrenReference().contains(pNode)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public void addSelectableParent(PNode pNode) {
        this.selectableParents.add(pNode);
    }

    public void removeSelectableParent(PNode pNode) {
        this.selectableParents.remove(pNode);
    }

    public void setSelectableParent(PNode pNode) {
        this.selectableParents.clear();
        this.selectableParents.add(pNode);
    }

    public void setSelectableParents(Collection collection) {
        this.selectableParents.clear();
        this.selectableParents.addAll(collection);
    }

    public Collection getSelectableParents() {
        return new ArrayList(this.selectableParents);
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.initializeSelection(pInputEvent);
        if (this.isMarqueeSelection(pInputEvent)) {
            this.initializeMarquee(pInputEvent);
            if (!this.isOptionSelection(pInputEvent)) {
                this.startMarqueeSelection(pInputEvent);
            } else {
                this.startOptionMarqueeSelection(pInputEvent);
            }
        } else if (!this.isOptionSelection(pInputEvent)) {
            this.startStandardSelection(pInputEvent);
        } else {
            this.startStandardOptionSelection(pInputEvent);
        }
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        if (this.isMarqueeSelection(pInputEvent)) {
            this.updateMarquee(pInputEvent);
            if (!this.isOptionSelection(pInputEvent)) {
                this.computeMarqueeSelection(pInputEvent);
            } else {
                this.computeOptionMarqueeSelection(pInputEvent);
            }
        } else {
            this.dragStandardSelection(pInputEvent);
        }
    }

    protected void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        if (this.isMarqueeSelection(pInputEvent)) {
            this.endMarqueeSelection(pInputEvent);
        } else {
            this.endStandardSelection(pInputEvent);
        }
    }

    public boolean isOptionSelection(PInputEvent pInputEvent) {
        return pInputEvent.isShiftDown();
    }

    protected boolean isMarqueeSelection(PInputEvent pInputEvent) {
        return this.pressNode == null;
    }

    protected void initializeSelection(PInputEvent pInputEvent) {
        this.canvasPressPt = pInputEvent.getCanvasPosition();
        this.presspt = pInputEvent.getPosition();
        this.pressNode = pInputEvent.getPath().getPickedNode();
        if (this.pressNode instanceof PCamera) {
            this.pressNode = null;
        }
    }

    protected void initializeMarquee(PInputEvent pInputEvent) {
        this.marquee = PPath.createRectangle((float)((float)this.presspt.getX()), (float)((float)this.presspt.getY()), (float)0.0f, (float)0.0f);
        this.marquee.setPaint(this.marqueePaint);
        this.marquee.setTransparency(this.marqueePaintTransparency);
        this.marquee.setStrokePaint((Paint)Color.black);
        this.marquee.setStroke(this.strokes[0]);
        this.marqueeParent.addChild((PNode)this.marquee);
        this.marqueeMap.clear();
    }

    protected void startOptionMarqueeSelection(PInputEvent pInputEvent) {
    }

    protected void startMarqueeSelection(PInputEvent pInputEvent) {
        this.unselectAll();
    }

    protected void startStandardSelection(PInputEvent pInputEvent) {
        if (!this.isSelected(this.pressNode)) {
            this.unselectAll();
            if (this.isSelectable(this.pressNode)) {
                this.select(this.pressNode);
            }
        }
    }

    protected void startStandardOptionSelection(PInputEvent pInputEvent) {
        if (this.isSelectable(this.pressNode)) {
            if (this.isSelected(this.pressNode)) {
                this.unselect(this.pressNode);
            } else {
                this.select(this.pressNode);
            }
        }
    }

    protected void updateMarquee(PInputEvent pInputEvent) {
        PBounds pBounds = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            pBounds.add(this.canvasPressPt);
            pBounds.add(pInputEvent.getCanvasPosition());
        } else {
            pBounds.add(this.presspt);
            pBounds.add(pInputEvent.getPosition());
        }
        this.marquee.globalToLocal((Rectangle2D)pBounds);
        this.marquee.setPathToRectangle((float)pBounds.x, (float)pBounds.y, (float)pBounds.width, (float)pBounds.height);
        pBounds.reset();
        pBounds.add(this.presspt);
        pBounds.add(pInputEvent.getPosition());
        this.allItems.clear();
        PNodeFilter pNodeFilter = this.createNodeFilter(pBounds);
        Iterator iterator = this.selectableParents.iterator();
        while (iterator.hasNext()) {
            Collection collection;
            PNode pNode = (PNode)iterator.next();
            if (pNode instanceof PCamera) {
                collection = new ArrayList();
                for (int i = 0; i < ((PCamera)pNode).getLayerCount(); ++i) {
                    ((PCamera)pNode).getLayer(i).getAllNodes(pNodeFilter, collection);
                }
            } else {
                collection = pNode.getAllNodes(pNodeFilter, null);
            }
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.allItems.put(iterator2.next(), Boolean.TRUE);
            }
        }
    }

    protected void computeMarqueeSelection(PInputEvent pInputEvent) {
        PNode pNode;
        this.unselectList.clear();
        Iterator iterator = this.selection.keySet().iterator();
        while (iterator.hasNext()) {
            pNode = (PNode)iterator.next();
            if (this.allItems.containsKey(pNode)) continue;
            this.unselectList.add(pNode);
        }
        this.unselect(this.unselectList);
        iterator = this.allItems.keySet().iterator();
        while (iterator.hasNext()) {
            pNode = (PNode)iterator.next();
            if (!this.selection.containsKey(pNode) && !this.marqueeMap.containsKey(pNode) && this.isSelectable(pNode)) {
                this.marqueeMap.put(pNode, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(pNode)) continue;
            iterator.remove();
        }
        this.select(this.allItems);
    }

    protected void computeOptionMarqueeSelection(PInputEvent pInputEvent) {
        PNode pNode;
        this.unselectList.clear();
        Iterator iterator = this.selection.keySet().iterator();
        while (iterator.hasNext()) {
            pNode = (PNode)iterator.next();
            if (this.allItems.containsKey(pNode) || !this.marqueeMap.containsKey(pNode)) continue;
            this.marqueeMap.remove(pNode);
            this.unselectList.add(pNode);
        }
        this.unselect(this.unselectList);
        iterator = this.allItems.keySet().iterator();
        while (iterator.hasNext()) {
            pNode = (PNode)iterator.next();
            if (!this.selection.containsKey(pNode) && !this.marqueeMap.containsKey(pNode) && this.isSelectable(pNode)) {
                this.marqueeMap.put(pNode, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(pNode)) continue;
            iterator.remove();
        }
        this.select(this.allItems);
    }

    protected PNodeFilter createNodeFilter(PBounds pBounds) {
        return new BoundsFilter(pBounds);
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void dragStandardSelection(PInputEvent pInputEvent) {
        PDimension pDimension = pInputEvent.getCanvasDelta();
        pInputEvent.getTopCamera().localToView((Dimension2D)pDimension);
        PDimension pDimension2 = new PDimension();
        Iterator iterator = this.getSelection().iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            pDimension2.setSize((Dimension2D)pDimension);
            pNode.getParent().globalToLocal((Dimension2D)pDimension2);
            pNode.offset(pDimension2.getWidth(), pDimension2.getHeight());
        }
    }

    protected void endMarqueeSelection(PInputEvent pInputEvent) {
        this.marquee.removeFromParent();
        this.marquee = null;
    }

    protected void endStandardSelection(PInputEvent pInputEvent) {
        this.pressNode = null;
    }

    protected void dragActivityStep(PInputEvent pInputEvent) {
        if (this.marquee != null) {
            float f = this.strokeNum;
            this.strokeNum = (this.strokeNum + 0.5f) % 10.0f;
            if ((int)this.strokeNum != (int)f) {
                this.marquee.setStroke(this.strokes[(int)this.strokeNum]);
            }
        }
    }

    public void keyPressed(PInputEvent pInputEvent) {
        switch (pInputEvent.getKeyCode()) {
            case 127: {
                if (!this.deleteKeyActive) break;
                Iterator iterator = this.selection.keySet().iterator();
                while (iterator.hasNext()) {
                    PNode pNode = (PNode)iterator.next();
                    pNode.removeFromParent();
                }
                this.selection.clear();
            }
        }
    }

    public boolean getSupportDeleteKey() {
        return this.deleteKeyActive;
    }

    public boolean isDeleteKeyActive() {
        return this.deleteKeyActive;
    }

    public void setDeleteKeyActive(boolean bl) {
        this.deleteKeyActive = bl;
    }

    public Paint getMarqueePaint() {
        return this.marqueePaint;
    }

    public void setMarqueePaint(Paint paint) {
        this.marqueePaint = paint;
    }

    public float getMarqueePaintTransparency() {
        return this.marqueePaintTransparency;
    }

    public void setMarqueePaintTransparency(float f) {
        this.marqueePaintTransparency = f;
    }

    protected class BoundsFilter
    implements PNodeFilter {
        PBounds localBounds = new PBounds();
        PBounds bounds;

        protected BoundsFilter(PBounds pBounds) {
            this.bounds = pBounds;
        }

        public boolean accept(PNode pNode) {
            this.localBounds.setRect(this.bounds);
            pNode.globalToLocal((Rectangle2D)this.localBounds);
            boolean bl = pNode.intersects((Rectangle2D)this.localBounds);
            boolean bl2 = pNode == PSelectionEventHandler.this.marquee;
            return pNode.getPickable() && bl && !bl2 && !PSelectionEventHandler.this.selectableParents.contains(pNode) && !this.isCameraLayer(pNode);
        }

        public boolean acceptChildrenOf(PNode pNode) {
            return PSelectionEventHandler.this.selectableParents.contains(pNode) || this.isCameraLayer(pNode);
        }

        public boolean isCameraLayer(PNode pNode) {
            if (pNode instanceof PLayer) {
                Iterator iterator = PSelectionEventHandler.this.selectableParents.iterator();
                while (iterator.hasNext()) {
                    PNode pNode2 = (PNode)iterator.next();
                    if (!(pNode2 instanceof PCamera) || ((PCamera)pNode2).indexOfLayer((PLayer)pNode) == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

