/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PLens
extends PNode {
    public static double LENS_DRAGBAR_HEIGHT = 20.0;
    public static Paint DEFAULT_DRAGBAR_PAINT = Color.DARK_GRAY;
    public static Paint DEFAULT_LENS_PAINT = Color.LIGHT_GRAY;
    private PPath dragBar = PPath.createRectangle((float)0.0f, (float)0.0f, (float)100.0f, (float)100.0f);
    private PCamera camera;
    private PDragEventHandler lensDragger;

    public PLens() {
        this.dragBar.setPaint(DEFAULT_DRAGBAR_PAINT);
        this.dragBar.setPickable(false);
        this.addChild((PNode)this.dragBar);
        this.camera = new PCamera();
        this.camera.setPaint(DEFAULT_LENS_PAINT);
        this.addChild((PNode)this.camera);
        this.lensDragger = new PDragEventHandler();
        this.lensDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.addInputEventListener((PInputEventListener)this.lensDragger);
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PLens.this.camera.setViewTransform((AffineTransform)PLens.this.getInverseTransform());
            }
        });
    }

    public PLens(PLayer pLayer) {
        this();
        this.addLayer(0, pLayer);
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public PPath getDragBar() {
        return this.dragBar;
    }

    public PDragEventHandler getLensDraggerHandler() {
        return this.lensDragger;
    }

    public void addLayer(int n, PLayer pLayer) {
        this.camera.addLayer(n, pLayer);
    }

    public void removeLayer(PLayer pLayer) {
        this.camera.removeLayer(pLayer);
    }

    protected void layoutChildren() {
        this.dragBar.setPathToRectangle((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)LENS_DRAGBAR_HEIGHT);
        this.camera.setBounds(this.getX(), this.getY() + LENS_DRAGBAR_HEIGHT, this.getWidth(), this.getHeight() - LENS_DRAGBAR_HEIGHT);
    }
}

