/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.islandmenu;

import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.SelectionMap;
import com.empireclassic.jec.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDesignate
extends JDialog {
    private boolean cancelled = true;
    private Map<IslandCoord, Sector> sectors;
    private IslandInfo island;
    private boolean changing = true;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel mainPanel = null;
    private JRadioButton ruralsOnlyRadioButton = null;
    private JRadioButton changeEffRadioButton = null;
    private JLabel changeEffPercentLabel = null;
    private ButtonGroup changeButtonGroup = null;
    private JLabel numToChangeNumberLabel = null;
    private JLabel numToChangeLabel = null;
    private JSpinner changeEffSpinner = null;
    private JLabel numDocksLabel = null;
    private JSpinner numDocksSpinner = null;
    private JLabel numArtilleryLabel = null;
    private JSpinner numArtillerySpinner = null;
    private JLabel shellLabel = null;
    private JSpinner numShellSpinner = null;
    private JSpinner numMinesSpinner = null;
    private JLabel minesLabel = null;
    private JLabel numIndustriesLabel = null;
    private JLabel industriesLabel = null;
    private JLabel sumIndustriesLabel = null;
    private JLabel designatedLabel = null;
    private JLabel numPlanesLabel = null;
    private JSpinner numPlanesSpinner = null;
    private JLabel minesSupportLabel = null;
    private JRadioButton dockCountDistanceRadioButton = null;
    private JSpinner dockDistanceSpinner = null;
    private JLabel dockDistanceLabel = null;
    private List<Sector> sortedSampleSectors;
    private SelectionMap minesMap;
    private List<Sector> minesList;
    private SelectionMap changeableMap;
    private List<Sector> docksList;
    private SelectionMap docksMap;
    private int mineCount;
    private int ruralCount;
    private int dockCount;
    private int artilleryCount;
    private int explosivesCount;
    private int planesCount;
    private int mineSample;
    private int oldMines;
    private int oldDocks;
    private int oldArtillery;
    private int oldExplosives;
    private int oldPlanes;
    private int oldSample;
    private JLabel existingMinesLabel = null;
    private JLabel totalDocksField = null;
    private JLabel totalDocksLabel = null;
    private JLabel totalArtilleryField = null;
    private JLabel totalArtilleryLabel = null;
    private JLabel totalExplosivesField = null;
    private JLabel totalExplosivesLabel = null;
    private JLabel totalAircraftField = null;
    private JLabel totalAircraftLabel = null;
    private JLabel newIndustriesLabel = null;
    private JLabel totalIndustriesField = null;

    public AutoDesignate(JFrame frame, IslandInfo island, Map<IslandCoord, Sector> sectors) {
        super(frame);
        this.sectors = sectors;
        this.island = island;
        this.initialize();
        this.changing = false;
        this.calculate(Changed.TOTAL);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public SelectionMap getChangeableMap() {
        return this.changeableMap;
    }

    public List<Sector> getMinesList() {
        return this.minesList;
    }

    public List<Sector> getDocksList() {
        return this.docksList;
    }

    public int getArtilleryCount() {
        return (Integer)this.numArtillerySpinner.getValue();
    }

    public int getExplosivesCount() {
        return (Integer)this.numShellSpinner.getValue();
    }

    public int getPlanesCount() {
        return (Integer)this.numPlanesSpinner.getValue();
    }

    private void calculate(Changed changed) {
        if (this.changing) {
            return;
        }
        this.changing = true;
        switch (changed) {
            case TOTAL: {
                this.ruralCount = 0;
                this.dockCount = 0;
                this.mineCount = 0;
                this.artilleryCount = 0;
                this.explosivesCount = 0;
                this.planesCount = 0;
                this.oldDocks = 0;
                this.oldMines = 0;
                this.oldArtillery = 0;
                this.oldExplosives = 0;
                this.oldPlanes = 0;
                this.changeableMap = this.island.getSelectionMap();
                this.countChangeable();
                this.countOld();
                this.numToChangeNumberLabel.setText("" + this.ruralCount);
                this.mineSample = 0;
                this.initMines();
                this.initDocks();
                break;
            }
            case DOCKSRESTRICTION: {
                this.initDocks();
            }
            case MINES: {
                this.recalcMines();
                this.initDocks();
                this.initArtillery();
                this.initExplosives();
                this.initPlanes();
                break;
            }
            case DOCKS: {
                this.recalcDocks();
                this.initArtillery();
                this.initExplosives();
                this.initPlanes();
                break;
            }
            case ARTILLERY: {
                this.recalcArtillery();
                this.initExplosives();
                this.initPlanes();
                break;
            }
            case SHELLS: {
                this.recalcExplosives();
                this.initPlanes();
                break;
            }
            case PLANES: {
                this.recalcPlanes();
            }
        }
        this.existingMinesLabel.setText("" + this.oldMines);
        this.totalDocksField.setText("" + (this.oldDocks + this.dockCount));
        this.totalArtilleryField.setText("" + (this.oldArtillery + this.artilleryCount));
        this.totalExplosivesField.setText("" + (this.oldExplosives + this.explosivesCount));
        this.totalAircraftField.setText("" + (this.oldPlanes + this.planesCount));
        int newIndustries = this.dockCount + this.artilleryCount + this.explosivesCount + this.planesCount;
        int oldIndustries = this.oldDocks + this.oldArtillery + this.oldExplosives + this.oldPlanes;
        this.sumIndustriesLabel.setText("" + newIndustries);
        this.totalIndustriesField.setText("" + (newIndustries + oldIndustries));
        this.changing = false;
    }

    private void countChangeable() {
        for (Sector sector : this.sectors.values()) {
            if (sector.getDes() != Sector.Des.RURAL || sector.getOwner() != Globals.nationNum) continue;
            ++this.ruralCount;
            this.changeableMap.setSelection(sector.getLocation());
        }
    }

    private void countOld() {
        this.oldMines = 0;
        this.oldSample = 0;
        this.oldArtillery = 0;
        this.oldExplosives = 0;
        this.oldDocks = 0;
        this.oldPlanes = 0;
        for (Sector sector : this.sectors.values()) {
            if (this.changeableMap.isSelected(sector.getLocation()) || sector.getOwner() != Globals.nationNum) continue;
            boolean x = true;
            switch (sector.getDes()) {
                case MINE: {
                    ++this.oldMines;
                    this.oldSample += sector.getOreSample();
                    break;
                }
                case ARTILLERY: {
                    ++this.oldArtillery;
                    break;
                }
                case EXPLOSIVE: {
                    ++this.oldExplosives;
                    break;
                }
                case DOCK: {
                    ++this.oldDocks;
                    break;
                }
                case PLANE: {
                    ++this.oldPlanes;
                }
            }
        }
    }

    private void initMines() {
        this.sortedSampleSectors = new ArrayList<Sector>(this.sectors.values());
        ListIterator<Sector> it = this.sortedSampleSectors.listIterator();
        while (it.hasNext()) {
            Sector sector = it.next();
            if (this.changeableMap.isSelected(sector.getLocation())) continue;
            it.remove();
        }
        Collections.sort(this.sortedSampleSectors, new Comparator<Sector>(){

            @Override
            public int compare(Sector s1, Sector s2) {
                return s2.getOreSample() - s1.getOreSample();
            }
        });
        this.minesMap = this.island.getSelectionMap();
        this.mineCount = 0;
        for (Sector sector : this.sortedSampleSectors) {
            if (sector.getOreSample() <= 9 || !this.changeableMap.isSelected(sector.getLocation())) continue;
            ++this.mineCount;
            this.mineSample += sector.getOreSample();
            this.minesMap.setSelection(sector.getLocation());
        }
        this.numMinesSpinner.setValue(this.mineCount);
        this.numIndustriesLabel.setText("" + (this.mineSample + this.oldSample) / 10);
    }

    private void recalcMines() {
        this.mineCount = (Integer)this.numMinesSpinner.getValue();
        this.minesMap = this.island.getSelectionMap();
        this.minesList = new ArrayList<Sector>();
        this.mineSample = 0;
        for (int i = 0; i < this.mineCount; ++i) {
            this.mineSample += this.sortedSampleSectors.get(i).getOreSample();
            this.minesMap.setSelection(this.sortedSampleSectors.get(i).getLocation());
            this.minesList.add(this.sortedSampleSectors.get(i));
        }
        this.numIndustriesLabel.setText("" + (this.mineSample + this.oldSample) / 10);
    }

    private void initDocks() {
        this.docksMap = this.island.getSelectionMap();
        this.docksList = new ArrayList<Sector>();
        this.dockCount = 0;
        for (Sector sector : this.sectors.values()) {
            if (!this.changeableMap.isSelected(sector.getLocation())) continue;
            boolean dockable = false;
            if (this.minesMap.isSelected(sector.getLocation())) continue;
            for (IslandCoord adjacentCoord : sector.getAdjacencies()) {
                if (this.sectors.get(adjacentCoord).getDes() != Sector.Des.WATER && this.sectors.get(adjacentCoord).getDes() != Sector.Des.WATERWAY) continue;
                if (this.dockDistanceSpinner.isEnabled()) {
                    int distance = (Integer)this.dockDistanceSpinner.getValue();
                    if (sector.getLocation().x >= distance - 1 && sector.getLocation().y >= distance - 1 && sector.getLocation().x <= this.island.getSize().width - distance && sector.getLocation().y <= this.island.getSize().height - distance) continue;
                    dockable = true;
                    continue;
                }
                dockable = true;
            }
            if (!dockable) continue;
            ++this.dockCount;
            this.docksMap.setSelection(sector.getLocation());
            this.docksList.add(sector);
        }
        ((SpinnerNumberModel)this.getNumDocksSpinner().getModel()).setMaximum(Integer.valueOf(this.dockCount));
        this.numDocksSpinner.setValue(this.dockCount);
    }

    private void recalcDocks() {
        this.dockCount = (Integer)this.numDocksSpinner.getValue();
    }

    private void initArtillery() {
        this.artilleryCount = (this.ruralCount - this.mineCount - this.dockCount) / 10;
        this.numArtillerySpinner.setValue(this.artilleryCount);
    }

    private void recalcArtillery() {
        this.artilleryCount = (Integer)this.numArtillerySpinner.getValue();
    }

    private void initExplosives() {
        this.explosivesCount = (this.ruralCount - this.mineCount - this.dockCount - this.artilleryCount) / 2;
        this.numShellSpinner.setValue(this.explosivesCount);
    }

    private void recalcExplosives() {
        this.explosivesCount = (Integer)this.numShellSpinner.getValue();
    }

    private void initPlanes() {
        this.planesCount = this.ruralCount - this.mineCount - this.dockCount - this.artilleryCount - this.explosivesCount;
        this.numPlanesSpinner.setValue(this.planesCount);
    }

    private void recalcPlanes() {
    }

    private void initialize() {
        this.setSize(484, 344);
        this.setModal(true);
        this.setTitle("Island Stipulate");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setEnabled(true);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoDesignate.this.cancelled = false;
                    AutoDesignate.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoDesignate.this.cancelled = true;
                    AutoDesignate.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.totalIndustriesField = new JLabel();
            this.totalIndustriesField.setBounds(new Rectangle(285, 245, 31, 14));
            this.totalIndustriesField.setText("999");
            this.newIndustriesLabel = new JLabel();
            this.newIndustriesLabel.setBounds(new Rectangle(177, 245, 97, 14));
            this.newIndustriesLabel.setText("new industries");
            this.totalAircraftLabel = new JLabel();
            this.totalAircraftLabel.setBounds(new Rectangle(208, 211, 94, 14));
            this.totalAircraftLabel.setText("total aircraft");
            this.totalAircraftField = new JLabel();
            this.totalAircraftField.setBounds(new Rectangle(187, 211, 21, 14));
            this.totalAircraftField.setText("999");
            this.totalExplosivesLabel = new JLabel();
            this.totalExplosivesLabel.setBounds(new Rectangle(208, 184, 88, 14));
            this.totalExplosivesLabel.setText("total shell");
            this.totalExplosivesField = new JLabel();
            this.totalExplosivesField.setBounds(new Rectangle(187, 184, 21, 14));
            this.totalExplosivesField.setText("999");
            this.totalArtilleryLabel = new JLabel();
            this.totalArtilleryLabel.setBounds(new Rectangle(208, 158, 99, 14));
            this.totalArtilleryLabel.setText("total artillery");
            this.totalArtilleryField = new JLabel();
            this.totalArtilleryField.setBounds(new Rectangle(187, 158, 21, 14));
            this.totalArtilleryField.setText("999");
            this.totalDocksLabel = new JLabel();
            this.totalDocksLabel.setBounds(new Rectangle(208, 131, 76, 14));
            this.totalDocksLabel.setText("total docks");
            this.totalDocksField = new JLabel();
            this.totalDocksField.setBounds(new Rectangle(187, 131, 21, 14));
            this.totalDocksField.setText("999");
            this.existingMinesLabel = new JLabel();
            this.existingMinesLabel.setBounds(new Rectangle(187, 112, 21, 14));
            this.existingMinesLabel.setText("99");
            this.dockDistanceLabel = new JLabel();
            this.dockDistanceLabel.setBounds(new Rectangle(208, 72, 59, 14));
            this.dockDistanceLabel.setText("of edge");
            this.minesSupportLabel = new JLabel();
            this.minesSupportLabel.setBounds(new Rectangle(208, 112, 132, 14));
            this.minesSupportLabel.setText("existing mines will support");
            this.numPlanesLabel = new JLabel();
            this.numPlanesLabel.setBounds(new Rectangle(30, 211, 98, 14));
            this.numPlanesLabel.setHorizontalAlignment(4);
            this.numPlanesLabel.setText("Aircraft factories:");
            this.designatedLabel = new JLabel();
            this.designatedLabel.setBounds(new Rectangle(315, 245, 94, 14));
            this.designatedLabel.setText("total industries");
            this.sumIndustriesLabel = new JLabel();
            this.sumIndustriesLabel.setBounds(new Rectangle(139, 245, 31, 14));
            this.sumIndustriesLabel.setText("99");
            this.industriesLabel = new JLabel();
            this.industriesLabel.setBounds(new Rectangle(370, 112, 54, 14));
            this.industriesLabel.setText("industries");
            this.numIndustriesLabel = new JLabel();
            this.numIndustriesLabel.setBounds(new Rectangle(351, 112, 21, 14));
            this.numIndustriesLabel.setText("99");
            this.minesLabel = new JLabel();
            this.minesLabel.setBounds(new Rectangle(30, 112, 98, 14));
            this.minesLabel.setHorizontalAlignment(4);
            this.minesLabel.setText("Mines:");
            this.shellLabel = new JLabel();
            this.shellLabel.setBounds(new Rectangle(30, 184, 98, 14));
            this.shellLabel.setHorizontalAlignment(4);
            this.shellLabel.setText("Shell factories:");
            this.numArtilleryLabel = new JLabel();
            this.numArtilleryLabel.setBounds(new Rectangle(30, 158, 98, 14));
            this.numArtilleryLabel.setHorizontalAlignment(4);
            this.numArtilleryLabel.setText("Artillery Factories:");
            this.numDocksLabel = new JLabel();
            this.numDocksLabel.setBounds(new Rectangle(30, 131, 98, 14));
            this.numDocksLabel.setHorizontalAlignment(4);
            this.numDocksLabel.setText("Docks:");
            this.numToChangeLabel = new JLabel();
            this.numToChangeLabel.setBounds(new Rectangle(206, 24, 91, 14));
            this.numToChangeLabel.setText("Sectors to change");
            this.numToChangeNumberLabel = new JLabel();
            this.numToChangeNumberLabel.setBounds(new Rectangle(170, 24, 23, 14));
            this.numToChangeNumberLabel.setText("0");
            this.changeEffPercentLabel = new JLabel();
            this.changeEffPercentLabel.setBounds(new Rectangle(231, 47, 17, 14));
            this.changeEffPercentLabel.setText("%");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.add((Component)this.getRuralsOnlyRadioButton(), null);
            this.mainPanel.add((Component)this.getChangeEffRadioButton(), null);
            this.mainPanel.add((Component)this.changeEffPercentLabel, null);
            this.mainPanel.add((Component)this.numToChangeNumberLabel, null);
            this.mainPanel.add((Component)this.numToChangeLabel, null);
            this.mainPanel.add((Component)this.getChangeEffSpinner(), null);
            this.mainPanel.add((Component)this.numDocksLabel, null);
            this.mainPanel.add((Component)this.getNumDocksSpinner(), null);
            this.mainPanel.add((Component)this.numArtilleryLabel, null);
            this.mainPanel.add((Component)this.getNumArtillerySpinner(), null);
            this.mainPanel.add((Component)this.shellLabel, null);
            this.mainPanel.add((Component)this.getNumShellSpinner(), null);
            this.mainPanel.add((Component)this.getNumMinesSpinner(), null);
            this.mainPanel.add((Component)this.minesLabel, null);
            this.mainPanel.add((Component)this.numIndustriesLabel, null);
            this.mainPanel.add((Component)this.industriesLabel, null);
            this.mainPanel.add((Component)this.sumIndustriesLabel, null);
            this.mainPanel.add((Component)this.designatedLabel, null);
            this.mainPanel.add((Component)this.numPlanesLabel, null);
            this.mainPanel.add((Component)this.getNumPlanesSpinner(), null);
            this.mainPanel.add((Component)this.minesSupportLabel, null);
            this.mainPanel.add((Component)this.getDockCountDistanceRadioButton(), null);
            this.mainPanel.add((Component)this.getDockDistanceSpinner(), null);
            this.mainPanel.add((Component)this.dockDistanceLabel, null);
            this.mainPanel.add((Component)this.existingMinesLabel, null);
            this.mainPanel.add((Component)this.totalDocksField, null);
            this.mainPanel.add((Component)this.totalDocksLabel, null);
            this.mainPanel.add((Component)this.totalArtilleryField, null);
            this.mainPanel.add((Component)this.totalArtilleryLabel, null);
            this.mainPanel.add((Component)this.totalExplosivesField, null);
            this.mainPanel.add((Component)this.totalExplosivesLabel, null);
            this.mainPanel.add((Component)this.totalAircraftField, null);
            this.mainPanel.add((Component)this.totalAircraftLabel, null);
            this.mainPanel.add((Component)this.newIndustriesLabel, null);
            this.mainPanel.add((Component)this.totalIndustriesField, null);
        }
        return this.mainPanel;
    }

    private JRadioButton getRuralsOnlyRadioButton() {
        if (this.ruralsOnlyRadioButton == null) {
            this.ruralsOnlyRadioButton = new JRadioButton();
            this.ruralsOnlyRadioButton.setBounds(new Rectangle(21, 21, 134, 21));
            this.ruralsOnlyRadioButton.setSelected(true);
            this.ruralsOnlyRadioButton.setText("Only change Rurals");
        }
        return this.ruralsOnlyRadioButton;
    }

    private JRadioButton getChangeEffRadioButton() {
        if (this.changeEffRadioButton == null) {
            this.changeEffRadioButton = new JRadioButton();
            this.changeEffRadioButton.setBounds(new Rectangle(21, 44, 174, 21));
            this.changeEffRadioButton.setText("Change any with eff less than:");
        }
        return this.changeEffRadioButton;
    }

    private ButtonGroup getChangeButtonGroup() {
        if (this.changeButtonGroup == null) {
            this.changeButtonGroup = new ButtonGroup();
            this.changeButtonGroup.add(this.getChangeEffRadioButton());
            this.changeButtonGroup.add(this.getRuralsOnlyRadioButton());
        }
        return this.changeButtonGroup;
    }

    private JSpinner getChangeEffSpinner() {
        if (this.changeEffSpinner == null) {
            this.changeEffSpinner = new JSpinner();
            this.changeEffSpinner.setBounds(new Rectangle(191, 45, 38, 18));
            this.changeEffSpinner.setEnabled(false);
        }
        return this.changeEffSpinner;
    }

    private JSpinner getNumDocksSpinner() {
        if (this.numDocksSpinner == null) {
            SpinnerNumberModel snm = new SpinnerNumberModel(10, 1, 999, 1);
            ChangeListener listener = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    AutoDesignate.this.calculate(Changed.DOCKS);
                }
            };
            this.numDocksSpinner = new JSpinner(snm);
            this.numDocksSpinner.setBounds(new Rectangle(134, 129, 38, 18));
            this.numDocksSpinner.addChangeListener(listener);
        }
        return this.numDocksSpinner;
    }

    private JSpinner getNumArtillerySpinner() {
        if (this.numArtillerySpinner == null) {
            SpinnerNumberModel snm = new SpinnerNumberModel(10, 1, 999, 1);
            ChangeListener listener = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    AutoDesignate.this.calculate(Changed.ARTILLERY);
                }
            };
            this.numArtillerySpinner = new JSpinner();
            this.numArtillerySpinner.setBounds(new Rectangle(134, 156, 38, 18));
            this.numArtillerySpinner.addChangeListener(listener);
        }
        return this.numArtillerySpinner;
    }

    private JSpinner getNumShellSpinner() {
        if (this.numShellSpinner == null) {
            SpinnerNumberModel snm = new SpinnerNumberModel(10, 1, 999, 1);
            ChangeListener listener = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    AutoDesignate.this.calculate(Changed.SHELLS);
                }
            };
            this.numShellSpinner = new JSpinner();
            this.numShellSpinner.setBounds(new Rectangle(134, 182, 38, 18));
            this.numShellSpinner.addChangeListener(listener);
        }
        return this.numShellSpinner;
    }

    private JSpinner getNumMinesSpinner() {
        if (this.numMinesSpinner == null) {
            SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, 999, 1);
            ChangeListener listener = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    AutoDesignate.this.calculate(Changed.MINES);
                }
            };
            this.numMinesSpinner = new JSpinner(snm);
            this.numMinesSpinner.setBounds(new Rectangle(134, 110, 38, 18));
            this.numMinesSpinner.getModel().addChangeListener(listener);
        }
        return this.numMinesSpinner;
    }

    private JSpinner getNumPlanesSpinner() {
        if (this.numPlanesSpinner == null) {
            this.numPlanesSpinner = new JSpinner();
            this.numPlanesSpinner.setBounds(new Rectangle(134, 209, 38, 18));
            this.numPlanesSpinner.setEnabled(false);
        }
        return this.numPlanesSpinner;
    }

    private JRadioButton getDockCountDistanceRadioButton() {
        if (this.dockCountDistanceRadioButton == null) {
            this.dockCountDistanceRadioButton = new JRadioButton();
            this.dockCountDistanceRadioButton.setBounds(new Rectangle(23, 69, 148, 21));
            this.dockCountDistanceRadioButton.setText("Only count docks within");
            this.dockCountDistanceRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (AutoDesignate.this.dockCountDistanceRadioButton.isSelected()) {
                        AutoDesignate.this.dockDistanceSpinner.setEnabled(true);
                    } else {
                        AutoDesignate.this.dockDistanceSpinner.setEnabled(false);
                    }
                    AutoDesignate.this.calculate(Changed.DOCKSRESTRICTION);
                }
            });
        }
        return this.dockCountDistanceRadioButton;
    }

    private JSpinner getDockDistanceSpinner() {
        if (this.dockDistanceSpinner == null) {
            SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, 999, 1);
            ChangeListener listener = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    AutoDesignate.this.calculate(Changed.DOCKSRESTRICTION);
                }
            };
            this.dockDistanceSpinner = new JSpinner(snm);
            this.dockDistanceSpinner.setBounds(new Rectangle(171, 70, 34, 18));
            this.dockDistanceSpinner.setEnabled(false);
            this.dockDistanceSpinner.getModel().addChangeListener(listener);
            this.dockDistanceSpinner.setValue(Math.max(this.island.getSize().height / 2, this.island.getSize().width / 2));
        }
        return this.dockDistanceSpinner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Changed {
        TOTAL,
        MINES,
        DOCKS,
        DOCKSRESTRICTION,
        ARTILLERY,
        SHELLS,
        PLANES;

    }
}

