/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.models;

import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.WorldCoord;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShipsModel
extends AbstractTableModel {
    private RemoteEmpire empire = null;
    Map<Integer, MyShip> ships = new HashMap<Integer, MyShip>();
    DefaultListModel listModel = new DefaultListModel();

    public ShipsModel(RemoteEmpire empire) {
        this.empire = empire;
    }

    public Map<Integer, MyShip> getShipList() {
        assert (this.empire != null);
        this.ships = this.empire.getShipList();
        this.fireTableDataChanged();
        return this.ships;
    }

    public MyShip getShip(int shipNum) {
        assert (this.empire != null);
        MyShip ship = this.empire.getShip(shipNum);
        this.ships.put(shipNum, ship);
        this.fireTableRowsUpdated(this.getIndex(shipNum), this.getIndex(shipNum));
        return ship;
    }

    public int getIndex(int shipNum) {
        int index = 0;
        for (MyShip ship : this.ships.values()) {
            if (ship.getShipNum() == shipNum) break;
            ++index;
        }
        return index;
    }

    @Override
    public int getRowCount() {
        if (this.empire == null) {
            return 0;
        }
        return this.ships.size();
    }

    @Override
    public int getColumnCount() {
        return 13;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        System.out.println("ships getting value at " + rowIndex + "; " + columnIndex);
        ArrayList<MyShip> shipList = new ArrayList<MyShip>(this.ships.values());
        MyShip ship = (MyShip)shipList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ship.getShipNum();
            }
            case 1: {
                return ship.getFleet();
            }
            case 2: {
                return ship.getType().getName();
            }
            case 3: {
                return ship.getLoc();
            }
            case 4: {
                return ship.getCivilians();
            }
            case 5: {
                return ship.getMilitary();
            }
            case 6: {
                return ship.getArtillery();
            }
            case 7: {
                return ship.getShells();
            }
            case 8: {
                return ship.getFighters();
            }
            case 9: {
                return String.format("%6.1f", ship.getOre());
            }
            case 10: {
                return ship.getEff();
            }
            case 11: {
                return String.format("%3.1f", ship.getTime());
            }
            case 12: {
                if (!ship.getDest().equals((Object)new Point(-1, -1))) {
                    return ship.getDest();
                }
                if (ship.isDocked()) {
                    return "[Docked]";
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 2 || columnIndex == 12) {
            return String.class;
        }
        if (columnIndex == 3) {
            return WorldCoord.class;
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Num";
            }
            case 1: {
                return "Fl";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Loc";
            }
            case 4: {
                return "Civ";
            }
            case 5: {
                return "Mil";
            }
            case 6: {
                return "Art";
            }
            case 7: {
                return "Shl";
            }
            case 8: {
                return "Ftrs";
            }
            case 9: {
                return "Fuel";
            }
            case 10: {
                return "Eff";
            }
            case 11: {
                return "Time";
            }
            case 12: {
                return "Destination";
            }
        }
        return "";
    }
}

