/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class ProgressWindow
extends JDialog {
    public JProgressBar bar;
    private String title;
    private int max;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ProgressWindow(String title, int max) {
        this.init(title, max);
    }

    private void init(String title, int max) {
        this.setTitle(title);
        this.title = title;
        this.max = max;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(true);
        this.pack();
    }

    public ProgressWindow(Frame parent, String title, int max) {
        super(parent);
        this.init(title, max);
    }

    public void setValue(int progressValue) {
        this.bar.setValue(progressValue);
        this.setVisible(true);
    }

    public void updateStatus(String status) {
        this.updateStatus(status, 1);
        if (status == "") {
            this.dispose();
        }
    }

    public void updateStatus(String status, int increment) {
        this.bar.setString(status);
        this.bar.setValue(this.bar.getValue() + increment);
        this.bar.repaint();
    }

    public void updateStatus(String status, int min, int max) {
        if (status == "") {
            this.dispose();
        } else {
            if (max == 0) {
                this.bar.setIndeterminate(true);
            } else {
                this.bar.setIndeterminate(false);
                this.bar.setMinimum(min);
                this.bar.setMaximum(max);
            }
            this.bar.setString(status);
            this.bar.setValue(0);
            this.bar.repaint();
        }
    }

    public ProgressWindow() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.bar = new JProgressBar(0, this.max);
        this.bar.setStringPainted(true);
        this.bar.setString(this.title);
        this.bar.setBackground(Color.gray);
        this.bar.setForeground(Color.black);
        this.bar.setMinimumSize(new Dimension(200, 25));
        this.setSize(new Dimension(220, 57));
        this.setLocation((screenDim.width - 250) / 2, (screenDim.height - 22) / 2);
        this.getContentPane().add((Component)this.bar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(13, 19, 13, 19), 34, 10));
    }
}

