/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.utils;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class UiUtil {
    public static void centerAndShow(Window aWindow) {
        aWindow.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = aWindow.getSize();
        if (window.height > screen.height) {
            window.height = screen.height;
        }
        if (window.width > screen.width) {
            window.width = screen.width;
        }
        int xCoord = screen.width / 2 - window.width / 2;
        int yCoord = screen.height / 2 - window.height / 2;
        aWindow.setLocation(xCoord, yCoord);
        aWindow.setVisible(true);
    }

    public static void centerOnParentAndShow(Window aWindow) {
        int yOffScreenExcess;
        aWindow.pack();
        Dimension parent = aWindow.getParent().getSize();
        Dimension window = aWindow.getSize();
        int xCoord = aWindow.getParent().getLocationOnScreen().x + (parent.width / 2 - window.width / 2);
        int yCoord = aWindow.getParent().getLocationOnScreen().y + (parent.height / 2 - window.height / 2);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int xOffScreenExcess = xCoord + window.width - screen.width;
        if (xOffScreenExcess > 0) {
            xCoord -= xOffScreenExcess;
        }
        if (xCoord < 0) {
            xCoord = 0;
        }
        if ((yOffScreenExcess = yCoord + window.height - screen.height) > 0) {
            yCoord -= yOffScreenExcess;
        }
        if (yCoord < 0) {
            yCoord = 0;
        }
        aWindow.setLocation(xCoord, yCoord);
        aWindow.setVisible(true);
    }

    public static void popupError(Frame frame, Throwable except, String message) {
        except.printStackTrace();
        StringBuffer stackTrace = new StringBuffer();
        stackTrace.append(except.getMessage());
        for (StackTraceElement s : except.getStackTrace()) {
            if (s.toString().length() != 0) {
                stackTrace.append(s.toString() + "\n");
            }
            System.out.println(s.toString());
        }
        JTextArea textArea = new JTextArea(stackTrace.toString(), 10, 80);
        textArea.setEditable(false);
        JScrollPane textScroller = new JScrollPane(textArea);
        Object[] messages = new Object[]{message, textScroller};
        JOptionPane.showMessageDialog(frame, messages, "Error", 0);
    }
}

