/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.islandmenu;

import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.ShipType;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.jec.utils.GTableModel;
import com.empireclassic.jec.utils.IntegerDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class IslandFleetCreate
extends JDialog {
    JPanel islandFleetCreatePanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel topPanel = new JPanel();
    JPanel tablePanel = new JPanel();
    JScrollPane tableScrollPane = new JScrollPane();
    Object[] rowData;
    JTable fleetBuildTable;
    private boolean cancelled = false;
    String[] ships;
    private boolean changingSelf = false;
    IslandInfo island;
    int fleetNum;
    boolean gatherOre;
    boolean gatherGuns;
    boolean gatherShells;
    boolean gatherMilitary;
    Vector<BuildTableEntry> buildList = new Vector();
    FleetTableModel model;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JTextField fleetNumField = new JTextField();
    JLabel fleetNumLabel = new JLabel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JCheckBox militaryGatherCheckBox = new JCheckBox();
    JCheckBox shellGatherCheckBox = new JCheckBox();
    JCheckBox gunGatherCheckBox = new JCheckBox();
    JCheckBox oreGatherCheckBox = new JCheckBox();
    JLabel autoGatherLabel = new JLabel();

    public IslandFleetCreate(Frame frame, IslandInfo island, int fleetNum) {
        super(frame, "Build Fleet", true);
        this.island = island;
        this.fleetNum = fleetNum;
        try {
            this.jbInit();
            this.pack();
            this.fleetNumField.setText(new Integer(fleetNum).toString());
            this.getRootPane().setDefaultButton(this.okButton);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    private void updateCanBuild(int row, int totalProd) {
        TableColumn shipTypeColumn = this.fleetBuildTable.getColumnModel().getColumn(row);
        JComboBox shipBox = (JComboBox)((Object)shipTypeColumn.getCellEditor());
    }

    private void jbInit() throws Exception {
        this.islandFleetCreatePanel.setLayout(this.borderLayout1);
        this.topPanel.setLayout(this.flowLayout1);
        this.tablePanel.setLayout(this.borderLayout2);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IslandFleetCreate.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IslandFleetCreate.this.okButton_actionPerformed(e);
            }
        });
        this.fleetNumLabel.setText("Fleet: ");
        this.fleetNumField.setDocument(new IntegerDocument());
        this.fleetNumField.setText("9999");
        this.jPanel1.setLayout(this.borderLayout3);
        this.militaryGatherCheckBox.setText("Military");
        this.shellGatherCheckBox.setText("Shells");
        this.gunGatherCheckBox.setText("Guns");
        this.oreGatherCheckBox.setText("Ore");
        this.oreGatherCheckBox.setSelected(true);
        this.autoGatherLabel.setText("Auto Gather:");
        this.jPanel2.add((Component)this.autoGatherLabel, null);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.oreGatherCheckBox, null);
        this.jPanel2.add((Component)this.gunGatherCheckBox, null);
        this.jPanel2.add((Component)this.shellGatherCheckBox, null);
        this.jPanel2.add((Component)this.militaryGatherCheckBox, null);
        this.getContentPane().add(this.islandFleetCreatePanel);
        this.model = new FleetTableModel();
        this.rowData = new Object[8];
        this.fleetBuildTable = new JTable(this.model);
        this.fleetBuildTable.setPreferredSize(new Dimension(468, 403));
        this.model.addColumn("Sector");
        this.model.addColumn("Production");
        this.model.addColumn("Artillery");
        this.model.addColumn("Shells");
        this.model.addColumn("Ore");
        this.model.addColumn("Ship 1");
        this.model.addColumn("Ship 2");
        this.model.addColumn("Ship 3");
        RemoteEmpire empire = RemoteEmpire.getInstance();
        this.ships = new String[empire.getShipTypeList().size() + 1];
        this.ships[0] = "";
        int shipTypeIndex = 0;
        for (ShipType type : empire.getShipTypeList()) {
            this.ships[shipTypeIndex++] = type.getName();
        }
        JComboBox<String> shipBox = new JComboBox<String>(this.ships);
        for (int i = 5; i < 8; ++i) {
            TableColumn shipTypeColumn = this.fleetBuildTable.getColumnModel().getColumn(i);
            shipBox.setActionCommand("column " + i);
            shipTypeColumn.setCellEditor(new DefaultCellEditor(shipBox));
        }
        this.buildTable();
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent event) {
                IslandFleetCreate.this.tableChangedEvent(event);
            }
        });
        this.model.addMouseListenerToHeaderInTable(this.fleetBuildTable);
        this.islandFleetCreatePanel.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.fleetNumLabel, null);
        this.topPanel.add((Component)this.fleetNumField, null);
        this.islandFleetCreatePanel.add((Component)this.tablePanel, "Center");
        this.tablePanel.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.getViewport().add((Component)this.fleetBuildTable, null);
        this.islandFleetCreatePanel.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
    }

    private void buildTable() {
        this.model.setNumRows(0);
        for (Sector sector : this.island.getSectors().values()) {
            if (sector.getDes() != Sector.Des.DOCK || sector.getProduction() <= 49) continue;
            this.rowData[0] = this.formatSector((int)sector.getLocation().getX(), (int)sector.getLocation().getY());
            this.rowData[1] = new Integer(sector.getProduction());
            this.rowData[2] = new Integer(sector.getGuns());
            this.rowData[3] = new Integer(sector.getShells());
            this.rowData[4] = new Integer(sector.getOre());
            this.rowData[5] = new String("");
            this.rowData[6] = new String("");
            this.rowData[7] = new String("");
            this.model.addRow(this.rowData);
        }
    }

    public Vector getBuildList() {
        return this.buildList;
    }

    public int getFleetNum() {
        return this.fleetNum;
    }

    public boolean getGatherOre() {
        return this.gatherOre;
    }

    public boolean getGatherGuns() {
        return this.gatherGuns;
    }

    public boolean getGatherShells() {
        return this.gatherShells;
    }

    public boolean getGatherMilitary() {
        return this.gatherMilitary;
    }

    void okButton_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int j = 5; j < 8; ++j) {
                if (((String)this.model.getValueAt(i, j)).trim().equals("")) continue;
                this.buildList.add(new BuildTableEntry((String)this.model.getValueAt(i, 0), (String)this.model.getValueAt(i, j)));
            }
        }
        this.fleetNum = new Integer(this.fleetNumField.getText());
        this.gatherOre = this.oreGatherCheckBox.isSelected();
        this.gatherGuns = this.gunGatherCheckBox.isSelected();
        this.gatherShells = this.shellGatherCheckBox.isSelected();
        this.gatherMilitary = this.militaryGatherCheckBox.isSelected();
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.cancelled = true;
        this.dispose();
    }

    private String formatSector(int x, int y) {
        String formatted = "";
        if (x < 10) {
            formatted = " ";
        }
        formatted = formatted + new Integer(x).toString() + ",";
        if (y < 10) {
            formatted = formatted + " ";
        }
        formatted = formatted + new Integer(y).toString();
        return formatted;
    }

    private void tableChangedEvent(TableModelEvent event) {
        if (this.changingSelf) {
            return;
        }
        this.changingSelf = true;
        String quad = (String)this.model.getValueAt(event.getFirstRow(), 0);
        StringTokenizer stQuad = new StringTokenizer(quad, ",");
        int x = new Integer(stQuad.nextToken().trim());
        int y = new Integer(stQuad.nextToken().trim());
        RemoteEmpire empire = RemoteEmpire.getInstance();
        Sector sector = this.island.getSectors().get(new WorldCoord(x, y));
        int prodRequired = 0;
        int gunsRequired = 0;
        int shellsRequired = 0;
        int oreRequired = 0;
        for (int i = 5; i < 8; ++i) {
            String shipType1 = (String)this.model.getValueAt(event.getFirstRow(), i);
            if (i == 5 || shipType1.trim().length() != 0) {
                // empty if block
            }
            for (ShipType type : empire.getShipTypeList()) {
                if (!shipType1.equals(type.getName())) continue;
                if (type.getCost() + prodRequired > sector.getProduction()) {
                    JOptionPane.showMessageDialog(null, "You don't have enough production to build that.", "Error", 0);
                    this.model.setValueAt("", event.getFirstRow(), i);
                    continue;
                }
                prodRequired += type.getCost();
                gunsRequired += type.getArtillery();
                shellsRequired += type.getExplosives();
                oreRequired = (int)((double)oreRequired + type.getFuel());
            }
        }
        Integer newProd = new Integer(sector.getProduction() - prodRequired);
        this.model.setValueAt(newProd, event.getFirstRow(), 1);
        Integer newGuns = new Integer(sector.getGuns() - gunsRequired);
        this.model.setValueAt(newGuns, event.getFirstRow(), 2);
        Integer newShells = new Integer(sector.getShells() - shellsRequired);
        this.model.setValueAt(newShells, event.getFirstRow(), 3);
        Integer newOre = new Integer(sector.getOre() - oreRequired);
        this.model.setValueAt(newOre, event.getFirstRow(), 4);
        this.changingSelf = false;
    }

    public class SelectShipRenderer
    extends JComboBox
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public class FleetTableModel
    extends GTableModel {
        public Class getColumnClass(int col) {
            Vector v = (Vector)this.dataVector.elementAt(0);
            return v.elementAt(col).getClass();
        }

        public boolean isCellEditable(int row, int column) {
            return column > 4;
        }
    }

    public class BuildTableEntry {
        public String quad;
        public String shipType;

        public BuildTableEntry(String quad, String shipType) {
            this.quad = quad;
            this.shipType = shipType;
        }
    }
}

