/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.reports;

import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.Sector;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.reports.JECReport;
import java.awt.Frame;

public class EmpireReport
extends JECReport {
    String[] columnNames = new String[]{"Number", "Sectors", "Civilians", "Military", "Land", "Power", "Time", "Name"};

    public EmpireReport(Frame frame) {
        super(frame, "Islands Report");
        this.setColumns(this.columnNames);
        try {
            for (IslandInfo island : this.empire.getIslandList().values()) {
                int occuppiedSects = 0;
                int totalCiv = 0;
                int totalMil = 0;
                int unoccuppiedSects = 0;
                this.rowData[0] = new Integer(island.getNumber());
                if (island.isOccuppied()) {
                    for (Sector sector : island.getSectors().values()) {
                        if (sector.getTerrain() == Sector.Des.RURAL && sector.getOwner() == 0) {
                            ++unoccuppiedSects;
                        }
                        if (sector.getOwner() != Globals.nationNum) continue;
                        ++occuppiedSects;
                        totalCiv += sector.getCivilians();
                        totalMil += sector.getMilitary();
                    }
                    if (occuppiedSects != 0) {
                        this.rowData[1] = new Integer(occuppiedSects);
                        this.rowData[2] = new Integer(totalCiv);
                        this.rowData[3] = new Integer(totalMil);
                        this.rowData[4] = new Integer(unoccuppiedSects);
                        this.rowData[5] = new Integer(0);
                        this.rowData[6] = new String(this.rightJust(new Integer(island.getCapitol(Globals.nationNum).getTimeLeft()).toString(), 2) + "/" + this.rightJust(new Integer(island.getCapitol(Globals.nationNum).getTimeRight()).toString(), 3));
                    }
                }
                if (occuppiedSects == 0) {
                    this.rowData[1] = "";
                    this.rowData[2] = "";
                    this.rowData[3] = "";
                    this.rowData[4] = "";
                    this.rowData[5] = "";
                    this.rowData[6] = "";
                }
                this.rowData[7] = island.getName();
                this.model.addRow(this.rowData);
            }
            this.setPreferredWidths();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

