/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class PStyledTextEventHandler
extends PBasicInputEventHandler {
    protected PCanvas canvas;
    protected JTextComponent editor;
    protected DocumentListener docListener;
    protected PStyledText editedText;

    public PStyledTextEventHandler(PCanvas pCanvas) {
        this.canvas = pCanvas;
        this.initEditor(this.createDefaultEditor());
    }

    public PStyledTextEventHandler(PCanvas pCanvas, JTextComponent jTextComponent) {
        this.canvas = pCanvas;
        this.initEditor(jTextComponent);
    }

    protected void initEditor(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        this.canvas.setLayout(null);
        this.canvas.add((Component)this.editor);
        this.editor.setVisible(false);
        this.docListener = this.createDocumentListener();
    }

    protected JTextComponent createDefaultEditor() {
        JTextPane jTextPane = new JTextPane(){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                super.paint(graphics);
            }

            public void scrollRectToVisible() {
            }
        };
        jTextPane.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(3, 3, 3, 3)));
        return jTextPane;
    }

    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }
        };
    }

    public PStyledText createText() {
        PStyledText pStyledText = new PStyledText();
        Document document = this.editor.getUI().getEditorKit(this.editor).createDefaultDocument();
        if (!(!(document instanceof StyledDocument) || document.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontFamily) && document.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontSize))) {
            Font font = this.editor.getFont();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
            simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
            ((StyledDocument)document).setParagraphAttributes(0, document.getLength(), simpleAttributeSet, false);
        }
        pStyledText.setDocument(document);
        return pStyledText;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        PNode pNode = pInputEvent.getPickedNode();
        this.stopEditing();
        if (pNode instanceof PStyledText) {
            this.startEditing(pInputEvent, (PStyledText)pNode);
        } else if (pNode instanceof PCamera) {
            PStyledText pStyledText = this.createText();
            Insets insets = pStyledText.getInsets();
            this.canvas.getLayer().addChild((PNode)pStyledText);
            pStyledText.translate(pInputEvent.getPosition().getX() - (double)insets.left, pInputEvent.getPosition().getY() - (double)insets.top);
            this.startEditing(pInputEvent, pStyledText);
        }
    }

    public void startEditing(PInputEvent pInputEvent, PStyledText pStyledText) {
        Insets insets = pStyledText.getInsets();
        Point2D.Double double_ = new Point2D.Double(pStyledText.getX() + (double)insets.left, pStyledText.getY() + (double)insets.top);
        pStyledText.localToGlobal(double_);
        pInputEvent.getTopCamera().viewToLocal((Point2D)double_);
        this.editor.setDocument(pStyledText.getDocument());
        this.editor.setVisible(true);
        Insets insets2 = this.editor.getBorder().getBorderInsets(this.editor);
        this.editor.setLocation((int)((Point2D)double_).getX() - insets2.left, (int)((Point2D)double_).getY() - insets2.top);
        this.reshapeEditorLater();
        this.dispatchEventToEditor(pInputEvent);
        this.canvas.repaint();
        pStyledText.setEditing(true);
        pStyledText.getDocument().addDocumentListener(this.docListener);
        this.editedText = pStyledText;
    }

    public void stopEditing() {
        if (this.editedText != null) {
            this.editedText.getDocument().removeDocumentListener(this.docListener);
            this.editedText.setEditing(false);
            if (this.editedText.getDocument().getLength() == 0) {
                this.editedText.removeFromParent();
            } else {
                this.editedText.syncWithDocument();
            }
            this.editor.setVisible(false);
            this.canvas.repaint();
            this.editedText = null;
        }
    }

    public void dispatchEventToEditor(final PInputEvent pInputEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MouseEvent mouseEvent = new MouseEvent(3.access$000(this.this$1).editor, 501, 3.access$100(this.this$1).getWhen(), 3.access$100(this.this$1).getModifiers() | 0x10, (int)(3.access$100(this.this$1).getCanvasPosition().getX() - (double)3.access$000(this.this$1).editor.getX()), (int)(3.access$100(this.this$1).getCanvasPosition().getY() - (double)3.access$000(this.this$1).editor.getY()), 1, false);
                        3.access$000(this.this$1).editor.dispatchEvent(mouseEvent);
                    }
                });
            }

            static /* synthetic */ PStyledTextEventHandler access$000(3 var0) {
                return var0.PStyledTextEventHandler.this;
            }

            static /* synthetic */ PInputEvent access$100(3 var0) {
                return var0.pInputEvent;
            }
        });
    }

    public void reshapeEditor() {
        if (this.editedText != null) {
            Dimension dimension = this.editor.getPreferredSize();
            Insets insets = this.editedText.getInsets();
            Insets insets2 = this.editor.getInsets();
            int n = this.editedText.getConstrainWidthToTextWidth() ? (int)dimension.getWidth() : (int)(this.editedText.getWidth() - (double)insets.left - (double)insets.right + (double)insets2.left + (double)insets2.right + 3.0);
            dimension.setSize((double)n, dimension.getHeight());
            this.editor.setSize(dimension);
            dimension = this.editor.getPreferredSize();
            int n2 = this.editedText.getConstrainHeightToTextHeight() ? (int)dimension.getHeight() : (int)(this.editedText.getHeight() - (double)insets.top - (double)insets.bottom + (double)insets2.top + (double)insets2.bottom + 3.0);
            dimension.setSize(n, n2);
            this.editor.setSize(dimension);
        }
    }

    protected void reshapeEditorLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PStyledTextEventHandler.this.reshapeEditor();
            }
        });
    }
}

