/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PCacheCamera
extends PCamera {
    private BufferedImage paintBuffer;
    private boolean imageAnimate;
    private PBounds imageAnimateBounds;

    protected BufferedImage getPaintBuffer() {
        PBounds pBounds = this.getFullBoundsReference();
        if (this.paintBuffer == null || (double)this.paintBuffer.getWidth() < pBounds.getWidth() || (double)this.paintBuffer.getHeight() < pBounds.getHeight()) {
            this.paintBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage((int)Math.ceil(pBounds.getWidth()), (int)Math.ceil(pBounds.getHeight()));
        }
        return this.paintBuffer;
    }

    private AffineTransform cacheViewBounds(Rectangle2D rectangle2D, boolean bl) {
        PBounds pBounds = this.getViewBounds();
        PBounds pBounds2 = new PBounds(pBounds);
        pBounds2.add(rectangle2D);
        this.animateViewToCenterBounds((Rectangle2D)pBounds2, bl, 0L);
        this.imageAnimateBounds = this.getViewBounds();
        BufferedImage bufferedImage = this.getPaintBuffer();
        Paint paint = Color.white;
        if (this.getPaint() != null) {
            paint = this.getPaint();
        }
        this.toImage(bufferedImage, paint);
        this.imageAnimate = true;
        this.animateViewToCenterBounds((Rectangle2D)pBounds, bl, 0L);
        PDimension pDimension = pBounds.deltaRequiredToCenter(rectangle2D);
        PAffineTransform pAffineTransform = this.getViewTransform();
        pAffineTransform.translate(pDimension.width, pDimension.height);
        if (bl) {
            double d = Math.min(pBounds.getWidth() / rectangle2D.getWidth(), pBounds.getHeight() / rectangle2D.getHeight());
            pAffineTransform.scaleAboutPoint(d, rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        return pAffineTransform;
    }

    private void clearViewCache() {
        this.imageAnimate = false;
        this.imageAnimateBounds = null;
    }

    public PTransformActivity animateStaticViewToCenterBoundsFast(Rectangle2D rectangle2D, boolean bl, long l) {
        if (l == 0L) {
            return this.animateViewToCenterBounds(rectangle2D, bl, l);
        }
        AffineTransform affineTransform = this.cacheViewBounds(rectangle2D, bl);
        return this.animateStaticViewToTransformFast(affineTransform, l);
    }

    protected PTransformActivity animateStaticViewToTransformFast(AffineTransform affineTransform, long l) {
        if (l == 0L) {
            this.setViewTransform(affineTransform);
            return null;
        }
        PTransformActivity.Target target = new PTransformActivity.Target(){

            public void setTransform(AffineTransform affineTransform) {
                PCacheCamera.this.setViewTransform(affineTransform);
            }

            public void getSourceMatrix(double[] dArray) {
                PCacheCamera.this.getViewTransformReference().getMatrix(dArray);
            }
        };
        PTransformActivity pTransformActivity = new PTransformActivity(l, PUtil.DEFAULT_ACTIVITY_STEP_RATE, target, affineTransform){

            protected void activityFinished() {
                PCacheCamera.this.clearViewCache();
                PCacheCamera.this.repaint();
                super.activityFinished();
            }
        };
        PRoot pRoot = this.getRoot();
        if (pRoot != null) {
            pRoot.getActivityScheduler().addActivity((PActivity)pTransformActivity);
        }
        return pTransformActivity;
    }

    public void fullPaint(PPaintContext pPaintContext) {
        if (this.imageAnimate) {
            PBounds pBounds = this.getFullBoundsReference();
            PBounds pBounds2 = this.getViewBounds();
            double d = this.getFullBoundsReference().getWidth() / this.imageAnimateBounds.getWidth();
            double d2 = (pBounds2.getX() - this.imageAnimateBounds.getX()) * d;
            double d3 = (pBounds2.getY() - this.imageAnimateBounds.getY()) * d;
            double d4 = pBounds2.getWidth() * d;
            double d5 = pBounds2.getHeight() * d;
            pPaintContext.getGraphics().drawImage(this.paintBuffer, 0, 0, (int)Math.ceil(pBounds.getWidth()), (int)Math.ceil(pBounds.getHeight()), (int)Math.floor(d2), (int)Math.floor(d3), (int)Math.ceil(d2 + d4), (int)Math.ceil(d3 + d5), null);
        } else {
            super.fullPaint(pPaintContext);
        }
    }
}

