/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.NationInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.Ship;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.Remote.YourShip;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.maputils.CircleNode;
import com.empireclassic.jec.maputils.IslandNode;
import com.empireclassic.jec.maputils.SectorNode;
import com.empireclassic.jec.models.ShipsCanvasModel;
import com.empireclassic.jec.models.ShipsModel;
import com.empireclassic.jec.utils.FixedSizeLabel;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MapCanvas
extends PCanvas
implements TableModelListener {
    public static final Color WATERCOLOR = new Color(155, 205, 255);
    private boolean showShipsRadar = false;
    private DefaultListModel shipListModel = new DefaultListModel();
    private DefaultListModel islandListModel = new DefaultListModel();
    private ListSelectionModel shipSelectionModel = new DefaultListSelectionModel();
    private ShipsCanvasModel shipsModel;
    private ShipsModel ships = null;
    private RemoteEmpire empire;
    private PPath worldRect = new PPath();
    private Rectangle initialView = new Rectangle();
    private boolean viewNationColor = true;
    private boolean viewShips = true;
    private boolean viewIslandName = true;
    private boolean viewIslandTime = true;
    private boolean viewSectorInfo = true;
    private boolean viewSectorDetails = false;
    private PImage airportImage = null;
    private PImage shellImage = null;
    private PImage artilleryImage = null;
    private PImage planeImage = null;
    private PImage mineImage = null;
    private PImage dockImage = null;
    private PImage capitolImage = null;
    private PImage fortImage = null;
    private PImage ruralImage = null;
    private ListSelectionListener shipSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent event) {
            if (event.getFirstIndex() < 0) {
                return;
            }
            for (int i = event.getFirstIndex(); i <= event.getLastIndex(); ++i) {
                if (((ListSelectionModel)event.getSource()).isSelectedIndex(i)) {
                    System.out.println("hilite index " + i + ";ship " + MapCanvas.this.ships.getIndex(i) + " from list selection listener");
                    MapCanvas.this.hiliteShip((Integer)MapCanvas.this.ships.getValueAt(i, 0));
                    continue;
                }
                MapCanvas.this.unHiliteShip((Integer)MapCanvas.this.ships.getValueAt(i, 0));
                System.out.println("unhilite ship " + MapCanvas.this.ships.getIndex(i) + " from list selection listener");
            }
        }
    };

    public MapCanvas() {
        this.setZoomEventHandler(null);
    }

    public void setShipsModel(ShipsModel ships) {
        if (this.ships != null) {
            this.ships.removeTableModelListener(this);
        }
        this.ships = ships;
        ships.addTableModelListener(this);
    }

    public void initialize() {
        PText label;
        this.empire = RemoteEmpire.getInstance();
        double x = this.empire.getWorldSize().getWidth();
        double y = this.empire.getWorldSize().getHeight();
        this.worldRect = PPath.createRectangle((float)0.0f, (float)0.0f, (float)this.empire.getWorldSize().width, (float)this.empire.getWorldSize().height);
        this.worldRect.setPaint((Paint)WATERCOLOR);
        this.worldRect.setStrokePaint((Paint)Color.BLACK);
        this.getLayer().addChild((PNode)this.worldRect);
        for (x = 0.0; x < this.empire.getWorldSize().getWidth(); x += 100.0) {
            PPath longLine = new PPath();
            longLine.moveTo((float)x, 0.0f);
            longLine.lineTo((float)x, (float)this.empire.getWorldSize().getHeight());
            longLine.setStrokePaint((Paint)new Color(0, 205, 255));
            label = new PText();
            label.setFont(new Font(PText.DEFAULT_FONT.getFontName(), PText.DEFAULT_FONT.getStyle(), 6));
            label.setText("" + (int)x);
            label.setTextPaint((Paint)new Color(0, 205, 255));
            label.setX(x + 2.0);
            label.setY(5.0);
            longLine.addChild((PNode)label);
            this.worldRect.addChild((PNode)longLine);
        }
        for (y = 0.0; y < this.empire.getWorldSize().getHeight(); y += 100.0) {
            PPath latLine = new PPath();
            latLine.moveTo(0.0f, (float)y);
            latLine.lineTo((float)this.empire.getWorldSize().getWidth(), (float)y);
            latLine.setStrokePaint((Paint)new Color(0, 205, 255));
            label = new PText();
            label.setFont(new Font(PText.DEFAULT_FONT.getFontName(), PText.DEFAULT_FONT.getStyle(), 6));
            label.setText("" + (int)y);
            label.setTextPaint((Paint)new Color(0, 205, 255));
            label.setX(5.0);
            label.setY(y + 2.0);
            latLine.addChild((PNode)label);
            this.worldRect.addChild((PNode)latLine);
        }
    }

    public void setShipSelected(int shipNum, boolean select) {
        if (select) {
            this.shipSelectionModel.addSelectionInterval(this.ships.getIndex(shipNum), this.ships.getIndex(shipNum));
        } else {
            this.shipSelectionModel.removeSelectionInterval(this.ships.getIndex(shipNum), this.ships.getIndex(shipNum));
        }
    }

    public void hiliteShip(int shipNum) {
        System.out.println("hiliting ship #" + shipNum);
        PPath shipNode = Globals.shipNodeList.get(shipNum);
        if (shipNode == null) {
            return;
        }
        Ship ship = (Ship)shipNode.getClientProperty((Object)"SHIP");
        shipNode.setStrokePaint((Paint)Color.WHITE);
        if (this.showShipsRadar) {
            CircleNode radarRings = this.getRadarRings((Point2D)ship.getLoc(), ship.getType().getRadar());
            if (shipNode.getClientProperty((Object)"RADAR") == null) {
                shipNode.addClientProperty((Object)"RADAR", (Object)radarRings);
                shipNode.addChild((PNode)radarRings);
            }
        } else {
            CircleNode radarRings = (CircleNode)((Object)shipNode.getClientProperty((Object)"RADAR"));
            if (radarRings != null) {
                shipNode.removeChild((PNode)radarRings);
                shipNode.addClientProperty((Object)"RADAR", null);
            }
        }
        shipNode.invalidateFullBounds();
    }

    public void unHiliteShip(int shipNum) {
        CircleNode radarRings;
        System.out.println("unhiliting ship #" + shipNum);
        PPath shipNode = Globals.shipNodeList.get(shipNum);
        if (shipNode == null) {
            return;
        }
        Ship ship = (Ship)shipNode.getClientProperty((Object)"SHIP");
        shipNode.setStrokePaint((Paint)Color.GREEN);
        if (!(ship instanceof MyShip)) {
            shipNode.setStrokePaint((Paint)this.colorNation(ship.getOwner()));
        }
        if ((radarRings = (CircleNode)((Object)shipNode.getClientProperty((Object)"RADAR"))) != null) {
            System.out.println("  removing radar");
            shipNode.removeChild((PNode)radarRings);
            shipNode.addClientProperty((Object)"RADAR", null);
        }
        shipNode.invalidateFullBounds();
    }

    private CircleNode getRadarRings(Point2D canvasPoint, int myRange) {
        int charHeight = (int)PText.DEFAULT_FONT.getMaxCharBounds(new FontRenderContext(null, false, false)).getHeight();
        CircleNode testRadar = new CircleNode((float)canvasPoint.getX(), (float)canvasPoint.getY(), myRange);
        testRadar.setPaint(Color.GREEN);
        testRadar.setTransparency(0.5f);
        PText bomberFlightRangeLabel = new PText();
        bomberFlightRangeLabel.setText("Bomber Flight Range");
        bomberFlightRangeLabel.setTextPaint((Paint)Color.GREEN);
        bomberFlightRangeLabel.setX(canvasPoint.getX());
        bomberFlightRangeLabel.setY(canvasPoint.getY() + 200.0);
        CircleNode bomberRange = new CircleNode((float)canvasPoint.getX(), (float)canvasPoint.getY(), 200.0f);
        bomberRange.setPaint(Color.RED);
        bomberRange.setTransparency(0.2f);
        PText bomberRadarRangeLabel = new PText();
        bomberRadarRangeLabel.setText("Bomber Radar Range");
        bomberRadarRangeLabel.setTextPaint((Paint)Color.RED);
        bomberRadarRangeLabel.setX(canvasPoint.getX());
        bomberRadarRangeLabel.setY(canvasPoint.getY() + 100.0);
        testRadar.addChild(bomberRange);
        CircleNode fighterFlyRange = new CircleNode((float)canvasPoint.getX(), (float)canvasPoint.getY(), 160.0f);
        fighterFlyRange.setPaint(Color.GREEN);
        PText fighterFlyRangeLabel = new PText();
        fighterFlyRangeLabel.setText("Fighter Flight Range");
        fighterFlyRangeLabel.setTextPaint((Paint)Color.GREEN);
        fighterFlyRangeLabel.setX(canvasPoint.getX());
        fighterFlyRangeLabel.setY(canvasPoint.getY() - 80.0 - (double)charHeight);
        CircleNode fighterRange = new CircleNode((float)canvasPoint.getX(), (float)canvasPoint.getY(), 80.0f);
        fighterRange.setPaint(Color.RED);
        fighterRange.setTransparency(0.2f);
        PText fighterRangeLabel = new PText();
        fighterRangeLabel.setText("Fighter Radar Range");
        fighterRangeLabel.setTextPaint((Paint)Color.RED);
        fighterRangeLabel.setX(canvasPoint.getX());
        fighterRangeLabel.setY(canvasPoint.getY() - 40.0 - (double)charHeight);
        testRadar.addChild(fighterRange);
        CircleNode radarRange = new CircleNode((float)canvasPoint.getX(), (float)canvasPoint.getY(), 60.0f);
        radarRange.setPaint(Color.YELLOW);
        PText radarRangeLabel = new PText();
        radarRangeLabel.setText("Radar Range");
        radarRangeLabel.setTextPaint((Paint)Color.YELLOW);
        radarRangeLabel.setX(canvasPoint.getX());
        radarRangeLabel.setY(canvasPoint.getY() + 30.0);
        return testRadar;
    }

    public void clearShipSelection() {
        for (PPath shipNode : Globals.shipNodeList.values()) {
            shipNode.setStrokePaint((Paint)Color.GREEN);
            Ship ship = (Ship)shipNode.getClientProperty((Object)"SHIP");
            this.shipSelectionModel.removeSelectionInterval(this.ships.getIndex(ship.getShipNum()), this.ships.getIndex(ship.getShipNum()));
        }
    }

    public PPath getWorldRect() {
        return this.worldRect;
    }

    public boolean isViewNationColor() {
        return this.viewNationColor;
    }

    public void setViewNationColor(boolean viewNationColor) {
        this.viewNationColor = viewNationColor;
    }

    public void setView(Rectangle view) {
        PTransformActivity act = this.getCamera().animateViewToCenterBounds((Rectangle2D)view, true, 1000L);
        this.getRoot().addActivity((PActivity)act);
        System.out.println("setting view");
    }

    public void setInitialView() {
        if (this.initialView.x != -1) {
            this.setView(this.initialView);
        }
    }

    public void setInitialView(Rectangle view) {
        this.initialView = view;
    }

    public Rectangle getInitialView() {
        return this.initialView;
    }

    public boolean isViewShips() {
        return this.viewShips;
    }

    public void setViewShips(boolean viewShips) {
        this.viewShips = viewShips;
    }

    public boolean isViewIslandName() {
        return this.viewIslandName;
    }

    public void setViewIslandName(boolean viewIslandName) {
        this.viewIslandName = viewIslandName;
    }

    public boolean isViewIslandTime() {
        return this.viewIslandTime;
    }

    public void setViewIslandTime(boolean viewIslandTime) {
        this.viewIslandTime = viewIslandTime;
    }

    public boolean isViewSectorDetails() {
        return this.viewSectorDetails;
    }

    public void setViewSectorDetails(boolean viewSectorDetails) {
        this.viewSectorDetails = viewSectorDetails;
    }

    public boolean isViewSectorInfo() {
        return this.viewSectorInfo;
    }

    public void setViewSectorInfo(boolean viewSectorInfo) {
        this.viewSectorInfo = viewSectorInfo;
    }

    public void makeIsland(IslandInfo island) {
        PPath wrappedRect;
        Rectangle islandNode = new Rectangle((int)island.getLocation().getX(), (int)island.getLocation().getY(), island.getSize().width, island.getSize().height);
        IslandNode islandRect = new IslandNode(islandNode, 3.0);
        islandRect.setStroke((Stroke)new PFixedWidthStroke());
        islandRect.setStrokePaint(Color.BLACK);
        Color islandColor = Color.GRAY;
        if (this.viewNationColor) {
            if (island.getNamingNationNum() == Globals.nationNum) {
                islandColor = Color.GREEN;
            } else if (island.getNamingNationNum() != 0) {
                islandColor = this.colorNation(island.getNamingNationNum());
                if (!island.isOccuppied()) {
                    islandColor = islandColor.darker();
                }
            }
        }
        islandRect.setPaint(islandColor);
        islandRect.addClientProperty("ISLAND", island);
        islandRect.setChildrenPickable(false);
        PNode oldIslandRect = (PNode)Globals.islandNodeList.get(island.getNumber());
        if (oldIslandRect != null) {
            this.worldRect.removeChild(oldIslandRect);
        }
        Globals.islandNodeList.put(island.getNumber(), islandRect);
        this.worldRect.addChild((PNode)islandRect);
        if (island.getLocation().getX() + (double)island.getSize().width > (double)this.empire.getWorldSize().width) {
            wrappedRect = new PPath();
            wrappedRect = PPath.createRectangle((float)((float)island.getLocation().getX() - (float)this.empire.getWorldSize().width), (float)((float)island.getLocation().getY()), (float)island.getSize().width, (float)island.getSize().height);
            this.worldRect.addChild((PNode)wrappedRect);
        }
        if (island.getLocation().getY() + (double)island.getSize().height > (double)this.empire.getWorldSize().height) {
            wrappedRect = new PPath();
            wrappedRect = PPath.createRectangle((float)((float)island.getLocation().getX()), (float)((float)island.getLocation().getY() - (float)this.empire.getWorldSize().height), (float)island.getSize().width, (float)island.getSize().height);
            this.worldRect.addChild((PNode)wrappedRect);
        }
        this.drawIsland((PNode)islandRect, island);
    }

    public void drawIsland(PNode islandRect, IslandInfo info) {
        info = RemoteEmpire.getInstance().getIsland(info.getNumber());
        islandRect.removeAllChildren();
        if (this.viewIslandName) {
            Sector capitol;
            Font nameFont = new Font(PText.DEFAULT_FONT.getName(), PText.DEFAULT_FONT.getStyle(), 6);
            String nameString = new String(info.getName());
            nameString = nameString + "[#" + info.getNumber() + "]";
            if (this.viewIslandTime && (capitol = info.getCapitol(Globals.nationNum)) != null && capitol.getTimeLeft() != -1) {
                nameString = nameString + " " + capitol.getTimeLeft() + "/" + capitol.getTimeRight();
            }
            FixedSizeLabel name = new FixedSizeLabel(nameString, nameFont, Color.GRAY);
            name.setX(info.getLocation().getX());
            name.setY(info.getLocation().getY() - 7.0);
            islandRect.addChild((PNode)name);
            Map sectors = info.getSectors();
            for (Sector sector : sectors.values()) {
                assert (sector.getTerrain() != null);
                int realX = (int)(sector.getLocation().getX() + info.getLocation().getX() - 1.0);
                int realY = (int)(sector.getLocation().getY() + info.getLocation().getY() - 1.0);
                Rectangle sectorNode = new Rectangle(realX, realY, 1, 1);
                SectorNode sectorRect = new SectorNode(sectorNode, this.empire);
                sectorRect.addClientProperty("SECTOR", sector);
                sectorRect.setChildrenPickable(false);
                Globals.sectorNodeList.put(sector.getLocation(), sectorRect);
                Color backgroundColor = Color.GRAY;
                switch (sector.getTerrain()) {
                    case WATER: {
                        backgroundColor = WATERCOLOR;
                        break;
                    }
                    case MOUNTAIN: {
                        backgroundColor = Color.BLACK;
                        break;
                    }
                    default: {
                        backgroundColor = Color.CYAN;
                        if (sector.getOwner() != 0) break;
                        backgroundColor = backgroundColor.darker();
                    }
                }
                Color bar5Color = null;
                Object des = new PNode();
                Font desFont = new Font(PText.DEFAULT_FONT.getName(), PText.DEFAULT_FONT.getStyle(), 1);
                if (this.viewSectorInfo) {
                    if (sector.getOwner() == Globals.nationNum) {
                        backgroundColor = Color.GREEN;
                        if (sector.getDes() == Sector.Des.RURAL || sector.getDes() == Sector.Des.MOUNTAIN) {
                            bar5Color = new Color(0, 255 - sector.getOreSample(), 0);
                        } else if (sector.getDes() == Sector.Des.AIRPORT) {
                            backgroundColor = Color.GRAY;
                        } else if (sector.getDes() == Sector.Des.CAPITOL) {
                            backgroundColor = Color.LIGHT_GRAY;
                        } else if (sector.getDes() == Sector.Des.SANCTUARY) {
                            backgroundColor = Color.BLUE;
                        }
                    } else if (sector.getOwner() > 0) {
                        backgroundColor = this.colorNation(sector.getOwner());
                    }
                    sectorRect.setPaint(backgroundColor);
                    sectorRect.setStroke(null);
                    des = new FixedSizeLabel("" + sector.getDes().asChar(), desFont, Color.BLACK);
                    if (!this.viewSectorDetails) {
                        // empty if block
                    }
                    switch (sector.getDes()) {
                        case AIRPORT: {
                            des = this.getAirportImage();
                            break;
                        }
                        case EXPLOSIVE: {
                            des = this.getShellImage();
                            break;
                        }
                        case ARTILLERY: {
                            des = this.getArtilleryImage();
                            break;
                        }
                        case PLANE: {
                            des = this.getPlaneImage();
                            break;
                        }
                        case MINE: {
                            des = this.getMineImage();
                            break;
                        }
                        case DOCK: {
                            des = this.getDockImage();
                            break;
                        }
                        case CAPITOL: 
                        case SANCTUARY: {
                            des = this.getCapitolImage();
                            break;
                        }
                        case RURAL: {
                            des = this.getRuralImage();
                            break;
                        }
                        case FORT: {
                            des = this.getFortImage();
                            break;
                        }
                    }
                    if (this.viewSectorDetails) {
                        float maxCiv = 999.0f;
                        if (sector.getDes() == Sector.Des.CAPITOL || sector.getDes() == Sector.Des.URBAN) {
                            maxCiv = 9999.0f;
                        }
                        PPath barRect = new PPath();
                        if (sector.getCivilians() != 0) {
                            barRect = PPath.createRectangle((float)((float)realX + 0.0f), (float)((float)realY + 1.0f - (float)sector.getCivilians() / maxCiv), (float)0.19f, (float)((float)sector.getCivilians() / maxCiv));
                            barRect.setPaint((Paint)Color.RED);
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            des.addChild((PNode)barRect);
                        }
                        if (sector.getMilitary() != 0) {
                            float maxMil = 999.0f;
                            if (sector.getDes() == Sector.Des.FORT) {
                                maxMil = 9999.0f;
                            }
                            barRect = PPath.createRectangle((float)((float)realX + 0.2f), (float)((float)realY + 1.0f - (float)sector.getMilitary() / maxMil), (float)0.19f, (float)((float)sector.getMilitary() / maxMil));
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            barRect.setPaint((Paint)Color.RED);
                            des.addChild((PNode)barRect);
                            barRect = PPath.createRectangle((float)((float)realX + 0.4f), (float)((float)realY + 1.0f - (float)sector.getGuns() / 9.0f), (float)0.19f, (float)((float)sector.getGuns() / 9.0f));
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            barRect.setPaint((Paint)Color.RED);
                            des.addChild((PNode)barRect);
                        }
                        if (sector.getShells() != 0) {
                            barRect = PPath.createRectangle((float)((float)realX + 0.6f), (float)((float)realY + 1.0f - (float)sector.getShells() / 999.0f), (float)0.19f, (float)((float)sector.getShells() / 999.0f));
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            barRect.setPaint((Paint)Color.RED);
                            des.addChild((PNode)barRect);
                        }
                        if (sector.getOreSample() != 0 && (sector.getDes() == Sector.Des.MINE || sector.getDes() == Sector.Des.RURAL)) {
                            barRect = PPath.createRectangle((float)((float)realX + 0.8f), (float)((float)realY + 1.0f - (float)sector.getOreSample() / 100.0f), (float)0.19f, (float)((float)sector.getOreSample() / 100.0f));
                            barRect.setPaint((Paint)Color.BLUE);
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            des.addChild((PNode)barRect);
                        } else if (sector.getProduction() != 0) {
                            barRect = PPath.createRectangle((float)((float)realX + 0.8f), (float)((float)realY + 1.0f - (float)sector.getProduction() / 9999.0f), (float)0.19f, (float)((float)sector.getProduction() / 9999.0f));
                            barRect.setPaint((Paint)Color.BLUE);
                            barRect.setTransparency(0.25f);
                            barRect.setStroke(null);
                            des.addChild((PNode)barRect);
                        }
                        PPath dividers = new PPath();
                        dividers.moveTo(0.0f, 0.99f);
                        dividers.lineTo(0.99f, 0.99f);
                        dividers.lineTo(0.99f, 0.0f);
                        dividers.setStroke((Stroke)new PFixedWidthStroke());
                        dividers.setStrokePaint((Paint)Color.BLACK);
                        sectorRect.addChild((PNode)dividers);
                    }
                }
                des.setBounds(sector.getLocation().getX() + info.getLocation().getX() - 1.0 + 0.1, sector.getLocation().getY() + info.getLocation().getY() - 1.0 - 0.1, 1.0, 1.0);
                sectorRect.setNode((PNode)des, 9.0);
                islandRect.addChild((PNode)sectorRect);
            }
        }
    }

    private void createShip(Ship ship) {
        if (!this.viewShips) {
            return;
        }
        PPath shipRect = PPath.createEllipse((float)((float)ship.getLoc().getX()), (float)((float)ship.getLoc().getY()), (float)1.0f, (float)1.0f);
        shipRect.setStrokePaint((Paint)Color.GREEN);
        shipRect.addClientProperty((Object)"SHIP", (Object)ship);
        if (!(ship instanceof MyShip)) {
            shipRect.setStrokePaint((Paint)this.colorNation(ship.getOwner()));
        }
        shipRect.setTransparency(0.5f);
        shipRect.setChildrenPickable(false);
        this.worldRect.addChild((PNode)shipRect);
        Globals.shipNodeList.put(ship.getShipNum(), shipRect);
        ListIterator it = this.worldRect.getChildrenIterator();
        TreeMap<Integer, PPath> shipList = new TreeMap<Integer, PPath>();
        while (it.hasNext()) {
            Ship testShip;
            PNode testNode = (PNode)it.next();
            if (testNode.getClientProperty((Object)"SHIP") == null || !(testShip = (Ship)testNode.getClientProperty((Object)"SHIP")).getLoc().equals((Object)ship.getLoc()) || Globals.shipNodeList.get(testShip.getShipNum()) == null) continue;
            shipList.put(new Integer(testShip.getShipNum()), Globals.shipNodeList.get(testShip.getShipNum()));
        }
        Iterator sortedShips = shipList.values().iterator();
        int thisSpotCounter = 0;
        while (sortedShips.hasNext()) {
            PNode sortedNode = (PNode)sortedShips.next();
            sortedNode.addClientProperty((Object)"DEPTH", (Object)new Integer(thisSpotCounter));
            Ship debugShip = (Ship)sortedNode.getClientProperty((Object)"SHIP");
            ++thisSpotCounter;
        }
        this.decorateShip((PNode)shipRect, ship);
    }

    private void decorateShip(PNode shipRect, Ship ship) {
        Font labelFont = new Font(PText.DEFAULT_FONT.getName(), PText.DEFAULT_FONT.getStyle(), 2);
        Color labelColor = Color.BLACK;
        String labelString = "";
        if (!(ship instanceof MyShip)) {
            Integer shipOwner = new Integer(ship.getOwner());
            NationInfo ni = this.empire.getNation(shipOwner.intValue());
            labelString = this.empire.getNation(ship.getOwner()).getName() + " ";
        }
        if (ship.isSubmerged()) {
            labelString = labelString + "(" + ship.getType() + ")";
            if (ship.getOwner() == Globals.nationNum) {
                labelString = labelString + " #" + new Integer(ship.getShipNum()).toString();
            }
        } else {
            labelString = labelString + ship.getType().getName() + " #" + new Integer(ship.getShipNum()).toString();
        }
        FixedSizeLabel label = new FixedSizeLabel(labelString, labelFont, labelColor);
        PBounds labelLoc = label.getBounds();
        Integer labelOffset = (Integer)shipRect.getClientProperty((Object)"DEPTH");
        if (labelOffset == null) {
            labelOffset = new Integer(0);
        }
        label.setX(ship.getLoc().getX() + 1.0);
        label.setY(ship.getLoc().getY() + 1.0 + (double)(2 * labelOffset));
        shipRect.addChild((PNode)label);
        WorldCoord destination = new WorldCoord(-1, -1);
        if (ship instanceof MyShip) {
            MyShip myShip = (MyShip)ship;
            destination = (WorldCoord)myShip.getDest().clone();
            if (destination.equals((Object)new WorldCoord(-1, -1))) {
                destination = ship.getLoc();
            }
            PPath travel = new PPath();
            travel.moveTo((float)ship.getLoc().getX() + 0.5f, (float)ship.getLoc().getY() + 0.5f);
            travel.lineTo((float)destination.getX() + 0.5f, (float)destination.getY() + 0.5f);
            travel.setStroke((Stroke)new PFixedWidthStroke());
            travel.setStrokePaint((Paint)Color.DARK_GRAY);
            shipRect.addChild((PNode)travel);
        }
        if (ship.getSpeed() != 0.0) {
            PPath header = new PPath();
            header.moveTo((float)ship.getLoc().getX(), (float)ship.getLoc().getY());
            header.lineTo((float)ship.getLoc().getX(), (float)(ship.getLoc().getY() - ship.getSpeed()));
            header.moveTo((float)ship.getLoc().getX() - 0.25f, (float)(ship.getLoc().getY() - ship.getSpeed()) + 0.25f);
            header.lineTo((float)ship.getLoc().getX(), (float)(ship.getLoc().getY() - ship.getSpeed()));
            header.lineTo((float)ship.getLoc().getX() + 0.25f, (float)(ship.getLoc().getY() - ship.getSpeed()) + 0.25f);
            AffineTransform rotate = new AffineTransform();
            rotate.translate(0.5, 0.5);
            System.out.println("heading=" + ship.getHeading());
            rotate.rotate(Math.toRadians(ship.getHeading()), (float)ship.getLoc().getX(), (float)ship.getLoc().getY());
            header.setTransform(rotate);
            header.setStroke((Stroke)new PFixedWidthStroke());
            header.setStrokePaint((Paint)Color.GRAY);
            header.setPaint((Paint)Color.GRAY);
            shipRect.addChild((PNode)header);
        }
    }

    public void updateShip(Ship ship) {
        if (Globals.shipNodeList.get(ship.getShipNum()) != null) {
            PPath shipRect = Globals.shipNodeList.get(ship.getShipNum());
            this.worldRect.removeChild((PNode)shipRect);
        }
        if (ship instanceof MyShip) {
            ship = this.ships.getShip(ship.getShipNum());
        }
        if (ship != null) {
            this.createShip(ship);
        }
    }

    public void updateAllShips() {
        Cursor saveCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        ListIterator worldIterator = this.worldRect.getChildrenIterator();
        LinkedList<PNode> nodeList = new LinkedList<PNode>();
        while (worldIterator.hasNext()) {
            PNode testNode = (PNode)worldIterator.next();
            if (testNode.getClientProperty((Object)"SHIP") == null) continue;
            try {
                nodeList.add(testNode);
            }
            catch (RuntimeException except) {
                except.printStackTrace();
            }
        }
        for (PNode node : nodeList) {
            this.worldRect.removeChild(node);
        }
        Map<Integer, MyShip> shipList = this.ships.getShipList();
        for (MyShip ship : shipList.values()) {
            this.createShip((Ship)ship);
        }
        Map yourShipList = this.empire.radar();
        for (YourShip ship : yourShipList.values()) {
            this.createShip((Ship)ship);
        }
        this.setCursor(saveCursor);
    }

    public void tableChanged(TableModelEvent event) {
    }

    public void shipValueChanged(Ship ship, ListSelectionEvent e) {
    }

    public PNode findIslandNodeUnder(Point coord) {
        for (IslandInfo island : this.empire.getIslandList().values()) {
            Rectangle rect = new Rectangle((int)island.getLocation().getX(), (int)island.getLocation().getY(), (int)island.getSize().getWidth(), (int)island.getSize().getHeight());
            if (!rect.contains(coord)) continue;
            return (PNode)Globals.islandNodeList.get(island.getNumber());
        }
        return null;
    }

    private Color colorNation(int nationNum) {
        NationInfo nation = this.empire.getNation(nationNum);
        Color nationColor = Color.GRAY;
        return nationColor;
    }

    private PImage getAirportImage() {
        this.airportImage = new PImage();
        this.airportImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/airport.png")));
        return this.airportImage;
    }

    private PImage getShellImage() {
        this.shellImage = new PImage();
        this.shellImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/shell.png")));
        return this.shellImage;
    }

    private PImage getArtilleryImage() {
        this.artilleryImage = new PImage();
        this.artilleryImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/artillery.png")));
        return this.artilleryImage;
    }

    private PImage getPlaneImage() {
        this.planeImage = new PImage();
        this.planeImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/plane.png")));
        return this.planeImage;
    }

    private PImage getMineImage() {
        this.mineImage = new PImage();
        this.mineImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/mine.png")));
        return this.mineImage;
    }

    private PImage getDockImage() {
        this.dockImage = new PImage();
        this.dockImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/dock.png")));
        return this.dockImage;
    }

    private PImage getCapitolImage() {
        this.capitolImage = new PImage();
        this.capitolImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/capitol.png")));
        return this.capitolImage;
    }

    private PImage getFortImage() {
        if (this.fortImage == null) {
            this.fortImage = new PImage();
            this.fortImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/fort.png")));
        }
        return this.fortImage;
    }

    private PImage getRuralImage() {
        this.ruralImage = new PImage();
        this.ruralImage.setImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/rural.png")));
        return this.ruralImage;
    }

    public ListSelectionModel getShipSelectionModel() {
        return this.shipSelectionModel;
    }

    public void setShipSelectionModel(ListSelectionModel shipSelectionModel) {
        if (this.shipSelectionModel != null) {
            this.shipSelectionModel.removeListSelectionListener(this.shipSelectionListener);
        }
        this.shipSelectionModel = shipSelectionModel;
        shipSelectionModel.addListSelectionListener(this.shipSelectionListener);
    }

    public void setShowShipsRadar(boolean b) {
        this.showShipsRadar = b;
        for (int i = 0; i < this.ships.getRowCount(); ++i) {
            if (this.shipSelectionModel.isSelectedIndex(i)) {
                this.hiliteShip((Integer)this.ships.getValueAt(i, 0));
                continue;
            }
            this.unHiliteShip((Integer)this.ships.getValueAt(i, 0));
        }
    }
}

