/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundFilePlayer {
    public void playSoundFile(URL file) {
        try {
            DataLine.Info datalineinfo;
            AudioInputStream ais = AudioSystem.getAudioInputStream(file);
            AudioFormat audioformat = ais.getFormat();
            System.out.println("Format: " + audioformat.toString());
            System.out.println("Encoding: " + audioformat.getEncoding());
            System.out.println("SampleRate:" + audioformat.getSampleRate());
            System.out.println("SampleSizeInBits: " + audioformat.getSampleSizeInBits());
            System.out.println("Channels: " + audioformat.getChannels());
            System.out.println("FrameSize: " + audioformat.getFrameSize());
            System.out.println("FrameRate: " + audioformat.getFrameRate());
            System.out.println("BigEndian: " + audioformat.isBigEndian());
            if (audioformat.getEncoding() == AudioFormat.Encoding.ULAW || audioformat.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat newformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioformat.getSampleRate(), audioformat.getSampleSizeInBits() * 2, audioformat.getChannels(), audioformat.getFrameSize() * 2, audioformat.getFrameRate(), true);
                ais = AudioSystem.getAudioInputStream(newformat, ais);
                audioformat = newformat;
            }
            if (!AudioSystem.isLineSupported(datalineinfo = new DataLine.Info(SourceDataLine.class, audioformat))) {
                System.out.println("Line matching " + datalineinfo + " is not supported.");
            } else {
                System.out.println("Line matching " + datalineinfo + " is supported.");
                SourceDataLine sourcedataline = (SourceDataLine)AudioSystem.getLine(datalineinfo);
                sourcedataline.open(audioformat);
                sourcedataline.start();
                int framesizeinbytes = audioformat.getFrameSize();
                int bufferlengthinframes = sourcedataline.getBufferSize() / 8;
                int bufferlengthinbytes = bufferlengthinframes * framesizeinbytes;
                byte[] sounddata = new byte[bufferlengthinbytes];
                int numberofbytesread = 0;
                while ((numberofbytesread = ais.read(sounddata)) != -1) {
                    int numberofbytesremaining = numberofbytesread;
                    sourcedataline.write(sounddata, 0, numberofbytesread);
                }
            }
        }
        catch (LineUnavailableException lue) {
            System.err.println("LineUnavailableException: " + lue.getMessage());
        }
        catch (UnsupportedAudioFileException uafe) {
            System.err.println("UnsupportedAudioFileException: " + uafe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }
}

