/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class AKDockLayout
extends BorderLayout {
    private ArrayList north = new ArrayList(1);
    private ArrayList south = new ArrayList(1);
    private ArrayList east = new ArrayList(1);
    private ArrayList west = new ArrayList(1);
    private Component center = null;
    private int northHeight;
    private int southHeight;
    private int eastWidth;
    private int westWidth;
    public Object[] curImbeddedTBRs = new Object[4];
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;

    public AKDockLayout() {
        this.curImbeddedTBRs[0] = this.north;
        this.curImbeddedTBRs[1] = this.south;
        this.curImbeddedTBRs[2] = this.west;
        this.curImbeddedTBRs[3] = this.east;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component c, Object con) {
        Object object = c.getTreeLock();
        synchronized (object) {
            if (con != null) {
                String s = con.toString();
                c.setVisible(true);
                if (s.equals("North")) {
                    this.north.add(c);
                } else if (s.equals("South")) {
                    this.south.add(c);
                } else if (s.equals("East")) {
                    this.east.add(c);
                } else if (s.equals("West")) {
                    this.west.add(c);
                } else if (s.equals("Center")) {
                    this.center = c;
                }
                c.getParent().validate();
            }
        }
    }

    public void removeLayoutComponent(Component c) {
        this.north.remove(c);
        this.south.remove(c);
        this.east.remove(c);
        this.west.remove(c);
        if (c == this.center) {
            this.center = null;
        }
        this.flipSeparators(c, 1);
        c.getParent().validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            this.northHeight = this.getPreferredDimension((ArrayList)this.north).height;
            this.southHeight = this.getPreferredDimension((ArrayList)this.south).height;
            this.eastWidth = this.getPreferredDimension((ArrayList)this.east).width;
            this.westWidth = this.getPreferredDimension((ArrayList)this.west).width;
            this.placeComponents(target, this.north, left, top, right - left, this.northHeight, 1);
            this.placeComponents(target, this.south, left, bottom - this.southHeight, right - left, this.southHeight, 3);
            this.placeComponents(target, this.east, right - this.eastWidth, top += this.northHeight + this.getVgap(), this.eastWidth, (bottom -= this.southHeight + this.getVgap()) - top, 4);
            right -= this.eastWidth + this.getHgap();
            this.placeComponents(target, this.west, left, top, this.westWidth, bottom - top, 2);
            left += this.westWidth + this.getHgap();
            if (this.center != null) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    private Dimension getPreferredDimension(ArrayList comps) {
        int w = 0;
        int h = 0;
        for (int i = 0; i < comps.size(); ++i) {
            Component c = (Component)comps.get(i);
            Dimension d = c.getPreferredSize();
            w = Math.max(w, d.width);
            h = Math.max(h, d.height);
        }
        return new Dimension(w, h);
    }

    private void placeComponents(Container target, ArrayList comps, int x, int y, int w, int h, int orientation) {
        int offset = 0;
        Component c = null;
        if (orientation == 1 || orientation == 3) {
            offset = x;
            int totalWidth = 0;
            int cwidth = 0;
            int num = comps.size();
            for (int i = 0; i < num; ++i) {
                c = (Component)comps.get(i);
                this.flipSeparators(c, 1);
                int widthSwap = totalWidth;
                int cwidthSwap = cwidth;
                cwidth = c.getPreferredSize().width;
                if (w < (totalWidth += cwidth) && i != 0) {
                    Component c0 = (Component)comps.get(i - 1);
                    Rectangle rec = c0.getBounds();
                    c0.setBounds(rec.x, rec.y, w - widthSwap + cwidthSwap, rec.height);
                    offset = x;
                    if (orientation == 1) {
                        y += h;
                        this.northHeight += h;
                    } else if (orientation == 3) {
                        this.southHeight += h;
                        y -= h;
                    }
                    totalWidth = cwidth;
                }
                if (i + 1 == num) {
                    c.setBounds(x + offset, y, w - totalWidth + cwidth, h);
                    continue;
                }
                c.setBounds(x + offset, y, cwidth, h);
                offset += cwidth;
            }
            this.flipSeparators(c, 1);
        } else {
            int totalHeight = 0;
            int cheight = 0;
            int num = comps.size();
            for (int i = 0; i < num; ++i) {
                c = (Component)comps.get(i);
                int heightSwap = totalHeight;
                int cheightSwap = cheight;
                cheight = c.getPreferredSize().height;
                if (h < (totalHeight += cheight) && i != 0) {
                    Component c0 = (Component)comps.get(i - 1);
                    Rectangle rec = c0.getBounds();
                    c0.setBounds(rec.x, rec.y, rec.width, h - heightSwap + cheightSwap);
                    if (orientation == 2) {
                        x += w;
                        this.westWidth += w;
                    } else if (orientation == 4) {
                        this.eastWidth += w;
                        x -= w;
                    }
                    totalHeight = cheight;
                    offset = 0;
                }
                if (totalHeight > h) {
                    // empty if block
                }
                if (i + 1 == num) {
                    c.setBounds(x, y + offset, w, h - totalHeight + cheight);
                    continue;
                }
                c.setBounds(x, y + offset, w, cheight);
                offset += cheight;
            }
            this.flipSeparators(c, 0);
        }
    }

    private void flipSeparators(Component c, int orientn) {
        JToolBar jtb;
        Component[] comps;
        if (c != null && c instanceof JToolBar && UIManager.getLookAndFeel().getName().toLowerCase().indexOf("windows") != -1 && (comps = (jtb = (JToolBar)c).getComponents()) != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                try {
                    Component component = comps[i];
                    if (component == null || !(component instanceof JSeparator)) continue;
                    boolean isVisi = component.isVisible();
                    jtb.remove(component);
                    JSeparator separ = new JSeparator();
                    separ.setVisible(isVisi);
                    if (orientn == 1) {
                        separ.setOrientation(1);
                        separ.setMinimumSize(new Dimension(2, 6));
                        separ.setPreferredSize(new Dimension(2, 6));
                        separ.setMaximumSize(new Dimension(2, 100));
                    } else {
                        separ.setOrientation(0);
                        separ.setMinimumSize(new Dimension(6, 2));
                        separ.setPreferredSize(new Dimension(6, 2));
                        separ.setMaximumSize(new Dimension(100, 2));
                    }
                    jtb.add((Component)separ, i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean containsImbeddedComp(Component c) {
        for (int i = 0; i < this.curImbeddedTBRs.length; ++i) {
            if (!((ArrayList)this.curImbeddedTBRs[i]).contains(c)) continue;
            return true;
        }
        return false;
    }

    public boolean containsImbeddedComp(Component c, int inx) {
        return inx > 0 && inx < 5 && ((ArrayList)this.curImbeddedTBRs[inx + 1]).contains(c);
    }
}

