/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.RemoteEmpire;
import java.awt.Point;

public class WorldCoord
extends Point
implements Comparable {
    private static final long serialVersionUID = 3760847844038488369L;

    public WorldCoord() {
    }

    public WorldCoord(Point p) {
        super(p);
    }

    public WorldCoord(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public WorldCoord(IslandInfo island, IslandCoord coord) {
        super(coord);
        this.translate(island.getLocation().x - 1, island.getLocation().y - 1);
    }

    public IslandCoord asIslandCoord(IslandInfo island) {
        IslandCoord islandCoord = new IslandCoord(this.x, this.y);
        islandCoord.translate(-island.getLocation().x + 1, -island.getLocation().y + 1);
        return islandCoord;
    }

    public WorldCoord(int x, int y) {
        super(x, y);
    }

    public WorldCoord translated(IslandCoord coord) {
        WorldCoord translated = new WorldCoord(this);
        translated.translate(-coord.x, -coord.y);
        return translated;
    }

    public WorldCoord translated(WorldCoord coord) {
        WorldCoord translated = new WorldCoord(this);
        translated.translate(coord.x, coord.y);
        return translated;
    }

    public WorldCoord translated(int x, int y) {
        WorldCoord translated = new WorldCoord(this);
        translated.translate(x, y);
        return translated;
    }

    public WorldCoord wrap() {
        if (this.x > RemoteEmpire.worldSize.width) {
            this.x -= RemoteEmpire.worldSize.width;
        }
        if (this.x < 0) {
            this.x += RemoteEmpire.worldSize.width;
        }
        if (this.y > RemoteEmpire.worldSize.height) {
            this.y -= RemoteEmpire.worldSize.height;
        }
        if (this.y < 0) {
            this.y += RemoteEmpire.worldSize.height;
        }
        return this;
    }

    public WorldCoord wrapped() {
        return new WorldCoord(this).wrap();
    }

    public int compareTo(Object obj) {
        if (this.x == ((WorldCoord)obj).x) {
            return this.y - ((WorldCoord)obj).y;
        }
        return this.x - ((WorldCoord)obj).x;
    }

    public String toString() {
        String output = new String();
        output = "" + this.x + "," + this.y;
        return output;
    }
}

