/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import edu.umd.cs.piccolox.util.LineShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PLine
extends PNode {
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private transient LineShape line;
    private transient Stroke stroke;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public PLine(LineShape lineShape) {
        this.stroke = DEFAULT_STROKE;
        if (lineShape == null) {
            lineShape = new LineShape(null);
        }
        this.line = lineShape;
    }

    public PLine() {
        this(null);
    }

    public PLine(LineShape lineShape, Stroke stroke) {
        this(lineShape);
        this.stroke = stroke;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint paint) {
        Paint paint2 = this.strokePaint;
        this.strokePaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", paint2, this.strokePaint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.updateBoundsFromLine();
        this.invalidatePaint();
        this.firePropertyChange(131072, "stroke", stroke2, this.stroke);
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        if (this.line == null || !super.setBounds(d, d2, d3, d4)) {
            return false;
        }
        Rectangle2D rectangle2D = this.line.getBounds2D();
        Rectangle2D rectangle2D2 = this.getLineBoundsWithStroke();
        double d5 = Math.max(rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D2.getHeight() - rectangle2D.getHeight());
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(d += d5 / 2.0, d2 += d5 / 2.0);
        TEMP_TRANSFORM.scale((d3 -= d5) / rectangle2D.getWidth(), (d4 -= d5) / rectangle2D.getHeight());
        TEMP_TRANSFORM.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.line.transformPoints((AffineTransform)TEMP_TRANSFORM);
        return true;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.line.intersects(rectangle2D)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.line).intersects(rectangle2D);
            }
        }
        return false;
    }

    public Rectangle2D getLineBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.line).getBounds2D();
        }
        return this.line.getBounds2D();
    }

    public void updateBoundsFromLine() {
        if (this.line.getPointCount() == 0) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.getLineBoundsWithStroke();
            super.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this.stroke != null && this.strokePaint != null) {
            graphics2D.setPaint(this.strokePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.line);
        }
    }

    public LineShape getLineReference() {
        return this.line;
    }

    public int getPointCount() {
        return this.line.getPointCount();
    }

    public Point2D getPoint(int n, Point2D point2D) {
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        return this.line.getPoint(n, point2D);
    }

    protected void lineChanged() {
        this.firePropertyChange(262144, "path", null, this.line);
        this.updateBoundsFromLine();
        this.invalidatePaint();
    }

    public void setPoint(int n, double d, double d2) {
        this.line.setPoint(n, d, d2);
        this.lineChanged();
    }

    public void addPoint(int n, double d, double d2) {
        this.line.addPoint(n, d, d2);
        this.lineChanged();
    }

    public void removePoints(int n, int n2) {
        this.line.removePoints(n, n2);
        this.lineChanged();
    }

    public void removeAllPoints() {
        this.line.removePoints(0, this.line.getPointCount());
        this.lineChanged();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        PUtil.writeStroke((Stroke)this.stroke, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stroke = PUtil.readStroke((ObjectInputStream)objectInputStream);
    }
}

