/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.maputils;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class CircleNode
extends PNode {
    private Ellipse2D circle = null;
    private float strokeWidth;

    public CircleNode(float x, float y, float diameter) {
        this.strokeWidth = 0.0f;
        this.circle = new Ellipse2D.Double((double)x - (double)diameter / 2.0, (double)y - (double)diameter / 2.0, diameter, diameter);
        this.setBounds((double)x - (double)diameter / 2.0, (double)y - (double)diameter / 2.0, diameter, diameter);
    }

    public CircleNode(float x, float y, float diameter, float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.circle = new Ellipse2D.Double((double)x - (double)diameter / 2.0, (double)y - (double)diameter / 2.0, diameter, diameter);
        this.setBounds((double)x - (double)diameter / 2.0, (double)y - (double)diameter / 2.0, diameter, diameter);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (super.setBounds(x, y, width, height)) {
            this.circle.setFrame(x, y, width, height);
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D aBounds) {
        return this.circle.intersects(aBounds);
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        g2.setStroke(new BasicStroke(this.strokeWidth));
        g2.setPaint(this.getPaint());
        g2.draw(this.circle);
        g2.fill(this.circle);
    }
}

