/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.models;

import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.jec.Globals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IslandTableModel
extends AbstractTableModel {
    private RemoteEmpire empire = null;
    private Map<Integer, IslandInfo> islandList;
    private Map<Integer, XIslandInfo> xIslandList = new HashMap<Integer, XIslandInfo>();

    public IslandTableModel(RemoteEmpire empire) {
        this.empire = empire;
        this.islandList = empire.getIslandList();
        this.recalcIslandData();
        System.out.println("found " + this.islandList.size() + " islands");
    }

    public void initialize() {
        this.empire = RemoteEmpire.getInstance();
        this.islandList = this.empire.getIslandList();
        this.recalcIslandData();
        System.out.println("found " + this.islandList.size() + " islands");
    }

    public Map<Integer, IslandInfo> getIslands() {
        this.islandList = this.empire.getIslandList();
        this.recalcIslandData();
        this.fireTableDataChanged();
        return this.islandList;
    }

    public IslandInfo getIsland(int islandNum) {
        IslandInfo island = this.empire.getIsland(islandNum);
        this.islandList.put(islandNum, island);
        this.recalcIslandData(islandNum);
        this.fireTableRowsUpdated(this.getIndex(islandNum), this.getIndex(islandNum));
        return island;
    }

    public int getIndex(int islandNum) {
        int row = 0;
        for (IslandInfo island : this.islandList.values()) {
            if (island.getNumber() == islandNum) break;
            ++row;
        }
        return row;
    }

    private void recalcIslandData() {
        for (IslandInfo island : this.islandList.values()) {
            this.recalcIslandData(island.getNumber());
        }
    }

    private void recalcIslandData(int islandNum) {
        IslandInfo island = this.islandList.get(islandNum);
        XIslandInfo xIsland = new XIslandInfo();
        if (island.isOccuppied()) {
            for (Sector sector : island.getSectors().values()) {
                if (sector.getTerrain() == Sector.Des.RURAL && sector.getOwner() == 0) {
                    xIsland.setLand(xIsland.getLand() + 1);
                }
                if (sector.getOwner() != Globals.nationNum) continue;
                xIsland.setSectors(xIsland.getSectors() + 1);
                xIsland.setCivilians(xIsland.getCivilians() + sector.getCivilians());
                xIsland.setMilitary(xIsland.getMilitary() + sector.getMilitary());
            }
            if (xIsland.getSectors() != 0) {
                xIsland.setTimeLeft(island.getCapitol(Globals.nationNum).getTimeLeft());
                xIsland.setTimeRight(island.getCapitol(Globals.nationNum).getTimeRight());
            }
        }
        this.xIslandList.put(island.getNumber(), xIsland);
    }

    @Override
    public int getRowCount() {
        if (this.empire == null) {
            return 0;
        }
        return this.islandList.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArrayList<IslandInfo> list = new ArrayList<IslandInfo>(this.islandList.values());
        switch (columnIndex) {
            case 0: {
                return ((IslandInfo)list.get(rowIndex)).getNumber();
            }
            case 1: {
                return ((IslandInfo)list.get(rowIndex)).getLocation();
            }
            case 2: {
                return ((IslandInfo)list.get(rowIndex)).getSize();
            }
            case 3: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors();
            }
            case 4: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getCivilians();
            }
            case 5: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getMilitary();
            }
            case 6: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getLand();
            }
            case 7: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getPower();
            }
            case 8: {
                if (this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getSectors() == 0) {
                    return "";
                }
                return String.format("%2d/%3d", this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getTimeLeft(), this.xIslandList.get(((IslandInfo)list.get(rowIndex)).getNumber()).getTimeRight());
            }
            case 9: {
                return ((IslandInfo)list.get(rowIndex)).getName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 7) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Number";
            }
            case 1: {
                return "Location";
            }
            case 2: {
                return "Size";
            }
            case 3: {
                return "Sectors";
            }
            case 4: {
                return "Civilians";
            }
            case 5: {
                return "Military";
            }
            case 6: {
                return "Land";
            }
            case 7: {
                return "Power";
            }
            case 8: {
                return "Time";
            }
            case 9: {
                return "Name";
            }
        }
        return null;
    }

    private class XIslandInfo {
        private int civilians;
        private int military;
        private int sectors;
        private int land;
        private int timeLeft;
        private int timeRight;
        private int power;

        private XIslandInfo() {
        }

        public int getCivilians() {
            return this.civilians;
        }

        public void setCivilians(int civilians) {
            this.civilians = civilians;
        }

        public int getLand() {
            return this.land;
        }

        public void setLand(int land) {
            this.land = land;
        }

        public int getMilitary() {
            return this.military;
        }

        public void setMilitary(int military) {
            this.military = military;
        }

        public int getSectors() {
            return this.sectors;
        }

        public void setSectors(int sectors) {
            this.sectors = sectors;
        }

        public int getTimeLeft() {
            return this.timeLeft;
        }

        public void setTimeLeft(int timeLeft) {
            this.timeLeft = timeLeft;
        }

        public int getTimeRight() {
            return this.timeRight;
        }

        public void setTimeRight(int timeRight) {
            this.timeRight = timeRight;
        }

        public int getPower() {
            return this.power;
        }

        public void setPower(int power) {
            this.power = power;
        }
    }
}

