/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.jec.ComposeMail;
import com.empireclassic.jec.MailTableModel;
import com.empireclassic.jec.utils.TableHeaderSorter;
import com.empireclassic.jec.utils.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MailWindow
extends JFrame {
    private MailTableModel model = new MailTableModel();
    private JPanel jContentPane = null;
    private JSplitPane mailSplitPane = null;
    private JPanel mailListPanel = null;
    private JPanel mailDetailPanel = null;
    private JScrollPane mailDetailScrollPane = null;
    private JScrollPane mailListScrollPane = null;
    private JTable mailListTable = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton sendButton = null;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JTextArea mailTextArea = null;

    public MailWindow() {
        this.setDefaultCloseOperation(1);
        this.initialize();
        Timer timer = new Timer(60000, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MailWindow.this.timerActionPerformed();
            }
        });
        this.timerActionPerformed();
        timer.start();
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(event);
        }
    }

    private void timerActionPerformed() {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        List<RemoteEmpire.Mail> mailList = empire.getMailList();
        this.model.update(mailList);
    }

    private void mailSelectionChanged(int newSelection) {
        String message = this.model.getMessageFromRow(newSelection);
        this.getMailTextArea().setText(message);
    }

    private void initialize() {
        this.setSize(503, 407);
        this.setTitle("Mail");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JSplitPane getMailSplitPane() {
        if (this.mailSplitPane == null) {
            this.mailSplitPane = new JSplitPane();
            this.mailSplitPane.setOrientation(0);
            this.mailSplitPane.setDividerLocation(100);
            this.mailSplitPane.setBottomComponent(this.getMailDetailPanel());
            this.mailSplitPane.setTopComponent(this.getMailListPanel());
        }
        return this.mailSplitPane;
    }

    private JPanel getMailListPanel() {
        if (this.mailListPanel == null) {
            this.mailListPanel = new JPanel();
            this.mailListPanel.setLayout(new BorderLayout());
            this.mailListPanel.add((Component)this.getMailListScrollPane(), "Center");
        }
        return this.mailListPanel;
    }

    private JPanel getMailDetailPanel() {
        if (this.mailDetailPanel == null) {
            this.mailDetailPanel = new JPanel();
            this.mailDetailPanel.setLayout(new BorderLayout());
            this.mailDetailPanel.add((Component)this.getMailDetailScrollPane(), "Center");
        }
        return this.mailDetailPanel;
    }

    private JScrollPane getMailDetailScrollPane() {
        if (this.mailDetailScrollPane == null) {
            this.mailDetailScrollPane = new JScrollPane();
            this.mailDetailScrollPane.setViewportView(this.getMailTextArea());
        }
        return this.mailDetailScrollPane;
    }

    private JScrollPane getMailListScrollPane() {
        if (this.mailListScrollPane == null) {
            this.mailListScrollPane = new JScrollPane();
            this.mailListScrollPane.setVerticalScrollBarPolicy(22);
            this.mailListScrollPane.setViewportView(this.getMailListTable());
        }
        return this.mailListScrollPane;
    }

    private JTable getMailListTable() {
        if (this.mailListTable == null) {
            TableSorter sorter = new TableSorter(this.model);
            this.mailListTable = new JTable(sorter);
            TableHeaderSorter.install(sorter, this.mailListTable);
            this.mailListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting() && event.getFirstIndex() != -1) {
                        int selectedIndex = ((DefaultListSelectionModel)event.getSource()).getAnchorSelectionIndex();
                        MailWindow.this.mailSelectionChanged(selectedIndex);
                    }
                }
            });
        }
        return this.mailListTable;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getMailSplitPane(), "Center");
            this.mainPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getSendButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Close");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MailWindow.this.closeButtonActionPerformed();
                }
            });
        }
        return this.okButton;
    }

    private void closeButtonActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, 1, "closed"));
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fireActionPerformed(new ActionEvent(this, 1, "closed"));
        }
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendButton.setText("Send...");
            this.sendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ComposeMail compose = new ComposeMail();
                    compose.setVisible(true);
                }
            });
        }
        return this.sendButton;
    }

    private JTextArea getMailTextArea() {
        if (this.mailTextArea == null) {
            this.mailTextArea = new JTextArea();
            this.mailTextArea.setWrapStyleWord(true);
            this.mailTextArea.setEditable(false);
        }
        return this.mailTextArea;
    }
}

