/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.islandmenu;

import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.reports.JECReport;
import com.empireclassic.jec.reports.SectorDesignateDialog;
import com.empireclassic.jec.utils.ProgressWindow;
import com.empireclassic.jec.utils.SwingWorker;
import edu.umd.cs.piccolo.PNode;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class SectorReport
extends JECReport {
    private JECFrame parent;
    private IslandInfo island;
    private PNode node;
    String[] columnNames = new String[]{"Sector", "Des", "Civ", "Mil", "Art", "Explv", "Ore", "Eff", "Prod", "Smpl", "Auth", "Ftr", "Bmr"};

    public SectorReport(JECFrame parent, PNode node) {
        super((Frame)parent, "Sector Report");
        IslandInfo island = (IslandInfo)node.getClientProperty("ISLAND");
        this.setTitle("Sector Report for " + island.getName());
        this.parent = parent;
        this.island = island;
        this.node = node;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new DesAction());
        this.setActions(actions);
        this.setColumns(this.columnNames);
        Map<IslandCoord, Sector> sectors = island.getSectors();
        for (Sector sector : sectors.values()) {
            if (sector.getOwner() != Globals.nationNum) continue;
            this.rowData[0] = sector.getLocation();
            this.rowData[1] = Character.valueOf(sector.getDes().asChar());
            this.rowData[2] = sector.getCivilians();
            this.rowData[3] = sector.getMilitary();
            this.rowData[4] = sector.getGuns();
            this.rowData[5] = sector.getShells();
            this.rowData[6] = sector.getOre();
            this.rowData[7] = sector.getEff();
            this.rowData[8] = sector.getProduction();
            this.rowData[9] = sector.getOreSample();
            this.rowData[10] = sector.getAuthorized();
            this.rowData[11] = sector.getFighters();
            this.rowData[12] = sector.getBombers();
            this.model.addRow(this.rowData);
        }
        this.setPreferredWidths();
    }

    public class DesAction
    extends AbstractAction {
        public DesAction() {
            this.putValue("Name", "Designate");
        }

        public void actionPerformed(ActionEvent e) {
            final int[] rows = SectorReport.this.reportTable.getSelectedRows();
            if (rows.length == 0) {
                JOptionPane.showMessageDialog(SectorReport.this.parent, "No sectors selected", "Selection error", 0);
                return;
            }
            SectorDesignateDialog desDialog = new SectorDesignateDialog();
            desDialog.setVisible(true);
            final int desSetTo = desDialog.getDes().getValue();
            if (!desDialog.cancelled()) {
                final ProgressWindow progress = new ProgressWindow((Frame)SectorReport.this.parent, "Designating...", rows.length);
                SwingWorker designater = new SwingWorker(){

                    public Object construct() {
                        for (int i = 0; i < rows.length; ++i) {
                            IslandCoord coord = (IslandCoord)SectorReport.this.reportTable.getModel().getValueAt(rows[i], 0);
                            RemoteEmpire.getInstance().setDes(SectorReport.this.island.getNumber(), coord, desSetTo);
                            System.out.println("des " + coord + " to " + desSetTo);
                            progress.updateStatus("" + coord);
                        }
                        return new Integer(0);
                    }

                    public void finished() {
                        super.finished();
                        SectorReport.this.island.getSectors();
                        SectorReport.this.parent.getMapCanvas().drawIsland(SectorReport.this.node, SectorReport.this.island);
                        progress.dispose();
                    }
                };
                designater.start();
            }
        }
    }
}

