/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.maputils;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class ToolTipHandler
extends PBasicInputEventHandler {
    public static final String PICCOLOX_TOOLTIP_PROPERTY_KEY = "PICCOLOX_TOOLTIP";
    private Timer initialTimer;
    private Timer reshowTimer;
    private Timer dismissTimer;
    private String toolTipText;
    private Point2D preferredLocation;
    private PNode insideNode;
    private PInputEvent inputEvent;
    private boolean showImmediately;
    private Popup tipPopup;
    private Window tipWindow;
    private JToolTip tip;
    private boolean tipShowing;
    private boolean customInitialDelay;
    private boolean customReshowDelay;
    private boolean customDismissDelay;
    private MouseListener windowMouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            ToolTipHandler.this.handleMousePressed();
        }

        public void mouseExited(MouseEvent event) {
            if (ToolTipHandler.this.tipWindow != null && event.getSource() == ToolTipHandler.this.tipWindow) {
                boolean locationIsInside;
                PCanvas canvas = ToolTipHandler.this.getCanvas();
                Container insideComponentWindow = canvas.getTopLevelAncestor();
                Point location = event.getPoint();
                SwingUtilities.convertPointToScreen(location, ToolTipHandler.this.tipWindow);
                location.x -= insideComponentWindow.getX();
                location.y -= insideComponentWindow.getY();
                location = SwingUtilities.convertPoint(insideComponentWindow, location, canvas);
                boolean bl = locationIsInside = location.x >= 0 && (double)location.x < ToolTipHandler.this.insideNode.getWidth() && location.y >= 0 && (double)location.y < ToolTipHandler.this.insideNode.getHeight();
                if (!locationIsInside) {
                    ToolTipHandler.this.hideNow();
                }
            }
        }
    };

    public ToolTipHandler() {
        PInputEventFilter eventFilter = this.getEventFilter();
        eventFilter.setAcceptsAlreadyHandledEvents(true);
        eventFilter.setMarksAcceptedEventsAsHandled(false);
        this.initialTimer = new Timer(750, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolTipHandler.this.initialTimerFired();
            }
        });
        this.initialTimer.setRepeats(false);
        this.reshowTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolTipHandler.this.reshowTimerFired();
            }
        });
        this.reshowTimer.setRepeats(false);
        this.dismissTimer = new Timer(4000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolTipHandler.this.dismissTimerFired();
            }
        });
        this.dismissTimer.setRepeats(false);
    }

    public boolean acceptsEvent(PInputEvent event, int type) {
        boolean accept = super.acceptsEvent(event, type);
        if (accept) {
            String toolTipText = this.getToolTipText(event);
            accept = toolTipText != null;
        }
        return accept;
    }

    private void toggleToolTip(PInputEvent event) {
        PNode toolTipNode = event.getPickedNode();
        if (this.tipShowing) {
            this.hideTipWindow();
            this.insideNode = null;
        } else {
            this.hideTipWindow();
            this.initialTimer.stop();
            this.reshowTimer.stop();
            this.dismissTimer.stop();
            this.insideNode = toolTipNode;
            this.inputEvent = event;
            if (this.insideNode != null) {
                this.toolTipText = this.getToolTipText(this.insideNode);
                this.preferredLocation = new Point2D.Double(10.0, this.insideNode.getHeight() + 10.0);
                this.showTipWindow();
            }
        }
    }

    private boolean isShowing(PNode node) {
        boolean result;
        do {
            result = node.getVisible();
            node = node.getParent();
        } while (result && node != null);
        return result;
    }

    private void showTipWindow() {
        PCanvas canvas = this.getCanvas();
        if (this.insideNode == null || !this.isShowing(this.insideNode) || !canvas.isShowing()) {
            return;
        }
        if (ToolTipManager.sharedInstance().isEnabled()) {
            Point location = new Point();
            Rectangle screenBounds = canvas.getGraphicsConfiguration().getBounds();
            boolean leftToRight = canvas.getComponentOrientation().isLeftToRight();
            this.hideTipWindow();
            this.tip = this.createToolTip(this.insideNode);
            this.tip.setTipText(this.toolTipText);
            Dimension tipSize = this.tip.getPreferredSize();
            Point canvasLocationOnScreen = canvas.getLocationOnScreen();
            if (this.preferredLocation != null) {
                Point2D preferredLocationGlobal = (Point2D)this.preferredLocation.clone();
                this.insideNode.localToGlobal(preferredLocationGlobal);
                location.x = canvasLocationOnScreen.x + (int)preferredLocationGlobal.getX();
                location.y = canvasLocationOnScreen.y + (int)preferredLocationGlobal.getY();
            } else {
                Point2D canvasPosition = this.inputEvent.getCanvasPosition();
                location.x = canvasLocationOnScreen.x + (int)canvasPosition.getX();
                location.y = canvasLocationOnScreen.y + (int)canvasPosition.getY() + 20;
            }
            if (!leftToRight) {
                location.x = Math.max(screenBounds.x, location.x - tipSize.width);
            }
            if (location.x < screenBounds.x) {
                location.x = screenBounds.x;
            } else if (location.x - screenBounds.x + tipSize.width > screenBounds.width) {
                location.x = screenBounds.x + Math.max(0, screenBounds.width - tipSize.width);
            }
            if (location.y < screenBounds.y) {
                location.y = screenBounds.y;
            } else if (location.y - screenBounds.y + tipSize.height > screenBounds.height) {
                location.y = screenBounds.y + Math.max(0, screenBounds.height - tipSize.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipPopup = popupFactory.getPopup(canvas, this.tip, location.x, location.y);
            this.tipPopup.show();
            Window componentWindow = SwingUtilities.windowForComponent(canvas);
            this.tipWindow = SwingUtilities.windowForComponent(this.tip);
            if (this.tipWindow != null && this.tipWindow != componentWindow) {
                this.tipWindow.addMouseListener(this.windowMouseListener);
            } else {
                this.tipWindow = null;
            }
            this.startDismissTimer();
            this.tipShowing = true;
        }
    }

    private PCanvas getCanvas() {
        return (PCanvas)this.inputEvent.getComponent();
    }

    private void handleMouseEntered(PInputEvent event) {
        PNode pickedNode = event.getPickedNode();
        this.reshowTimer.stop();
        Point2D location = event.getPositionRelativeTo(pickedNode);
        if (location.getX() < 0.0 || location.getX() >= pickedNode.getWidth() || location.getY() < 0.0 || location.getY() >= pickedNode.getHeight()) {
            return;
        }
        if (this.insideNode != null) {
            this.initialTimer.stop();
        }
        boolean sameComponent = this.insideNode == pickedNode;
        this.insideNode = pickedNode;
        if (this.tipPopup != null) {
            this.inputEvent = event;
            if (this.showImmediately) {
                boolean sameLoc;
                String newToolTipText = this.getToolTipText(event);
                Point2D newPreferredLocation = this.getToolTipLocation(event);
                boolean bl = this.preferredLocation != null ? this.preferredLocation.equals(newPreferredLocation) : (sameLoc = newPreferredLocation == null);
                if (!(sameComponent && this.toolTipText.equals(newToolTipText) && sameLoc)) {
                    this.toolTipText = newToolTipText;
                    this.preferredLocation = newPreferredLocation;
                    this.showTipWindow();
                }
            } else {
                this.startInitialTimer();
            }
        }
    }

    public static void setToolTipText(PNode node, String text) {
        node.addClientProperty(PICCOLOX_TOOLTIP_PROPERTY_KEY, text);
    }

    protected String getToolTipText(PNode node) {
        Object toolTipProperty = node.getClientProperty(PICCOLOX_TOOLTIP_PROPERTY_KEY);
        String toolTip = toolTipProperty != null ? toolTipProperty.toString() : null;
        return toolTip;
    }

    protected String getToolTipText(PInputEvent event) {
        String toolTipText = this.getToolTipText(event.getPickedNode());
        return toolTipText;
    }

    protected Point2D getToolTipLocation(PInputEvent event) {
        return null;
    }

    protected JToolTip createToolTip(PNode node) {
        JToolTip tip = new JToolTip();
        return tip;
    }

    private void checkForTipChange(PInputEvent event) {
        String newText = this.getToolTipText(event);
        Point2D newPreferredLocation = this.getToolTipLocation(event);
        if (newText == null && newPreferredLocation == null) {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.inputEvent = null;
            this.insideNode = null;
            this.hideTipWindow();
            this.initialTimer.stop();
            this.restartReshowTimer();
        } else {
            boolean locationIsEqual;
            this.inputEvent = event;
            boolean textIsEqual = newText != null && newText.equals(this.toolTipText) || newText == null;
            boolean bl = locationIsEqual = newPreferredLocation != null && newPreferredLocation.equals(this.preferredLocation) || newPreferredLocation == null;
            if (textIsEqual && locationIsEqual) {
                if (this.tipPopup != null) {
                    this.restartDismissTimer();
                } else {
                    this.restartInitialTimer();
                }
            } else {
                this.toolTipText = newText;
                this.preferredLocation = newPreferredLocation;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.reshowTimer.stop();
                } else {
                    this.restartInitialTimer();
                }
            }
        }
    }

    private void startDismissTimer() {
        this.dismissTimer.setInitialDelay(this.getDismissDelay());
        this.dismissTimer.start();
    }

    private void startInitialTimer() {
        this.initialTimer.setInitialDelay(this.getInitialDelay());
        this.initialTimer.start();
    }

    private void restartInitialTimer() {
        this.initialTimer.setInitialDelay(this.getInitialDelay());
        this.initialTimer.restart();
    }

    private void restartReshowTimer() {
        int reshowDelay = this.getReshowDelay();
        if (reshowDelay == 0) {
            this.reshowTimer.stop();
            this.reshowTimerFired();
        } else {
            this.reshowTimer.setInitialDelay(reshowDelay);
            this.reshowTimer.restart();
        }
    }

    private void restartDismissTimer() {
        this.dismissTimer.setInitialDelay(this.getDismissDelay());
        this.dismissTimer.restart();
    }

    public int getInitialDelay() {
        int initialDelay = this.customInitialDelay ? this.initialTimer.getInitialDelay() : ToolTipManager.sharedInstance().getInitialDelay();
        return initialDelay;
    }

    public int getReshowDelay() {
        int reshowDelay = this.customReshowDelay ? this.reshowTimer.getInitialDelay() : ToolTipManager.sharedInstance().getReshowDelay();
        return reshowDelay;
    }

    public int getDismissDelay() {
        int dismissDelay = this.customDismissDelay ? this.dismissTimer.getInitialDelay() : ToolTipManager.sharedInstance().getDismissDelay();
        return dismissDelay;
    }

    public void setInitialDelay(int milliseconds) {
        this.customInitialDelay = true;
        this.initialTimer.setInitialDelay(milliseconds);
    }

    public void resetInitialDelay() {
        this.customInitialDelay = false;
    }

    public void setReshowDelay(int milliseconds) {
        this.customReshowDelay = true;
        this.reshowTimer.setInitialDelay(milliseconds);
    }

    public void resetReshowDelay() {
        this.customReshowDelay = false;
    }

    public void setDismissDelay(int milliseconds) {
        this.customDismissDelay = true;
        this.dismissTimer.setInitialDelay(milliseconds);
    }

    public void resetDismissDelay() {
        this.customDismissDelay = false;
    }

    private void initialTimerFired() {
        if (this.insideNode != null && this.isShowing(this.insideNode)) {
            if (this.toolTipText == null && this.inputEvent != null) {
                this.toolTipText = this.getToolTipText(this.inputEvent);
                this.preferredLocation = this.getToolTipLocation(this.inputEvent);
            }
            if (this.toolTipText != null) {
                this.showImmediately = true;
                this.showTipWindow();
            } else {
                this.insideNode = null;
                this.toolTipText = null;
                this.preferredLocation = null;
                this.inputEvent = null;
                this.hideTipWindow();
            }
        }
    }

    private void reshowTimerFired() {
        this.showImmediately = false;
    }

    private void dismissTimerFired() {
        this.hideTipWindow();
        this.initialTimer.stop();
        this.showImmediately = false;
        this.insideNode = null;
        this.inputEvent = null;
    }

    public void mouseEntered(PInputEvent event) {
        this.handleMouseEntered(event);
    }

    public void mouseExited(PInputEvent event) {
        if (event.getPickedNode() == this.insideNode) {
            PCanvas canvas;
            Window win;
            this.initialTimer.stop();
            if (this.tipPopup != null && (win = SwingUtilities.getWindowAncestor(canvas = this.getCanvas())) != null) {
                boolean locationInToolTip;
                Point2D canvasPosition2D = event.getCanvasPosition();
                Point canvasPosition = new Point((int)canvasPosition2D.getX(), (int)canvasPosition2D.getY());
                Point location = SwingUtilities.convertPoint(canvas, canvasPosition, win);
                Rectangle bounds = canvas.getTopLevelAncestor().getBounds();
                location.x += bounds.x;
                location.y += bounds.y;
                Point loc = new Point(0, 0);
                SwingUtilities.convertPointToScreen(loc, this.tip);
                bounds.x = loc.x;
                bounds.y = loc.y;
                bounds.width = this.tip.getWidth();
                bounds.height = this.tip.getHeight();
                boolean bl = locationInToolTip = location.x >= bounds.x && location.x < bounds.x + bounds.width && location.y >= bounds.y && location.y < bounds.y + bounds.height;
                if (!locationInToolTip) {
                    this.hideNow();
                }
            }
        }
    }

    public void mousePressed(PInputEvent event) {
        this.handleMousePressed();
    }

    public void mouseDragged(PInputEvent event) {
    }

    public void mouseMoved(PInputEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else if (this.showImmediately) {
            PNode component = event.getPickedNode();
            this.toolTipText = this.getToolTipText(event);
            if (this.toolTipText != null) {
                this.preferredLocation = this.getToolTipLocation(event);
                this.inputEvent = event;
                this.insideNode = component;
                this.reshowTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideNode = event.getPickedNode();
            this.inputEvent = event;
            this.toolTipText = null;
            this.restartInitialTimer();
        }
    }

    public void keyPressed(PInputEvent event) {
        int keyCode = event.getKeyCode();
        int modifiers = event.getModifiers();
        boolean tipShownBefore = this.tipShowing;
        if (keyCode == 112 && modifiers == 2) {
            this.toggleToolTip(event);
        } else if (keyCode == 27 && modifiers == 0) {
            this.hideToolTip();
        }
        if (this.tipShowing != tipShownBefore) {
            event.setHandled(true);
        }
    }

    private void handleMousePressed() {
        this.initialTimer.stop();
        this.insideNode = null;
        this.inputEvent = null;
        this.hideTipWindow();
        this.showImmediately = false;
    }

    private void hideTipWindow() {
        if (this.tipPopup != null) {
            if (this.tipWindow != null) {
                this.tipWindow.removeMouseListener(this.windowMouseListener);
                this.tipWindow = null;
            }
            this.tipPopup.hide();
            this.tipPopup = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.dismissTimer.stop();
        }
    }

    private void hideToolTip() {
        this.hideTipWindow();
        this.preferredLocation = null;
        this.insideNode = null;
    }

    private void hideNow() {
        this.initialTimer.stop();
        this.insideNode = null;
        this.toolTipText = null;
        this.inputEvent = null;
        this.hideTipWindow();
        this.restartReshowTimer();
    }
}

