/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.EmpireDimension;
import com.empireclassic.Remote.EmpireError;
import com.empireclassic.Remote.EmpireStreamReader;
import com.empireclassic.Remote.IslandChangeEvent;
import com.empireclassic.Remote.IslandChangeListener;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.NationInfo;
import com.empireclassic.Remote.ParamInfo;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.SectorChangeEvent;
import com.empireclassic.Remote.SectorChangeListener;
import com.empireclassic.Remote.ShipType;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.Remote.YourShip;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEmpire {
    protected Socket comSocket;
    protected BufferedWriter writer;
    protected EmpireStreamReader reader;
    protected static RemoteEmpire instance = null;
    protected String serverName;
    protected int serverPortNum;
    protected CacheStrategy cacheStrategy = CacheStrategy.NONE;
    protected int mruCacheLimit = 10;
    protected Map<Integer, IslandInfo> islands = new HashMap<Integer, IslandInfo>();
    protected Map<Integer, CacheData> sectorCache = new HashMap<Integer, CacheData>();
    protected LinkedList<CacheData> mruCache = new LinkedList();
    protected List<IslandChangeListener> islandChangeListeners = new LinkedList<IslandChangeListener>();
    protected List<SectorChangeListener> sectorChangeListeners = new LinkedList<SectorChangeListener>();
    public static List<ShipType> shipTypeList;
    public static EmpireDimension worldSize;

    private RemoteEmpire(String serverName, int portNum) throws UnknownHostException, IOException {
        this.serverName = serverName;
        this.serverPortNum = portNum;
        this.comSocket = new Socket(serverName, portNum);
        this.writer = new BufferedWriter(new OutputStreamWriter(this.comSocket.getOutputStream()));
        this.reader = new EmpireStreamReader(this.comSocket.getInputStream());
        String response = this.reader.readResponse();
        shipTypeList = this.getShipTypeList();
        ParamInfo params = this.getParams();
        worldSize = params.getWorldSize();
    }

    public static RemoteEmpire getInstance(String serverName, int portNum) throws UnknownHostException, IOException {
        if (instance == null) {
            instance = new RemoteEmpire(serverName, portNum);
        }
        return instance;
    }

    public static RemoteEmpire getInstance() {
        if (instance == null) {
            throw new Error("RemoteEmpire not initialized");
        }
        return instance;
    }

    public void addIslandChangeListener(IslandChangeListener listener) {
        this.islandChangeListeners.add(listener);
    }

    public void addSectorChangeListener(SectorChangeListener listener) {
        this.sectorChangeListeners.add(listener);
    }

    private void fireIslandChanged(int islandNum) {
        for (IslandChangeListener listener : this.islandChangeListeners) {
            listener.islandChanged(new IslandChangeEvent(islandNum));
        }
    }

    private void fireSectorChanged(int islandNum, IslandCoord coord) {
        this.fireSectorChanged(islandNum, coord, coord);
    }

    private void fireSectorChanged(int islandNum, IslandCoord startCoord, IslandCoord endCoord) {
        for (SectorChangeListener listener : this.sectorChangeListeners) {
            listener.sectorChanged(new SectorChangeEvent(islandNum, startCoord, endCoord));
        }
    }

    private void fireSectorChanged(int islandNum) {
        IslandCoord startC = new IslandCoord(2, 2);
        IslandCoord endC = new IslandCoord(this.islands.get(islandNum).getSize());
        this.fireSectorChanged(islandNum, startC, endC);
    }

    public synchronized LoginReply login(String nationName, String password) {
        try {
            this.writer.write("login:" + nationName + ":" + password + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new LoginReply(response);
        }
        catch (IOException except) {
            return new LoginReply();
        }
    }

    public synchronized List<UserInfo> getUserList() {
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        try {
            String[] responses;
            this.writer.write("userlist\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            for (String user : responses = response.split("\n")) {
                String[] params = user.split(":");
                UserInfo ui = new UserInfo();
                ui.number = Integer.parseInt(params[0]);
                ui.logonTime = new Date(Long.parseLong(params[1]));
                ui.activityTime = new Date(Long.parseLong(params[2]));
                ui.radioChannel = Integer.parseInt(params[3]);
                ui.quote = params.length > 4 ? params[4] : "";
                userList.add(ui);
            }
        }
        catch (NumberFormatException except) {
            except.printStackTrace();
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return userList;
    }

    public synchronized Map<Integer, IslandInfo> getIslandList() {
        this.islands = new TreeMap<Integer, IslandInfo>();
        try {
            String[] islandsString;
            this.writer.write("islandinfo\n");
            this.writer.flush();
            String islandInfoString = this.reader.readResponse();
            islandInfoString = this.stripOk(islandInfoString);
            for (String islandString : islandsString = islandInfoString.split("\n")) {
                IslandInfo islandInfo = new IslandInfo(islandString);
                this.islands.put(islandInfo.getNumber(), islandInfo);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return this.islands;
    }

    public synchronized Map<IslandCoord, Sector> getSectors(int islandNum) {
        IslandInfo checkIsland = null;
        String fileName = "";
        try {
            if (this.getCacheStrategy() != CacheStrategy.NONE) {
                if (this.getCacheStrategy() == CacheStrategy.DISK) {
                    File cacheDir = new File(".empire");
                    cacheDir.mkdir();
                    fileName = ".empire/" + this.getServerName() + this.getServerPortNum() + islandNum;
                }
                checkIsland = this.getIsland(islandNum);
            }
            if (this.islands.size() == 0) {
                System.out.println("Entered getSectors with no island list");
            }
            boolean inMruCache = false;
            for (CacheData data : this.mruCache) {
                if (data.getIslandNum() != islandNum) continue;
                inMruCache = true;
                break;
            }
            if (this.getCacheStrategy() == CacheStrategy.NONE || this.islands.size() == 0 || this.sectorCache.size() == 0 || !this.sectorCache.containsKey(islandNum) || this.sectorCache.get(islandNum).getVersion() != this.getIsland(islandNum).getVersion()) {
                this.writer.write("sectorinfo:" + islandNum + "\n");
                this.writer.flush();
                String sectorInfoString = this.reader.readResponse();
                sectorInfoString = this.stripOk(sectorInfoString);
                String[] sectorsInfo = sectorInfoString.split("\n");
                HashMap<IslandCoord, Sector> sectors = new HashMap<IslandCoord, Sector>();
                for (String sectorInfo : sectorsInfo) {
                    Sector sector = new Sector(sectorInfo);
                    sectors.put(sector.getLocation(), sector);
                }
                if (this.islands.get(islandNum) == null) {
                    this.islands.put(islandNum, this.getIsland(islandNum));
                }
                this.sectorCache.put(islandNum, new CacheData(islandNum, this.islands.get(islandNum).getVersion(), sectors));
                if (this.getCacheStrategy() == CacheStrategy.DISK) {
                    File file = new File(fileName);
                    file.delete();
                    file.createNewFile();
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                    for (Sector sector : this.sectorCache.get(islandNum).getSectors().values()) {
                        oos.writeObject(sector);
                    }
                    for (CacheData data : this.mruCache) {
                        if (data.getIslandNum() != islandNum) continue;
                        this.mruCache.remove(data);
                        break;
                    }
                    this.mruCache.add(new CacheData(islandNum, this.islands.get(islandNum).getVersion(), this.sectorCache.get(islandNum).getSectors()));
                    if (this.mruCache.size() > this.mruCacheLimit) {
                        this.mruCache.remove();
                    }
                }
            } else if (this.getCacheStrategy() == CacheStrategy.DISK) {
                for (CacheData data : this.mruCache) {
                    if (data.getIslandNum() != islandNum) continue;
                    this.mruCache.remove(data);
                    break;
                }
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(fileName)));
                while (ois.available() != 0) {
                    try {
                        Sector sector = (Sector)ois.readObject();
                    }
                    catch (ClassNotFoundException except) {
                        except.printStackTrace();
                    }
                }
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return this.sectorCache.get(islandNum).getSectors();
    }

    public synchronized Map<Integer, NationInfo> getNationList() {
        TreeMap<Integer, NationInfo> nations = new TreeMap<Integer, NationInfo>();
        try {
            String[] nationsString;
            this.writer.write("nationinfo\n");
            this.writer.flush();
            String nationInfoString = this.reader.readResponse();
            nationInfoString = this.stripOk(nationInfoString);
            for (String nationString : nationsString = nationInfoString.split("\n")) {
                NationInfo nationInfo = new NationInfo(nationString);
                nations.put(nationInfo.getNationNum(), nationInfo);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return nations;
    }

    public synchronized LoginReply newNation(String nationName, String password) {
        try {
            this.writer.write("newnation:" + nationName + ":" + password + ":\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new LoginReply(response);
        }
        catch (IOException except) {
            return new LoginReply();
        }
    }

    public synchronized IslandInfo getIsland(int islandNumber) {
        IslandInfo info = null;
        try {
            this.writer.write("islandinfo:" + islandNumber + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            if (response.startsWith("OK")) {
                response = this.stripOk(response);
                info = new IslandInfo(response);
                this.islands.put(islandNumber, info);
            } else {
                info = null;
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return info;
    }

    public synchronized NationInfo getNation(int nationNumber) {
        NationInfo info = null;
        try {
            this.writer.write("nationinfo:" + nationNumber + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            info = new NationInfo(response);
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return info;
    }

    public synchronized ParamInfo getParams() {
        ParamInfo info = null;
        try {
            this.writer.write("params\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            info = new ParamInfo(response);
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return info;
    }

    public synchronized double date() {
        try {
            this.writer.write("date\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            EmpireError errorDate = new EmpireError(response);
            return Double.parseDouble(errorDate.errorString);
        }
        catch (IOException except) {
            except.printStackTrace();
            return 0.0;
        }
    }

    public synchronized String date(String gameDate) {
        String julianDate = new String();
        String response = "";
        try {
            this.writer.write("date:" + gameDate + "\n");
            this.writer.flush();
            response = this.reader.readResponse();
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        if (response.startsWith("OK")) {
            response = this.stripOk(response);
            return response;
        }
        EmpireError error = new EmpireError(response);
        return error.errorString;
    }

    public synchronized List<ShipType> getShipTypeList() {
        ArrayList<ShipType> shipTypeList = new ArrayList<ShipType>();
        try {
            String[] responses;
            this.writer.write("shipdata\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            for (String shipLine : responses = response.split("\n")) {
                shipTypeList.add(new ShipType(shipLine));
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return shipTypeList;
    }

    public synchronized Map<Integer, MyShip> getShipList() {
        TreeMap<Integer, MyShip> shipList = new TreeMap<Integer, MyShip>();
        try {
            String[] responses;
            this.writer.write("shipinfo\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            if (response.length() == 0) {
                return shipList;
            }
            for (String shipLine : responses = response.split("\n")) {
                MyShip ship = new MyShip(shipLine);
                shipList.put(ship.getShipNum(), ship);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return shipList;
    }

    public synchronized MyShip getShip(int shipNum) {
        try {
            this.writer.write("shipinfo:" + shipNum + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            if (response.startsWith("OK")) {
                response = this.stripOk(response);
                return new MyShip(response);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return null;
    }

    public synchronized List<String> getAlerts() {
        ArrayList<String> alerts = new ArrayList<String>();
        try {
            String[] responses;
            this.writer.write("alertlist\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            if (response.length() == 0) {
                return alerts;
            }
            for (String alertLine : responses = response.split("\n")) {
                alerts.add(alertLine);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return alerts;
    }

    public synchronized Map<Integer, YourShip> radar() {
        TreeMap<Integer, YourShip> ships = new TreeMap<Integer, YourShip>();
        try {
            this.writer.write("radarshipinfo\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            if (response.length() != 0) {
                String[] responses;
                for (String shipLine : responses = response.split("\n")) {
                    YourShip ship = new YourShip(shipLine);
                    ships.put(ship.getShipNum(), ship);
                }
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return ships;
    }

    public synchronized EmpireError setDes(int islandNumber, IslandCoord coord, int selection) {
        EmpireError error = new EmpireError();
        try {
            this.writer.write("sectorsetdes:" + islandNumber + ":" + coord + ":" + selection + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            if (!response.startsWith("OK")) {
                this.fireSectorChanged(islandNumber, coord);
                return new EmpireError(response);
            }
            return error;
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError move(int islandNum, char thing, String from, String to, int quantity, boolean test) {
        try {
            this.writer.write("sectormove:" + islandNum + ":" + from + ":" + to + ":" + thing + ":" + quantity);
            if (test) {
                this.writer.write(":test");
            }
            this.writer.write("\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError islandUpdate(int islandNum, int updateTime) {
        EmpireError error = new EmpireError();
        try {
            this.writer.write("islandupdate:" + islandNum + ":" + updateTime + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            if (!response.startsWith("OK")) {
                this.fireIslandChanged(islandNum);
                this.fireSectorChanged(islandNum);
                return new EmpireError(response);
            }
            return error;
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized SpreadTestReply spreadTest(int islandNum, Rectangle area, IslandCoord fromCoord, boolean mountains, boolean own) {
        try {
            this.writer.write("sectorspread:" + islandNum + ":" + area.x + "," + area.y + "," + (area.x + area.width - 1) + "," + (area.y + area.height - 1) + ":" + fromCoord.x + "," + fromCoord.y + ":");
            if (mountains) {
                this.writer.write("M");
            }
            if (own) {
                this.writer.write("O");
            }
            this.writer.write(":0:0,0:test\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new SpreadTestReply(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new SpreadTestReply();
        }
    }

    public synchronized EmpireError spread(int islandNum, Rectangle area, IslandCoord fromCoord, boolean mountains, boolean own, int civsPerSec, IslandCoord dumpCoord) {
        try {
            this.writer.write("sectorspread:" + islandNum + ":" + area.x + "," + area.y + "," + (area.x + area.width - 1) + "," + (area.y + area.height - 1) + ":" + fromCoord.x + "," + fromCoord.y + ":");
            if (mountains) {
                this.writer.write("M");
            }
            if (own) {
                this.writer.write("O");
            }
            this.writer.write(":" + civsPerSec + ":" + dumpCoord.x + "," + dumpCoord.y + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError setIslandName(int islandNum, String newName) {
        try {
            this.writer.write("islandsetname:" + islandNum + ":\"" + newName + "\"\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError launch(int islandNum, IslandCoord coord, String shipType) {
        try {
            this.writer.write("sectorbuildship:" + islandNum + ":" + coord + ":" + shipType + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError enlist(int islandNum, IslandCoord coord, int enlistNum) {
        try {
            this.writer.write("sectorenlist:" + islandNum + ":" + coord + ":" + enlistNum + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError radioSend(String message) {
        try {
            this.writer.write("alertsend:" + message + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized BuildPlanesReply buildPlanesTest(int islandNum, PlaneType type) {
        try {
            this.writer.write("islandbuildplanes:" + islandNum + ":" + (Object)((Object)type) + ":9999:test\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new BuildPlanesReply(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new BuildPlanesReply();
        }
    }

    public synchronized BuildPlanesReply BuildPlanes(int islandNum, PlaneType type, int numRequested) {
        try {
            this.writer.write("islandbuildplanes:" + islandNum + ":" + (Object)((Object)type) + ":" + numRequested + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new BuildPlanesReply(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new BuildPlanesReply();
        }
    }

    public synchronized EmpireError assignShipToFleet(int shipNum, int fleetNum) {
        try {
            this.writer.write("shipfleetassign:" + shipNum + ":" + fleetNum + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public EmpireError gatherToShip(int islandNum, int what, int howMuch, int maxTime) {
        return new EmpireError(-1, "");
    }

    public EmpireError setFleetCourse(int nationNum, int fleetNum, WorldCoord dest) {
        return new EmpireError(-1, "");
    }

    public synchronized AttackReply attackTest(int islandNum, IslandCoord from, IslandCoord to) {
        return this.realAttack(islandNum, from, to, 1, true);
    }

    public synchronized AttackReply attack(int islandNum, IslandCoord from, IslandCoord to, int numAttacking) {
        return this.realAttack(islandNum, from, to, numAttacking, false);
    }

    private AttackReply realAttack(int islandNum, IslandCoord from, IslandCoord to, int numAttacking, boolean test) {
        EmpireError error = new EmpireError();
        boolean casualties = false;
        AttackReply ar = new AttackReply(0, new EmpireError(-1, "Network error"));
        try {
            this.writer.write("sectorattack:" + islandNum + ":" + from + ":" + to + ":" + numAttacking);
            if (test) {
                this.writer.write(":test");
            }
            this.writer.write("\n");
            this.writer.flush();
            ar = new AttackReply(this.reader.readResponse());
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return ar;
    }

    public synchronized EmpireError shipUndock(int shipNum) {
        try {
            this.writer.write("shipundock:" + shipNum + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError shipLoadUnload(int shipNum, String what, int quantity) {
        try {
            this.writer.write("shiploadunload:" + shipNum + ":" + what + ":" + quantity + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized AssaultTestReply shipAssaultTest(int shipNum) {
        String response = null;
        try {
            this.writer.write("shipassault:" + shipNum + ":0:test\n");
            this.writer.flush();
            response = this.reader.readResponse();
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return new AssaultTestReply(response);
    }

    public synchronized AssaultReply shipAssault(int shipNum, int numAttacking) {
        try {
            this.writer.write("shipassault:" + shipNum + ":" + numAttacking + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new AssaultReply(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new AssaultReply();
        }
    }

    public EmpireError shipSubmerge(int shipNum) {
        return new EmpireError(-1, "");
    }

    public EmpireError shipEmerge(int shipNum) {
        return new EmpireError(-1, "");
    }

    public EmpireError shipMine(int shipNum, int numMines) {
        return new EmpireError(-1, "");
    }

    public synchronized EmpireError shipMove(int shipNum, double direction, double distance) {
        try {
            this.writer.write("shipmove:" + shipNum + ":" + direction + ":" + distance + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError shipSetCourse(int shipNum, WorldCoord dest, double speed) {
        try {
            this.writer.write("shipsetcourse:" + shipNum + ":" + dest + ":" + speed + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPortNum() {
        return this.serverPortNum;
    }

    private String stripOk(String responseString) {
        String newString = new String();
        if (responseString.length() - 3 < responseString.indexOf("\n") + 1) {
            return "";
        }
        newString = responseString.substring(responseString.indexOf("\n") + 1, responseString.length() - 2);
        if (newString.charAt(newString.length() - 1) == '\n') {
            newString = newString.substring(0, newString.length() - 1);
        }
        return newString;
    }

    public void close() {
        try {
            this.comSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public EmpireDimension getWorldSize() {
        return worldSize;
    }

    public void setWorldSize(EmpireDimension worldSize) {
        RemoteEmpire.worldSize = worldSize;
    }

    public synchronized List<Mail> getMailList() {
        LinkedList<Mail> mailList = new LinkedList<Mail>();
        try {
            String[] responses;
            this.writer.write("mailinfo\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            response = this.stripOk(response);
            for (String message : responses = response.split("\n")) {
                if (message.startsWith("OK") || message.length() == 0) continue;
                Mail mail = new Mail(message);
                mailList.add(mail);
            }
        }
        catch (IOException except) {
            except.printStackTrace();
        }
        return mailList;
    }

    public synchronized EmpireError getMail(int id) {
        try {
            this.writer.write("mailget:" + id + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public synchronized EmpireError sendMail(int to, String subject, String message) {
        try {
            this.writer.write("mailsend:" + to + ":" + subject + ":" + message + "\n");
            this.writer.flush();
            String response = this.reader.readResponse();
            return new EmpireError(response);
        }
        catch (IOException except) {
            except.printStackTrace();
            return new EmpireError(-1, "");
        }
    }

    public CacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public int getMruCacheLimit() {
        return this.mruCacheLimit;
    }

    public void setMruCacheLimit(int mruCacheLimit) {
        this.mruCacheLimit = mruCacheLimit;
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public class Mail {
        private int id;
        private String from;
        private String subject;
        private double date;
        private MailStatus status;

        public Mail(String input) {
            try {
                String[] parts = input.split(":");
                this.id = Integer.parseInt(parts[0]);
                this.status = parts[1].equals("NEW") ? MailStatus.NEW : MailStatus.OLD;
                this.date = Double.parseDouble(parts[2]);
                this.from = parts[3];
                this.subject = parts[4];
            }
            catch (Exception except) {
                System.out.println("Input = " + input);
                except.printStackTrace();
            }
        }

        public double getDate() {
            return this.date;
        }

        public String getFrom() {
            return this.from;
        }

        public int getId() {
            return this.id;
        }

        public MailStatus getStatus() {
            return this.status;
        }

        public String getSubject() {
            return this.subject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MailStatus {
        NEW,
        OLD;

    }

    public class AssaultReply {
        private EmpireError error;
        private boolean won = true;
        private int casualties = 0;
        private int enemyLosses = 0;

        public AssaultReply() {
            this.error = new EmpireError(-1, "");
        }

        public AssaultReply(String response) {
            String[] lines;
            this.error = new EmpireError(response);
            for (String line : lines = response.split("\n")) {
                if (line.startsWith("results:los")) {
                    this.won = false;
                }
                if (line.startsWith("casualties:")) {
                    this.casualties = Integer.parseInt(line.substring(11));
                }
                if (!line.startsWith("enemylosses:")) continue;
                this.enemyLosses = Integer.parseInt(line.substring(12));
            }
        }

        public EmpireError getError() {
            return this.error;
        }

        public int getCasualties() {
            return this.casualties;
        }

        public int getEnemyLosses() {
            return this.enemyLosses;
        }

        public boolean isWon() {
            return this.won;
        }
    }

    public class AssaultTestReply {
        private EmpireError error;
        private int expectedCasualties = 0;

        AssaultTestReply(String response) {
            this.error = new EmpireError(response);
            if (this.error.errorNum == 0) {
                String[] lines = response.split("\n");
                this.expectedCasualties = Integer.parseInt(lines[1]);
            }
        }

        public EmpireError getError() {
            return this.error;
        }

        public void setError(EmpireError error) {
            this.error = error;
        }

        public int getExpectedCasualties() {
            return this.expectedCasualties;
        }

        public void setExpectedCasualties(int expectedCasualties) {
            this.expectedCasualties = expectedCasualties;
        }
    }

    public class AttackReply {
        private int casualties;
        private int enemyCasualties;
        private boolean won;
        private EmpireError error;

        public AttackReply(int casualties, EmpireError error) {
            this.casualties = casualties;
            this.error = error;
        }

        public AttackReply(String response) {
            this.error = new EmpireError(response);
            this.won = true;
            if (this.error.errorNum == 0) {
                String[] lines;
                for (String line : lines = response.split("\n")) {
                    if (line.startsWith("casualties:")) {
                        this.casualties = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                        continue;
                    }
                    if (line.startsWith("enemycasualties:")) {
                        this.enemyCasualties = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                        continue;
                    }
                    if (!line.startsWith("LOST")) continue;
                    this.won = false;
                }
            } else {
                this.casualties = 0;
            }
        }

        public int getCasualties() {
            return this.casualties;
        }

        public void setCasualties(int casualties) {
            this.casualties = casualties;
        }

        public int getEnemyCasualties() {
            return this.enemyCasualties;
        }

        public void setEnemyCasualties(int enemyCasualties) {
            this.enemyCasualties = enemyCasualties;
        }

        public boolean isWon() {
            return this.won;
        }

        public void setWon(boolean won) {
            this.won = won;
        }

        public EmpireError getError() {
            return this.error;
        }

        public void setError(EmpireError error) {
            this.error = error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlaneType {
        FIGHTER,
        BOMBER;

    }

    public class BuildPlanesReply {
        private int numPlanes;
        private EmpireError error;

        public BuildPlanesReply() {
            this.numPlanes = 0;
            this.error = new EmpireError();
        }

        public BuildPlanesReply(String response) {
            this.error = new EmpireError(response);
            if (this.error.errorNum == 0) {
                String[] lines = response.split("\n");
                this.numPlanes = Integer.parseInt(lines[1]);
            } else {
                this.numPlanes = -1;
            }
        }

        public EmpireError getError() {
            return this.error;
        }

        public void setError(EmpireError error) {
            this.error = error;
        }

        public int getNumPlanes() {
            return this.numPlanes;
        }

        public void setNumPlanes(int numPlanes) {
            this.numPlanes = numPlanes;
        }
    }

    public class SpreadTestReply {
        private EmpireError error;
        private int civiliansPerSector;
        private int sectors;

        public SpreadTestReply() {
            this.error = new EmpireError();
            this.civiliansPerSector = -1;
            this.sectors = -1;
        }

        public SpreadTestReply(String response) {
            this.error = new EmpireError(response);
            if (this.error.errorNum == 0) {
                String[] lines = response.split("\n");
                this.sectors = Integer.parseInt(lines[1].split(":")[1]);
                this.civiliansPerSector = Integer.parseInt(lines[2].split(":")[1]);
            } else {
                this.civiliansPerSector = -1;
                this.sectors = -1;
            }
        }

        public int getCiviliansPerSector() {
            return this.civiliansPerSector;
        }

        public void setCiviliansPerSector(int civiliansPerSector) {
            this.civiliansPerSector = civiliansPerSector;
        }

        public EmpireError getError() {
            return this.error;
        }

        public void setError(EmpireError error) {
            this.error = error;
        }

        public int getSectors() {
            return this.sectors;
        }

        public void setSectors(int sectors) {
            this.sectors = sectors;
        }
    }

    public class LoginReply {
        private int nationNum;
        private int homeIsland;
        private EmpireError error;

        public LoginReply() {
            this.nationNum = -1;
            this.homeIsland = -1;
            this.error = new EmpireError();
        }

        public LoginReply(String response) {
            this.error = new EmpireError(response);
            if (this.error.errorNum == 0) {
                String[] lines = response.split("\n");
                this.nationNum = Integer.parseInt(lines[1].split(":")[1]);
                this.homeIsland = Integer.parseInt(lines[3].split(":")[1]);
            } else {
                this.nationNum = -1;
                this.homeIsland = -1;
            }
        }

        public int getHomeIsland() {
            return this.homeIsland;
        }

        public void setHomeIsland(int homeIsland) {
            this.homeIsland = homeIsland;
        }

        public int getNationNum() {
            return this.nationNum;
        }

        public void setNationNum(int nationNum) {
            this.nationNum = nationNum;
        }

        public EmpireError getError() {
            return this.error;
        }

        public void setError(EmpireError error) {
            this.error = error;
        }
    }

    public class UserInfo {
        public int number;
        public Date logonTime;
        public Date activityTime;
        public int radioChannel;
        public String quote;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CacheData {
        private int islandNum;
        private int version;
        private Map<IslandCoord, Sector> sectors;

        public CacheData(int islandNum, int version, Map<IslandCoord, Sector> sectors) {
            this.islandNum = islandNum;
            this.version = version;
            this.sectors = sectors;
        }

        public int getIslandNum() {
            return this.islandNum;
        }

        public void setIslandNum(int islandNum) {
            this.islandNum = islandNum;
        }

        public Map<IslandCoord, Sector> getSectors() {
            return this.sectors;
        }

        public void setSectors(Map<IslandCoord, Sector> sectors) {
            this.sectors = sectors;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheStrategy {
        NONE,
        MEMORY,
        DISK;

    }
}

