/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.reports;

import com.empireclassic.Remote.MyShip;
import com.empireclassic.jec.reports.JECReport;
import java.awt.Frame;
import java.awt.Point;

public class ShipsReport
extends JECReport {
    String[] columnNames = new String[]{"Number", "Fleet", "Style", "Location", "Civilians", "Military", "Artillery", "Shells", "Fighters", "Fuel", "Efficiency", "Time", "Destination"};

    public ShipsReport(Frame frame) {
        super(frame, "Ships Report");
        try {
            this.setColumns(this.columnNames);
            for (MyShip ship : this.empire.getShipList().values()) {
                this.rowData[0] = new Integer(ship.getShipNum());
                this.rowData[1] = new Integer(ship.getFleet());
                this.rowData[2] = ship.getType().getName();
                this.rowData[3] = new String((int)ship.getLoc().getX() + "," + (int)ship.getLoc().getY());
                this.rowData[4] = new Integer(ship.getCivilians());
                this.rowData[5] = new Integer(ship.getMilitary());
                this.rowData[6] = new Integer(ship.getArtillery());
                this.rowData[7] = new Integer(ship.getShells());
                this.rowData[8] = new Integer(ship.getFighters());
                this.rowData[9] = new Float(ship.getOre());
                this.rowData[10] = new Integer(ship.getEff());
                this.rowData[11] = new Float(ship.getTime());
                this.rowData[12] = !ship.getDest().equals(new Point(-1, -1)) ? new String((int)ship.getDest().getX() + "," + (int)ship.getDest().getY()) : (ship.isDocked() ? new String("[docked]") : new String(""));
                this.model.addRow(this.rowData);
            }
            this.setPreferredWidths();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

