/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class EmpireProperties {
    private String url;
    private String gameUrl;
    private String defaultHost;
    private int defaultPort;
    private String defaultUser;
    private String defaultPassword;
    Properties props = new Properties();
    Properties gameProps = new Properties();

    public EmpireProperties(String url) {
        this.url = url;
        if (new File(url).exists()) {
            try {
                this.props.load(new FileInputStream(url));
            }
            catch (FileNotFoundException except) {
                except.printStackTrace();
            }
            catch (IOException except) {
                except.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            this.props.store(new FileOutputStream(this.url), "JEC");
            this.gameProps.store(new FileOutputStream(this.gameUrl), "Game Specific Properties");
        }
        catch (Exception except) {
            except.printStackTrace();
        }
    }

    public void setGameProps(String url) {
        if (new File(url).exists()) {
            try {
                this.gameProps.load(new FileInputStream(url));
            }
            catch (FileNotFoundException except) {
                except.printStackTrace();
            }
            catch (IOException except) {
                except.printStackTrace();
            }
        }
        this.gameUrl = url;
    }

    public String getDefaultHost() {
        this.defaultHost = this.props.getProperty("default.host", "empire.floogle.net");
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.props.setProperty("default.host", defaultHost);
    }

    public String getDefaultPassword() {
        this.defaultPassword = this.props.getProperty("default.pass", "");
        return this.defaultPassword;
    }

    public void setDefaultPassword() {
    }

    public int getDefaultPort() {
        this.defaultPort = new Integer(this.props.getProperty("default.port", "8282"));
        return this.defaultPort;
    }

    public void setDefaultPort(int port) {
        this.props.setProperty("default.port", Integer.toString(port));
    }

    public String getDefaultUser() {
        this.defaultUser = this.props.getProperty("default.user", "empire4");
        return this.defaultUser;
    }

    public String getMapWindowSize() {
        return this.gameProps.getProperty("mapWindow.size", "-1,-1");
    }

    public Rectangle getMapWindowRect() {
        String mapSizeString = this.gameProps.getProperty("mapWindow.size", "-1,-1");
        StringTokenizer mssTokens = new StringTokenizer(mapSizeString, ",");
        int mapWidth = new Integer(mssTokens.nextToken());
        int mapHeight = new Integer(mssTokens.nextToken());
        String mapLocString = this.gameProps.getProperty("mapWindow.location", "-1,-1");
        StringTokenizer mlsTokens = new StringTokenizer(mapLocString, ",");
        int mapX = new Integer(mlsTokens.nextToken());
        int mapY = new Integer(mlsTokens.nextToken());
        return new Rectangle(mapX, mapY, mapWidth, mapHeight);
    }

    public void setMapWindowRect(Rectangle mapRect) {
        String mapLocationString = new String(new Integer(mapRect.x).toString() + "," + new Integer(mapRect.y).toString());
        this.gameProps.setProperty("mapWindow.location", mapLocationString);
        String mapSizeString = new String(new Integer(mapRect.width).toString() + "," + new Integer(mapRect.height).toString());
        this.gameProps.setProperty("mapWindow.size", mapSizeString);
    }

    public Rectangle getMapBounds() {
        String mapBoundsString = this.gameProps.getProperty("mapWindow.bounds", "-1,-1,-1,-1");
        StringTokenizer mbsTokens = new StringTokenizer(mapBoundsString, ",");
        Rectangle initialView = new Rectangle();
        initialView.x = new Integer(mbsTokens.nextToken());
        initialView.y = new Integer(mbsTokens.nextToken());
        initialView.width = new Integer(mbsTokens.nextToken());
        initialView.height = new Integer(mbsTokens.nextToken());
        return initialView;
    }

    public void setMapBounds(Rectangle mapBounds) {
        String mapBoundsString = new String(mapBounds.x + "," + mapBounds.y + "," + mapBounds.width + "," + mapBounds.height);
        this.gameProps.setProperty("mapWindow.bounds", mapBoundsString);
    }

    public void setMapScale(double scale) {
        String mapScale = new Double(scale).toString();
        this.gameProps.setProperty("mapWindow.scale", mapScale);
    }

    public int getMapSplit() {
        String mainSplitString = this.gameProps.getProperty("mapWindow.split", "500");
        return new Integer(mainSplitString);
    }

    public void setMapSplit(int split) {
        this.gameProps.setProperty("mapWindow.split", new Integer(split).toString());
    }

    public int getDetailsSplit() {
        String detailsSplitString = this.gameProps.getProperty("detailWindow.split", "350");
        return new Integer(detailsSplitString);
    }

    public void setDetailsSplit(int split) {
        this.gameProps.setProperty("detailWindow.split", new Integer(split).toString());
    }

    public int getChatSplit() {
        String chatSplitString = this.gameProps.getProperty("chatWindow.split", "50");
        return new Integer(chatSplitString);
    }

    public void setChatSplit(int split) {
        this.gameProps.setProperty("chatWindow.split", new Integer(split).toString());
    }

    public String getShipsTableConfig() {
        return this.gameProps.getProperty("ships.Config", "");
    }

    public void setShipsTableConfig(String config) {
        this.gameProps.setProperty("ships.Config", config);
    }

    public String getNationsTableConfig() {
        return this.gameProps.getProperty("nations.Config", "");
    }

    public void setNationsTableConfig(String config) {
        this.gameProps.setProperty("nations.Config", config);
    }

    public String getIslandsTableConfig() {
        return this.gameProps.getProperty("islands.Config", "");
    }

    public void setIslandsTableConfig(String config) {
        this.gameProps.setProperty("islands.Config", config);
    }

    public String getSectorsTableConfig() {
        return this.gameProps.getProperty("sectors.Config", "");
    }

    public void setSectorsTableConfig(String config) {
        this.gameProps.setProperty("sectors.Config", config);
    }
}

