/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.EmpireError;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.NationInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.SelectionMap;
import com.empireclassic.Remote.Ship;
import com.empireclassic.jec.EmpireLoad;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.fleetmenu.SelectFleetMenu;
import com.empireclassic.jec.islandmenu.AutoDesignate;
import com.empireclassic.jec.islandmenu.IslandBuildPlanes;
import com.empireclassic.jec.islandmenu.IslandDraftDialog;
import com.empireclassic.jec.islandmenu.IslandFleetCreate;
import com.empireclassic.jec.islandmenu.IslandRenameDialog;
import com.empireclassic.jec.islandmenu.IslandUpdateDialog;
import com.empireclassic.jec.islandmenu.SectorReport;
import com.empireclassic.jec.maputils.CircleNode;
import com.empireclassic.jec.sectormenu.SelectSectorMenu;
import com.empireclassic.jec.shipmenu.SelectShipMenu;
import com.empireclassic.jec.utils.ProgressWindow;
import com.empireclassic.jec.utils.SwingWorker;
import com.empireclassic.jec.utils.UiUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class FrameListener
extends PBasicInputEventHandler {
    private JECFrame frame;
    private CircleNode testRadar;
    private Sector lastSectMovedOver = null;

    public FrameListener(JECFrame frame) {
        this.frame = frame;
        PInputEventFilter filter = new PInputEventFilter();
        filter.setAcceptsKeyPressed(true);
        filter.setAcceptsMouseWheelRotated(true);
        filter.setAcceptsMousePressed(true);
        filter.setAcceptsMouseReleased(true);
        filter.setAcceptsMouseMoved(true);
        filter.setAcceptsMouseEntered(true);
        filter.setAcceptsMouseExited(true);
        this.setEventFilter(filter);
    }

    public void keyPressed(PInputEvent event) {
        super.keyPressed(event);
        System.out.println("got key " + event.getKeyChar());
    }

    public void mouseWheelRotated(PInputEvent event) {
        if (event.isMouseWheelEvent()) {
            PBounds bounds = event.getCamera().getViewBounds();
            Rectangle rect = bounds.getBounds();
            double targetScale = (double)event.getWheelRotation() * 0.1;
            rect.grow((int)((double)rect.width * targetScale), (int)((double)rect.height * targetScale));
            bounds.setRect((Rectangle2D)rect);
            if (targetScale > 0.0 && event.getCamera().getViewScale() >= 0.5 || targetScale < 0.0 && event.getCamera().getViewScale() <= 30.0 || event.isControlDown()) {
                event.getCamera().scaleViewAboutPoint(1.0 - targetScale, event.getPosition().getX(), event.getPosition().getY());
            }
            this.frame.setWheelAdjustingScale(true);
            this.frame.setZoomValue(this.scaleToZoom(event.getCamera().getViewScale()));
            this.frame.setWheelAdjustingScale(false);
        }
    }

    private double zoomToScale(int zoom) {
        return (double)zoom / 3.3 - 0.5;
    }

    private int scaleToZoom(double scale) {
        return (int)(scale + 1.65);
    }

    public void mousePressed(PInputEvent event) {
        if (this.frame.getFrameState() == JECFrame.State.PANANDZOOM) {
            String title;
            super.mousePressed(event);
            System.out.println("mouse pressed event");
            Point2D canvasPoint = (Point2D)event.getPosition().clone();
            if (event.getButton() == 1) {
                PNode node = event.getPickedNode();
                if (node.getAttribute((Object)"ISLAND") != null) {
                    IslandInfo island = (IslandInfo)node.getAttribute((Object)"ISLAND");
                    if (!event.isShiftDown()) {
                        this.frame.getMapCanvas().clearIslandSelection();
                    }
                    this.frame.getMapCanvas().setIslandSelected(island.getNumber(), true);
                }
                if (event.getClickCount() > 1 && node.getAttribute((Object)"ISLAND") != null) {
                    PBounds newBounds = (PBounds)node.getBounds().clone();
                    newBounds.y -= 8.0;
                    newBounds.height += 10.0;
                    newBounds.width = 55.0;
                    this.frame.getMapCanvas().setView(newBounds.getBounds());
                }
            }
            JPopupMenu popup = new JPopupMenu();
            boolean somethingToShow = false;
            Point coord = new Point((int)canvasPoint.getX(), (int)canvasPoint.getY());
            PNode pickedNode = null;
            if (event.getPickedNode().getAttribute((Object)"SHIP") != null) {
                Ship ship = (Ship)event.getPickedNode().getAttribute((Object)"SHIP");
                if (!event.isShiftDown()) {
                    this.frame.getMapCanvas().clearShipSelection();
                }
                this.frame.getMapCanvas().setShipSelected(ship.getShipNum(), true);
                if (event.getButton() == 3) {
                    SelectShipMenu selectShipMenu;
                    String title2;
                    HashMap<Integer, MyShip> fleetList = new HashMap<Integer, MyShip>();
                    if (ship instanceof MyShip) {
                        MyShip myShip = (MyShip)ship;
                        fleetList.put(new Integer(myShip.getFleet()), myShip);
                        title = new String(ship.getType().getName() + " #" + ship.getShipNum());
                        SelectShipMenu selectShipMenu2 = new SelectShipMenu(this.frame, title, event.getPickedNode());
                        popup.add(selectShipMenu2);
                        somethingToShow = true;
                    }
                    Map<Integer, MyShip> myShips = this.frame.getShipList();
                    Map yourShips = RemoteEmpire.getInstance().radar();
                    for (MyShip anotherShip : myShips.values()) {
                        if (!anotherShip.getLoc().equals((Object)coord) || anotherShip.getShipNum() == ship.getShipNum()) continue;
                        title2 = new String(anotherShip.getType().getName() + " #" + anotherShip.getShipNum());
                        selectShipMenu = new SelectShipMenu(this.frame, title2, (PNode)Globals.shipNodeList.get(anotherShip.getShipNum()));
                        popup.add(selectShipMenu);
                        fleetList.put(new Integer(anotherShip.getFleet()), anotherShip);
                    }
                    for (MyShip anotherShip : yourShips.values()) {
                        if (!anotherShip.getLoc().equals((Object)coord) || anotherShip.getShipNum() == ship.getShipNum()) continue;
                        title2 = new String(anotherShip.getType() + " #" + anotherShip.getShipNum());
                        selectShipMenu = new SelectShipMenu(this.frame, title2, (PNode)Globals.shipNodeList.get(anotherShip.getShipNum()));
                        popup.add(selectShipMenu);
                    }
                    for (MyShip fleetShip : fleetList.values()) {
                        if (fleetShip.getFleet() == 0) continue;
                        SelectFleetMenu fleetMenu = new SelectFleetMenu(this.frame, "Fleet " + fleetShip.getFleet(), fleetShip.getFleet());
                        popup.add(fleetMenu);
                    }
                    pickedNode = this.frame.getMapCanvas().findIslandNodeUnder(coord);
                }
            }
            if (event.getPickedNode().getAttribute((Object)"ISLAND") != null && event.getButton() == 3) {
                pickedNode = event.getPickedNode();
            }
            this.frame.setLastSelectedNode(pickedNode);
            if (pickedNode != null) {
                if (event.getClickCount() > 1) {
                    System.out.println("detected here, too");
                }
                IslandInfo island = (IslandInfo)pickedNode.getAttribute((Object)"ISLAND");
                coord.translate(-island.getLocation().x + 1, -island.getLocation().y + 1);
                IslandCoord sectorCoord = new IslandCoord(coord.x, coord.y);
                Sector sector = (Sector)this.frame.getIslandsTableModel().getIsland(island.getNumber()).getSectors().get(sectorCoord);
                title = new String(island.getName() + " sector " + (int)coord.getX() + "," + (int)coord.getY());
                if (sector != null && sector.getOwner() == Globals.nationNum) {
                    SelectSectorMenu selectSectorMenu = new SelectSectorMenu(this.frame, title, pickedNode, sectorCoord);
                    JPopupMenu sectorPopup = new JPopupMenu();
                    popup.add(selectSectorMenu);
                }
                JMenu planesMenu = new JMenu("Build");
                planesMenu.add(new AbstractAction("Fleet"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.buildFleetActionPerformed(event);
                    }
                });
                planesMenu.add(new AbstractAction("Fighters"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.buildFightersActionPerformed(event);
                    }
                });
                planesMenu.add(new AbstractAction("Bombers"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.buildBombersActionPerformed(event);
                    }
                });
                popup.add(planesMenu);
                popup.add(new AbstractAction("Stipulate"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.stipulateActionPerformed(event);
                    }
                });
                popup.add(new AbstractAction("Draft"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.islandDraftActionPerformed(event);
                    }
                });
                popup.add(new AbstractAction("Sector report"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.sectorReportActionPerformed(event);
                    }
                });
                popup.add(new AbstractAction("Island update"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.islandUpdateActionPerformed(event);
                    }
                });
                popup.addSeparator();
                popup.add(new AbstractAction("Island rename"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.islandRenameActionPerformed(event);
                    }
                });
                popup.addSeparator();
                popup.add(new AbstractAction("Resync this island"){

                    public void actionPerformed(ActionEvent event) {
                        FrameListener.this.resyncIslandActionPerformed(event);
                    }
                });
                somethingToShow = true;
            }
            if (somethingToShow) {
                Point2D where = this.frame.getMapCanvas().getCamera().viewToLocal(event.getPosition());
                popup.show((Component)((Object)this.frame.getMapCanvas()), (int)where.getX(), (int)where.getY());
            }
        }
        if (event.getButton() == 1) {
            this.frame.getMapCanvas().setCursor(new Cursor(12));
        }
    }

    public void mouseReleased(PInputEvent event) {
        super.mouseReleased(event);
        System.out.println("mouse released event");
        this.frame.getMapCanvas().setCursor(this.frame.getCrossHairCursor());
        this.testRadar = null;
    }

    public void mouseMoved(PInputEvent event) {
        super.mouseMoved(event);
        if (event.isHandled()) {
            return;
        }
        String text = new Integer((int)event.getPosition().getX()).toString() + "," + new Integer((int)event.getPosition().getY()).toString();
        PPickPath pickPath = event.getPath();
        PStack nodeStack = pickPath.getNodeStackReference();
        Iterator i = nodeStack.iterator();
        String sectorText = " ";
        while (i.hasNext()) {
            PNode y;
            PNode x = (PNode)i.next();
            if (x.getAttribute((Object)"ISLAND") != null) {
                sectorText = this.statusInfo(x, event);
                continue;
            }
            if (x.getAttribute((Object)"SHIP") == null) continue;
            Ship ship = (Ship)x.getAttribute((Object)"SHIP");
            if (!(ship instanceof MyShip)) {
                NationInfo nation = RemoteEmpire.getInstance().getNation(ship.getOwner());
                text = text + " " + nation.getName();
            }
            text = text + "; " + ship.getType().getName() + " #" + ship.getShipNum();
            if (ship instanceof MyShip) {
                text = text + "[" + ((MyShip)ship).getTime() + "]";
            }
            if ((y = this.frame.getMapCanvas().findIslandNodeUnder((Point)ship.getLoc())) == null) continue;
            sectorText = this.statusInfo(y, event);
        }
        this.frame.setStatusDisplay(text);
        this.frame.setSectorInfoDisplay(sectorText);
    }

    private String statusInfo(PNode x, PInputEvent event) {
        IslandInfo info = (IslandInfo)x.getAttribute((Object)"ISLAND");
        String sectorText = info.getName() + "[" + info.getNumber() + "]: ";
        int sectX = (int)(event.getPosition().getX() - info.getLocation().getX()) + 1;
        sectorText = sectorText + new Integer(sectX).toString();
        sectorText = sectorText + ",";
        int sectY = (int)(event.getPosition().getY() - info.getLocation().getY()) + 1;
        sectorText = sectorText + new Integer(sectY).toString();
        Sector sector = null;
        sector = this.lastSectMovedOver == null || !this.lastSectMovedOver.getLocation().equals((Object)new IslandCoord(sectX, sectY)) ? (Sector)info.getSectors().get(new IslandCoord(sectX, sectY)) : this.lastSectMovedOver;
        if (sector != null && sector.getOwner() > 0) {
            NationInfo ni = RemoteEmpire.getInstance().getNation(sector.getOwner());
            sectorText = sectorText + " -- " + ni.getName();
            if (sector.getTerrain() != Sector.Des.WATER) {
                sectorText = sectorText + ": " + sector.getCivilians() + " civilians; " + sector.getMilitary() + " military;" + sector.getGuns() + " artillery; " + sector.getShells() + " shells";
                if (sector.getDes() == Sector.Des.AIRPORT) {
                    sectorText = sectorText + "; " + sector.getFighters() + " fighters; " + sector.getBombers() + " bombers";
                }
                if (sector.getDes() == Sector.Des.CAPITOL || sector.getDes() == Sector.Des.SANCTUARY) {
                    sectorText = sectorText + "; " + sector.getTimeLeft() + "/" + sector.getTimeRight() + " time";
                }
                if (sector.getDes() == Sector.Des.DOCK) {
                    sectorText = sectorText + "; " + sector.getProduction() + " production";
                }
            }
        }
        this.lastSectMovedOver = sector;
        return sectorText;
    }

    public void buildFleetActionPerformed(ActionEvent event) {
        int lowestUnusedFleetNum;
        Vector<Integer> fleetNumsInUse = new Vector<Integer>();
        for (MyShip ship : this.frame.getShipList().values()) {
            fleetNumsInUse.add(ship.getFleet());
        }
        for (lowestUnusedFleetNum = 1; lowestUnusedFleetNum < 1000 && fleetNumsInUse.contains(lowestUnusedFleetNum); ++lowestUnusedFleetNum) {
        }
        final IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        IslandFleetCreate fleetCreateWindow = new IslandFleetCreate(null, island, lowestUnusedFleetNum);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = fleetCreateWindow.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        fleetCreateWindow.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        fleetCreateWindow.setVisible(true);
        boolean progressCounter = false;
        if (!fleetCreateWindow.cancelled()) {
            final int fleetNum = fleetCreateWindow.getFleetNum();
            final Vector buildList = fleetCreateWindow.getBuildList();
            final boolean gatherOre = fleetCreateWindow.getGatherOre();
            final boolean gatherGuns = fleetCreateWindow.getGatherGuns();
            final boolean gatherShells = fleetCreateWindow.getGatherShells();
            final boolean gatherMilitary = fleetCreateWindow.getGatherMilitary();
            this.frame.getProgressStatus().setVisible(true);
            this.frame.getProgressStatus().setString("Building Fleet #" + fleetNum);
            this.frame.getProgressStatus().setMaximum(buildList.size());
            this.frame.getProgressStatus().setIndeterminate(false);
            SwingWorker fleetCreate = new SwingWorker(){

                public Object construct() {
                    Iterator i = buildList.iterator();
                    RemoteEmpire empire = RemoteEmpire.getInstance();
                    while (i.hasNext()) {
                        IslandFleetCreate.BuildTableEntry build = (IslandFleetCreate.BuildTableEntry)i.next();
                        StringTokenizer quadTokens = new StringTokenizer(build.quad, ", ");
                        IslandCoord sector = new IslandCoord(new Integer(quadTokens.nextToken()).intValue(), new Integer(quadTokens.nextToken()).intValue());
                        EmpireError error = empire.launch(island.getNumber(), sector, build.shipType.trim());
                        if (error.errorNum != 0) continue;
                        FrameListener.this.updateFleetLaunch("You have launched ship #" + error.errorString, 1);
                        empire.assignShipToFleet(Integer.parseInt(error.errorString), fleetNum);
                        FrameListener.this.updateFleetLaunch("Loading ship " + error.errorString, 0);
                        if (gatherOre) {
                            empire.gatherToShip(island.getNumber(), 0, 99, 0);
                        }
                        if (gatherGuns) {
                            empire.gatherToShip(island.getNumber(), 1, 99, 1);
                        }
                        if (gatherShells) {
                            empire.gatherToShip(island.getNumber(), 2, 99, 1);
                        }
                        if (!gatherMilitary) continue;
                        empire.gatherToShip(island.getNumber(), 3, 99, 1);
                    }
                    FrameListener.this.updateFleetLaunch("", 0);
                    return new Integer(1);
                }

                public void finished() {
                    FrameListener.this.frame.getProgressStatus().setIndeterminate(true);
                    EmpireLoad loader = new EmpireLoad(FrameListener.this.frame);
                    loader.start();
                }
            };
            fleetCreate.start();
        }
    }

    private void updateFleetLaunch(final String status, final int increment) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                FrameListener.this.frame.getProgressStatus().setString(status);
                FrameListener.this.frame.getProgressStatus().setValue(FrameListener.this.frame.getProgressStatus().getValue() + increment);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void buildFightersActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        RemoteEmpire empire = RemoteEmpire.getInstance();
        RemoteEmpire.BuildPlanesReply reply = empire.buildPlanesTest(island.getNumber(), RemoteEmpire.PlaneType.FIGHTER);
        if (reply.getError().errorNum != 0) {
            JOptionPane.showMessageDialog(this.frame, reply.getError().errorString, "Error", 0);
        } else {
            IslandBuildPlanes buildFightersDialog = new IslandBuildPlanes(this.frame, "Build fighters", true, reply.getNumPlanes());
            UiUtil.centerAndShow(buildFightersDialog);
            if (!buildFightersDialog.cancelled()) {
                reply = empire.BuildPlanes(island.getNumber(), RemoteEmpire.PlaneType.FIGHTER, buildFightersDialog.getNumPlanes());
                if (reply.getError().errorNum != 0) {
                    JOptionPane.showMessageDialog(this.frame, reply.getError().errorString, "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.frame, "" + reply.getNumPlanes() + " planes built");
                    EmpireLoad loader = new EmpireLoad(this.frame);
                    loader.start();
                }
            }
        }
    }

    public void buildBombersActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        RemoteEmpire empire = RemoteEmpire.getInstance();
        RemoteEmpire.BuildPlanesReply reply = empire.buildPlanesTest(island.getNumber(), RemoteEmpire.PlaneType.BOMBER);
        if (reply.getError().errorNum != 0) {
            JOptionPane.showMessageDialog(this.frame, reply.getError().errorString, "Error", 0);
        } else {
            IslandBuildPlanes buildBombersDialog = new IslandBuildPlanes(this.frame, "Build bombers", true, reply.getNumPlanes());
            UiUtil.centerAndShow(buildBombersDialog);
            if (!buildBombersDialog.cancelled()) {
                reply = empire.BuildPlanes(island.getNumber(), RemoteEmpire.PlaneType.BOMBER, buildBombersDialog.getNumPlanes());
                if (reply.getError().errorNum != 0) {
                    JOptionPane.showMessageDialog(this.frame, reply.getError().errorString, "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.frame, "" + reply.getNumPlanes() + " planes built");
                    EmpireLoad loader = new EmpireLoad(this.frame);
                    loader.start();
                }
            }
        }
    }

    public void islandUpdateActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        IslandUpdateDialog updateWindow = new IslandUpdateDialog(this.frame, "Update", true);
        UiUtil.centerAndShow(updateWindow);
        if (updateWindow.getUpdateTime() != 0) {
            EmpireError error = RemoteEmpire.getInstance().islandUpdate(island.getNumber(), updateWindow.getUpdateTime());
            JOptionPane.showMessageDialog(this.frame, error.errorString, "Island Update", 1);
        }
        this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
        EmpireLoad loader = new EmpireLoad(this.frame);
        loader.start();
    }

    public void islandDraftActionPerformed(ActionEvent event) {
        final IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        IslandDraftDialog draftWindow = new IslandDraftDialog(this.frame, "Draft", true);
        UiUtil.centerAndShow(draftWindow);
        if (!draftWindow.cancelled() && draftWindow.getPercentDrafted() != 0) {
            SelectionMap selection = new SelectionMap(island);
            final Map sectors = island.getSectors();
            int sectorCount = 0;
            for (Sector sector : sectors.values()) {
                if (sector.getOwner() != Globals.nationNum) continue;
                ++sectorCount;
            }
            final ProgressWindow progress = new ProgressWindow((Frame)this.frame, "Drafting...", sectorCount);
            final int percentDrafted = draftWindow.getPercentDrafted();
            SwingWorker drafter = new SwingWorker(){

                public Object construct() {
                    for (Sector sector : sectors.values()) {
                        if (sector.getOwner() != Globals.nationNum) continue;
                        EmpireError error = RemoteEmpire.getInstance().enlist(island.getNumber(), sector.getLocation(), (int)((double)sector.getCivilians() * ((double)percentDrafted / 100.0)));
                        progress.updateStatus(sector.getLocation().toString(), 1);
                    }
                    return new Integer(0);
                }

                public void finished() {
                    super.finished();
                    FrameListener.this.frame.getIslandsTableModel().getIsland(island.getNumber()).getSectors();
                    FrameListener.this.frame.getMapCanvas().drawIsland(FrameListener.this.frame.getLastSelectedNode(), FrameListener.this.frame.getIslandsTableModel().getIsland(island.getNumber()));
                    progress.dispose();
                }
            };
            drafter.start();
        }
    }

    private void stipulateActionPerformed(ActionEvent event) {
        final IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        final Map sectors = island.getSectors();
        AutoDesignate stipulateForm = new AutoDesignate(this.frame, island, sectors);
        stipulateForm.setVisible(true);
        if (!stipulateForm.cancelled()) {
            final SelectionMap changeableMap = stipulateForm.getChangeableMap();
            final List<Sector> minesList = stipulateForm.getMinesList();
            final List<Sector> docksList = stipulateForm.getDocksList();
            final int artilleryCount = stipulateForm.getArtilleryCount();
            final int explosivesCount = stipulateForm.getExplosivesCount();
            final int planesCount = stipulateForm.getPlanesCount();
            final ProgressWindow progress = new ProgressWindow((Frame)this.frame, "Designating...", changeableMap.count());
            SwingWorker designater = new SwingWorker(){

                public Object construct() {
                    RemoteEmpire empire = RemoteEmpire.getInstance();
                    for (Sector sector : minesList) {
                        empire.setDes(island.getNumber(), sector.getLocation(), Sector.Des.MINE.getValue());
                        changeableMap.clearSelection(sector.getLocation());
                        progress.updateStatus(sector.getLocation().toString(), 1);
                    }
                    for (Sector sector : docksList) {
                        empire.setDes(island.getNumber(), sector.getLocation(), Sector.Des.DOCK.getValue());
                        changeableMap.clearSelection(sector.getLocation());
                        progress.updateStatus(sector.getLocation().toString(), 1);
                    }
                    ArrayList<Sector> changes = new ArrayList<Sector>();
                    for (Sector sector : sectors.values()) {
                        if (!changeableMap.isSelected(sector.getLocation())) continue;
                        changes.add(sector);
                    }
                    Collections.shuffle(changes);
                    int artCount = artilleryCount;
                    int expCount = explosivesCount;
                    int plaCount = planesCount;
                    for (int i = 0; i < changes.size(); ++i) {
                        if (artCount != 0) {
                            empire.setDes(island.getNumber(), ((Sector)changes.get(i)).getLocation(), Sector.Des.ARTILLERY.getValue());
                            progress.updateStatus(((Sector)changes.get(i)).getLocation().toString(), 1);
                            --artCount;
                            continue;
                        }
                        if (expCount != 0) {
                            empire.setDes(island.getNumber(), ((Sector)changes.get(i)).getLocation(), Sector.Des.EXPLOSIVE.getValue());
                            progress.updateStatus(((Sector)changes.get(i)).getLocation().toString(), 1);
                            --expCount;
                            continue;
                        }
                        if (plaCount == 0) continue;
                        empire.setDes(island.getNumber(), ((Sector)changes.get(i)).getLocation(), Sector.Des.PLANE.getValue());
                        progress.updateStatus(((Sector)changes.get(i)).getLocation().toString(), 1);
                        --plaCount;
                    }
                    return new Integer(0);
                }

                public void finished() {
                    super.finished();
                    FrameListener.this.frame.getIslandsTableModel().getIsland(island.getNumber()).getSectors();
                    FrameListener.this.frame.getMapCanvas().drawIsland(FrameListener.this.frame.getLastSelectedNode(), FrameListener.this.frame.getIslandsTableModel().getIsland(island.getNumber()));
                    progress.dispose();
                }
            };
            designater.start();
        }
    }

    private void sectorReportActionPerformed(ActionEvent event) {
        SectorReport sectorReport = new SectorReport(this.frame, this.frame.getLastSelectedNode());
        sectorReport.setVisible(true);
    }

    public void resyncIslandActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
    }

    public void islandRenameActionPerformed(ActionEvent event) {
        IslandInfo island = (IslandInfo)this.frame.getLastSelectedNode().getAttribute((Object)"ISLAND");
        IslandRenameDialog renameWindow = new IslandRenameDialog((Frame)this.frame, island.getName());
        UiUtil.centerAndShow(renameWindow);
        if (!renameWindow.cancelled()) {
            EmpireError error = RemoteEmpire.getInstance().setIslandName(island.getNumber(), renameWindow.getNewName());
            if (error.errorNum != 0) {
                JOptionPane.showMessageDialog(this.frame, error.errorString, "Island Rename", 1);
            }
        }
        this.frame.getMapCanvas().drawIsland(this.frame.getLastSelectedNode(), island);
    }

    public void mouseEntered(PInputEvent event) {
        super.mouseEntered(event);
    }

    public void mouseExited(PInputEvent arg0) {
        super.mouseExited(arg0);
    }

    public void keyTyped(PInputEvent event) {
        System.out.println("Got key press");
    }
}

