/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.jec.JECFrame;
import com.empireclassic.jec.LogonWindow;
import com.empireclassic.jec.NewNationDialog;
import com.empireclassic.jec.utils.UiUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class LogonProcess {
    boolean failed = true;
    String server;
    int port;
    String user;
    String password;
    int nationNum;
    int homeIsland;

    public LogonProcess(JECFrame thisFrame, String defaultHost, int defaultPort, String defaultUser, String defaultPass) {
        LogonWindow logonWindow;
        boolean finished = false;
        RemoteEmpire.LoginReply response = null;
        do {
            RemoteEmpire empire;
            logonWindow = new LogonWindow(defaultHost, defaultPort, defaultUser, defaultPass);
            logonWindow.setModal(true);
            UiUtil.centerAndShow(logonWindow);
            if (logonWindow.cancelled()) {
                this.failed = true;
                return;
            }
            try {
                empire = RemoteEmpire.getInstance((String)logonWindow.getServer(), (int)logonWindow.getPort());
            }
            catch (UnknownHostException except) {
                JOptionPane.showMessageDialog(thisFrame, "Unable to contact server", "Error", 0);
                finished = false;
                continue;
            }
            catch (IOException except) {
                JOptionPane.showMessageDialog(thisFrame, "Unable to contact server", "Error", 0);
                finished = false;
                continue;
            }
            empire.setCacheStrategy(RemoteEmpire.CacheStrategy.MEMORY);
            response = empire.login(logonWindow.getUser(), logonWindow.getPassword());
            if (response.getNationNum() > 0) {
                finished = true;
                continue;
            }
            if (response.getError().errorString.startsWith("passwords do not match")) {
                JOptionPane.showMessageDialog(logonWindow, "Incorrect password", "Login Error", 0);
                continue;
            }
            int answer = JOptionPane.showConfirmDialog(thisFrame, "Do you want to start a new nation?", "Not found", 0);
            if (answer != 0) continue;
            NewNationDialog newNationDialog = new NewNationDialog(thisFrame, logonWindow.getUser(), logonWindow.getPassword());
            UiUtil.centerAndShow(newNationDialog);
            if (newNationDialog.cancelled()) continue;
            response = empire.newNation(newNationDialog.getNationName(), newNationDialog.getPassword());
            if (response.getError().errorNum == 0) {
                finished = true;
                continue;
            }
            JOptionPane.showMessageDialog(logonWindow, response.getError().errorString, "LogonWindow Error", 0);
        } while (!finished);
        this.failed = false;
        this.server = logonWindow.getServer();
        this.port = logonWindow.getPort();
        this.user = logonWindow.getUser();
        this.nationNum = response.getNationNum();
        this.homeIsland = response.getHomeIsland();
    }

    public boolean failed() {
        return this.failed;
    }

    public String getUser() {
        return this.user;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public int getHomeIsland() {
        return this.homeIsland;
    }

    public int getNationNum() {
        return this.nationNum;
    }
}

