/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec.utils;

import java.awt.geom.Point2D;

public class EmpireUtilities {
    public static String leftTrim(String input) {
        if (input.length() == 0) {
            return input;
        }
        int start = 0;
        while (input.charAt(start) == ' ') {
            ++start;
        }
        return input.substring(start);
    }

    public static String rightTrim(String input) {
        int end;
        if (input.length() == 0) {
            return input;
        }
        for (end = input.length() - 1; end != -1 && input.charAt(end) == ' '; --end) {
        }
        if (end == -1) {
            return "";
        }
        return input.substring(0, ++end);
    }

    public static String rightTrim(StringBuffer input) {
        return EmpireUtilities.rightTrim(new String(input));
    }

    public static float distance(Point2D from, Point2D to) {
        float distX = (int)from.getX() - (int)to.getX();
        float distY = (int)from.getY() - (int)to.getY();
        return (float)Math.sqrt(distX * distX + distY * distY);
    }

    public static float direction(Point2D from, Point2D to) {
        float distY = (int)from.getX() - (int)to.getX();
        float distX = (int)from.getY() - (int)to.getY();
        float dir = (double)distY == 0.0 ? (float)Math.atan((double)distX / 1.0E-6) * 57.2958f : (float)Math.atan(distX / distY) * 57.2958f;
        dir += 270.0f;
        if (distY < 0.0f) {
            dir += 180.0f;
        }
        dir += 360.0f;
        while (dir >= 360.0f) {
            dir -= 360.0f;
        }
        return dir;
    }
}

