/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.NationInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.utils.GTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatFrame
extends JFrame {
    private JPanel jContentPane = null;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    JScrollPane usersScrollPane = new JScrollPane();
    JScrollPane chatScrollPane = new JScrollPane();
    GTableModel model = new GTableModel();
    Object[] rowData = new Object[4];
    JTable usersTable = new JTable(this.model);
    JTextField inputField = new JTextField();
    JButton submitButton = new JButton();
    private Frame frame;
    private String title;
    private Timer timer;
    private int pollRate;
    JLabel quoteLabel = new JLabel();
    JTextField quoteField = new JTextField();
    JButton setButton = new JButton();
    private boolean locked = false;
    private JPanel quotePanel = null;
    private JPanel inputPanel = null;
    private JSplitPane chatSplitPane = null;
    private JTextArea chatTextField = null;

    public ChatFrame(Frame frame, String title, int pollRate) {
        this.frame = frame;
        this.title = title;
        this.setDefaultCloseOperation(1);
        try {
            this.initialize();
            this.model.addColumn("Nation");
            this.model.addColumn("Online time");
            this.model.addColumn("Radio channel");
            this.model.addColumn("Quote");
            this.model.addMouseListenerToHeaderInTable(this.usersTable);
            this.setTitle(title);
            this.timer = new Timer(pollRate, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ChatFrame.this.timerActionPerformed(event);
                }
            });
            this.getRootPane().setDefaultButton(this.submitButton);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startTimer() {
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    public void setSplit(int split) {
        this.chatSplitPane.setDividerLocation(split);
    }

    public int getSplit() {
        return this.chatSplitPane.getDividerLocation();
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    private void timerActionPerformed(ActionEvent event) {
        if (this.locked) {
            return;
        }
        RemoteEmpire empire = RemoteEmpire.getInstance();
        List userList = empire.getUserList();
        this.updateUsers(userList);
        List alerts = empire.getAlerts();
        this.updateRadio(alerts);
    }

    private void updateUsers(List<RemoteEmpire.UserInfo> usersList) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        this.model.setNumRows(0);
        for (RemoteEmpire.UserInfo user : usersList) {
            this.rowData[0] = empire.getNation(user.number).formatNationName();
            this.rowData[1] = user.logonTime;
            this.rowData[2] = user.radioChannel;
            this.rowData[3] = user.quote;
            this.model.addRow(this.rowData);
        }
    }

    private void updateRadio(List<String> alerts) {
        for (String alert : alerts) {
            this.chatTextField.append(alert + "\n");
        }
        this.chatTextField.setCaretPosition(this.chatTextField.getText().length());
    }

    private String niceTime(int seconds) {
        String returnTime = new String();
        returnTime = seconds < 14400 ? new Integer(seconds / 60).toString() + " minutes" : new Integer(seconds / 3600).toString() + " hours";
        return returnTime;
    }

    public ChatFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        ImageIcon ic = new ImageIcon(this.getClass().getResource("/Image/telnet.png"));
        this.setIconImage(ic.getImage());
        this.setSize(new Dimension(362, 320));
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatFrame.this.submitButton_actionPerformed(e);
            }
        });
        this.usersScrollPane.setVerticalScrollBarPolicy(22);
        this.chatScrollPane.setVerticalScrollBarPolicy(22);
        this.chatScrollPane.setViewportView(this.getChatTextField());
        this.quoteLabel.setText("Quote:");
        this.setButton.setText("Set");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatFrame.this.setButton_actionPerformed(e);
            }
        });
        this.quoteField.setText("");
        this.chatSplitPane.setDividerLocation(0.4);
        this.usersScrollPane.setViewportView(this.usersTable);
        this.usersScrollPane.getViewport().add((Component)this.usersTable, null);
        this.chatScrollPane.add((Component)this.chatTextField, null);
        this.chatScrollPane.getViewport().add(this.chatTextField);
        this.getContentPane().add((Component)this.chatSplitPane, "Center");
        this.getContentPane().add((Component)this.inputPanel, "South");
        this.getContentPane().add((Component)this.quotePanel, "North");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getQuotePanel(), "North");
            this.jContentPane.add((Component)this.getInputPanel(), "South");
            this.jContentPane.add((Component)this.getChatSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    void submitButton_actionPerformed(ActionEvent e) {
        RemoteEmpire.getInstance().radioSend(this.inputField.getText());
        NationInfo nation = RemoteEmpire.getInstance().getNation(Globals.nationNum);
        StringBuffer chatText = new StringBuffer(nation.formatNationName() + ": ");
        chatText.append(this.inputField.getText());
        chatText.append("\n");
        this.chatTextField.append(chatText.toString());
        this.chatTextField.setCaretPosition(this.chatTextField.getText().length());
        this.inputField.setText("");
    }

    void setButton_actionPerformed(ActionEvent e) {
        this.quoteField.setText("");
    }

    private JPanel getQuotePanel() {
        if (this.quotePanel == null) {
            this.quotePanel = new JPanel();
            this.quotePanel.setLayout(new BorderLayout());
            this.quotePanel.add((Component)this.setButton, "East");
            this.quotePanel.add((Component)this.quoteLabel, "West");
            this.quotePanel.add((Component)this.quoteField, "Center");
        }
        return this.quotePanel;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new BorderLayout());
            this.inputPanel.add((Component)this.submitButton, "East");
            this.inputPanel.add((Component)this.inputField, "Center");
        }
        return this.inputPanel;
    }

    private JSplitPane getChatSplitPane() {
        if (this.chatSplitPane == null) {
            this.chatSplitPane = new JSplitPane();
            this.chatSplitPane.setOrientation(0);
            this.chatSplitPane.setPreferredSize(new Dimension(3, 7));
            this.chatSplitPane.setDividerLocation(50);
            this.chatSplitPane.setTopComponent(this.usersScrollPane);
            this.chatSplitPane.setBottomComponent(this.chatScrollPane);
        }
        return this.chatSplitPane;
    }

    private JTextArea getChatTextField() {
        if (this.chatTextField == null) {
            this.chatTextField = new JTextArea();
            this.chatTextField.setLineWrap(true);
            this.chatTextField.setWrapStyleWord(true);
        }
        return this.chatTextField;
    }

    private void closeButtonActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, 1, "closed"));
        this.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fireActionPerformed(new ActionEvent(this, 1, "closed"));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(event);
        }
    }
}

