/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.jec;

import com.empireclassic.Remote.EmpireDimension;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.MyShip;
import com.empireclassic.Remote.NationInfo;
import com.empireclassic.Remote.ParamInfo;
import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Ship;
import com.empireclassic.Remote.WorldCoord;
import com.empireclassic.jec.AboutBox;
import com.empireclassic.jec.EmpireLoad;
import com.empireclassic.jec.EmpireProperties;
import com.empireclassic.jec.FrameListener;
import com.empireclassic.jec.Globals;
import com.empireclassic.jec.LogonProcess;
import com.empireclassic.jec.MailWindow;
import com.empireclassic.jec.MapCanvas;
import com.empireclassic.jec.models.ETable;
import com.empireclassic.jec.models.IslandTableModel;
import com.empireclassic.jec.models.NationTableModel;
import com.empireclassic.jec.models.SectorTableModel;
import com.empireclassic.jec.models.ShipsModel;
import com.empireclassic.jec.utils.GTableModel;
import com.empireclassic.jec.utils.SoundFilePlayer;
import com.empireclassic.jec.utils.TableSorter;
import com.empireclassic.jec.utils.UiUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JECFrame
extends JFrame {
    private NationTableModel nationTableModel = new NationTableModel();
    private ShipsModel ships;
    private SectorTableModel sectors;
    private EmpireProperties props;
    private boolean wheelAdjustingScale = false;
    private PBounds initialBounds;
    private JPanel jContentPane = null;
    private JECFrame thisFrame;
    private MailWindow mailWindow = null;
    private RemoteEmpire empire;
    private PZoomEventHandler zoomer;
    private FrameListener standardListener;
    private State state = State.PANANDZOOM;
    private PNode lastSelectedNode = null;
    private Object[] usersRowData = new Object[4];
    private Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable except) {
            except.printStackTrace();
            UiUtil.popupError(JECFrame.this.thisFrame, except, "FATAL ERROR: " + except.getMessage());
            System.exit(1);
        }
    };
    private ListSelectionListener updateSectorsSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            JECFrame.this.sectors.updateSelection();
        }
    };
    private Timer chatTimer;
    private Image xHairCursorImage;
    private Cursor xHairCursor;
    private String defaultHost;
    private int defaultPort;
    private String defaultUser;
    private String defaultPass;
    private Calendar startTime = Calendar.getInstance();
    private ListSelectionModel islandSelectionModel = new DefaultListSelectionModel();
    private ListSelectionModel shipSelectionModel = new DefaultListSelectionModel();
    private JToolBar toolBar = null;
    private JPanel statusPanel = null;
    private PScrollPane pScrollPane = null;
    private MapCanvas mapCanvas = null;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem fileMenuExit = null;
    private PScrollPane mapScrollPane = null;
    private JPanel mapPanel = null;
    private Timer mailCheckTimer;
    private JMenu menuView = null;
    private JCheckBoxMenuItem menuViewIslandTime = null;
    private JCheckBoxMenuItem menuViewIslandName = null;
    private JCheckBoxMenuItem menuViewNationColor = null;
    private JCheckBoxMenuItem menuViewSectorInfo = null;
    private JCheckBoxMenuItem menuViewMoreSectorInfo = null;
    private JCheckBoxMenuItem menuViewShips = null;
    private JButton shipUpdateButton = null;
    private JPanel progressStatusPanel = null;
    private JMenu menuReport = null;
    private JMenuItem menuReportShips = null;
    private JMenuItem menuReportIslands = null;
    private JMenuItem menuReportNations = null;
    private JButton zoomInButton = null;
    private JMenu helpMenu = null;
    private JMenuItem helpAboutMenuItem = null;
    private JPanel statusLowerPanel = null;
    private JLabel statusDisplay = null;
    private JLabel status2Display = null;
    public JProgressBar progressStatus = null;
    private JLabel sectorInfoLabel = null;
    private JToggleButton mailToggleButton = null;
    private JButton zoomOutButton = null;
    private JButton zoomToFitButton = null;
    private JPanel centerPanel = null;
    private JSplitPane mapSplitPane = null;
    private JPanel detailsPanel = null;
    private JTabbedPane detailsTabbedPane = null;
    private JPanel nationsPanel = null;
    private JPanel islandsPanel = null;
    private JPanel sectorsPanel = null;
    private JTabbedPane sectorsTabbedPane = null;
    private JPanel analysisPanel = null;
    private JPanel shipsPanel = null;
    private JSplitPane detailsSplitPane = null;
    private JTabbedPane chatTabbedPane = null;
    private JPanel chatDetailsPanel = null;
    private JPanel emailPanel = null;
    private JPanel newsPanel = null;
    private JPanel battleMailPanel = null;
    private JSplitPane chatSplitPane = null;
    private JScrollPane chatScrollPane = null;
    private JScrollPane usersScrollPane = null;
    private JTable usersTable = null;
    private GTableModel usersTableModel = null;
    private JTextArea chatTextField = null;
    private JPanel chatInputPanel = null;
    private JTextField chatInputTextField = null;
    private JButton chatInputSubmitButton = null;
    private JPanel nationsTopPanel = null;
    private JScrollPane nationsScrollPane = null;
    private ETable nationsTable = null;
    private JLabel nationsPowerDateLabel = null;
    private JPanel sectorLabelPanel = null;
    private JLabel sectorPanelIslandLabel = null;
    private JPanel islandsLabelPanel = null;
    private JScrollPane islandsScrollPane = null;
    private ETable islandsTable = null;
    private JScrollPane shipsScrollPane = null;
    private ETable shipsTable = null;
    protected boolean updatingFromMap;
    protected boolean updatingFromTable;
    private JPanel shipsButtonPanel = null;
    private JButton shipFleetButton = null;
    private JButton shipCourseButton = null;
    private JButton shipsZoomButton = null;
    private JToggleButton radarToggleButton = null;
    private JPanel islandsButtonPanel = null;
    private JButton islandsZoomButton = null;
    private JPanel sectorsDetailPanel = null;
    private JPanel sectorDetailsOptionsPanel = null;
    private JScrollPane sectorDetailsScrollPane = null;
    private ETable sectorDetailsTable = null;
    private JPanel sectorDetailsButtonPanel = null;
    private JCheckBox sectorDetailsSelectedIslandCheckBox = null;
    private IslandTableModel islandsTableModel = null;

    public JECFrame() {
        Thread.setDefaultUncaughtExceptionHandler(this.handler);
        this.setDefaultCloseOperation(2);
        this.thisFrame = this;
        this.initialize();
        this.standardListener = new FrameListener(this);
        this.props = new EmpireProperties("JEC.properties");
        LogonProcess logon = new LogonProcess(this.thisFrame, this.props.getDefaultHost(), this.props.getDefaultPort(), this.props.getDefaultUser(), this.props.getDefaultPassword());
        if (logon.failed()) {
            System.exit(1);
        }
        this.empire = RemoteEmpire.getInstance();
        ParamInfo config = this.empire.getParams();
        Globals.nationNum = logon.getNationNum();
        Globals.currentIsland = logon.getHomeIsland();
        Globals.currentShip = -1;
        Globals.atSea = false;
        this.ships = new ShipsModel(this.empire);
        TableSorter sorter = new TableSorter(this.ships);
        this.shipsTable.setModel(sorter);
        sorter.setTableHeader(this.shipsTable.getTableHeader());
        this.mapCanvas.setShipsModel(this.ships);
        this.mapCanvas.setIslandsModel(this.getIslandsTableModel());
        this.sectors = new SectorTableModel(this.empire, this.getIslandsTableModel(), this.islandSelectionModel);
        sorter = new TableSorter(this.sectors);
        this.sectorDetailsTable.setModel(sorter);
        sorter.setTableHeader(this.sectorDetailsTable.getTableHeader());
        this.mapCanvas.setSectorModel(this.sectors);
        this.mapScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.mapScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.mapScrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        this.mapScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.mapScrollPane.setWheelScrollingEnabled(false);
        this.mapCanvas.addInputEventListener((PInputEventListener)this.standardListener);
        this.chatTimer.start();
        String gameIdent = logon.getServer() + "#" + logon.getPort() + "-" + logon.getUser();
        String gameUrl = "JEC" + gameIdent + ".properties";
        this.props.setGameProps(gameUrl);
        this.setTitle("JEC: " + gameIdent);
        this.defaultHost = logon.getServer();
        this.defaultPort = logon.getPort();
        this.defaultUser = logon.getUser();
        Rectangle mapRect = this.props.getMapWindowRect();
        if (mapRect.x != -1) {
            this.setLocation(mapRect.x, mapRect.y);
        }
        if (mapRect.width != -1) {
            this.setSize(mapRect.width, mapRect.height);
        }
        this.mapCanvas.setInitialView(this.props.getMapBounds());
        this.getMapSplitPane().setDividerLocation(this.props.getMapSplit());
        this.getDetailsSplitPane().setDividerLocation(this.props.getDetailsSplit());
        this.getChatSplitPane().setDividerLocation(this.props.getChatSplit());
        this.getShipsTable().setColumnConfig(this.props.getShipsTableConfig());
        this.getNationsTable().setColumnConfig(this.props.getNationsTableConfig());
        this.getIslandsTable().setColumnConfig(this.props.getIslandsTableConfig());
        this.getSectorDetailsTable().setColumnConfig(this.props.getSectorsTableConfig());
        this.mapCanvas.initialize();
        this.nationTableModel.initialize();
        this.getIslandsTableModel().initialize();
        this.getIslandsTableModel().setTableHeader(this.getIslandsTable().getTableHeader());
        this.ships.getShipList();
        this.progressStatus.setString("");
        this.progressStatus.setIndeterminate(true);
        this.setTitle("JEC: " + gameIdent);
        this.setIconImage(new ImageIcon(JECFrame.class.getResource("/image/empire.png")).getImage());
        this.mailWindow = new MailWindow();
        this.mailWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JECFrame.this.mailWindowActionPerformed(e);
            }
        });
        Timer timer = new Timer(30000, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                boolean count = false;
                JECFrame.this.status2Display.setText("Game date:" + Globals.gameDateString());
            }
        });
        String powerDateString = String.format("Power as of %8.3f", config.getLastPowerDate());
        this.nationsPowerDateLabel.setText(powerDateString);
        EmpireLoad empireLoad = new EmpireLoad(this);
        empireLoad.start();
        timer.setInitialDelay(0);
        timer.start();
    }

    public Ship getShip(int shipNum) {
        return this.ships.getShip(shipNum);
    }

    public Map<Integer, MyShip> getShipList() {
        return this.ships.getShipList();
    }

    private void mailWindowActionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("closed")) {
            this.mailToggleButton.setSelected(false);
        }
    }

    public void setWheelAdjustingScale(boolean value) {
        this.wheelAdjustingScale = value;
    }

    public void setStatusDisplay(String text) {
        this.statusDisplay.setText(text);
    }

    public void setSectorInfoDisplay(String text) {
        this.sectorInfoLabel.setText(text);
    }

    public void setStatus2Display(String text) {
        this.status2Display.setText(text);
    }

    public void setZoomValue(int value) {
    }

    public State getFrameState() {
        return this.state;
    }

    public void setFrameState(State newState) {
        this.state = newState;
    }

    public PPath getWorldRect() {
        return this.mapCanvas.getWorldRect();
    }

    public PNode getLastSelectedNode() {
        return this.lastSelectedNode;
    }

    public void setLastSelectedNode(PNode newNode) {
        this.lastSelectedNode = newNode;
    }

    public void updateProgress(final String status, final int min, final int max) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                JECFrame.this.progressStatus.setStringPainted(true);
                if (status == "") {
                    JECFrame.this.progressStatus.setVisible(false);
                    JECFrame.this.progressStatus.repaint();
                }
                JECFrame.this.progressStatus.setString(status);
                if (max == 0) {
                    JECFrame.this.progressStatus.setIndeterminate(true);
                } else {
                    JECFrame.this.progressStatus.setIndeterminate(false);
                    JECFrame.this.progressStatus.setMinimum(min);
                    JECFrame.this.progressStatus.setMaximum(max);
                }
                JECFrame.this.progressStatus.setValue(min);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void updateProgress(final String status, final int increment) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                JECFrame.this.progressStatus.setString(status);
                JECFrame.this.progressStatus.setValue(JECFrame.this.progressStatus.getValue() + increment);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void updateIslandFromThread(final IslandInfo island) {
        Runnable doMakeIsland = new Runnable(){

            public void run() {
                JECFrame.this.mapCanvas.makeIsland(island);
            }
        };
        SwingUtilities.invokeLater(doMakeIsland);
    }

    private void initialize() {
        this.setJMenuBar(this.getMainMenuBar());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/empire.png")));
        this.setSize(578, 581);
        this.xHairCursorImage = new ImageIcon(JECFrame.class.getResource("/image/crosshair.png")).getImage();
        this.xHairCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.xHairCursorImage, new Point(12, 12), "xhair");
        this.getMapCanvas().setCursor(this.xHairCursor);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JEC");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToolBar(), "North");
            this.jContentPane.add((Component)this.getStatusPanel(), "South");
            this.jContentPane.add((Component)this.getCenterPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getShipUpdateButton());
            this.toolBar.add(this.getMailToggleButton());
            this.toolBar.add(this.getZoomInButton());
            this.toolBar.add(this.getZoomOutButton());
            this.toolBar.add(this.getZoomToFitButton());
        }
        return this.toolBar;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.add((Component)this.getProgressStatusPanel(), "Center");
            this.statusPanel.add((Component)this.getStatusLowerPanel(), "South");
        }
        return this.statusPanel;
    }

    public MapCanvas getMapCanvas() {
        if (this.mapCanvas == null) {
            this.mapCanvas = new MapCanvas();
            this.mapCanvas.setCursor(this.xHairCursor);
            this.mapCanvas.setShipSelectionModel(this.shipSelectionModel);
            this.mapCanvas.setIslandSelectionModel(this.islandSelectionModel);
            this.islandSelectionModel.addListSelectionListener(this.updateSectorsSelectionListener);
        }
        return this.mapCanvas;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getMenuView());
            this.mainMenuBar.add(this.getHelpMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getFileMenuExit());
        }
        return this.fileMenu;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.exitActionPerformed();
        }
        if (e.getID() == 200) {
            this.initialBounds = this.mapCanvas.getCamera().getBounds();
            System.out.println("window opened");
        }
    }

    private JMenuItem getFileMenuExit() {
        if (this.fileMenuExit == null) {
            this.fileMenuExit = new JMenuItem();
            this.fileMenuExit.setText("Exit");
            this.fileMenuExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JECFrame.this.exitActionPerformed();
                }
            });
        }
        return this.fileMenuExit;
    }

    private void exitActionPerformed() {
        this.props.setMapWindowRect(this.thisFrame.getBounds());
        this.props.setMapBounds(this.mapCanvas.getCamera().getViewBounds().getBounds());
        this.props.setMapScale(this.mapCanvas.getCamera().getViewScale());
        this.props.setMapSplit(this.getMapSplitPane().getDividerLocation());
        this.props.setDetailsSplit(this.getDetailsSplitPane().getDividerLocation());
        this.props.setChatSplit(this.getChatSplitPane().getDividerLocation());
        this.props.setDefaultHost(this.defaultHost);
        this.props.setDefaultPort(this.defaultPort);
        this.props.setShipsTableConfig(this.getShipsTable().getColumnConfig());
        this.props.setNationsTableConfig(this.getNationsTable().getColumnConfig());
        this.props.setIslandsTableConfig(this.getIslandsTable().getColumnConfig());
        this.props.setSectorsTableConfig(this.getSectorDetailsTable().getColumnConfig());
        this.props.save();
        Calendar endTime = Calendar.getInstance();
        long ms = endTime.getTimeInMillis() - this.startTime.getTimeInMillis();
        this.empire.close();
        System.exit(0);
    }

    private PScrollPane getMapScrollPane() {
        if (this.mapScrollPane == null) {
            this.mapScrollPane = new PScrollPane();
            this.mapScrollPane.setViewportView((Component)((Object)this.getMapCanvas()));
            this.mapScrollPane.setHorizontalScrollBarPolicy(32);
            this.mapScrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.mapScrollPane;
    }

    private JPanel getMapPanel() {
        if (this.mapPanel == null) {
            this.mapPanel = new JPanel();
            this.mapPanel.setLayout(new BorderLayout());
            this.mapPanel.add((Component)this.getMapScrollPane(), "Center");
        }
        return this.mapPanel;
    }

    private JMenu getMenuView() {
        if (this.menuView == null) {
            this.menuView = new JMenu();
            this.menuView.setText("View");
            this.menuView.add(this.getMenuViewIslandTime());
            this.menuView.add(this.getMenuViewIslandName());
            this.menuView.add(this.getMenuViewNationColor());
            this.menuView.add(this.getMenuViewSectorInfo());
            this.menuView.add(this.getMenuViewMoreSectorInfo());
            this.menuView.add(this.getMenuViewShips());
        }
        return this.menuView;
    }

    private JCheckBoxMenuItem getMenuViewIslandTime() {
        if (this.menuViewIslandTime == null) {
            this.menuViewIslandTime = new JCheckBoxMenuItem();
            this.menuViewIslandTime.setText("Island time");
            this.menuViewIslandTime.setSelected(true);
        }
        return this.menuViewIslandTime;
    }

    private JCheckBoxMenuItem getMenuViewIslandName() {
        if (this.menuViewIslandName == null) {
            this.menuViewIslandName = new JCheckBoxMenuItem();
            this.menuViewIslandName.setText("Island name");
            this.menuViewIslandName.setSelected(true);
        }
        return this.menuViewIslandName;
    }

    private JCheckBoxMenuItem getMenuViewNationColor() {
        if (this.menuViewNationColor == null) {
            this.menuViewNationColor = new JCheckBoxMenuItem();
            this.menuViewNationColor.setText("Nation color");
            this.menuViewNationColor.setSelected(true);
            this.getMapCanvas().setViewNationColor(true);
        }
        return this.menuViewNationColor;
    }

    private JCheckBoxMenuItem getMenuViewSectorInfo() {
        if (this.menuViewSectorInfo == null) {
            this.menuViewSectorInfo = new JCheckBoxMenuItem();
            this.menuViewSectorInfo.setText("Sector details");
            this.menuViewSectorInfo.setSelected(true);
        }
        return this.menuViewSectorInfo;
    }

    private JCheckBoxMenuItem getMenuViewMoreSectorInfo() {
        if (this.menuViewMoreSectorInfo == null) {
            this.menuViewMoreSectorInfo = new JCheckBoxMenuItem();
            this.menuViewMoreSectorInfo.setText("Additional sector details");
        }
        return this.menuViewMoreSectorInfo;
    }

    private JCheckBoxMenuItem getMenuViewShips() {
        if (this.menuViewShips == null) {
            this.menuViewShips = new JCheckBoxMenuItem();
            this.menuViewShips.setText("Display ships");
            this.menuViewShips.setSelected(true);
        }
        return this.menuViewShips;
    }

    private JButton getShipUpdateButton() {
        if (this.shipUpdateButton == null) {
            this.shipUpdateButton = new JButton();
            this.shipUpdateButton.setIcon(new ImageIcon(this.getClass().getResource("/image/shipupdate.png")));
            this.shipUpdateButton.setToolTipText("Re-sync ships");
            this.shipUpdateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JECFrame.this.mapCanvas.updateAllShips();
                }
            });
        }
        return this.shipUpdateButton;
    }

    private JPanel getProgressStatusPanel() {
        if (this.progressStatusPanel == null) {
            this.sectorInfoLabel = new JLabel();
            this.sectorInfoLabel.setText("");
            this.progressStatusPanel = new JPanel();
            this.progressStatusPanel.setLayout(new BoxLayout(this.getProgressStatusPanel(), 0));
            this.progressStatusPanel.add((Component)this.sectorInfoLabel, null);
        }
        return this.progressStatusPanel;
    }

    private JButton getZoomInButton() {
        if (this.zoomInButton == null) {
            this.zoomInButton = new JButton();
            this.zoomInButton.setText("");
            this.zoomInButton.setToolTipText("Zoom in");
            this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/image/ZoomIn24.png")));
            this.zoomInButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PBounds bounds = JECFrame.this.mapCanvas.getCamera().getViewBounds();
                    Rectangle rect = bounds.getBounds();
                    double targetScale = JECFrame.this.mapCanvas.getCamera().getViewScale() * 1.1;
                    rect.grow((int)((double)rect.width * targetScale), (int)((double)rect.height * targetScale));
                    bounds.setRect((Rectangle2D)rect);
                    if (targetScale > 0.0 && JECFrame.this.mapCanvas.getCamera().getViewScale() >= 0.5 || targetScale < 0.0 && JECFrame.this.mapCanvas.getCamera().getViewScale() <= 30.0) {
                        JECFrame.this.mapCanvas.getCamera().scaleViewAboutPoint(1.1, JECFrame.this.mapCanvas.getCamera().getViewBounds().getCenterX(), JECFrame.this.mapCanvas.getCamera().getViewBounds().getCenterY());
                    }
                }
            });
        }
        return this.zoomInButton;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getHelpAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getHelpAboutMenuItem() {
        if (this.helpAboutMenuItem == null) {
            this.helpAboutMenuItem = new JMenuItem();
            this.helpAboutMenuItem.setText("About...");
            this.helpAboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutBox aboutBox = new AboutBox(JECFrame.this.thisFrame);
                    aboutBox.setModal(true);
                    UiUtil.centerAndShow(aboutBox);
                }
            });
        }
        return this.helpAboutMenuItem;
    }

    private JPanel getStatusLowerPanel() {
        if (this.statusLowerPanel == null) {
            this.status2Display = new JLabel();
            this.status2Display.setPreferredSize(new Dimension(200, 18));
            this.status2Display.setText("Nodes");
            this.statusDisplay = new JLabel();
            this.statusDisplay.setPreferredSize(new Dimension(300, 18));
            this.statusDisplay.setText("");
            this.statusLowerPanel = new JPanel();
            this.statusLowerPanel.setLayout(new BorderLayout());
            this.statusLowerPanel.add((Component)this.statusDisplay, "West");
            this.statusLowerPanel.add((Component)this.status2Display, "East");
            this.statusLowerPanel.add((Component)this.getProgressStatus(), "Center");
        }
        return this.statusLowerPanel;
    }

    public JProgressBar getProgressStatus() {
        if (this.progressStatus == null) {
            this.progressStatus = new JProgressBar();
            this.progressStatus.setPreferredSize(new Dimension(180, 18));
        }
        return this.progressStatus;
    }

    private JToggleButton getMailToggleButton() {
        if (this.mailToggleButton == null) {
            this.mailToggleButton = new JToggleButton();
            this.mailToggleButton.setText("");
            this.mailToggleButton.setToolTipText("Mail");
            this.mailToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/image/mail.png")));
            this.mailToggleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (JECFrame.this.mailWindow != null) {
                        if (((JToggleButton)event.getSource()).getSelectedObjects() == null) {
                            JECFrame.this.mailWindow.toFront();
                            JECFrame.this.mailToggleButton.setSelected(true);
                        } else {
                            JECFrame.this.mailWindow.setVisible(true);
                        }
                    }
                }
            });
        }
        return this.mailToggleButton;
    }

    private JButton getZoomOutButton() {
        if (this.zoomOutButton == null) {
            this.zoomOutButton = new JButton();
            this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/image/ZoomOut24.png")));
            this.zoomOutButton.setToolTipText("Zoom out");
            this.zoomOutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PBounds bounds = JECFrame.this.mapCanvas.getCamera().getViewBounds();
                    Rectangle rect = bounds.getBounds();
                    double targetScale = JECFrame.this.mapCanvas.getCamera().getViewScale() * 0.9;
                    rect.grow((int)((double)rect.width * targetScale), (int)((double)rect.height * targetScale));
                    bounds.setRect((Rectangle2D)rect);
                    if (targetScale > 0.0 && JECFrame.this.mapCanvas.getCamera().getViewScale() >= 0.5 || targetScale < 0.0 && JECFrame.this.mapCanvas.getCamera().getViewScale() <= 30.0) {
                        JECFrame.this.mapCanvas.getCamera().scaleViewAboutPoint(0.9, JECFrame.this.mapCanvas.getCamera().getViewBounds().getCenterX(), JECFrame.this.mapCanvas.getCamera().getViewBounds().getCenterY());
                    }
                }
            });
        }
        return this.zoomOutButton;
    }

    private JButton getZoomToFitButton() {
        if (this.zoomToFitButton == null) {
            this.zoomToFitButton = new JButton();
            this.zoomToFitButton.setIcon(new ImageIcon(this.getClass().getResource("/image/ZoomToFit.png")));
            this.zoomToFitButton.setToolTipText("Zoom to show world");
            this.zoomToFitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (JECFrame.this.mapCanvas.getCamera().getViewBounds().getBounds().contains((Rectangle2D)JECFrame.this.mapCanvas.getWorldRect().getBounds())) {
                        Rectangle rect = new Rectangle();
                        for (IslandInfo island : RemoteEmpire.getInstance().getIslandList().values()) {
                            if (rect.isEmpty()) {
                                rect = (Rectangle)island.getRect().clone();
                                continue;
                            }
                            rect.add(island.getRect());
                        }
                        rect.y -= 7;
                        rect.height += 10;
                        JECFrame.this.mapCanvas.setView(rect);
                    } else {
                        JECFrame.this.mapCanvas.setView(JECFrame.this.mapCanvas.getWorldRect().getBounds().getBounds());
                    }
                }
            });
        }
        return this.zoomToFitButton;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getMapSplitPane(), "Center");
        }
        return this.centerPanel;
    }

    private JSplitPane getMapSplitPane() {
        if (this.mapSplitPane == null) {
            this.mapSplitPane = new JSplitPane();
            this.mapSplitPane.setDividerLocation(350);
            this.mapSplitPane.setOneTouchExpandable(true);
            this.mapSplitPane.setLeftComponent(this.getMapPanel());
            this.mapSplitPane.setRightComponent(this.getDetailsPanel());
        }
        return this.mapSplitPane;
    }

    private JPanel getDetailsPanel() {
        if (this.detailsPanel == null) {
            this.detailsPanel = new JPanel();
            this.detailsPanel.setLayout(new BorderLayout());
            this.detailsPanel.add((Component)this.getDetailsSplitPane(), "Center");
        }
        return this.detailsPanel;
    }

    private JTabbedPane getDetailsTabbedPane() {
        if (this.detailsTabbedPane == null) {
            this.detailsTabbedPane = new JTabbedPane();
            this.detailsTabbedPane.addTab("Nations", null, this.getNationsPanel(), null);
            this.detailsTabbedPane.addTab("Islands", null, this.getIslandsPanel(), null);
            this.detailsTabbedPane.addTab("Sectors", null, this.getSectorsPanel(), null);
            this.detailsTabbedPane.addTab("Ships", null, this.getShipsPanel(), null);
        }
        return this.detailsTabbedPane;
    }

    private JPanel getNationsPanel() {
        if (this.nationsPanel == null) {
            this.nationsPanel = new JPanel();
            this.nationsPanel.setLayout(new BorderLayout());
            this.nationsPanel.add((Component)this.getNationsTopPanel(), "North");
            this.nationsPanel.add((Component)this.getNationsScrollPane(), "Center");
        }
        return this.nationsPanel;
    }

    private JPanel getIslandsPanel() {
        if (this.islandsPanel == null) {
            this.islandsPanel = new JPanel();
            this.islandsPanel.setLayout(new BorderLayout());
            this.islandsPanel.add((Component)this.getIslandsLabelPanel(), "North");
            this.islandsPanel.add((Component)this.getIslandsScrollPane(), "Center");
            this.islandsPanel.add((Component)this.getIslandsButtonPanel(), "South");
        }
        return this.islandsPanel;
    }

    private JPanel getSectorsPanel() {
        if (this.sectorsPanel == null) {
            this.sectorsPanel = new JPanel();
            this.sectorsPanel.setLayout(new BorderLayout());
            this.sectorsPanel.add((Component)this.getSectorsTabbedPane(), "Center");
            this.sectorsPanel.add((Component)this.getSectorLabelPanel(), "North");
        }
        return this.sectorsPanel;
    }

    private JTabbedPane getSectorsTabbedPane() {
        if (this.sectorsTabbedPane == null) {
            this.sectorsTabbedPane = new JTabbedPane();
            this.sectorsTabbedPane.setTabPlacement(1);
            this.sectorsTabbedPane.addTab("Details", null, this.getSectorsDetailPanel(), null);
            this.sectorsTabbedPane.addTab("Analysis", null, this.getAnalysisPanel(), null);
        }
        return this.sectorsTabbedPane;
    }

    private JPanel getAnalysisPanel() {
        if (this.analysisPanel == null) {
            this.analysisPanel = new JPanel();
        }
        return this.analysisPanel;
    }

    private JPanel getShipsPanel() {
        if (this.shipsPanel == null) {
            this.shipsPanel = new JPanel();
            this.shipsPanel.setLayout(new BorderLayout());
            this.shipsPanel.add((Component)this.getShipsScrollPane(), "Center");
            this.shipsPanel.add((Component)this.getShipsButtonPanel(), "South");
        }
        return this.shipsPanel;
    }

    private JSplitPane getDetailsSplitPane() {
        if (this.detailsSplitPane == null) {
            this.detailsSplitPane = new JSplitPane();
            this.detailsSplitPane.setOrientation(0);
            this.detailsSplitPane.setOneTouchExpandable(true);
            this.detailsSplitPane.setTopComponent(this.getDetailsTabbedPane());
            this.detailsSplitPane.setBottomComponent(this.getChatTabbedPane());
            this.detailsSplitPane.setDividerLocation(250);
        }
        return this.detailsSplitPane;
    }

    private JTabbedPane getChatTabbedPane() {
        if (this.chatTabbedPane == null) {
            this.chatTabbedPane = new JTabbedPane();
            this.chatTabbedPane.addTab("Chat", null, this.getChatDetailsPanel(), null);
            this.chatTabbedPane.addTab("Mail", null, this.getEmailPanel(), null);
            this.chatTabbedPane.addTab("News", null, this.getNewsPanel(), null);
            this.chatTabbedPane.addTab("Battle Mail", null, this.getBattleMailPanel(), null);
            this.thisFrame.getRootPane().setDefaultButton(this.getChatInputSubmitButton());
            this.chatTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                    System.out.println(tabbedPane.getSelectedIndex());
                    if (tabbedPane.getSelectedIndex() == 0) {
                        JECFrame.this.thisFrame.getRootPane().setDefaultButton(JECFrame.this.getChatInputSubmitButton());
                    }
                }
            });
        }
        return this.chatTabbedPane;
    }

    private JPanel getChatDetailsPanel() {
        if (this.chatDetailsPanel == null) {
            this.chatDetailsPanel = new JPanel();
            this.chatDetailsPanel.setLayout(new BorderLayout());
            this.chatDetailsPanel.add((Component)this.getChatSplitPane(), "Center");
            this.chatDetailsPanel.add((Component)this.getChatInputPanel(), "South");
        }
        return this.chatDetailsPanel;
    }

    private JPanel getEmailPanel() {
        if (this.emailPanel == null) {
            this.emailPanel = new JPanel();
        }
        return this.emailPanel;
    }

    private JPanel getNewsPanel() {
        if (this.newsPanel == null) {
            this.newsPanel = new JPanel();
        }
        return this.newsPanel;
    }

    private JPanel getBattleMailPanel() {
        if (this.battleMailPanel == null) {
            this.battleMailPanel = new JPanel();
        }
        return this.battleMailPanel;
    }

    private JSplitPane getChatSplitPane() {
        if (this.chatSplitPane == null) {
            this.chatSplitPane = new JSplitPane();
            this.chatSplitPane.setOrientation(0);
            this.chatSplitPane.setTopComponent(this.getUsersScrollPane());
            this.chatSplitPane.setBottomComponent(this.getChatScrollPane());
        }
        return this.chatSplitPane;
    }

    private JScrollPane getChatScrollPane() {
        if (this.chatScrollPane == null) {
            this.chatScrollPane = new JScrollPane();
            this.chatScrollPane.setVerticalScrollBarPolicy(22);
            this.chatScrollPane.setViewportView(this.getChatTextField());
        }
        return this.chatScrollPane;
    }

    private JScrollPane getUsersScrollPane() {
        if (this.usersScrollPane == null) {
            this.usersScrollPane = new JScrollPane();
            this.usersScrollPane.setViewportView(this.getUsersTable());
        }
        return this.usersScrollPane;
    }

    private JTable getUsersTable() {
        if (this.usersTable == null) {
            this.usersTable = new JTable();
            this.usersTable.setModel(this.getUsersTableModel());
            this.chatTimer = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JECFrame.this.chatPanelTimerPerformed(e);
                }
            });
        }
        return this.usersTable;
    }

    private void chatPanelTimerPerformed(ActionEvent e) {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        this.updateUsers();
        List alerts = empire.getAlerts();
        this.updateRadio(alerts);
    }

    private void updateUsers() {
        RemoteEmpire empire = RemoteEmpire.getInstance();
        List userList = empire.getUserList();
        this.getUsersTableModel().setNumRows(0);
        for (RemoteEmpire.UserInfo user : userList) {
            this.usersRowData[0] = empire.getNation(user.number).formatNationName();
            this.usersRowData[1] = user.logonTime;
            this.usersRowData[2] = user.radioChannel;
            this.usersRowData[3] = user.quote;
            this.getUsersTableModel().addRow(this.usersRowData);
        }
    }

    private void updateRadio(List<String> alerts) {
        boolean something = false;
        for (String alert : alerts) {
            this.chatTextField.append(alert + "\n");
            something = true;
        }
        if (something && !this.chatDetailsPanel.isShowing()) {
            new SoundFilePlayer().playSoundFile(this.getClass().getResource("/image/ding.wav"));
        }
        this.chatTextField.setCaretPosition(this.chatTextField.getText().length());
    }

    private GTableModel getUsersTableModel() {
        if (this.usersTableModel == null) {
            this.usersTableModel = new GTableModel();
            this.usersTableModel.addColumn("Nation");
            this.usersTableModel.addColumn("Online time");
            this.usersTableModel.addColumn("Radio channel");
            this.usersTableModel.addColumn("Quote");
            this.usersTableModel.addMouseListenerToHeaderInTable(this.getUsersTable());
        }
        return this.usersTableModel;
    }

    private JTextArea getChatTextField() {
        if (this.chatTextField == null) {
            this.chatTextField = new JTextArea();
            this.chatTextField.setLineWrap(true);
            this.chatTextField.setEditable(false);
            this.chatTextField.setWrapStyleWord(true);
        }
        return this.chatTextField;
    }

    private JPanel getChatInputPanel() {
        if (this.chatInputPanel == null) {
            this.chatInputPanel = new JPanel();
            this.chatInputPanel.setLayout(new BorderLayout());
            this.chatInputPanel.add((Component)this.getChatInputTextField(), "Center");
            this.chatInputPanel.add((Component)this.getChatInputSubmitButton(), "East");
        }
        return this.chatInputPanel;
    }

    private JTextField getChatInputTextField() {
        if (this.chatInputTextField == null) {
            this.chatInputTextField = new JTextField();
        }
        return this.chatInputTextField;
    }

    private JButton getChatInputSubmitButton() {
        if (this.chatInputSubmitButton == null) {
            this.chatInputSubmitButton = new JButton();
            this.chatInputSubmitButton.setText("Send");
            this.chatInputSubmitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JECFrame.this.chatSubmitButtonActionPerformed(e);
                }
            });
        }
        return this.chatInputSubmitButton;
    }

    private void chatSubmitButtonActionPerformed(ActionEvent e) {
        RemoteEmpire.getInstance().radioSend(this.chatInputTextField.getText());
        NationInfo nation = RemoteEmpire.getInstance().getNation(Globals.nationNum);
        StringBuffer chatText = new StringBuffer(nation.formatNationName() + ": ");
        chatText.append(this.chatInputTextField.getText());
        chatText.append("\n");
        this.chatTextField.append(chatText.toString());
        this.chatTextField.setCaretPosition(this.chatTextField.getText().length());
        this.chatInputTextField.setText("");
    }

    private JPanel getNationsTopPanel() {
        if (this.nationsTopPanel == null) {
            this.nationsPowerDateLabel = new JLabel();
            this.nationsPowerDateLabel.setText("Power as of 0.00");
            this.nationsTopPanel = new JPanel();
            this.nationsTopPanel.add((Component)this.nationsPowerDateLabel, null);
        }
        return this.nationsTopPanel;
    }

    private JScrollPane getNationsScrollPane() {
        if (this.nationsScrollPane == null) {
            this.nationsScrollPane = new JScrollPane();
            this.nationsScrollPane.setViewportView(this.getNationsTable());
        }
        return this.nationsScrollPane;
    }

    private ETable getNationsTable() {
        if (this.nationsTable == null) {
            TableSorter sorter = new TableSorter(this.nationTableModel);
            this.nationsTable = new ETable(sorter);
            sorter.setTableHeader(this.nationsTable.getTableHeader());
        }
        return this.nationsTable;
    }

    private JPanel getSectorLabelPanel() {
        if (this.sectorLabelPanel == null) {
            this.sectorPanelIslandLabel = new JLabel();
            this.sectorLabelPanel = new JPanel();
            this.sectorLabelPanel.add((Component)this.sectorPanelIslandLabel, null);
        }
        return this.sectorLabelPanel;
    }

    private JPanel getIslandsLabelPanel() {
        if (this.islandsLabelPanel == null) {
            this.islandsLabelPanel = new JPanel();
        }
        return this.islandsLabelPanel;
    }

    private JScrollPane getIslandsScrollPane() {
        if (this.islandsScrollPane == null) {
            this.islandsScrollPane = new JScrollPane();
            this.islandsScrollPane.setViewportView(this.getIslandsTable());
        }
        return this.islandsScrollPane;
    }

    private ETable getIslandsTable() {
        if (this.islandsTable == null) {
            this.islandsTable = new ETable();
            this.islandsTable.setSelectionModel(this.islandSelectionModel);
            this.islandsTable.setModel(this.getIslandsTableModel());
        }
        return this.islandsTable;
    }

    private JScrollPane getShipsScrollPane() {
        if (this.shipsScrollPane == null) {
            this.shipsScrollPane = new JScrollPane();
            this.shipsScrollPane.setHorizontalScrollBarPolicy(32);
            this.shipsScrollPane.setVerticalScrollBarPolicy(22);
            this.shipsScrollPane.setViewportView(this.getShipsTable());
        }
        return this.shipsScrollPane;
    }

    public Cursor getCrossHairCursor() {
        return this.xHairCursor;
    }

    public ETable getShipsTable() {
        if (this.shipsTable == null) {
            TableSorter sorter = new TableSorter(this.ships);
            this.shipsTable = new ETable(sorter);
            sorter.setTableHeader(this.shipsTable.getTableHeader());
            this.shipsTable.setSelectionModel(this.shipSelectionModel);
        }
        return this.shipsTable;
    }

    public void selectShipFromMap(int shipNum) {
        int index = this.ships.getIndex(shipNum);
        if (this.updatingFromTable) {
            return;
        }
        this.updatingFromMap = true;
        this.getShipsTable().getSelectionModel().addSelectionInterval(index, index);
        this.updatingFromMap = false;
        System.out.println("selectShipFromMap()");
    }

    public void clearShipSelection() {
        this.updatingFromMap = true;
        this.getShipsTable().getSelectionModel().clearSelection();
        this.updatingFromMap = false;
    }

    private JPanel getShipsButtonPanel() {
        if (this.shipsButtonPanel == null) {
            this.shipsButtonPanel = new JPanel();
            this.shipsButtonPanel.add((Component)this.getShipFleetButton(), null);
            this.shipsButtonPanel.add((Component)this.getShipCourseButton(), null);
            this.shipsButtonPanel.add((Component)this.getShipsZoomButton(), null);
            this.shipsButtonPanel.add((Component)this.getRadarToggleButton(), null);
        }
        return this.shipsButtonPanel;
    }

    private JButton getShipFleetButton() {
        if (this.shipFleetButton == null) {
            this.shipFleetButton = new JButton();
            this.shipFleetButton.setText("Fleet");
        }
        return this.shipFleetButton;
    }

    private JButton getShipCourseButton() {
        if (this.shipCourseButton == null) {
            this.shipCourseButton = new JButton();
            this.shipCourseButton.setText("Course");
            this.shipCourseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.shipCourseButton;
    }

    private JButton getShipsZoomButton() {
        if (this.shipsZoomButton == null) {
            this.shipsZoomButton = new JButton();
            this.shipsZoomButton.setText("Zoom");
            this.shipsZoomButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rectangle view = new Rectangle(-1, -1, -1, -1);
                    for (int i : JECFrame.this.getShipsTable().getSelectedRows()) {
                        WorldCoord coord = (WorldCoord)JECFrame.this.getShipsTable().getValueAt(i, 3);
                        if (view.x == -1) {
                            view.setLocation((Point)coord);
                        }
                        view.add((Point)coord);
                    }
                    view.grow(15, 15);
                    view.width += 5;
                    JECFrame.this.mapCanvas.setView(view);
                }
            });
        }
        return this.shipsZoomButton;
    }

    private JToggleButton getRadarToggleButton() {
        if (this.radarToggleButton == null) {
            this.radarToggleButton = new JToggleButton();
            this.radarToggleButton.setText("Radar");
            this.radarToggleButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        JECFrame.this.getMapCanvas().setShowShipsRadar(true);
                    } else {
                        JECFrame.this.getMapCanvas().setShowShipsRadar(false);
                    }
                }
            });
        }
        return this.radarToggleButton;
    }

    private JPanel getIslandsButtonPanel() {
        if (this.islandsButtonPanel == null) {
            this.islandsButtonPanel = new JPanel();
            this.islandsButtonPanel.add((Component)this.getIslandsZoomButton(), null);
        }
        return this.islandsButtonPanel;
    }

    private JButton getIslandsZoomButton() {
        if (this.islandsZoomButton == null) {
            this.islandsZoomButton = new JButton();
            this.islandsZoomButton.setText("Zoom");
            this.islandsZoomButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rectangle view = new Rectangle(-1, -1, -1, -1);
                    for (int i : JECFrame.this.getIslandsTable().getSelectedRows()) {
                        Rectangle rect = new Rectangle((Point)((WorldCoord)JECFrame.this.getIslandsTable().getValueAt(i, 1)), (Dimension)((EmpireDimension)JECFrame.this.getIslandsTable().getValueAt(i, 2)));
                        if (view.x == -1) {
                            view.setBounds(rect);
                        }
                        view.add(rect);
                    }
                    view.grow(5, 5);
                    view.width += 5;
                    JECFrame.this.mapCanvas.setView(view);
                }
            });
        }
        return this.islandsZoomButton;
    }

    private JPanel getSectorsDetailPanel() {
        if (this.sectorsDetailPanel == null) {
            this.sectorsDetailPanel = new JPanel();
            this.sectorsDetailPanel.setLayout(new BorderLayout());
            this.sectorsDetailPanel.add((Component)this.getSectorDetailsOptionsPanel(), "North");
            this.sectorsDetailPanel.add((Component)this.getSectorDetailsScrollPane(), "Center");
            this.sectorsDetailPanel.add((Component)this.getSectorDetailsButtonPanel(), "South");
        }
        return this.sectorsDetailPanel;
    }

    private JPanel getSectorDetailsOptionsPanel() {
        if (this.sectorDetailsOptionsPanel == null) {
            this.sectorDetailsOptionsPanel = new JPanel();
            this.sectorDetailsOptionsPanel.add((Component)this.getSectorDetailsSelectedIslandCheckBox(), null);
        }
        return this.sectorDetailsOptionsPanel;
    }

    private JScrollPane getSectorDetailsScrollPane() {
        if (this.sectorDetailsScrollPane == null) {
            this.sectorDetailsScrollPane = new JScrollPane();
            this.sectorDetailsScrollPane.setViewportView(this.getSectorDetailsTable());
        }
        return this.sectorDetailsScrollPane;
    }

    private ETable getSectorDetailsTable() {
        if (this.sectorDetailsTable == null) {
            TableSorter sorter = new TableSorter(this.sectors);
            this.sectorDetailsTable = new ETable(sorter);
            sorter.setTableHeader(this.sectorDetailsTable.getTableHeader());
        }
        return this.sectorDetailsTable;
    }

    private JPanel getSectorDetailsButtonPanel() {
        if (this.sectorDetailsButtonPanel == null) {
            this.sectorDetailsButtonPanel = new JPanel();
        }
        return this.sectorDetailsButtonPanel;
    }

    private JCheckBox getSectorDetailsSelectedIslandCheckBox() {
        if (this.sectorDetailsSelectedIslandCheckBox == null) {
            this.sectorDetailsSelectedIslandCheckBox = new JCheckBox();
            this.sectorDetailsSelectedIslandCheckBox.setText("Selected islands");
            this.sectorDetailsSelectedIslandCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (JECFrame.this.sectorDetailsSelectedIslandCheckBox.isSelected()) {
                        JECFrame.this.sectors.setFilterSelectedIslands();
                    } else {
                        JECFrame.this.sectors.clearFilterSelectedIslands();
                    }
                }
            });
        }
        return this.sectorDetailsSelectedIslandCheckBox;
    }

    private IslandTableModel getIslandsTableModel() {
        if (this.islandsTableModel == null) {
            this.islandsTableModel = new IslandTableModel();
        }
        return this.islandsTableModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PANANDZOOM,
        ATTACK,
        FIRE,
        BOMB,
        SHIPMOVE,
        LANDMOVECIV,
        LANDMOVEMIL,
        LANDMOVEART,
        LANDMOVEEXP,
        LANDMOVEORE,
        FLY,
        SHIPCOURSE,
        FLEETCOURSE,
        SPREAD;

    }
}

