/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.RemoteEmpire;
import com.empireclassic.Remote.Ship;
import com.empireclassic.Remote.ShipType;
import com.empireclassic.Remote.WorldCoord;
import java.util.Scanner;

public class MyShip
extends Ship {
    private int fleet;
    private int civilians;
    private int military;
    private int artillery;
    private int explosives;
    private double ore;
    private int fighters;
    private int bombers;
    private int eff;
    private int rust;
    private WorldCoord dest;
    private boolean courseSet;
    private boolean docked;
    private double time;
    public boolean isNew;

    public MyShip(String serverResponse) {
        Scanner scanner = new Scanner(serverResponse);
        scanner.useDelimiter(":");
        this.shipNum = scanner.nextInt();
        this.fleet = scanner.nextInt();
        String[] coord = scanner.next().split(",");
        this.loc = new WorldCoord(Integer.parseInt(coord[0]), Integer.parseInt(coord[1]));
        String shipType = scanner.next();
        if (RemoteEmpire.shipTypeList != null) {
            for (ShipType type : RemoteEmpire.shipTypeList) {
                if (!type.getName().equals(shipType)) continue;
                this.type = type;
            }
        } else {
            this.type = new ShipType(4, "destroyer");
        }
        coord = scanner.next().split(",");
        this.dest = new WorldCoord(Integer.parseInt(coord[0]), Integer.parseInt(coord[1]));
        this.courseSet = this.dest.x > 0 && this.dest.y > 0;
        this.speed = scanner.nextDouble();
        this.submerged = scanner.next().startsWith("sub");
        this.docked = scanner.next().startsWith("dock");
        this.isNew = scanner.next().startsWith("new");
        this.civilians = scanner.nextInt();
        this.military = scanner.nextInt();
        this.artillery = scanner.nextInt();
        this.explosives = scanner.nextInt();
        this.fighters = scanner.nextInt();
        this.bombers = scanner.nextInt();
        this.ore = scanner.nextDouble();
        this.eff = scanner.nextInt();
        this.rust = scanner.nextInt();
        this.time = scanner.nextDouble();
    }

    public double getHeading() {
        double distY = this.loc.x - this.dest.x;
        double distX = this.loc.y - this.dest.y;
        if (distY == 0.0) {
            distY = 1.0E-6;
        }
        double dir = Math.toDegrees(Math.atan(distX / distY));
        dir += 270.0;
        if (distY < 0.0) {
            dir += 180.0;
        }
        dir += 360.0;
        while (dir >= 360.0) {
            dir -= 360.0;
        }
        return dir;
    }

    public int getOwner() {
        throw new UnsupportedOperationException("You must know the owner of your own ship");
    }

    public int getArtillery() {
        return this.artillery;
    }

    public int getBombers() {
        return this.bombers;
    }

    public int getCivilians() {
        return this.civilians;
    }

    public boolean isCourseSet() {
        return this.courseSet;
    }

    public WorldCoord getDest() {
        return this.dest;
    }

    public int getEff() {
        return this.eff;
    }

    public int getShells() {
        return this.explosives;
    }

    public int getFighters() {
        return this.fighters;
    }

    public int getFleet() {
        return this.fleet;
    }

    public WorldCoord getLoc() {
        return this.loc;
    }

    public int getMilitary() {
        return this.military;
    }

    public double getOre() {
        return this.ore;
    }

    public int getRust() {
        return this.rust;
    }

    public int getShipNum() {
        return this.shipNum;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isSubmerged() {
        return this.submerged;
    }

    public double getTime() {
        return this.time;
    }

    public boolean isDocked() {
        return this.docked;
    }

    public int getExplosives() {
        return this.explosives;
    }

    public boolean isNew() {
        return this.isNew;
    }
}

