/*
 * Decompiled with CFR 0.152.
 */
package com.empireclassic.Remote;

import com.empireclassic.Remote.Criteria;
import com.empireclassic.Remote.IslandCoord;
import com.empireclassic.Remote.IslandInfo;
import com.empireclassic.Remote.Sector;
import com.empireclassic.Remote.SelectionCondition;
import java.util.Map;
import java.util.TreeMap;

public class SelectionMap {
    private Map<IslandCoord, Boolean> map = new TreeMap<IslandCoord, Boolean>();
    private IslandInfo island;

    public SelectionMap(IslandInfo island) {
        this.island = island;
        for (int x = 1; x <= island.getSize().width; ++x) {
            for (int y = 1; y <= island.getSize().height; ++y) {
                this.map.put(new IslandCoord(x, y), false);
            }
        }
    }

    public boolean isSelected(IslandCoord coord) {
        return this.map.get(coord);
    }

    public void setSelection(Criteria criteria) {
        int prod = 0;
        if (criteria == null) {
            return;
        }
        Map<IslandCoord, Sector> sectors = this.island.getSectors();
        for (int x = 1; x <= this.island.getSize().width; ++x) {
            for (int y = 1; y <= this.island.getSize().height; ++y) {
                boolean sectorOdd;
                boolean sectorEven;
                Sector sector = sectors.get(new IslandCoord(x, y));
                if (sector.getDes() == Sector.Des.DOCK || sector.getDes() == Sector.Des.ARTILLERY || sector.getDes() == Sector.Des.EXPLOSIVE || sector.getDes() == Sector.Des.PLANE) {
                    prod = sector.getProduction();
                }
                if ((x % 2 + y % 2) % 2 == 0) {
                    sectorEven = true;
                    sectorOdd = false;
                } else {
                    sectorEven = false;
                    sectorOdd = true;
                }
                if (!criteria.artilleryQualifies(sector.getGuns()) || !criteria.civilianQualifies(sector.getCivilians()) || !criteria.desQualifies(sector.getDes()) || !criteria.effQualifies(sector.getEff()) || !criteria.explosiveQualifies(sector.getShells()) || !criteria.militaryQualifies(sector.getMilitary()) || !criteria.nationQualifies(sector.getOwner()) || !criteria.oreQualifies(sector.getOre()) || !criteria.prodQualifies(prod) || !criteria.sampleQualifies(sector.getOreSample()) || !criteria.xQualifies(x) || !criteria.yQualifies(y) || (!sectorEven || !criteria.evenQualifies()) && (!sectorOdd || !criteria.oddQualifies())) continue;
                this.setSelection(new IslandCoord(x, y));
            }
        }
    }

    public void setSelection(IslandCoord coord) {
        this.map.put(coord, true);
    }

    public void clearSelection(IslandCoord coord) {
        this.map.put(coord, false);
    }

    public int count() {
        return this.count(new SelectionCondition(){

            public boolean check(IslandCoord coord) {
                return true;
            }
        });
    }

    public int count(SelectionCondition condition) {
        int count = 0;
        for (int x = 1; x <= this.island.getSize().width; ++x) {
            for (int y = 1; y <= this.island.getSize().height; ++y) {
                if (!this.isSelected(new IslandCoord(x, y)) || !condition.check(new IslandCoord(x, y))) continue;
                ++count;
            }
        }
        return count;
    }
}

