/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class P3DRect
extends PNode {
    private Color topLeftOuterColor;
    private Color topLeftInnerColor;
    private Color bottomRightInnerColor;
    private Color bottomRightOuterColor;
    private GeneralPath path;
    private Stroke stroke = new BasicStroke(0.0f);
    private boolean raised = true;

    public P3DRect() {
        this.path = new GeneralPath();
    }

    public P3DRect(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public P3DRect(double d, double d2, double d3, double d4) {
        this();
        this.setBounds(d, d2, d3, d4);
    }

    public void setRaised(boolean bl) {
        this.raised = bl;
        this.setPaint(this.getPaint());
    }

    public boolean getRaised() {
        return this.raised;
    }

    protected void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        double d5 = graphics2D.getTransform().getScaleX();
        double d6 = graphics2D.getTransform().getScaleY();
        double d7 = (float)(1.0 / d5);
        double d8 = (float)(1.0 / d6);
        PBounds pBounds = this.getBounds();
        graphics2D.setPaint(this.getPaint());
        graphics2D.fill((Shape)pBounds);
        graphics2D.setStroke(this.stroke);
        this.path.reset();
        this.path.moveTo((float)(d + d3), (float)d2);
        this.path.lineTo((float)d, (float)d2);
        this.path.lineTo((float)d, (float)(d2 + d4));
        graphics2D.setPaint(this.topLeftOuterColor);
        graphics2D.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(d + d3), (float)(d2 + d8));
        this.path.lineTo((float)(d + d7), (float)(d2 + d8));
        this.path.lineTo((float)(d + d7), (float)(d2 + d4));
        graphics2D.setPaint(this.topLeftInnerColor);
        graphics2D.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(d + d3), (float)d2);
        this.path.lineTo((float)(d + d3), (float)(d2 + d4));
        this.path.lineTo((float)d, (float)(d2 + d4));
        graphics2D.setPaint(this.bottomRightOuterColor);
        graphics2D.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(d + d3 - d7), (float)(d2 + d8));
        this.path.lineTo((float)(d + d3 - d7), (float)(d2 + d4 - d8));
        this.path.lineTo((float)d, (float)(d2 + d4 - d8));
        graphics2D.setPaint(this.bottomRightInnerColor);
        graphics2D.draw(this.path);
    }

    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            Color color = (Color)paint;
            if (this.raised) {
                this.topLeftOuterColor = color.brighter();
                this.topLeftInnerColor = this.topLeftOuterColor.brighter();
                this.bottomRightInnerColor = color.darker();
                this.bottomRightOuterColor = this.bottomRightInnerColor.darker();
            } else {
                this.topLeftOuterColor = color.darker();
                this.topLeftInnerColor = this.topLeftOuterColor.darker();
                this.bottomRightInnerColor = color.brighter();
                this.bottomRightOuterColor = this.bottomRightInnerColor.brighter();
            }
        } else {
            this.topLeftOuterColor = null;
            this.topLeftInnerColor = null;
            this.bottomRightInnerColor = null;
            this.bottomRightOuterColor = null;
        }
    }

    public static void main(String[] stringArray) {
        new PFrame(){

            public void initialize() {
                this.getCanvas().setDefaultRenderQuality(0);
                P3DRect p3DRect = new P3DRect(50.0, 50.0, 100.0, 100.0);
                p3DRect.setPaint(new Color(239, 235, 222));
                P3DRect p3DRect2 = new P3DRect(50.0, 50.0, 100.0, 100.0);
                p3DRect2.setPaint(new Color(239, 235, 222));
                p3DRect2.translate(110.0, 0.0);
                p3DRect2.setRaised(false);
                this.getCanvas().getLayer().addChild((PNode)p3DRect);
                this.getCanvas().getLayer().addChild((PNode)p3DRect2);
            }
        };
    }
}

