/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.DateSelectionListener;
import org.jdesktop.swingx.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.EventListenerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDateSelectionModel
implements DateSelectionModel {
    private EventListenerMap listenerMap = new EventListenerMap();
    private DateSelectionModel.SelectionMode selectionMode = DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    private Set<Date> selectedDates = new TreeSet<Date>();
    private Calendar cal = Calendar.getInstance();
    private int firstDayOfWeek = 1;

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.clearSelection();
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @Override
    public void addSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                this.clearSelectionImpl();
                this.selectedDates.add(startDate);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                this.addSelectionImpl(startDate, endDate);
                break;
            }
        }
        this.fireValueChanged(DateSelectionEvent.EventType.DATES_ADDED);
    }

    @Override
    public void setSelectionInterval(Date startDate, Date endDate) {
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                this.clearSelectionImpl();
                this.selectedDates.add(startDate);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                this.clearSelectionImpl();
                this.addSelectionImpl(startDate, endDate);
                break;
            }
        }
        this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
    }

    @Override
    public void removeSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        this.cal.setTime(startDate);
        Date date = this.cal.getTime();
        while (date.before(endDate) || date.equals(endDate)) {
            this.selectedDates.remove(date);
            this.cal.add(5, 1);
            date = this.cal.getTime();
        }
        this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
    }

    @Override
    public void clearSelection() {
        this.clearSelectionImpl();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    private void clearSelectionImpl() {
        this.selectedDates.clear();
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public boolean isSelected(Date date) {
        return this.selectedDates.contains(date);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.size() == 0;
    }

    @Override
    public void addDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.add(DateSelectionListener.class, l);
    }

    @Override
    public void removeDateSelectionListener(DateSelectionListener l) {
        this.listenerMap.remove(DateSelectionListener.class, l);
    }

    public List<DateSelectionListener> getDateSelectionListeners() {
        return this.listenerMap.getListeners(DateSelectionListener.class);
    }

    protected void fireValueChanged(DateSelectionEvent.EventType eventType) {
        List<DateSelectionListener> listeners = this.getDateSelectionListeners();
        DateSelectionEvent e = null;
        for (DateSelectionListener listener : listeners) {
            if (e == null) {
                e = new DateSelectionEvent(this, eventType);
            }
            listener.valueChanged(e);
        }
    }

    private void addSelectionImpl(Date startDate, Date endDate) {
        this.cal.setTime(startDate);
        Date date = this.cal.getTime();
        while (date.before(endDate) || date.equals(endDate)) {
            this.selectedDates.add(date);
            this.cal.add(5, 1);
            date = this.cal.getTime();
        }
    }
}

