/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.gradient.BasicGradientPainter;

public class JXHeader
extends JXPanel {
    private JLabel titleLabel;
    private JXEditorPane descriptionPane;
    private JLabel imagePanel;

    public JXHeader() {
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel("Title");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
        this.descriptionPane = new JXEditorPane();
        this.descriptionPane.setContentType("text/html");
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText("<html><body><p> </p><p> </p></body></html>");
        this.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 24, 0, 11), 0, 0));
        this.imagePanel = new JLabel();
        this.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 10, 0, new Insets(12, 0, 11, 11), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setBackgroundPainter(new BasicGradientPainter(0.0f, 0.0f, Color.WHITE, 1.0f, 0.0f, UIManager.getColor("control")));
    }

    public void setEnabled(boolean enabled) {
        this.titleLabel.setEnabled(enabled);
        this.descriptionPane.setEnabled(enabled);
        this.imagePanel.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setTitle(String title) {
        String old = this.getTitle();
        this.titleLabel.setText(title);
        this.firePropertyChange("title", old, this.getTitle());
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setDescription(String description) {
        String old = this.getDescription();
        this.descriptionPane.setText(description);
        this.firePropertyChange("description", old, this.getDescription());
    }

    public String getDescription() {
        return this.descriptionPane.getText();
    }

    public void setIcon(Icon icon) {
        Icon old = this.getIcon();
        this.imagePanel.setIcon(icon);
        this.firePropertyChange("icon", old, this.getIcon());
    }

    public Icon getIcon() {
        return this.imagePanel.getIcon();
    }
}

